/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.extension;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.websvcs.exception.ConfigurationException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.http.WASAxis2Servlet;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2ExtensionProcessor
extends WebExtensionProcessor {
    private static final TraceComponent _tc = Tr.register(WASAxis2ExtensionProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigurationContext configContext = null;
    private Map urlServiceMap = null;

    public WASAxis2ExtensionProcessor(IServletContext webApp, ConfigurationContext cc) throws Exception {
        super(webApp);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ExtensionProcessor ctor");
        }
        this.configContext = cc;
        this.urlServiceMap = new HashMap();
        this.createServletConfigs();
        this.initializeMBean(webApp);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ExtensionProcessor ctor");
        }
    }

    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
    }

    private void createServletConfigs() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createServletConfigs, module=" + this.extensionContext.getWebAppConfig().getModuleName());
        }
        try {
            AxisConfiguration ac = this.configContext.getAxisConfiguration();
            Iterator svcGroupIter = ac.getServiceGroups();
            while (svcGroupIter.hasNext()) {
                AxisServiceGroup svcGroup = (AxisServiceGroup)svcGroupIter.next();
                Iterator svcIter = svcGroup.getServices();
                while (svcIter.hasNext()) {
                    IServletConfig servlet;
                    AxisService axisService = (AxisService)svcIter.next();
                    String implClassName = Axis2Utils.getServiceImplClass(axisService);
                    if (implClassName == null) {
                        Object[] inserts = new Object[]{axisService.getName()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("axisSvcNotContainImpl00", inserts, "''AxisService'' {0} does not contain an implementation class name.");
                        throw new DeploymentException(msg);
                    }
                    String servletLink = Axis2Utils.getLinkValue(axisService);
                    boolean newServlet = false;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for servlet for class: " + implClassName + " with " + "link value: " + servletLink);
                    }
                    if ((servlet = this.locateServlet(servletLink)) == null && !servletLink.equals(implClassName)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Did not find servlet, looking with class name: " + implClassName);
                        }
                        servlet = this.locateServlet(implClassName);
                    }
                    if (servlet == null) {
                        newServlet = true;
                        servlet = this.createServlet(servletLink, WASAxis2Servlet.class.getName());
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found an existing servlet with name=" + servlet.getServletName());
                            Tr.debug(_tc, "Implementation class=" + servlet.getClassName());
                        }
                        servlet.setClassName(WASAxis2Servlet.class.getName());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set implementation class to: " + servlet.getClassName());
                        }
                    }
                    this.checkServletMappings(servlet, axisService, newServlet);
                }
            }
            this.configContext.setProperty("com.ibm.ws.websvcs.URL_SERVICES_MAPPINGS", this.urlServiceMap);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URL to Services Map: " + this.urlServiceMap);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.extension.WASAxis2ExtensionProcessor.createServletConfigs", "157", (Object)this);
            Object[] inserts = new Object[]{e};
            Tr.error(_tc, "processWebModFail00", inserts);
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createServletConfigs");
        }
    }

    private IServletConfig locateServlet(String value) throws Exception {
        WebAppConfig config2 = this.extensionContext.getWebAppConfig();
        Iterator servletsIter = config2.getServletInfos();
        while (servletsIter.hasNext()) {
            IServletConfig servlet = (IServletConfig)servletsIter.next();
            if (value.equals(servlet.getServletName())) {
                return servlet;
            }
            if (!value.equals(servlet.getClassName())) continue;
            return servlet;
        }
        return null;
    }

    private IServletConfig createServlet(String servletName, String servletClassName) throws Exception {
        IServletConfig servlet = this.createConfig(servletName);
        servlet.setServletName(servletName);
        servlet.setClassName(servletClassName);
        servlet.setDisplayName("Web services servlet");
        servlet.setServletContext(this.extensionContext);
        servlet.setStartUpWeight(new Integer(1));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created new servlet, name=" + servlet.getServletName() + ", class=" + servlet.getClassName());
        }
        return servlet;
    }

    private void checkServletMappings(IServletConfig servlet, AxisService axisService, boolean newServlet) throws Exception {
        List mappings;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkServletMappings, servlet=" + servlet.getServletName() + ", service=" + axisService.getName());
        }
        IServletWrapper servletWrapper = null;
        WebAppConfig webAppConfig = this.extensionContext.getWebAppConfig();
        if (newServlet) {
            servletWrapper = this.extensionContext.createServletWrapper(servlet);
        }
        String urlPattern = null;
        List servletMappings = servlet.getMappings();
        if (servletMappings != null && servletMappings.size() > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Servlet [" + servlet.getServletName() + "] has " + Integer.toString(servletMappings.size()) + " mappings.");
            }
            if (servletMappings.size() > 1) {
                Object[] inserts = new Object[]{servlet.getServletName()};
                String msg = NLSProvider.getNLS().getFormattedMessage("servletMapNum00", inserts, "Servlet {0} contains more than one servlet mapping, which is a violation of JSR 109.");
                throw new ServletException(msg);
            }
            if (servletMappings.size() == 1) {
                ServletMapping servletMapping = (ServletMapping)servletMappings.get(0);
                urlPattern = servletMapping.getUrlPattern();
                if (urlPattern.equals("/*") || urlPattern.equals("*")) {
                    Object[] inserts = new Object[]{servlet.getServletName()};
                    String msg = NLSProvider.getNLS().getFormattedMessage("illegalUrlPattern00", inserts, "Servlet {0} cannot specify \"*\" as a URL pattern.");
                    throw new ServletException(msg);
                }
                if (!urlPattern.startsWith("/")) {
                    urlPattern = "/" + urlPattern;
                }
                Axis2Utils.setURLPattern(axisService, urlPattern);
                this.addMetaDataMappings(servlet, webAppConfig, servletWrapper, urlPattern, axisService);
                this.addMapping(servlet, webAppConfig, servletWrapper, urlPattern + "/wsdl" + "/*");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Servlet [" + servlet.getServletName() + "] already has a servlet mapping.");
                    Tr.debug(_tc, "Set URL pattern [" + urlPattern + "] on AxisService [" + axisService.getName() + "].");
                }
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Servlet [" + servlet.getServletName() + "] contains no servlet mappings.");
            }
            if ((urlPattern = Axis2Utils.getURLPattern(axisService)) == null) {
                Object[] inserts = new Object[]{axisService.getName(), "com.ibm.ws.websvcs.AxisServiceUrlPattern"};
                String msg = NLSProvider.getNLS().getFormattedMessage("axisSvcNotHaveParam00", inserts, "Internal Error: ''AxisService'' {0} does not contain parameter {1}.");
                throw new DeploymentException(msg);
            }
            if (urlPattern.equals("/*")) {
                this.addMapping(servlet, webAppConfig, servletWrapper, urlPattern);
            } else {
                this.addMapping(servlet, webAppConfig, servletWrapper, urlPattern);
                this.addMapping(servlet, webAppConfig, servletWrapper, urlPattern + "/wsdl" + "/*");
                this.addMetaDataMappings(servlet, webAppConfig, servletWrapper, urlPattern, axisService);
            }
        }
        if (urlPattern != null) {
            this.urlServiceMap.put(urlPattern, axisService);
        }
        Object[] inserts = new Object[]{urlPattern, servlet.getServletName(), this.extensionContext.getWebAppConfig().getModuleName()};
        Tr.info(_tc, "urlPattern00", inserts);
        if (_tc.isDebugEnabled() && (mappings = servlet.getMappings()) != null) {
            Tr.debug(_tc, "Servlet [" + servlet.getServletName() + "] has the following mappings:");
            for (int i = 0; i < mappings.size(); ++i) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                Tr.debug(_tc, "[" + Integer.toString(i) + "]: " + mapping.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkServletMappings");
        }
    }

    void addMetaDataMappings(IServletConfig servlet, WebAppConfig webAppConfig, IServletWrapper servletWrapper, String urlPattern, AxisService axisService) throws Exception {
        String wsdlLocation;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addMetaDataMappings");
        }
        String mappingPattern = urlPattern.endsWith("/") ? urlPattern : urlPattern + "/";
        Map filePathMappings = (Map)this.configContext.getProperty("com.ibm.ws.websvcs.FILE_PATH_SERVLET_MAPPINGS");
        List<String> paths = null;
        if (filePathMappings != null) {
            paths = (List)filePathMappings.get(axisService.getName());
        }
        if ((paths == null || paths.isEmpty()) && (wsdlLocation = Axis2Utils.getWSDLLocation(axisService)) != null && !"".equals(wsdlLocation)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Mappings not stored on ConfigurationContext");
            }
            paths = this.getWSDLMappings(axisService, wsdlLocation);
        }
        if (paths != null && !paths.isEmpty() && paths != null && !paths.isEmpty()) {
            for (String path : paths) {
                if (path == null) continue;
                this.addMapping(servlet, webAppConfig, servletWrapper, mappingPattern + path);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addMetaDataMappings");
        }
    }

    List<String> getWSDLMappings(AxisService axisService, String wsdlLocation) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWSDLMappings");
        }
        LinkedList<String> mappings = null;
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to build metadata mapping list for AxisService: " + axisService.getName());
            }
            mappings = new LinkedList<String>();
            if (Axis2Utils.isAbsolutePath(wsdlLocation)) {
                String filePathMapping = Axis2Utils.getServletFilePath(wsdlLocation);
                String filePathPrefix = Axis2Utils.getServletFilePathPrefix(wsdlLocation);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding servlet file path mapping: " + filePathMapping + " for AxisService: " + axisService + " with prefix: " + filePathPrefix);
                }
                mappings.add(filePathMapping);
                Axis2Utils.createAndSetAxisParameter(axisService, "com.ibm.ws.websvcs.FILE_PATH_PREFIX", filePathPrefix);
            } else {
                String packagedMapping = wsdlLocation.replace("\\", "/");
                mappings.add(packagedMapping);
            }
            ClassLoader cl = axisService.getClassLoader();
            ModuleWSDLLocator wsdlLocator = new ModuleWSDLLocator(wsdlLocation, null, cl);
            InputStream is = wsdlLocator.getInputStream(wsdlLocation);
            if (is != null) {
                wsdlLocator = new ModuleWSDLLocator(wsdlLocation, is, cl);
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader reader = factory.newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                reader.readWSDL(wsdlLocator);
                List<String> importedMappings = wsdlLocator.getResolvedImportLocations();
                if (importedMappings != null && !importedMappings.isEmpty()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding imported mapping list with size: " + importedMappings.size());
                    }
                    mappings.addAll(importedMappings);
                    Axis2Utils.createAndSetAxisParameter(axisService, "com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS", importedMappings);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "An InputStream could not be found for the " + wsdlLocation + " WSDL document");
            }
            HashMap<String, LinkedList<String>> filePathMappings = (HashMap<String, LinkedList<String>>)this.configContext.getProperty("com.ibm.ws.websvcs.FILE_PATH_SERVLET_MAPPINGS");
            if (filePathMappings == null) {
                filePathMappings = new HashMap<String, LinkedList<String>>();
                this.configContext.setProperty("com.ibm.ws.websvcs.FILE_PATH_SERVLET_MAPPINGS", filePathMappings);
            }
            filePathMappings.put(axisService.getName(), mappings);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.extension.WASAxis2ExtensionProcessor.getWSDLMappings", "588", (Object)this);
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWSDLMappings");
        }
        return mappings;
    }

    private void addMapping(IServletConfig servlet, WebAppConfig webAppConfig, IServletWrapper servletWrapper, String urlPattern) throws Exception {
        if (servletWrapper != null) {
            this.extensionContext.addMappingTarget(urlPattern, servletWrapper);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added mapping target [" + urlPattern + "] for servletWrapper of servlet [" + servlet.getServletName() + "].");
            }
        }
        if (webAppConfig.getServletInfo(servlet.getServletName()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added mapping [" + urlPattern + "] for user-defined servlet [" + servlet.getServletName() + "].");
            }
            webAppConfig.addServletMapping(servlet.getServletName(), urlPattern);
        } else {
            servlet.addMapping(urlPattern);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added mapping [" + urlPattern + "] for servlet [" + servlet.getServletName() + "].");
            }
        }
    }

    private void initializeMBean(IServletContext webApp) throws ConfigurationException {
        EndpointManagerMBean mbean;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initializeMBean");
        }
        if ((mbean = Axis2Utils.getEndpointManagerMBean(this.configContext)) == null) {
            throw new ConfigurationException("Endpoint MBean not found from metadata.");
        }
        List<Endpoint> endpoints = Axis2Utils.generateEndpoints(this.configContext);
        mbean.initializeEndpoints(endpoints);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initializeMBean");
        }
    }
}

