/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.dispatcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;

public class URLPatternBasedDispatcher
extends AbstractDispatcher
implements Constants {
    private static final TraceComponent _tc = Tr.register(URLPatternBasedDispatcher.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static String sessUrlRewritePrefix = ";jsessionid=";
    private static final String SESSION_ID_NAME = "SessionRewriteIdentifier";
    private final String dispatcherName = "URLPatternBasedDispatcher";
    private String className = this.getClass().getName();

    public AxisService findService(MessageContext mc) throws AxisFault {
        if (mc.getAxisService() != null) {
            return mc.getAxisService();
        }
        EndpointReference toEPR = mc.getTo();
        String contextRoot = (String)mc.getProperty("com.ibm.ws.websvcs.MsgContext_ContextRoot");
        if (toEPR != null && contextRoot != null) {
            String urlPattern = null;
            try {
                int index;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Request URL is: " + toEPR.getAddress());
                }
                if ((index = (urlPattern = toEPR.getAddress()).indexOf(contextRoot)) >= 0) {
                    urlPattern = urlPattern.substring(index + contextRoot.length());
                }
                urlPattern = this.checkForSessionId(urlPattern);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for AxisService with URL pattern: " + urlPattern);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.className + ".findService", "93", this);
                return null;
            }
            AxisService service = null;
            Map urlServiceMap = (Map)mc.getConfigurationContext().getProperty("com.ibm.ws.websvcs.URL_SERVICES_MAPPINGS");
            if (urlServiceMap != null && (service = (AxisService)urlServiceMap.get(urlPattern)) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found AxisService (cache): " + service.getName());
                }
                return service;
            }
            AxisConfiguration ac = mc.getConfigurationContext().getAxisConfiguration();
            Iterator svcGrpIter = ac.getServiceGroups();
            if (svcGrpIter != null) {
                while (svcGrpIter.hasNext()) {
                    AxisServiceGroup svcGroup = (AxisServiceGroup)svcGrpIter.next();
                    Iterator svcIter = svcGroup.getServices();
                    if (svcIter == null) continue;
                    while (svcIter.hasNext()) {
                        service = (AxisService)svcIter.next();
                        String pattern = Axis2Utils.getURLPattern(service);
                        if (pattern == null || !pattern.equals(urlPattern) && !pattern.equals("/*")) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found AxisService: " + service.getName());
                        }
                        return service;
                    }
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URLPatternBasedDispatcher didn't find matching AxisService...");
            }
        }
        return null;
    }

    public AxisOperation findOperation(AxisService arg0, MessageContext arg1) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription("URLPatternBasedDispatcher"));
    }

    public String checkForSessionId(String urlPattern) {
        int sessionIndex = urlPattern.indexOf(sessUrlRewritePrefix);
        if (sessionIndex > 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found session identifier: " + sessUrlRewritePrefix);
            }
            urlPattern = urlPattern.substring(0, sessionIndex);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Returning url pattern after removing session info: " + urlPattern);
        }
        return urlPattern;
    }

    static {
        if (WebContainer.getWebContainerProperties().get(SESSION_ID_NAME) != null) {
            sessUrlRewritePrefix = ";" + WebContainer.getWebContainerProperties().get(SESSION_ID_NAME) + "=";
        }
    }
}

