/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.WSClientEndpointDescriptorImpl;
import com.ibm.wsspi.websvcs.desc.ServiceRefInfo;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class WSClientServiceDescriptorImpl
implements WSClientServiceDescriptor {
    private Service service;
    private ArrayList clientEndpoints;
    private boolean clientEndpointsBuilt;
    private ServiceRefInfo srInfo;

    WSClientServiceDescriptorImpl(Service service, ServiceRefInfo srInfo) {
        this.service = service;
        this.clientEndpoints = new ArrayList();
        this.clientEndpointsBuilt = false;
        this.srInfo = srInfo;
    }

    public QName getQName() {
        return this.service.getQName();
    }

    public Iterator getEndpoints() {
        this.buildEndpoints();
        return this.clientEndpoints.iterator();
    }

    private void buildEndpoints() {
        if (!this.clientEndpointsBuilt) {
            Map portMap = this.service.getPorts();
            if (portMap != null && !portMap.isEmpty()) {
                for (Port port : portMap.values()) {
                    WSClientEndpointDescriptorImpl clientDesc = new WSClientEndpointDescriptorImpl(port);
                    this.clientEndpoints.add(clientDesc);
                }
            }
            this.clientEndpointsBuilt = true;
        }
    }

    public WSClientType getClientType() {
        return WSClientType.JAX_WS;
    }

    public boolean isServiceRef() {
        return false;
    }

    public ServiceRefInfo getServiceRefInfo() {
        return this.srInfo;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

