/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.WSClientOperationDescriptorImpl;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientOperationDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClientEndpointDescriptorDBC
implements WSClientEndpointDescriptor {
    private DescriptionBuilderComposite dbc;
    private String portName;
    private List<WSClientOperationDescriptor> operationList;
    private boolean clientOperationsBuilt;

    WSClientEndpointDescriptorDBC(DescriptionBuilderComposite dbc, String portName) {
        this.dbc = dbc;
        this.portName = portName;
        this.operationList = new ArrayList<WSClientOperationDescriptor>();
        this.clientOperationsBuilt = false;
    }

    @Override
    public String getName() {
        return this.portName;
    }

    @Override
    public QName getBindingQName() {
        return null;
    }

    @Override
    public QName getPortTypeQName() {
        return null;
    }

    @Override
    public Iterator getOperations() {
        this.buildOperations();
        return this.operationList.iterator();
    }

    private void buildOperations() {
        if (!this.clientOperationsBuilt) {
            List<String> methodNames = this.getDispatchableMethods(this.dbc.getMethodDescriptionsList());
            for (String methodName : methodNames) {
                this.operationList.add(new WSClientOperationDescriptorImpl(methodName));
            }
            this.clientOperationsBuilt = true;
        }
    }

    private List<String> getDispatchableMethods(List<MethodDescriptionComposite> mdcList) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (MethodDescriptionComposite mdc : mdcList) {
            String returnType;
            if (mdc.getMethodName() == null || mdc.getMethodName().equals("<init>") || (returnType = mdc.getReturnType()) == null || returnType.indexOf("javax.xml.ws.Response") != -1 || returnType.indexOf("java.util.concurrent.Future") != -1) continue;
            methodNames.add(mdc.getMethodName());
        }
        return methodNames;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

