/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.MDQEndpointDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;

public class MDQServiceDescriptorImpl
implements WSServiceDescriptor {
    private WSModuleDescriptor parent;
    private ServiceDescription serviceDescription;
    private List<WSEndpointDescriptor> endpointDescriptors;
    private boolean endpointsBuilt;
    private static final TraceComponent _tc = Tr.register(MDQServiceDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public MDQServiceDescriptorImpl(WSModuleDescriptor parent, ServiceDescription serviceDescription) {
        this.parent = parent;
        this.serviceDescription = serviceDescription;
        this.endpointsBuilt = false;
        this.endpointDescriptors = new ArrayList<WSEndpointDescriptor>();
    }

    public boolean deployedWithWSDL() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL sdWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
            return sdWSDL.getWSDLDefinition() != null;
        }
        return false;
    }

    public Iterator getEndpoints() {
        this.buildEndpoints();
        return this.endpointDescriptors.iterator();
    }

    public String getName() {
        return this.serviceDescription.getServiceQName() != null ? this.serviceDescription.getServiceQName().getLocalPart() : null;
    }

    public WSModuleDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.serviceDescription.getServiceQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getWSDLDefinition() {
        Definition definition;
        block16: {
            block10: {
                Definition definition2;
                block15: {
                    block13: {
                        Definition definition3;
                        block14: {
                            ServiceDescriptionWSDL sdWSDL;
                            block11: {
                                Definition definition4;
                                block12: {
                                    if (_tc.isEntryEnabled()) {
                                        Tr.entry(_tc, "getWSDLDefinition");
                                    }
                                    try {
                                        if (!(this.serviceDescription instanceof ServiceDescriptionWSDL)) break block10;
                                        sdWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
                                        if (sdWSDL.getWSDLDefinition() == null) break block11;
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "getWSDLDefinition returning definition");
                                        }
                                        definition4 = sdWSDL.getWSDLDefinition();
                                        Object var4_6 = null;
                                        if (!_tc.isEntryEnabled()) break block12;
                                    }
                                    catch (Throwable throwable) {
                                        block17: {
                                            Object var4_10 = null;
                                            if (!_tc.isEntryEnabled()) break block17;
                                            Tr.exit(_tc, "getWSDLDefinition");
                                        }
                                        throw throwable;
                                    }
                                    Tr.exit(_tc, "getWSDLDefinition");
                                }
                                return definition4;
                            }
                            if (sdWSDL.getGeneratedWsdlWrapper() == null) break block13;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "getWSDLDefinition returning generated definition");
                            }
                            definition3 = sdWSDL.getGeneratedWsdlWrapper().getDefinition();
                            Object var4_7 = null;
                            if (!_tc.isEntryEnabled()) break block14;
                            Tr.exit(_tc, "getWSDLDefinition");
                        }
                        return definition3;
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getWSDLDefinition returning null");
                    }
                    definition2 = null;
                    Object var4_8 = null;
                    if (!_tc.isEntryEnabled()) break block15;
                    Tr.exit(_tc, "getWSDLDefinition");
                }
                return definition2;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getWSDLDefinition not instance of ServiceDescriptionWSDL");
            }
            definition = null;
            Object var4_9 = null;
            if (!_tc.isEntryEnabled()) break block16;
            Tr.exit(_tc, "getWSDLDefinition");
        }
        return definition;
    }

    public String getWSDLLocationBaseName() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL sdWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
            if (sdWSDL.getWSDLLocation() != null) {
                String path = sdWSDL.getWSDLLocation();
                if (path.indexOf("/") != -1) {
                    path = path.substring(path.lastIndexOf("/"), path.length());
                    return path;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public URI getWSDLLocationURI() {
        if (this.serviceDescription instanceof ServiceDescriptionWSDL) {
            ServiceDescriptionWSDL sdWSDL = (ServiceDescriptionWSDL)((Object)this.serviceDescription);
            if (sdWSDL.getWSDLLocation() != null) {
                try {
                    return new URI(sdWSDL.getWSDLLocation());
                }
                catch (Throwable t) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Could not get WSDL location URI due to the following error: " + t.toString());
                    }
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public boolean isJAXRPCService() {
        return false;
    }

    public boolean isJAXWSService() {
        return true;
    }

    private void buildEndpoints() {
        if (!this.endpointsBuilt) {
            for (EndpointDescription ed : this.serviceDescription.getEndpointDescriptions_AsCollection()) {
                if (_tc.isDebugEnabled()) {
                    String serviceImplClass = ed.getAxisService() != null ? Axis2Utils.getServiceImplClass(ed.getAxisService()) : null;
                    Tr.debug(_tc, "Building MDQEndpointDescriptorImpl for port: " + ed.getPortQName() + " service impl class: " + serviceImplClass);
                }
                MDQEndpointDescriptorImpl endpointDescriptor = new MDQEndpointDescriptorImpl(this, ed);
                this.endpointDescriptors.add(endpointDescriptor);
            }
            this.endpointsBuilt = true;
        }
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

