/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;

public class WASAxis2PolicySetConfigurator
implements PolicySetLoader {
    private static final TraceComponent _tc = Tr.register(WASAxis2PolicySetConfigurator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ClassLoader appClassLoader = null;
    private ClassLoader sysClassLoader = null;
    private PolicySetAttachments psa = null;

    public WASAxis2PolicySetConfigurator(ClassLoader appClassLoader, ClassLoader sysClassLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2PolicySetBuilder ctr");
        }
        this.appClassLoader = appClassLoader;
        this.sysClassLoader = sysClassLoader;
        if (_tc.isDebugEnabled() && (appClassLoader == null || sysClassLoader == null)) {
            Tr.debug(_tc, "One of the constructor parameters does not have a value");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2PolicySetBuilder ctr");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void associatePolicySets(ConfigurationContext configContext, Axis2ServiceConfigPluginManager plugins) throws DeploymentException, Exception {
        block13: {
            block12: {
                block11: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "associatePolicySets");
                    }
                    try {
                        AxisConfiguration axisCfg = configContext.getAxisConfiguration();
                        if (axisCfg == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Axis Configuration does not exist. Exiting.");
                            }
                            Object var9_4 = null;
                            if (!_tc.isEntryEnabled()) return;
                            break block11;
                        }
                        String appName = null;
                        if (Axis2Utils.getApplicationName(axisCfg) != null) {
                            appName = Axis2Utils.getApplicationName(axisCfg);
                        }
                        String moduleName = null;
                        if (Axis2Utils.getModuleName(axisCfg) != null) {
                            moduleName = Axis2Utils.getModuleName(axisCfg);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding Policy Sets for " + appName + "/" + moduleName);
                        }
                        Iterator servicesIter = null;
                        if (axisCfg.getServices() == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "AxisConfiguration did not have any services set on it. Exiting.");
                            }
                            break block12;
                        }
                        servicesIter = axisCfg.getServices().keySet().iterator();
                        while (servicesIter.hasNext()) {
                            AxisService service = axisCfg.getService((String)servicesIter.next());
                            this.associatePolicySets(service, plugins);
                        }
                        this.psa = null;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        if (!_tc.isEntryEnabled()) throw throwable;
                        Tr.exit(_tc, "associatePolicySets");
                        throw throwable;
                    }
                }
                Tr.exit(_tc, "associatePolicySets");
                return;
            }
            Object var9_5 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "associatePolicySets");
            return;
        }
        Object var9_6 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "associatePolicySets");
    }

    public void associatePolicySets(AxisService service, Axis2ServiceConfigPluginManager plugins) throws DeploymentException, Exception {
        if (service == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Service is null. Continuing.");
            }
            return;
        }
        HashMap<String, AxisService> params = new HashMap<String, AxisService>();
        params.put("com.ibm.wsspi.websvcs.AxisServiceKey", service);
        plugins.runPreAttach(params);
        if (Axis2Utils.getPolicySet(service) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Axis Service already has policy set associated with it. Continuing.");
            }
            return;
        }
        QName serviceName = Axis2Utils.getServiceQName(service);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "*** Associating policy set for service: " + serviceName + " ***");
        }
        String appName = null;
        if (service.getAxisConfiguration() != null) {
            appName = Axis2Utils.getApplicationName(service.getAxisConfiguration());
        }
        String moduleName = null;
        if (service.getAxisConfiguration() != null) {
            moduleName = Axis2Utils.getModuleName(service.getAxisConfiguration());
        }
        String resourceKey = "WebService:/";
        if (moduleName != null) {
            resourceKey = resourceKey + moduleName + ":";
        }
        if (serviceName != null) {
            resourceKey = resourceKey + serviceName.toString();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Base Policy Set resource key: " + resourceKey);
        }
        try {
            PolicySetAttachments psa = this.getPolicySetAttachments(appName, serviceName.toString(), moduleName, plugins.isServerSide());
            if (psa != null) {
                PolicySetConfiguration policySet = null;
                String portName = Axis2Utils.getPortName(service);
                if (portName != null) {
                    Iterator operIter = service.getOperations();
                    while (operIter.hasNext()) {
                        AxisOperation operation = (AxisOperation)operIter.next();
                        QName operationName = operation.getName();
                        String operResourceKey = resourceKey + "/" + portName + "/" + operationName.getLocalPart();
                        policySet = psa.getPolicySet(operResourceKey, this.appClassLoader, this.sysClassLoader);
                        if (policySet != null) {
                            Axis2Utils.setPolicySet(operation, policySet);
                        }
                        if (!_tc.isDebugEnabled()) continue;
                        if (policySet != null) {
                            Tr.debug(_tc, "    Policy Set loaded for operation " + operationName + " using key '" + operResourceKey + "'.");
                            continue;
                        }
                        Tr.debug(_tc, "    Policy set could not be loaded for operation " + operationName + ".");
                    }
                }
                if ((policySet = psa.getPolicySet(resourceKey, this.appClassLoader, this.sysClassLoader)) != null) {
                    Axis2Utils.setPolicySet(service, policySet);
                }
                if (_tc.isDebugEnabled()) {
                    if (policySet != null) {
                        Tr.debug(_tc, "  Policy Set loaded for service " + serviceName + " using key '" + resourceKey + "'.");
                    } else {
                        Tr.debug(_tc, "  Policy set could not be loaded for service " + serviceName + ".");
                    }
                }
                plugins.runPostAttach(params);
                plugins.runConfig(params);
            }
        }
        catch (DeploymentException de) {
            FFDCFilter.processException((Throwable)de, "com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator.associatePolicySets", "259", this);
            Object[] inserts = new Object[]{serviceName, de};
            Tr.error(_tc, "loadPolicySetFail00", inserts);
            throw de;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator.associatePolicySets", "269", this);
            Object[] inserts = new Object[]{serviceName, e};
            Tr.error(_tc, "loadPolicySetFail00", inserts);
            throw e;
        }
    }

    private PolicySetAttachments getPolicySetAttachments(String appName, String serviceName, String moduleName, boolean isServerSide) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getPolicySetAttachments");
            Tr.debug(_tc, "serverSide=" + isServerSide + ", appName=" + appName);
        }
        PolicySetUtil psu = PolicySetUtil.getInstance(this.sysClassLoader);
        if (isServerSide) {
            if (this.psa != null) {
                return this.psa;
            }
            this.psa = psu.getAttachments(appName);
        } else {
            this.psa = psu.getClientAttachments(appName, serviceName, moduleName);
        }
        if (_tc.isDebugEnabled()) {
            if (this.psa == null) {
                Tr.debug(_tc, "Application " + appName + " does not" + " have any policy sets associated with it.");
            } else {
                Tr.debug(_tc, "Retrieved Policy Sets for application " + appName + ".");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getPolicySetAttachments");
        }
        return this.psa;
    }

    public void setAppClassLoader(ClassLoader cl) {
        this.appClassLoader = cl;
    }
}

