/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2DescriptionBuilder
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2DescriptionBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AxisServiceGroup serviceGroup;
    private ClassLoader classLoader;
    private ModuleFile moduleFile;
    private boolean isEJB;
    private List<String> pcNameList;

    public WASAxis2DescriptionBuilder(ModuleFile moduleFile, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.moduleFile = moduleFile;
        this.isEJB = moduleFile.isEJBJarFile();
        this.pcNameList = new LinkedList<String>();
    }

    public AxisServiceGroup buildAxisServiceGroup(List<ServiceDescription> sdList) {
        if (sdList != null && !sdList.isEmpty()) {
            this.serviceGroup = new AxisServiceGroup();
            for (ServiceDescription sd : sdList) {
                try {
                    this.retrieveAxisServices(sd);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder.buildAxisServiceGroup", "75", this);
                    String msg = NLSProvider.getNLS().getFormattedMessage("buildRuntimeFail00", new Object[]{this.moduleFile.getName(), t}, "A runtime configuration for the {0} application module could not be built because of the following error: {1}");
                    Tr.error(_tc, msg);
                }
            }
            return this.serviceGroup;
        }
        return null;
    }

    private void retrieveAxisServices(ServiceDescription sd) throws Exception {
        EndpointDescription[] endpoints = sd.getEndpointDescriptions();
        if (endpoints != null) {
            for (int i = 0; i < endpoints.length; ++i) {
                EndpointDescription endpoint = endpoints[i];
                AxisService axisService = endpoint.getAxisService();
                this.setPortComponentName(endpoint, axisService);
                this.setServiceURLPattern(axisService);
                this.setOperationInfo(axisService);
                axisService.setClassLoader(this.classLoader);
                this.addStackTraceParam(axisService);
                this.setMessageReceiver(axisService);
                this.setLinkValue(endpoint, axisService);
                this.setResolvedImports(endpoint, axisService);
                if (this.isEJB) {
                    this.setEJBParams(axisService);
                }
                this.serviceGroup.addService(axisService);
            }
        }
    }

    void setPortComponentName(EndpointDescription endpoint, AxisService axisService) throws AxisFault {
        String pcName = (String)endpoint.getProperty("WSDL_PORTTYPE_NAME");
        if (pcName != null && !"".equals(pcName)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "For axisService: " + axisService.getName() + " the port component name: " + pcName + " was set on the EndpointDescription");
            }
            Axis2Utils.setPortComponentName(axisService, pcName);
        } else {
            pcName = Axis2Utils.getPortComponentName(axisService);
            if (pcName == null || "".equals(pcName)) {
                String implClassName = Axis2Utils.getServiceImplClass(axisService);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For AxisService: " + axisService.getName() + " the port " + "component name was not set. Defaulting to implementation class name: " + implClassName);
                }
                Axis2Utils.setPortComponentName(axisService, implClassName);
                this.pcNameList.add(implClassName);
            } else if (this.pcNameList.contains(pcName)) {
                String implClassName = Axis2Utils.getServiceImplClass(axisService);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The " + pcName + " port component name for the AxisService: " + axisService.getName() + " conflicts with an existing port component. " + "Updating port component name: " + implClassName);
                }
                Axis2Utils.setPortComponentName(axisService, implClassName);
                this.pcNameList.add(implClassName);
            } else {
                this.pcNameList.add(pcName);
            }
        }
    }

    private void setServiceURLPattern(AxisService axisService) throws AxisFault {
        QName serviceQName = Axis2Utils.getServiceQName(axisService);
        if (serviceQName != null) {
            String serviceName = serviceQName.getLocalPart();
            Axis2Utils.setURLPattern(axisService, "/" + serviceName);
        }
    }

    private void setOperationInfo(AxisService service) {
        Iterator opIter = service.getOperations();
        while (opIter.hasNext()) {
            AxisOperation operation = (AxisOperation)opIter.next();
            operation.setMessageReceiver(new JAXWSMessageReceiver());
            this.addStackTraceParam(operation);
        }
    }

    void addStackTraceParam(AxisDescription description) {
        try {
            Parameter param = new Parameter();
            param.setName("sendStacktraceDetailsWithFaults");
            param.setValue(Boolean.FALSE.toString());
            description.addParameter(param);
        }
        catch (AxisFault af) {
            Tr.warning(_tc, "Problem occurrred adding parameter to a configuration object.");
        }
    }

    void setMessageReceiver(AxisService axisService) throws Exception {
        Iterator opIter = axisService.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)opIter.next();
            axisOperation.setMessageReceiver(new JAXWSMessageReceiver());
        }
    }

    private void setEJBParams(AxisService axisService) throws DeploymentException {
        EJBJarFile ejbJarFile;
        EJBJar ejbDD;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setEJBParams");
        }
        String applicationName = this.moduleFile.getEARFile() != null ? this.moduleFile.getEARFile().getName() : null;
        String moduleName = this.moduleFile.getName();
        String ejbLinkName = Axis2Utils.getLinkValue(axisService);
        EnterpriseBean bean = this.getStatelessEJB(ejbLinkName, ejbDD = (ejbJarFile = (EJBJarFile)this.moduleFile).getDeploymentDescriptor());
        if (bean == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("beanFail00", new Object[]{ejbLinkName, Axis2Utils.getServiceImplClass(axisService), moduleName}, "The {0} ejb-link value for the {1} Enterprise Java Bean Web service implementation class did not correspond to an Enterprise Bean defined in the ejb-jar.xml for the {2} module.");
            throw new DeploymentException(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Enterprise bean name: " + bean.getName());
        }
        J2EENameFactory factory = (J2EENameFactory)ImplFactory.loadImplFromKey(J2EENameFactory.class);
        J2EEName j2eename = factory.create(applicationName, moduleName, bean.getName());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Created J2EEName for ejbLink: " + ejbLinkName + " application/" + "module: " + applicationName + "/" + moduleName + " J2EEName: " + j2eename);
        }
        Axis2Utils.createAndSetAxisParameter(axisService, "EJB_J2EE_NAME", j2eename);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setEJBParams");
        }
    }

    void setLinkValue(EndpointDescription ed, AxisService axisService) throws AxisFault {
        String paramName = null;
        Object value = null;
        if (ed.getProperty("com.ibm.ws.websvcs.SERVLET_LINK_VALUE") != null) {
            paramName = "com.ibm.ws.websvcs.SERVLET_LINK_VALUE";
            value = ed.getProperty("com.ibm.ws.websvcs.SERVLET_LINK_VALUE");
        } else if (ed.getProperty("com.ibm.ws.websvcs.EJB_LINK_VALUE") != null) {
            paramName = "com.ibm.ws.websvcs.EJB_LINK_VALUE";
            value = ed.getProperty("com.ibm.ws.websvcs.EJB_LINK_VALUE");
        }
        if (paramName != null) {
            Parameter parameter = new Parameter();
            parameter.setName(paramName);
            parameter.setValue(value);
            axisService.addParameter(parameter);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added link value parameter with name: " + paramName + " and " + "value: " + value);
            }
        }
    }

    EnterpriseBean getStatelessEJB(String ejbLinkName, EJBJar ejbDD) {
        EnterpriseBean bean = null;
        bean = ejbDD.getEnterpriseBeanNamed(ejbLinkName);
        if (bean != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Matched ejb link value: " + ejbLinkName + " to ejb-name in ejb-jar.xml");
            }
            return bean;
        }
        EList ejbs = ejbDD.getEnterpriseBeans();
        if (ejbs != null && !ejbs.isEmpty()) {
            for (EnterpriseBean ejb : ejbs) {
                Session session;
                String ejbClassName = ejb.getEjbClassName();
                if (!ejbLinkName.equals(ejbClassName) || !ejb.isSession() || !(session = (Session)ejb).getSessionType().equals(1) && !session.getSessionType().equals(SessionType.STATELESS_LITERAL)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Matched ejb link value: " + ejbLinkName + " to stateless session bean: " + ejb.getName());
                }
                bean = ejb;
                break;
            }
        }
        return bean;
    }

    void setResolvedImports(EndpointDescription endpointDesc, AxisService axisService) {
        Axis2Utils.createAndSetAxisParameter(axisService, "com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS", endpointDesc.getProperty("com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS"));
    }
}

