/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.exception.WSDLPostProcessingException;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.webservices.WSDLPostProcessorPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateWsdlEndpointUrls
implements WSDLPostProcessorPlugin {
    private static final TraceComponent _tc = Tr.register(UpdateWsdlEndpointUrls.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public int getWeight() {
        return Integer.MIN_VALUE;
    }

    @Override
    public void postProcessWSDL(Definition definition, Map parameters) throws WSDLPostProcessingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "UpdateWsdlEndpointUrls.postProcessWSDL()...");
        }
        AxisService as = (AxisService)parameters.get("AXIS_SERVICE_KEY");
        ConfigurationContext cc = (ConfigurationContext)parameters.get("CONFIGURATION_CONTEXT_KEY");
        HttpServletRequest req = (HttpServletRequest)parameters.get("SERVLET_REQUEST_KEY");
        if (as != null && cc != null && req != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AxisService, ConfigContext, and Servlet Req objects are availablefor WSDL definition URL update: " + as + ", " + cc + ", " + req);
            }
            HashMap prefixMap = this.getPrefixMap(req);
            HashMap urlMap = this.getURLMap(as, cc);
            this.updateEndpointURLS(definition, cc, prefixMap, urlMap, req.getScheme());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...UpdateWsdlEndpointUrls.postProcessWSDL()");
        }
    }

    @Override
    public void registerExtensions(ExtensionRegistry er) {
    }

    private void updateEndpointURLS(Definition def, ConfigurationContext configContext, Map prefixMap, Map urlMap, String protocol) {
        HashMap servicesMap = configContext.getAxisConfiguration().getServices();
        if (servicesMap != null && !servicesMap.isEmpty()) {
            for (AxisService axisService : servicesMap.values()) {
                String portName;
                Port port;
                Service service;
                QName serviceQName = Axis2Utils.getServiceQName(axisService);
                String prefix = (String)prefixMap.get(protocol);
                if (serviceQName == null || (service = def.getService(serviceQName)) == null || (port = service.getPort(portName = Axis2Utils.getPortName(axisService))) == null) continue;
                String tns = def.getTargetNamespace();
                QName portQName = new QName(tns, portName);
                String key = serviceQName.toString() + portQName.toString() + Axis2Utils.getWSDLLocation(axisService);
                String endpointURL = (String)urlMap.get(key);
                if (endpointURL == null || "".equals(endpointURL)) continue;
                List elements = port.getExtensibilityElements();
                for (ExtensibilityElement element : elements) {
                    ExtensibilityElement address;
                    if (element instanceof SOAPAddress) {
                        address = (SOAPAddress)element;
                        address.setLocationURI(prefix + endpointURL);
                        continue;
                    }
                    if (!(element instanceof SOAP12Address)) continue;
                    address = (SOAP12Address)element;
                    address.setLocationURI(prefix + endpointURL);
                }
            }
        }
    }

    private HashMap getPrefixMap(HttpServletRequest req) {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        String prefix = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
        prefixMap.put(req.getScheme(), prefix);
        return prefixMap;
    }

    private HashMap getURLMap(AxisService as, ConfigurationContext configContext) {
        WsdlComposite composite;
        HashMap<String, String> urlMap = new HashMap<String, String>();
        Definition wsdlDef = Axis2Utils.getWSDLDefinition(as);
        if (wsdlDef == null && (composite = Axis2Utils.getWsdlComposite(as)) != null) {
            wsdlDef = composite.getRootWsdlDefinition();
        }
        if (wsdlDef == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getURLMap(): WSDL def was null.");
            }
            return urlMap;
        }
        String tns = wsdlDef.getTargetNamespace();
        Map services = wsdlDef.getServices();
        Iterator serviceIter = services.values().iterator();
        Object[] serviceArray = this.getAxisServices(configContext);
        if (serviceArray.length > 0) {
            while (serviceIter.hasNext()) {
                Service service = (Service)serviceIter.next();
                ArrayList<AxisService> servicesByQName = this.getAxisServicesByQName(service.getQName(), serviceArray);
                Map ports = service.getPorts();
                for (Port port : ports.values()) {
                    String urlPattern = this.matchesRequestedAxisService(as, service.getQName().toString(), port.getName()) ? Axis2Utils.getURLPattern(as) : this.getAxisServiceByPort(servicesByQName, port.getName());
                    QName qName = new QName(tns, port.getName());
                    String key = service.getQName().toString() + qName.toString() + Axis2Utils.getWSDLLocation(as);
                    if (urlPattern != null && urlPattern.equals("/*")) {
                        urlPattern = "/";
                    }
                    urlMap.put(key, urlPattern);
                }
            }
        }
        return urlMap;
    }

    private Object[] getAxisServices(ConfigurationContext configContext) {
        HashMap serviceMap = configContext.getAxisConfiguration().getServices();
        if (!serviceMap.isEmpty()) {
            return serviceMap.values().toArray();
        }
        return null;
    }

    private ArrayList<AxisService> getAxisServicesByQName(QName qName, Object[] services) {
        ArrayList<AxisService> servicesByQName = new ArrayList<AxisService>();
        for (int i = 0; i < services.length; ++i) {
            AxisService service = (AxisService)services[i];
            QName serviceQName = Axis2Utils.getServiceQName(service);
            if (serviceQName == null || !serviceQName.toString().equals(qName.toString())) continue;
            servicesByQName.add(service);
        }
        return servicesByQName;
    }

    private String getAxisServiceByPort(ArrayList<AxisService> services, String portName) {
        Iterator<AxisService> serviceIter = services.iterator();
        String name = null;
        while (serviceIter.hasNext()) {
            AxisService service = serviceIter.next();
            String pName = Axis2Utils.getPortName(service);
            if (!portName.equals(pName)) continue;
            name = Axis2Utils.getURLPattern(service);
        }
        if (name == null || name.equals("")) {
            name = "IMPLEMENTATION NOT PROVIDED";
        }
        return name;
    }

    private boolean matchesRequestedAxisService(AxisService as, String sName, String pName) {
        return Axis2Utils.getServiceQName(as).toString().equals(sName) && Axis2Utils.getPortName(as).equals(pName);
    }
}

