/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.ArchiveFileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.WARFileExplorer;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;

public class FileExplorerFactory
implements Constants {
    private static final TraceComponent _tc = Tr.register(FileExplorerFactory.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static FileExplorer getFileExplorer(Archive archive, ClassLoader classLoader) {
        ModuleFile moduleFile;
        if (archive instanceof ModuleFile && !Axis2Utils.scanModule(moduleFile = (ModuleFile)archive)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The " + moduleFile.getName() + " module will not be scanned " + "for annotations");
            }
            return null;
        }
        if (archive.isWARFile()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving a WARFileExplorer for WAR module: " + archive.getName());
            }
            return new WARFileExplorer((WARFile)archive, classLoader);
        }
        if (archive.isEJBJarFile()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving an ArchiveFileExplorer for EJB module: " + archive.getName());
            }
            return new ArchiveFileExplorer(archive, classLoader);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieving an ArchiveFileExplorer for archive: " + archive.getName());
        }
        return new ArchiveFileExplorer(archive, classLoader);
    }
}

