/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.PluginUtils;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;

public class Axis2ServiceConfigPluginManager {
    private static final TraceComponent _tc = Tr.register(Axis2ServiceConfigPluginManager.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private List<Axis2ServiceConfigPlugin> implementationList = new ArrayList<Axis2ServiceConfigPlugin>();
    private boolean forServerSide = false;

    public void discoverAxis2ServiceConfigPlugins(boolean isServerSide) {
        this.forServerSide = isServerSide;
        PluginUtils.discoverExtensions(Axis2ServiceConfigPlugin.class.getName(), "com.ibm.wsfp.main.ibmaxis2-service-config-plugin", this.implementationList);
        if (!isServerSide) {
            PluginUtils.discoverExtensions(Axis2ServiceConfigPlugin.class.getName(), "com.ibm.wsfp.thinclient.ibmaxis2-service-config-plugin", this.implementationList);
        }
    }

    public void runConfig(HashMap configMap) throws DeploymentException {
        for (Axis2ServiceConfigPlugin configPlugin : this.implementationList) {
            Object[] inserts;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Running config plugin: " + configPlugin);
                }
                configPlugin.config(configMap);
            }
            catch (DeploymentException de) {
                FFDCFilter.processException((Throwable)de, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runConfig", "92", this);
                inserts = new Object[]{configPlugin.getClass().getName(), de};
                Tr.error(_tc, "runConfigPluginFail00", inserts);
                throw de;
            }
            catch (AxisFault af) {
                FFDCFilter.processException((Throwable)af, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runConfig", "98", this);
                inserts = new Object[]{configPlugin.getClass().getName(), af};
                Tr.error(_tc, "runConfigPluginFail00", inserts);
            }
        }
    }

    public void runPreAttach(HashMap configMap) throws DeploymentException {
        for (Axis2ServiceConfigPlugin configPlugin : this.implementationList) {
            Object[] inserts;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Calling preAttach method of config plugin: " + configPlugin);
                }
                configPlugin.preAttach(configMap);
            }
            catch (DeploymentException de) {
                FFDCFilter.processException((Throwable)de, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runPreAttach", "122", this);
                inserts = new Object[]{configPlugin.getClass().getName(), de};
                Tr.error(_tc, "runConfigPluginFail00", inserts);
                throw de;
            }
            catch (AxisFault af) {
                FFDCFilter.processException((Throwable)af, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runPreAttach", "128", this);
                inserts = new Object[]{configPlugin.getClass().getName(), af};
                Tr.error(_tc, "runConfigPluginFail00", inserts);
            }
        }
    }

    public void runPostAttach(HashMap configMap) throws DeploymentException {
        for (Axis2ServiceConfigPlugin configPlugin : this.implementationList) {
            Object[] inserts;
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Calling postAttach method of config plugin: " + configPlugin);
                }
                configPlugin.postAttach(configMap);
            }
            catch (DeploymentException de) {
                FFDCFilter.processException((Throwable)de, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runPostAttach", "149", this);
                inserts = new Object[]{configPlugin.getClass().getName(), de};
                Tr.error(_tc, "runConfigPluginFail00", inserts);
                throw de;
            }
            catch (AxisFault af) {
                FFDCFilter.processException((Throwable)af, "com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager.runPostAttach", "155", this);
                inserts = new Object[]{configPlugin.getClass().getName(), af};
                Tr.error(_tc, "runConfigPluginFail00", inserts);
            }
        }
    }

    public boolean isServerSide() {
        return this.forServerSide;
    }
}

