/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.webservices.component.JAXRPCMetaDataHelper;
import com.ibm.ws.webservices.component.JAXRPCMetaDataWrapper;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessor;
import com.ibm.ws.webservices.modutils.ModuleServiceRefAccessorFactory;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCache;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCacheMgr;
import com.ibm.ws.webservices.shared.cache.jaxb.JaxrpcWebServiceInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.JaxwsWebServiceInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.ObjectFactory;
import com.ibm.ws.webservices.shared.cache.jaxb.WebServiceClientInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsCacheInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsClientType;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.deployment.ArchiveFileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.ServiceRefInfo;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSCacheWriter {
    private static final TraceComponent _tc = Tr.register(WSCacheWriter.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String appName;
    private String earLocation;
    private WebServicesModuleCache cache;
    HashMap<String, DescriptionBuilderComposite> dbcMap;
    private HashMap<String, ArchiveFileLocator> archiveFileLocatorMap;
    private List<String> moduleNames;
    private String rootDir;
    private ObjectFactory factory;

    public WSCacheWriter(String earLocation, String appName) throws Exception {
        this.earLocation = earLocation;
        this.appName = appName;
        this.factory = new ObjectFactory();
    }

    public WSCacheWriter(String appName) throws Exception {
        this.appName = appName;
        this.factory = new ObjectFactory();
    }

    public void writeApplicationCache(boolean generateMetaData) throws Exception {
        this.writeApplicationCache(null, generateMetaData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeApplicationCache(EARFile earFile, boolean generateMetaData) throws Exception {
        boolean wasOpened;
        block29: {
            block26: {
                block27: {
                    block28: {
                        if (_tc.isEntryEnabled()) {
                            Tr.entry(_tc, "writeClassCache");
                        }
                        wasOpened = false;
                        try {
                            try {
                                if (earFile == null) {
                                    if (this.earLocation == null) {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Neither an EARFile or the location of an EARFile was supplied. No cache will be written for the application: " + this.appName);
                                        }
                                        Object var9_4 = null;
                                        if (earFile == null || !wasOpened) break block26;
                                        if (!_tc.isDebugEnabled()) break block27;
                                        break block28;
                                    }
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Need to open EARFile from location: " + this.earLocation);
                                    }
                                    CommonarchiveFactory archiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
                                    ArchiveOptions options = new ArchiveOptions();
                                    options.setIsReadOnly(true);
                                    options.setUseJavaReflection(true);
                                    earFile = archiveFactory.openEARFile(options, this.earLocation);
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Opened EARFile...");
                                    }
                                    wasOpened = true;
                                }
                                this.rootDir = null;
                                if (CacheRootDirectoryTLS.get() != null) {
                                    this.rootDir = CacheRootDirectoryTLS.get();
                                }
                                this.moduleNames = new ArrayList<String>();
                                List moduleList = earFile.getWARFiles();
                                moduleList.addAll(earFile.getEJBJarFiles());
                                for (ModuleFile module : moduleList) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Writing cache for module " + module.getName() + " in application " + this.appName);
                                    }
                                    boolean copySuccess = false;
                                    if (this.cacheExistsInApp(module)) {
                                        copySuccess = this.copyCacheFile(module, this.appName);
                                    }
                                    if (!copySuccess) {
                                        this.writeModuleCache(module, generateMetaData, module.getArchiveClassLoader());
                                    }
                                    WSModuleDescriptorImpl.clearCache(module);
                                }
                                break block29;
                            }
                            catch (Throwable e) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("cacheWriteFail00", new Object[]{earFile.getName(), e}, "Web services metadata cache could not be generated for the {0} application due to the following error: {1}");
                                Tr.info(_tc, msg);
                                e.printStackTrace();
                                throw new Exception(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_6 = null;
                            if (earFile != null && wasOpened) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Closing EARFile");
                                }
                                earFile.close();
                            }
                            if (this.moduleNames != null && !this.moduleNames.isEmpty()) {
                                for (String moduleName : this.moduleNames) {
                                    Axis2Utils.deleteExtractedApp(this.appName, moduleName);
                                }
                            }
                            if (!_tc.isEntryEnabled()) throw throwable;
                            Tr.exit(_tc, "writeClassCache");
                            throw throwable;
                        }
                    }
                    Tr.debug(_tc, "Closing EARFile");
                }
                earFile.close();
            }
            if (this.moduleNames != null && !this.moduleNames.isEmpty()) {
                for (String moduleName : this.moduleNames) {
                    Axis2Utils.deleteExtractedApp(this.appName, moduleName);
                }
            }
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "writeClassCache");
            return;
        }
        Object var9_5 = null;
        if (earFile != null && wasOpened) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Closing EARFile");
            }
            earFile.close();
        }
        if (this.moduleNames != null && !this.moduleNames.isEmpty()) {
            for (String moduleName : this.moduleNames) {
                Axis2Utils.deleteExtractedApp(this.appName, moduleName);
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "writeClassCache");
    }

    private void buildMap(List<FileLocator> locators) {
        if (!locators.isEmpty()) {
            this.archiveFileLocatorMap = new HashMap();
            for (FileLocator loc : locators) {
                if (!(loc instanceof ArchiveFileLocator)) continue;
                this.archiveFileLocatorMap.put(loc.getName(), (ArchiveFileLocator)loc);
            }
        }
    }

    private void writeJAXWSCache(ClassLoader classLoader, WsCacheInfo cacheInfo) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeJAXWSCache");
        }
        if (this.dbcMap == null || this.dbcMap.isEmpty()) {
            return;
        }
        List<JaxwsWebServiceInfo> jaxwsInfoList = cacheInfo.getJaxwsServices();
        for (DescriptionBuilderComposite dbc : this.dbcMap.values()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to cache the following file name: " + dbc.getClassName());
            }
            if (this.archiveFileLocatorMap == null) continue;
            String classKey = dbc.getClassName().replace(".", "/");
            ArchiveFileLocator aLoc = this.archiveFileLocatorMap.get(classKey = classKey + ".class");
            if (aLoc != null) {
                JaxwsWebServiceInfo jaxwsInfo = this.factory.createJaxwsWebServiceInfo();
                jaxwsInfo.setClassName(aLoc.getName());
                jaxwsInfo.setContainerPath(aLoc.getContainerPath());
                jaxwsInfoList.add(jaxwsInfo);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Adding class file to cached list: " + aLoc.getName() + " with container path: " + aLoc.getContainerPath());
                continue;
            }
            URL url = null;
            String containerPath = null;
            try {
                url = classLoader.getResource(classKey);
                containerPath = url.toString();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding out of module class file to cached list: " + classKey + " with container path: " + containerPath);
            }
            JaxwsWebServiceInfo jaxwsInfo = this.factory.createJaxwsWebServiceInfo();
            jaxwsInfo.setClassName(classKey);
            jaxwsInfo.setContainerPath(containerPath);
            jaxwsInfoList.add(jaxwsInfo);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeJAXWSCache");
        }
    }

    private void writeJAXRPCCache(ModuleFile moduleFile, WsCacheInfo wsCacheInfo, ClassLoader classLoader) {
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "writeJAXRPCCache= " + moduleFile.getName());
        }
        List<JaxrpcWebServiceInfo> jaxrpcInfoList = wsCacheInfo.getJaxrpcServices();
        List jaxrpcPortComponents = this.getJAXRPCPortComponents(moduleFile, classLoader);
        for (String pcName : jaxrpcPortComponents) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding JAX-RPC port component to cache: " + pcName + " for " + "module: " + moduleFile.getName());
            }
            JaxrpcWebServiceInfo jaxrpcInfo = this.factory.createJaxrpcWebServiceInfo();
            jaxrpcInfo.setPortComponentName(pcName);
            jaxrpcInfoList.add(jaxrpcInfo);
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "writeJAXRPCCache= " + moduleFile.getName());
        }
    }

    private List getJAXRPCPortComponents(ModuleFile moduleFile, ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJAXRPCPortComponents= " + moduleFile.getName());
        }
        List jaxrpcPortComponents = new ArrayList();
        Set<String> jaxwsClassList = null;
        if (this.dbcMap != null) {
            jaxwsClassList = this.dbcMap.keySet();
        }
        JAXRPCMetaDataHelper helper = new JAXRPCMetaDataHelper((Archive)moduleFile, classLoader, jaxwsClassList);
        JAXRPCMetaDataWrapper wrapper = helper.loadJAXRPCMetaData();
        jaxrpcPortComponents = wrapper.getJaxrpcPortComponents();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJAXRPCPortComponents= " + moduleFile.getName());
        }
        return jaxrpcPortComponents;
    }

    private void writeWSClientCache(ModuleFile moduleFile, WsCacheInfo cacheInfo, Iterator serviceRefIter) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeWSClientCache= " + moduleFile.getName());
        }
        List<WebServiceClientInfo> wsClientInfoList = cacheInfo.getWebServiceClient();
        while (serviceRefIter.hasNext()) {
            WSClientServiceDescriptor clientDesc = (WSClientServiceDescriptor)serviceRefIter.next();
            ServiceRefInfo srInfo = clientDesc.getServiceRefInfo();
            if (srInfo == null) continue;
            WebServiceClientInfo wsClientInfo = this.factory.createWebServiceClientInfo();
            wsClientInfo.setServiceRefName(srInfo.getServiceRefName());
            if (clientDesc.getClientType() == null || clientDesc.getClientType().equals((Object)WSClientType.JAX_WS)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding JAX-WS service-ref: " + srInfo.getServiceRefName() + " with service class name: " + srInfo.getServiceClassName());
                }
                wsClientInfo.setClientType(WsClientType.JAX_WS);
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding JAX-RPC service-ref: " + srInfo.getServiceRefName() + " with service class name: " + srInfo.getServiceClassName());
                }
                wsClientInfo.setClientType(WsClientType.JAX_RPC);
            }
            wsClientInfo.setServiceClassName(srInfo.getServiceClassName());
            wsClientInfoList.add(wsClientInfo);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeWSClientCache= " + moduleFile.getName());
        }
    }

    public void writeModuleCache(ModuleFile module, boolean generateMetaData, ClassLoader classLoader) throws Exception {
        FileExplorer fileExplorer = FileExplorerFactory.getFileExplorer(module, classLoader);
        List<FileLocator> fileLocators = null;
        if (fileExplorer != null) {
            fileLocators = fileExplorer.explore();
            this.buildMap(fileLocators);
        }
        String cacheSuffix = "";
        if (this.rootDir != null) {
            String currentCacheRoot = this.rootDir + this.appName + File.separator + module.getName() + File.separator;
            CacheRootDirectoryTLS.set(currentCacheRoot);
            this.moduleNames.add(module.getName());
        } else {
            cacheSuffix = this.appName + File.separator + module.getName();
        }
        WSModuleDescriptor modDesc = WSDescriptionBuilderFactory.getBuilder().getModuleDescriptor(module);
        this.dbcMap = ((WSModuleDescriptorImpl)modDesc).getDBCs();
        String cacheDirectory = this.appName + File.separator + module.getName();
        this.cache = WebServicesModuleCacheMgr.getModuleCache(cacheSuffix);
        this.cache.setClassLoader(classLoader);
        WsCacheInfo wsCacheInfo = null;
        if (this.cache.exists()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "An existing web services metadata cache was found for the module: " + module.getName() + ". This cache will " + "be rewritten");
            }
            wsCacheInfo = this.cache.getWsCacheInfo();
            wsCacheInfo = this.factory.createWsCacheInfo();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Creating web services cache at following location: " + cacheDirectory + " for class name list of size: " + (this.dbcMap.isEmpty() ? 0 : this.dbcMap.values().size()));
        }
        wsCacheInfo = this.cache.getWsCacheInfo();
        if (modDesc.containsJAXWSWebServices()) {
            this.writeJAXWSCache(classLoader, wsCacheInfo);
        }
        if (modDesc.containsJAXRPCWebServices()) {
            this.writeJAXRPCCache(module, wsCacheInfo, classLoader);
        }
        if (modDesc.containsWebServiceClients()) {
            this.writeWSClientCache(module, wsCacheInfo, modDesc.getServiceRefs());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Saving webservices XML cache for module: " + module.getName());
        }
        this.cache.save();
    }

    private List<ServiceRef> getDDServiceRefs(ModuleFile moduleFile) {
        ArrayList untypedRefs;
        ArrayList<ServiceRef> serviceRefs;
        block16: {
            block15: {
                block17: {
                    serviceRefs = new ArrayList<ServiceRef>();
                    untypedRefs = new ArrayList();
                    if (!moduleFile.isWARFile()) break block15;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Getting service refs for WAR module: " + moduleFile.getName());
                    }
                    boolean lookupWARClients = true;
                    WebApp webApp = ((WARFile)moduleFile).getDeploymentDescriptor();
                    if (webApp != null && webApp.getJ2EEVersionID() < 14 && !moduleFile.containsFile("WEB-INF/webservicesclient.xml")) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The module: " + moduleFile.getName() + " is at an earlier " + "version than J2EE 1.4, and it does not contain a WEB-INF/" + "webservicesclient.xml file. No service-ref processing will " + "be done during cache writing.");
                        }
                        lookupWARClients = false;
                    }
                    if (!lookupWARClients) break block16;
                    ModuleServiceRefAccessor serviceRefAccessor = ModuleServiceRefAccessorFactory.createModuleServiceRefAccessorWeb((ResourceSet)moduleFile.getResourceSet(), null);
                    if (serviceRefAccessor.getServiceReferences() == null || serviceRefAccessor.getServiceReferences().isEmpty()) break block17;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found service refs within WAR module: " + moduleFile.getName());
                    }
                    untypedRefs.addAll(serviceRefAccessor.getServiceReferences());
                    break block16;
                }
                if (!_tc.isDebugEnabled()) break block16;
                Tr.debug(_tc, "No service refs were found within WAR module: " + moduleFile.getName());
                break block16;
            }
            if (moduleFile.isEJBJarFile()) {
                EJBJarFile ejbJarFile;
                EJBJar ejbJar;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Getting service refs for EJB module: " + moduleFile.getName());
                }
                if ((ejbJar = (ejbJarFile = (EJBJarFile)moduleFile).getDeploymentDescriptor()) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found deployment descriptor for EJB module: " + moduleFile.getName());
                    }
                    if (ejbJar.getJ2EEVersionID() < 14 && !ejbJarFile.containsFile("META-INF/webservicesclient.xml")) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The module: " + moduleFile.getName() + " is at an earlier " + "version than J2EE 1.4, and it does not contain a META-INF/" + "webservicesclient.xml file. No service-ref processing " + "will be done during cache writing.");
                        }
                    } else {
                        for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
                            ModuleServiceRefAccessor serviceRefAccessor = ModuleServiceRefAccessorFactory.createModuleServiceRefAccessorEJB((ResourceSet)ejbJarFile.getResourceSet(), null, (String)bean.getName());
                            if (serviceRefAccessor.getServiceReferences() != null && !serviceRefAccessor.getServiceReferences().isEmpty()) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Found service refs within EJB module: " + moduleFile.getName());
                                }
                                untypedRefs.addAll(serviceRefAccessor.getServiceReferences());
                                continue;
                            }
                            if (!_tc.isDebugEnabled()) continue;
                            Tr.debug(_tc, "No service refs were found within EJB module: " + moduleFile.getName());
                        }
                    }
                }
            }
        }
        Iterator srIter = untypedRefs.iterator();
        while (srIter.hasNext()) {
            serviceRefs.add((ServiceRef)srIter.next());
        }
        return serviceRefs;
    }

    boolean cacheExistsInApp(ModuleFile moduleFile) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheExistsInApp, moduleFile= " + moduleFile.getName());
        }
        boolean cacheExists = false;
        if (moduleFile.containsFile("META-INF/ibm/webservices/cache/wscache.xml")) {
            cacheExists = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheExistsInApp, moduleFile= " + moduleFile.getName() + ", cacheExists= " + cacheExists);
        }
        return cacheExists;
    }

    boolean copyCacheFile(ModuleFile moduleFile, String appName) {
        boolean success;
        File cacheFile;
        String moduleName;
        block11: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "copyCacheFile, app= " + appName + ", module= " + moduleFile.getName());
            }
            moduleName = moduleFile.getName();
            cacheFile = null;
            success = false;
            try {
                StringBuffer sb = new StringBuffer(Axis2Utils.getCacheDirectory());
                String cacheDirPath = sb.append(appName).append(File.separator).append(moduleName).toString();
                File cacheDir = new File(cacheDirPath);
                WebServiceUtils.fileMkDirs(cacheDir);
                InputStream source = moduleFile.getInputStream("META-INF/ibm/webservices/cache/wscache.xml");
                if (source != null && WebServiceUtils.fileIsDirectory(cacheDir)) {
                    cacheFile = new File(cacheDir.getAbsolutePath() + File.separator + "wscache.xml");
                    WebServiceUtils.createFile(cacheFile);
                    if (WebServiceUtils.fileExists(cacheFile)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Copying cache file contents to location: " + cacheFile.getAbsolutePath());
                        }
                        BufferedReader reader = new BufferedReader(new InputStreamReader(source));
                        String fileContents = "";
                        String newLine = reader.readLine();
                        while (newLine != null) {
                            fileContents = fileContents + newLine + "\n";
                            newLine = reader.readLine();
                        }
                        reader.close();
                        BufferedWriter writer = new BufferedWriter(new FileWriter(cacheFile));
                        writer.write(fileContents);
                        writer.close();
                    }
                }
                source.close();
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.deploy.WSCacheWriter.copyCacheFile", "729", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The cache for the " + moduleName + " module in the " + appName + " application could not be copied");
                }
                if (cacheFile == null || !WebServiceUtils.fileExists(cacheFile)) break block11;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Removing web services cache file due to error");
                }
                WebServiceUtils.deleteFile(cacheFile);
            }
        }
        if (cacheFile != null && WebServiceUtils.fileExists(cacheFile)) {
            success = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "copyCacheFile, app= " + appName + ", module= " + moduleName + ", success= " + success);
        }
        return success;
    }
}

