/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.DefaultEndpointURIPrefix;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.websphere.management.Session;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.webservices.admin.exceptions.NoItemFoundException;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelper;
import com.ibm.ws.webservices.admin.sysmgmt.SysMgmtHelperFactory;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPrefixMapHelper {
    private static final TraceComponent _tc = Tr.register(URLPrefixMapHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    public static final String PERSISTENT_URLPREFIX_FILENAME = "URLPrefixMap";
    private Session session = null;
    private ModuleFile moduleFile = null;
    private String appName = null;
    private SysMgmtHelper smHelper = null;
    private String moduleName = null;

    public URLPrefixMapHelper(String appName, ModuleFile mf, Session session) {
        this.appName = appName;
        this.moduleFile = mf;
        this.session = session;
        this.moduleFile = mf;
        this.moduleName = this.moduleFile.getName();
    }

    public HashMap<String, String> get() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "get, [" + this.appName + ":" + this.moduleName + "]");
        }
        HashMap<String, String> bindingMap = this.getURLPrefixInfoFromBinding();
        HashMap map = null;
        this.getSysMgmtHelper(this.session);
        String filename = null;
        try {
            filename = this.smHelper.getFilePath(this.appName, this.moduleName, PERSISTENT_URLPREFIX_FILENAME, false);
        }
        catch (NoItemFoundException t) {
        }
        catch (Exception e) {
            FFDCFilter.processException(e, this.getClass().getName(), "114");
            throw e;
        }
        if (filename != null) {
            File fileObj;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URL prefix map filename: " + filename);
            }
            if ((fileObj = new File(filename)).exists()) {
                try {
                    FileInputStream fis = new FileInputStream(fileObj);
                    ObjectInputStream oi = new ObjectInputStream(fis);
                    map = (HashMap)oi.readObject();
                    fis.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "URL prefix map read from file: " + map.toString());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, this.getClass().getName(), "97", this);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "URL prefix map file does not exist...");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Could not determine URL prefix map filename...");
        }
        if (map == null) {
            map = new HashMap();
        }
        this.mergePrefix(map, bindingMap, "http");
        this.mergePrefix(map, bindingMap, "jms");
        this.mergePrefix(map, bindingMap, "ejb");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "get, returning Map: " + map.toString());
        }
        return map;
    }

    private void mergePrefix(Map map1, Map map2, String transport) {
        String s1 = (String)map1.get(transport);
        String s2 = (String)map2.get(transport);
        if (s1 == null && s2 != null) {
            map1.put(transport, s2);
        }
    }

    public void save(HashMap<String, String> map) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "save(HashMap<>), [" + this.appName + ":" + this.moduleName + "]");
            Tr.debug(_tc, "Map: " + (map == null ? "<null>" : map.toString()));
        }
        if (map != null && !map.isEmpty()) {
            try {
                this.getSysMgmtHelper(this.session);
                String filename = this.smHelper.getFilePath(this.appName, this.moduleName, PERSISTENT_URLPREFIX_FILENAME, true);
                if (filename != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "URL prefix map filename: " + filename);
                    }
                    File fileObj = new File(filename);
                    FileOutputStream fos = new FileOutputStream(fileObj);
                    ObjectOutputStream oo = new ObjectOutputStream(fos);
                    oo.writeObject(map);
                    fos.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Saved URL prefix map to file: " + map.toString());
                    }
                    this.smHelper.updateFilePath(this.appName, this.moduleName, PERSISTENT_URLPREFIX_FILENAME);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not determine URL prefix map filename...");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName(), "159", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "save(HashMap<>)");
        }
    }

    public void save(RepositoryContext repoCtx, HashMap<String, String> map) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "save(RepositoryContext,HashMap<>), [" + this.appName + ":" + this.moduleName + "]");
            Tr.debug(_tc, "Map: " + (map == null ? "<null>" : map.toString()));
        }
        if (map != null && !map.isEmpty()) {
            try {
                boolean newFile;
                String fileName = this.moduleFile.getName() + File.separator + this.moduleMetaDirectory(this.moduleFile) + File.separator + PERSISTENT_URLPREFIX_FILENAME;
                boolean bl = newFile = !repoCtx.isAvailable(fileName);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "URL prefix map file: " + fileName + ", newFile=" + (newFile ? "true" : "false"));
                }
                OutputStream os = repoCtx.getOutputStream(fileName);
                ObjectOutputStream oo = new ObjectOutputStream(os);
                oo.writeObject(map);
                os.close();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saved URL prefix map...");
                }
                int opType = newFile ? 0 : 1;
                repoCtx.notifyChanged(opType, fileName);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Notified the repository of the " + (newFile ? "new" : "changed") + " file.");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName(), "159", this);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "save(RepositoryContext,HashMap<>)");
        }
    }

    private String moduleMetaDirectory(ModuleFile mf) {
        return mf.isWARFile() ? "WEB-INF" : "META-INF";
    }

    private void getSysMgmtHelper(Session session) throws Exception {
        if (this.smHelper == null) {
            this.smHelper = SysMgmtHelperFactory.createHelper(session);
        }
        if (this.smHelper == null) {
            throw new IllegalStateException("Received null SysMgmtHelper object.");
        }
    }

    private HashMap<String, String> getURLPrefixInfoFromBinding() throws Exception {
        EList wsDescBindings;
        WSBinding wsBinding;
        String wsbFilename;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getURLPrefixInfoFromBinding");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String string = wsbFilename = this.moduleFile.isWARFile() ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to load the binding for module " + this.moduleFile.getName() + "[" + this.appName + "]: " + wsbFilename);
        }
        if ((wsBinding = WSModels.getWSBinding(this.moduleFile.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi")) != null && (wsDescBindings = wsBinding.getWsdescBindings()).size() > 0) {
            DefaultEndpointURIPrefix defaultHTTPPrefix;
            String defaultHTTPPrefixString;
            DefaultEndpointURIPrefix defaultJMSPrefix;
            String defaultJMSPrefixString;
            WSDescBinding firstBinding = (WSDescBinding)wsDescBindings.get(0);
            EList defaultPrefixes = firstBinding.getDefaultEndpointURIPrefixes();
            if (defaultPrefixes.size() >= 3) {
                DefaultEndpointURIPrefix defaultEJBPrefix = (DefaultEndpointURIPrefix)defaultPrefixes.get(2);
                String defaultEJBPrefixString = defaultEJBPrefix.getText();
                if (defaultEJBPrefixString == null) {
                    defaultEJBPrefixString = "";
                }
                map.put("ejb", defaultEJBPrefixString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Added ejb-->" + defaultEJBPrefixString + " to result map.");
                }
            }
            if (defaultPrefixes.size() >= 2 && (defaultJMSPrefixString = (defaultJMSPrefix = (DefaultEndpointURIPrefix)defaultPrefixes.get(1)).getText()) != null && defaultJMSPrefixString.length() > 0) {
                map.put("jms", defaultJMSPrefixString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Added jms-->" + defaultJMSPrefixString + " to result map.");
                }
            }
            if (defaultPrefixes.size() >= 1 && (defaultHTTPPrefixString = (defaultHTTPPrefix = (DefaultEndpointURIPrefix)defaultPrefixes.get(0)).getText()) != null && defaultHTTPPrefixString.length() > 0) {
                map.put("http", defaultHTTPPrefixString);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Added http-->" + defaultHTTPPrefixString + " to result map.");
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getURLPrefixInfoFromBinding, returning URL prefix map: " + map.toString());
        }
        return map;
    }
}

