/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.amm.client.WSAmmUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

public class PersistentStorageInstallTask
extends AbstractTask
implements Constants {
    private static final TraceComponent tc = Tr.register(PersistentStorageInstallTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String temp_dir = "WSFP_WSDL_TEMP";

    public boolean performTask() {
        block26: {
            String cacheRoot;
            File cacheRootDir;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "performTask");
            }
            CacheRootDirectoryTLS.set(this.scheduler.getTempDir() + File.separator + temp_dir + File.separator);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set temp directory on thread local: " + CacheRootDirectoryTLS.get());
            }
            if (WebServiceUtils.fileIsDirectory(cacheRootDir = new File(cacheRoot = Axis2Utils.getCacheDirectory() + this.scheduler.getAppName()))) {
                File[] files;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found root cache directory: " + cacheRoot + ". The files in " + "this directory will be backed up.");
                }
                if ((files = WebServiceUtils.listFiles(cacheRootDir)) != null) {
                    for (File file : files) {
                        File cacheFile;
                        File cacheFileBackup;
                        File[] innerFiles;
                        if (!WebServiceUtils.fileIsDirectory(file) || (innerFiles = WebServiceUtils.listFiles(file)) == null || innerFiles.length != 1 || (cacheFileBackup = WebServiceUtils.doFileCopy(cacheFile = innerFiles[0], WebServiceUtils.fileGetAbsolutePath(file) + File.separator + cacheFile.getName() + ".bak")) == null || !WebServiceUtils.fileExists(cacheFileBackup)) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "A web services backup cache file has been created. The original file will be removed.");
                        }
                        WebServiceUtils.deleteFile(cacheFile);
                    }
                }
            }
            if (this.scheduler instanceof InstallScheduler) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking to see if client bindings need to be proessed for application: " + this.scheduler.getAppName());
                }
                Object zeroBinaryCopy = this.scheduler.getProperties().get("zeroBinaryCopy");
                boolean zeroEarCopy = false;
                if (zeroBinaryCopy != null) {
                    if (zeroBinaryCopy instanceof String) {
                        zeroEarCopy = Boolean.valueOf((String)zeroBinaryCopy);
                    } else if (zeroBinaryCopy instanceof Boolean) {
                        zeroEarCopy = (Boolean)zeroBinaryCopy;
                    }
                }
                if (!zeroEarCopy) {
                    try {
                        List moduleFiles;
                        boolean changesNeeded = false;
                        EARFile earFile = ((InstallScheduler)this.scheduler).getEarFile(true, true);
                        if (earFile != null && (moduleFiles = earFile.getModuleFiles()) != null && !moduleFiles.isEmpty()) {
                            for (ModuleFile module : moduleFiles) {
                                if (!this.processClientBindings(module, true)) continue;
                                changesNeeded = true;
                                break;
                            }
                        }
                        if (!changesNeeded) break block26;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The client bindings need to be updated for application: " + this.scheduler.getAppName());
                        }
                        if ((earFile = ((InstallScheduler)this.scheduler).getEarFile()) != null) {
                            moduleFiles = earFile.getModuleFiles();
                            if (moduleFiles != null && !moduleFiles.isEmpty()) {
                                for (ModuleFile module : moduleFiles) {
                                    this.processClientBindings(module, false);
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Saving EARFile and setting new path");
                            }
                            earFile.save();
                            ((InstallScheduler)this.scheduler).setEarPath(((InstallScheduler)this.scheduler).getEarPath());
                        }
                    }
                    catch (Exception e) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("processClientBindingFail01", new Object[]{this.scheduler.getAppName(), e}, "Client binding information for the {0} application could not be processed due to the following error: {1}.");
                        Tr.error(tc, msg);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client bindings will not be processed because the " + this.scheduler.getAppName() + " is being installed with zero binary copy");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    boolean processClientBindings(ModuleFile module, boolean breakOnUpdate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processClientBindings, module= " + module.getName());
        }
        try {
            String xmiFileName = null;
            if (module instanceof EJBJarFile) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for defined service refs in EJB module: " + module.getName());
                }
                xmiFileName = "META-INF/ibm-webservicesclient-bnd.xmi";
                EJBJar ejbJar = ((EJBJarFile)module).getDeploymentDescriptor();
                Iterator ebIter = ejbJar.getEnterpriseBeans().iterator();
                if (WSAmmUtils.handleBindingComponentServiceRefs(module, ebIter) && breakOnUpdate) {
                    return true;
                }
            } else if (module instanceof WARFile || module instanceof ApplicationClientFile) {
                List<ServiceRef> serviceRefs = null;
                if (module instanceof WARFile) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for defined service refs in WAR module: " + module.getName());
                    }
                    xmiFileName = "WEB-INF/ibm-webservicesclient-bnd.xmi";
                    WebApp webApp = ((WARFile)module).getDeploymentDescriptor();
                    serviceRefs = WebServiceUtils.getJAXWSServiceRefs(webApp.getServiceRefs(), module.getArchiveClassLoader());
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking for defined service refs in app client module: " + module.getName());
                    }
                    xmiFileName = "META-INF/ibm-webservicesclient-bnd.xmi";
                    ApplicationClient appClient = ((ApplicationClientFile)module).getDeploymentDescriptor();
                    serviceRefs = WebServiceUtils.getJAXWSServiceRefs(appClient.getServiceRefs(), module.getArchiveClassLoader());
                }
                if (serviceRefs != null && !serviceRefs.isEmpty() && WSAmmUtils.handleBindingServiceRefs(module, serviceRefs, xmiFileName) && breakOnUpdate) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            String appName = Axis2Utils.getApplicationName(module);
            String msg = NLSProvider.getNLS().getFormattedMessage("processClientBindingFail00", new Object[]{module.getName(), appName, e}, "Client binding information for the {0} module in the {1} application could not be processed due to the following error: {2}.");
            Tr.error(tc, msg);
            return false;
        }
        return false;
    }
}

