/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.ws.client.applicationclient.ClientProcessService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.annotations.injection.ServiceRefPostProcessor;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefProcessor;
import com.ibm.ws.websvcs.binding.WSClassFinder;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.deployment.WSRefInfoBuilder;
import com.ibm.ws.websvcs.deployment.WSServerMetadataMerger;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import com.ibm.wsspi.websvcs.runtime.JAXWSMetaDataListener;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.message.factory.ClassFinderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2ClientImpl
extends WsComponentImpl
implements WASAxis2Service {
    private static final TraceComponent tc = Tr.register(WASAxis2ClientImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ApplicationClientFile acf;
    private ClientMetaData clientMetaData;
    private Map<String, DescriptionBuilderComposite> dbcMap;
    private boolean dbcsInitialized = false;
    private Map<String, ServiceRefPartialInfo> partialInfoMap;
    private boolean partialInfoInitialized = false;
    private ConfigurationContext configContext = null;

    @Override
    public void initialize(Object config2) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            WsServiceRegistry.addService(this, WASAxis2Service.class);
            WASAnnotationCollector.registerAnnotationAdapters();
            WebServiceRefProcessor.registerSelf();
            ClassFinderFactory cff = new ClassFinderFactory();
            cff.setClassFinder(new WSClassFinder());
            FactoryRegistry.setFactory(ClassFinderFactory.class, cff);
        }
        catch (Exception e) {
            throw new ConfigurationError(e);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
        }
    }

    @Override
    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        ClientProcessService cps = this.getClientProcessService();
        this.acf = cps.getClientFile();
        if (this.clientMetaData == null) {
            this.clientMetaData = new ClientMetaData();
        }
        Map<String, String> clientURLInfo = WASAxis2ClientImpl.loadClientURLInfo(this.acf, "META-INF/ibm-webservicesclient-bnd.xmi");
        this.clientMetaData.setClientURLInfo(clientURLInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    private ClientProcessService getClientProcessService() throws RuntimeError {
        try {
            ClientProcessService cps = WsServiceRegistry.getService(this, ClientProcessService.class);
            if (cps == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("noService", new Object[]{ClientProcessService.class.getName()}, "Internal error. The {0} internal service class could not be found.");
                throw new RuntimeError(msg);
            }
            return cps;
        }
        catch (RuntimeError e) {
            throw e;
        }
        catch (Throwable t) {
            String msg = NLSProvider.getNLS().getFormattedMessage("noService", new Object[]{ClientProcessService.class.getName()}, "Internal error. The {0} internal service class could not be found.");
            throw new RuntimeError(msg);
        }
    }

    @Override
    public void addClientConfigurationContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    @Override
    public void addJAXWSMetaDataListener(JAXWSMetaDataListener mdl) {
    }

    @Override
    public void completeAxis2Configuration(ConfigurationContext configCtx, MetaDataEvent mde) throws Exception {
    }

    @Override
    public Object getClientComponentMetaData() {
        return this.clientMetaData;
    }

    @Override
    public Object getClientComponentMetaData(ComponentMetaData cmd) {
        return this.clientMetaData;
    }

    @Override
    public List<ConfigurationContext> getClientConfigurationContexts(String appName, String modName) {
        return null;
    }

    @Override
    public Object getClientModuleMetaData() {
        return this.clientMetaData;
    }

    @Override
    public Object getClientModuleMetaData(ModuleMetaData mmd) {
        return this.clientMetaData;
    }

    @Override
    public Object getModuleMetaData() {
        return null;
    }

    @Override
    public Object getModuleMetaDataSlot() {
        return null;
    }

    @Override
    public ServiceRefPartialInfo getServiceRefInfo(String portComponentName, ModuleMetaData moduleMetaData) throws Exception {
        return null;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public ConfigurationContext loadAxis2ConfigurationContext(MetaDataEvent mde) throws Exception {
        return null;
    }

    @Override
    public ConfigurationContext loadAxis2ConfigurationContext(String applicationName, String moduleName) throws Exception {
        return null;
    }

    @Override
    public void removeJAXWSMetaDataListener(JAXWSMetaDataListener mdl) {
    }

    @Override
    public void setClientComponentMetaData(ClientMetaData clientMetaData, ComponentMetaData cmd) {
        this.clientMetaData = clientMetaData;
        this.processMetaData(clientMetaData);
    }

    @Override
    public void setClientModuleMetaData(ClientMetaData clientMetaData, ModuleMetaData mmd) {
        this.clientMetaData = clientMetaData;
        this.processMetaData(clientMetaData);
    }

    private void processMetaData(ClientMetaData clientMetaData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processMetaData, clientMetaData= " + clientMetaData);
        }
        try {
            if (this.acf != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing application client file: " + this.acf.getName());
                }
                if (this.acf instanceof Archive) {
                    Tr.debug(tc, "Client file is an archive");
                    if (!this.dbcsInitialized) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Initializing DBCs in client");
                        }
                        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        this.dbcMap = this.getDBCs(this.acf, cl);
                        this.dbcsInitialized = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "DBCs already initialized in client");
                    }
                    if (this.dbcMap != null && !this.dbcMap.isEmpty() && clientMetaData != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found DBC collection for client module: " + this.acf.getName());
                        }
                        if (!this.partialInfoInitialized) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Building partial service reference information for application client file: " + this.acf.getName());
                            }
                            WSRefInfoBuilder builder = new WSRefInfoBuilder(this.dbcMap);
                            this.partialInfoMap = builder.buildInfo();
                            this.partialInfoInitialized = true;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Partial service reference information already built for application client file: " + this.acf.getName());
                        }
                        if (this.partialInfoMap != null && !this.partialInfoMap.isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Completing client metadata for client module: " + this.acf.getName());
                            }
                            ServiceRefPostProcessor processor = new ServiceRefPostProcessor(clientMetaData.getClientServiceRefs(), this.partialInfoMap, null);
                            processor.completeClientMetadata();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("loadClientMetaDataFail00", new Object[]{this.acf.getName(), e}, "The {0} application client file could not be processed due to the following error: {1}");
            Tr.error(tc, msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processMetaData, clientMetaData= " + clientMetaData);
        }
    }

    Map<String, DescriptionBuilderComposite> getDBCs(Archive moduleFile, ClassLoader classLoader) throws Exception {
        List<FileLocator> fileLocators;
        HashMap<String, DescriptionBuilderComposite> dbcMap = null;
        FileExplorer fileExplorer = FileExplorerFactory.getFileExplorer(moduleFile, classLoader);
        if (fileExplorer != null && (fileLocators = fileExplorer.explore()) != null) {
            WASAnnotationCollector collector = new WASAnnotationCollector();
            collector.setClassLoader(classLoader);
            List<ClassDataObject> cdoList = collector.collect(fileLocators);
            if (cdoList != null) {
                WASAnnotationInputBuilder inputBuilder = new WASAnnotationInputBuilder(cdoList, classLoader, moduleFile);
                dbcMap = inputBuilder.buildInputs();
                String xmlFileName = moduleFile.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
                WebServices webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), xmlFileName);
                WSServerMetadataMerger merger = new WSServerMetadataMerger(dbcMap, webServices, moduleFile.getLoadStrategy(), moduleFile.getName());
                dbcMap.putAll(merger.mergeMetadata());
            }
        }
        return dbcMap;
    }

    static Map<String, String> loadClientURLInfo(ModuleFile moduleFile, String xmiFilePath) throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadClientURLInfo \nmodule= " + moduleFile.getName() + "\nbindingFile= " + xmiFilePath);
        }
        HashMap<String, String> clientURLInfo = new HashMap<String, String>();
        String moduleName = moduleFile.getName();
        try {
            LoadStrategy loadStrategy = moduleFile.getLoadStrategy();
            ClientBinding binding = WSModels.getWSClientBinding(loadStrategy, xmiFilePath);
            if (binding != null) {
                EList bindingRefs;
                EList componentScopedRefs = binding.getComponentScopedRefs();
                if (componentScopedRefs != null && !componentScopedRefs.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found component scoped refs in binding for module: " + moduleName);
                    }
                    for (ComponentScopedRefs csr : componentScopedRefs) {
                        WASAxis2ClientImpl.processBindingRefs(moduleFile, csr.getServiceRefs(), clientURLInfo, csr.getComponentNameLink());
                    }
                }
                if ((bindingRefs = binding.getServiceRefs()) != null && !bindingRefs.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found service refs in binding for module: " + moduleName);
                    }
                    WASAxis2ClientImpl.processBindingRefs(moduleFile, bindingRefs, clientURLInfo, null);
                }
            }
        }
        catch (Throwable t) {
            String appName = WebServiceUtils.getApplicationName(moduleFile);
            String msg = NLSProvider.getNLS().getFormattedMessage("processClientBindingFail00", new Object[]{moduleName, appName, t}, "Client binding information for the {0} module  in the {1} application could not be processed due to the following error: {2}.");
            throw new RuntimeError(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "loadClientURLInfo \nmodule= " + moduleFile.getName() + "\n bindingFile= " + xmiFilePath + "\n clientURLInfo= " + clientURLInfo);
            }
        }
        return clientURLInfo;
    }

    static void processBindingRefs(ModuleFile moduleFile, List bindingRefs, Map<String, String> clientURLInfo, String componentLink) {
        for (ServiceRef bindingRef : bindingRefs) {
            String localPart;
            EList portQNames;
            String serviceRefLink = bindingRef.getServiceRefLink();
            org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef = WASAxis2ClientImpl.getServiceRef(moduleFile, serviceRefLink, componentLink);
            if (serviceRef == null || (portQNames = bindingRef.getPortQnameBindings()) == null || portQNames.isEmpty()) continue;
            String string = localPart = serviceRef.getServiceQname() != null ? serviceRef.getServiceQname().getLocalPart() : null;
            if (localPart == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Did not find local service name for service ref: " + serviceRef.getServiceRefName() + ". The client binding will not be processed " + "for this service-ref");
                continue;
            }
            String tns = serviceRef.getServiceQname() != null ? serviceRef.getServiceQname().getNamespaceURI() : null;
            QName sqName = new QName(tns, localPart);
            for (PortQnameBinding portBinding : portQNames) {
                String localPortName = portBinding.getPortQnameLocalNameLink();
                QName pqName = new QName(tns, localPortName);
                String url = portBinding.getOverriddenEndpointURI();
                if (url == null || "".equals(url)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For the port: " + pqName + " within the service: " + sqName + " setting overridden endpoint URL: " + url);
                }
                String key = sqName.toString() + ":" + pqName.toString();
                clientURLInfo.put(key, url);
            }
        }
    }

    static org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef getServiceRef(ModuleFile moduleFile, String serviceRefLink, String componentName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceRef \nmodule= " + moduleFile.getName() + "\nserviceRefLink= " + serviceRefLink, "\ncomponentName= " + componentName);
        }
        org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef = null;
        EList serviceRefs = null;
        if (moduleFile.isWARFile()) {
            serviceRefs = ((WARFile)moduleFile).getDeploymentDescriptor().getServiceRefs();
        } else if (moduleFile.isEJBJarFile()) {
            EJBJar ejbJar = ((EJBJarFile)moduleFile).getDeploymentDescriptor();
            EnterpriseBean bean = ejbJar.getEnterpriseBeanNamed(componentName);
            if (bean == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Service ref entries could not be found for the " + moduleFile.getName() + " EJB JAR because an EnterpriseBean with the " + componentName + " was not found.");
                }
            } else {
                serviceRefs = bean.getServiceRefs();
            }
        } else if (moduleFile instanceof ApplicationClientFile) {
            serviceRefs = ((ApplicationClientFile)moduleFile).getDeploymentDescriptor().getServiceRefs();
        }
        if (serviceRefs != null && !serviceRefs.isEmpty()) {
            for (org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef currentRef : serviceRefs) {
                if (!serviceRefLink.equals(currentRef.getServiceRefName())) continue;
                serviceRef = currentRef;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceRef \nmodule= " + moduleFile.getName() + "\nserviceRefLink= " + serviceRefLink, "\ncomponentName= " + componentName + "\nserviceRef= " + serviceRef);
        }
        return serviceRef;
    }

    @Override
    public boolean isServerEnv() {
        return false;
    }
}

