/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.configarchive.ConfigArchiveCommand;
import com.ibm.wsspi.configarchive.ImportStep;
import java.util.Hashtable;
import java.util.SortedMap;
import javax.management.ObjectName;

public class WSImportCommandExt
extends ImportStep {
    private static final TraceComponent _tc = Tr.register(WSImportCommandExt.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSImportCommandExt(AbstractTaskCommand absTskCmd, CommandData cmdData) throws CommandNotFoundException {
        super(absTskCmd, cmdData);
    }

    public WSImportCommandExt(AbstractTaskCommand absTskCmd, CommandMetadata cmdMetadata) {
        super(absTskCmd, cmdMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeStep() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "executeStep");
        }
        try {
            ObjectName[] servers;
            String nodeName = (String)this.taskCmd.getParameter("nodeName");
            Hashtable<String, Object> prefs = new Hashtable<String, Object>();
            ManagedObjectMetadataHelper helper = ((ConfigArchiveCommand)this.taskCmd).getConfigArchiveMetadataHelper();
            SortedMap versionsMap = helper.getNodeProductVersions(nodeName);
            String baseVersion = helper.getNodeBaseProductVersion(nodeName);
            if (!WSCommandUtils.targetARSApp(versionsMap, baseVersion)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The ARS application will not be targetted to the " + nodeName + " node because it is not a WSFP or higher node.");
                }
                return;
            }
            if (WSCommandUtils.useOldARSConfig(baseVersion)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The ARS application will use the WSFP binaries location");
                }
                prefs.put("com.ibm.ws.websvcs.ARS_USE_OLD_CONFIG", Boolean.TRUE);
            }
            Session session = this.getConfigSession();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Node", nodeName);
            ObjectName node = cs.queryConfigObjects(session, null, pattern, null)[0];
            pattern = ConfigServiceHelper.createObjectName(null, "Server");
            for (ObjectName server : servers = cs.queryConfigObjects(session, node, pattern, null)) {
                String serverType;
                String serverName = ConfigServiceHelper.getDisplayName(server);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "serverName", new Object[]{nodeName, server, serverName});
                }
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand getServerTypeCmd = commandMgr.createCommand("getServerType");
                getServerTypeCmd.setConfigSession(session);
                getServerTypeCmd.setParameter("serverName", serverName);
                getServerTypeCmd.setParameter("nodeName", nodeName);
                getServerTypeCmd.execute();
                CommandResult cmdResult = getServerTypeCmd.getCommandResult();
                if (!cmdResult.isSuccessful() || !(serverType = (String)cmdResult.getResult()).equals("APPLICATION_SERVER")) continue;
                String cell = ConfigServiceHelper.getObjectLocation(server).getProperty("cell");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found app server: " + serverName + " on cell: " + cell + " node: " + nodeName);
                }
                prefs.put("cell.name", cell);
                prefs.put("node.name", nodeName);
                prefs.put("server.name", serverName);
                prefs.put("server", serverName);
                prefs.put("META-INF/ibm-application-ha.props", true);
                prefs.put("target", serverName);
                prefs.put("META-INF/ibm-application-sa.props", false);
                WSCommandUtils utils = new WSCommandUtils();
                utils.installApplication(prefs, this.getConfigService(), session, this.isLocalMode());
            }
        }
        catch (Throwable t) {
            String msg = NLSProvider.getNLS().getFormattedMessage("sysappinstallfail00", new Object[]{t}, "The ibmasyncrsp.ear system application could not be installed due to the following error: {0}");
            Tr.error(_tc, msg);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "executeStep");
            }
        }
    }
}

