/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SortedMap;
import javax.management.ObjectName;

public class WSDeleteClusterMemberExt
extends AbstractCommandStep {
    private static final TraceComponent _tc = Tr.register(WSDeleteClusterMemberExt.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSDeleteClusterMemberExt(AbstractTaskCommand parent, CommandMetadata metadata) {
        super(parent, metadata);
    }

    public WSDeleteClusterMemberExt(AbstractTaskCommand parent, CommandData stepData) throws CommandNotFoundException {
        super(parent, stepData);
    }

    protected void executeStep() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "executeStep");
        }
        try {
            Session session = this.getConfigSession();
            ConfigService service = this.getConfigService();
            String cluster = (String)this.taskCmd.getParameter("clusterName");
            if (cluster != null) {
                String server = (String)this.taskCmd.getParameter("memberName");
                String node = null;
                String cell = null;
                WSCommandUtils utils = new WSCommandUtils();
                ObjectName serverON = this.getServerON(utils.getClusterMemberObjs(cluster, service, session), server);
                if (serverON != null) {
                    String baseVersion;
                    Properties props;
                    ManagedObjectMetadataAccessor accessor;
                    ManagedObjectMetadataHelper helper;
                    SortedMap versionsMap;
                    node = (String)this.taskCmd.getParameter("memberNode");
                    cell = ConfigServiceHelper.getObjectLocation(serverON).getProperty("cell");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Server: " + server + ", on node: " + node + " is being removed " + "from cluster: " + cluster);
                    }
                    if (!WSCommandUtils.targetARSApp(versionsMap = (helper = new ManagedObjectMetadataHelper(accessor = ManagedObjectMetadataAccessorFactory.createAccessor(props = new Properties()))).getNodeProductVersions(node), baseVersion = helper.getNodeBaseProductVersion(node))) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The server: " + server + " is a not a WSFP or higher server");
                        }
                        if (utils.installARSToCluster(cluster, service, session, server)) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "After removing server: " + server + " from cluster: " + cluster + " the ARS application will be installed");
                            }
                            Hashtable<String, Object> prefs = new Hashtable<String, Object>();
                            prefs.put("cell.name", cell);
                            prefs.put("node.name", node);
                            prefs.put("META-INF/ibm-application-ha.props", true);
                            prefs.put("target", cluster);
                            prefs.put("META-INF/ibm-application-sa.props", false);
                            prefs.put("cluster.name", cluster);
                            utils.installApplication(prefs, service, session, this.isLocalMode());
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "No action needed during removal of cluster member: " + server + " from cluster: " + cluster);
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not find ObjectName instance for member being removed. The member being removed is not a server.");
                }
            }
        }
        catch (Throwable t) {
            String msg = NLSProvider.getNLS().getFormattedMessage("sysappinstallfail00", new Object[]{t}, "The ibmasyncrsp.ear system application could not be installed due to the following error: {0}");
            Tr.error(_tc, msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "executeStep");
        }
    }

    private ObjectName getServerON(ObjectName[] objectNames, String serverName) throws Exception {
        if (objectNames != null && objectNames.length > 0) {
            for (ObjectName objectName : objectNames) {
                String server = ConfigServiceHelper.getDisplayName(objectName);
                if (!serverName.equals(server)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found ObjectName for server: " + server + " being removed from the cluster");
                }
                return objectName;
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No server members were found in the cluster");
        }
        return null;
    }
}

