/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.util.Hashtable;
import java.util.Properties;
import java.util.SortedMap;
import javax.management.ObjectName;

public class WSCreateServerExt
extends AbstractCommandStep {
    private static final TraceComponent _tc = Tr.register(WSCreateServerExt.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSCreateServerExt(AbstractTaskCommand parent, CommandMetadata metadata) {
        super(parent, metadata);
    }

    public WSCreateServerExt(AbstractTaskCommand parent, CommandData stepData) throws CommandNotFoundException {
        super(parent, stepData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStep() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "executeStep");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Attempting to install ARS application from the following location: " + Constants.ASYNC_RSP_SYS_APP_PATH_EXTRACTED);
        }
        String server = null;
        String node = null;
        String cell = null;
        boolean doInstall = true;
        boolean checkForUninstall = false;
        try {
            String baseVersion;
            ObjectName serverON = (ObjectName)this.taskCmd.getCommandResult().getResult();
            node = ConfigServiceHelper.getObjectLocation(serverON).getProperty("node");
            cell = ConfigServiceHelper.getObjectLocation(serverON).getProperty("cell");
            server = ConfigServiceHelper.getDisplayName(serverON);
            String cluster = (String)this.taskCmd.getParameter("clusterName");
            Hashtable<String, Object> prefs = new Hashtable<String, Object>();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Installing ARS application on cell: " + cell + " node: " + node + " server: " + server);
            }
            Properties props = new Properties();
            WSCommandUtils utils = new WSCommandUtils();
            Session session = this.getConfigSession();
            ConfigService service = this.getConfigService();
            ManagedObjectMetadataAccessor accessor = ManagedObjectMetadataAccessorFactory.createAccessor(props);
            ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(accessor);
            SortedMap versionsMap = helper.getNodeProductVersions(node);
            if (!WSCommandUtils.targetARSApp(versionsMap, baseVersion = helper.getNodeBaseProductVersion(node))) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The ARS application will not be targetted to the " + node + " node because it is not a WSFP or higher node.");
                }
                doInstall = false;
                if (cluster != null && !"".equals(cluster)) {
                    checkForUninstall = true;
                }
            }
            if (cluster != null && !"".equals(cluster) && !utils.installARSToCluster(cluster, service, session, null)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The ARS application will not be installed to the cluster: " + cluster + " because the cluster contains members which are not WSFP or " + "higher members.");
                }
                doInstall = false;
                checkForUninstall = true;
            }
            if (doInstall) {
                if (WSCommandUtils.useOldARSConfig(baseVersion)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The ARS application will use the WSFP binaries location");
                    }
                    prefs.put("com.ibm.ws.websvcs.ARS_USE_OLD_CONFIG", Boolean.TRUE);
                }
                prefs.put("cell.name", cell);
                prefs.put("node.name", node);
                prefs.put("server.name", server);
                prefs.put("server", server);
                prefs.put("META-INF/ibm-application-ha.props", true);
                prefs.put("target", server);
                prefs.put("META-INF/ibm-application-sa.props", false);
                if (cluster != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Server: " + server + " is part of cluster: " + cluster);
                    }
                    prefs.put("cluster.name", cluster);
                }
                utils.installApplication(prefs, service, session, this.isLocalMode());
            } else if (checkForUninstall) {
                prefs.put("cell.name", cell);
                prefs.put("node.name", node);
                prefs.put("server.name", server);
                prefs.put("server", server);
                prefs.put("META-INF/ibm-application-ha.props", true);
                prefs.put("target", server);
                prefs.put("META-INF/ibm-application-sa.props", false);
                prefs.put("cluster.name", cluster);
                if (utils.uninstallARSFromCluster(service, session, prefs)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The ARS application will be removed from the " + cluster + " cluster.");
                    }
                    utils.uninstallApplication(prefs, service, session, this.isLocalMode());
                }
            }
        }
        catch (Throwable t) {
            String msg = NLSProvider.getNLS().getFormattedMessage("sysappinstallfail00", new Object[]{t}, "The ibmasyncrsp.ear system application could not be installed due to the following error: {0}");
            Tr.error(_tc, msg);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "executeStep");
            }
        }
    }
}

