/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.management.application.client.MapModulesToServers;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.websvcs.Constants;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class WSCommandUtils {
    private static final TraceComponent _tc = Tr.register(WSCommandUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static boolean targetARSApp(Map versionsMap, String baseVersion) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "targetARSApp");
        }
        boolean targetARSApp = false;
        if (versionsMap != null && versionsMap.get("WS FEP") != null) {
            targetARSApp = true;
        } else if (Utils.compareVersions((String)baseVersion, (String)"7.0.0") >= 0) {
            targetARSApp = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "targetARSApp= " + String.valueOf(targetARSApp));
        }
        return targetARSApp;
    }

    public static boolean useOldARSConfig(String baseVersion) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "useOldARSConfig");
        }
        boolean useOldARSConfig = false;
        if (Utils.compareVersions((String)baseVersion, (String)"6.1.0.19") < 0) {
            useOldARSConfig = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "useOldARSConfig= " + String.valueOf(useOldARSConfig));
        }
        return useOldARSConfig;
    }

    public int getMappingIndex(Vector appInfo) {
        for (int i = 0; i < appInfo.size(); ++i) {
            Object obj = appInfo.get(i);
            if (!(obj instanceof MapModulesToServers)) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found application mapping object");
            }
            return i;
        }
        return -1;
    }

    public void addNewTarget(MapModulesToServers mapping, String cell, String node, String server, String cluster) throws AppDeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addNewTarget");
        }
        String[][] taskData = mapping.getTaskData();
        String[] newEntry = taskData[taskData.length - 1];
        String newTarget = "";
        if (cluster == null) {
            newTarget = "WebSphere:cell=" + cell + ",node=" + node + ",server=" + server;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added new server target: " + newTarget);
            }
        } else {
            newTarget = "WebSphere:cell=" + cell + ",cluster=" + cluster;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added new cluster target: " + newTarget);
            }
        }
        if (newEntry[2] != null && !"".equals(newEntry[2])) {
            if (!this.targetExists(newTarget, newEntry[2])) {
                newEntry[2] = newEntry[2] + "+" + newTarget;
            }
        } else {
            newEntry[2] = newTarget;
        }
        taskData[taskData.length - 1] = newEntry;
        mapping.setTaskData(taskData);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addNewTarget= " + newEntry[2]);
        }
    }

    boolean targetExists(String newTarget, String existingTargets) {
        String inLineTarget = newTarget + "+";
        if (existingTargets.indexOf(inLineTarget) != -1) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Not adding target because the target already exists: " + newTarget + " existing target: " + existingTargets);
            }
            return true;
        }
        int lastIndex = existingTargets.lastIndexOf(newTarget);
        int targetIndex = existingTargets.length() - newTarget.length();
        if (lastIndex != -1 && targetIndex == lastIndex) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Not adding target because the target already exists: " + newTarget + " existing target: " + existingTargets);
            }
            return true;
        }
        return false;
    }

    String removeTarget(String targetToRemove, String existingTargets) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeTarget, targetToRemove= " + targetToRemove + ", appTargets= " + existingTargets);
        }
        String newTargets = existingTargets;
        String inLineTarget = targetToRemove + "+";
        if (existingTargets.indexOf(inLineTarget) != -1) {
            newTargets = existingTargets.replace(inLineTarget, "");
        } else {
            int lastIndex = existingTargets.lastIndexOf(targetToRemove);
            int targetIndex = existingTargets.length() - targetToRemove.length();
            if (lastIndex != -1 && targetIndex == lastIndex) {
                if (targetIndex == 0) {
                    targetIndex = 1;
                }
                newTargets = existingTargets.substring(0, targetIndex - 1);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeTarget, targetToRemove= " + targetToRemove + ", appTargets= " + newTargets);
        }
        return newTargets;
    }

    public void updateAppInfo(Vector appInfo, int index, String cell, String node, String server, String cluster) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateAppInfo");
        }
        MapModulesToServers mapping = (MapModulesToServers)appInfo.get(index);
        this.addNewTarget(mapping, cell, node, server, cluster);
        appInfo.add(index, mapping);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateAppInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installApplication(Hashtable prefs, ConfigService service, Session session, boolean isLocalMode) throws Exception {
        Vector appInfo;
        int index;
        String binPath;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "installApplication");
        }
        String serverName = (String)prefs.get("server.name");
        String nodeName = (String)prefs.get("node.name");
        String cellName = (String)prefs.get("cell.name");
        String clusterName = (String)prefs.get("cluster.name");
        Boolean useOldConfig = (Boolean)prefs.get("com.ibm.ws.websvcs.ARS_USE_OLD_CONFIG");
        if (useOldConfig == null) {
            useOldConfig = false;
        }
        String string = binPath = useOldConfig != false ? "${WAS_INSTALL_ROOT}/systemApps/ibmasyncrsp.ear" : "${WAS_INSTALL_ROOT}/systemApps/ibmARS.ear";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Installing ARS application with binary path: " + binPath);
        }
        prefs.put("zeroEarCopy", true);
        prefs.put("installed.ear.destination.final", binPath);
        AppManagement appMgmt = this.getAppMgmtObject(service);
        if (!appMgmt.checkIfAppExists("ibmasyncrsp", prefs, session.toString())) {
            WSCommandListener listener;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Installing ARS application to new server");
            }
            WSCommandListener wSCommandListener = listener = new WSCommandListener("ibmasyncrsp", "InstallApplication");
            synchronized (wSCommandListener) {
                block25: {
                    if (isLocalMode) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Installing ARS application in local mode");
                        }
                        appMgmt.installApplicationLocal(Constants.ASYNC_RSP_SYS_APP_PATH_EXTRACTED, "ibmasyncrsp", prefs, listener, session.toString());
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Installing ARS application in non-local mode");
                        }
                        appMgmt.installApplication(Constants.ASYNC_RSP_SYS_APP_PATH_EXTRACTED, "ibmasyncrsp", prefs, session.toString());
                    }
                    if (!listener.isComplete()) {
                        try {
                            listener.wait();
                        }
                        catch (InterruptedException ie) {
                            Tr.debug(_tc, "Interrupted.  Continue...");
                        }
                    }
                    if (!listener.isSuccess()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "App install completed but was not successful");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "App install completed and was successful");
                    }
                    try {
                        AdminServiceFactory.getAdminService().removeNotificationListener(listener.getAppMgmt(), listener);
                    }
                    catch (Throwable t) {
                        if (!_tc.isDebugEnabled()) break block25;
                        Tr.debug(_tc, "Could not remove app notification listener: " + t.toString());
                    }
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ARS application already targetted for federated node. Updating target mappings");
        }
        if ((index = this.getMappingIndex(appInfo = appMgmt.getApplicationInfo("ibmasyncrsp", prefs, session.toString()))) != -1) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found application target mapping object");
            }
            this.updateAppInfo(appInfo, index, cellName, nodeName, serverName, clusterName);
            appMgmt.setApplicationInfo("ibmasyncrsp", prefs, session.toString(), appInfo);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "installApplication");
        }
    }

    void removeInvalidTarget(ConfigService service, Session session, Hashtable prefs) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeInvalidTarget");
        }
        AppManagement appMgmt = this.getAppMgmtObject(service);
        Vector appInfo = appMgmt.getApplicationInfo("ibmasyncrsp", prefs, session.toString());
        String serverName = (String)prefs.get("server.name");
        String nodeName = (String)prefs.get("node.name");
        String cellName = (String)prefs.get("cell.name");
        int index = this.getMappingIndex(appInfo);
        MapModulesToServers mapping = (MapModulesToServers)appInfo.get(index);
        String[][] taskData = mapping.getTaskData();
        String[] newEntry = taskData[taskData.length - 1];
        String oldTargets = newEntry[2];
        String invalidTarget = "WebSphere:cell=" + cellName + ",node=" + nodeName + ",server=" + serverName;
        if (this.targetExists(invalidTarget, newEntry[2])) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removing invalid target for ARS application: " + invalidTarget);
            }
            newEntry[2] = this.removeTarget(invalidTarget, newEntry[2]);
            taskData[taskData.length - 1] = newEntry;
            mapping.setTaskData(taskData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeInvalidTarget, invalidTarget= " + invalidTarget + ", previousTargets= " + oldTargets + ", newTargets= " + newEntry[2]);
        }
    }

    protected AppManagement getAppMgmtObject(ConfigService service) throws Exception {
        AppManagement appMgmt = null;
        if (service instanceof ConfigServiceProxy) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving app management bean for client");
            }
            appMgmt = AppManagementProxy.getJMXProxyForClient(((ConfigServiceProxy)service).getAdminClient());
        } else if (AdminServiceFactory.getAdminService() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving app management bean for local");
            }
            appMgmt = AppManagementProxy.getLocalProxy();
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving app management bean for server");
            }
            appMgmt = AppManagementProxy.getJMXProxyForServer();
        }
        return appMgmt;
    }

    public boolean installARSToCluster(String clusterName, ConfigService configService, Session session, String removedServer) throws Exception {
        ObjectName[] currentMemberObjs;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "installARSToCluster= " + clusterName);
        }
        boolean targetApp = true;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking to see if the ARS application should be installed to the cluster: " + clusterName);
        }
        if ((currentMemberObjs = this.getClusterMemberObjs(clusterName, configService, session)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found " + currentMemberObjs.length + " existing cluster " + "member(s) for cluster: " + clusterName);
            }
            for (int i = 0; i < currentMemberObjs.length; ++i) {
                String baseVersion;
                String serverName = (String)configService.getAttribute(session, currentMemberObjs[i], "memberName");
                if (removedServer != null && removedServer.equals(serverName)) continue;
                String nodeName = (String)configService.getAttribute(session, currentMemberObjs[i], "nodeName");
                ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                SortedMap versionsMap = helper.getNodeProductVersions(nodeName);
                if (WSCommandUtils.targetARSApp(versionsMap, baseVersion = helper.getNodeBaseProductVersion(nodeName))) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For the cluster: " + clusterName + " a non-WSFP " + "server member was found. The ARS application will not be " + "targetted for this cluster.");
                }
                targetApp = false;
                break;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "installARSToCluster= " + String.valueOf(targetApp));
        }
        return targetApp;
    }

    public boolean uninstallARSFromCluster(ConfigService configService, Session session, Hashtable prefs) throws Exception {
        AppManagement appMgmt;
        String clusterName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "uninstallARSFromCluster");
        }
        if ((clusterName = (String)prefs.get("cluster.name")) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The uninstallARSFromCluster method was called but no cluster name was available. No action will be taken");
            }
            return false;
        }
        boolean uninstallARS = false;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking to see if ARS application should be uninstalled from cluster: " + clusterName);
        }
        if ((appMgmt = this.getAppMgmtObject(configService)) != null && appMgmt.checkIfAppExists("ibmasyncrsp", prefs, session.toString())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The ARS application needs to be uninstalled from the cluster: " + clusterName);
            }
            uninstallARS = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "uninstallARSFromCluster= " + String.valueOf(uninstallARS));
        }
        return uninstallARS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallApplication(Hashtable prefs, ConfigService service, Session session, boolean isLocalMode) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "uninstallApplication");
        }
        String serverName = (String)prefs.get("server.name");
        String nodeName = (String)prefs.get("node.name");
        String cellName = (String)prefs.get("cell.name");
        String clusterName = (String)prefs.get("cluster.name");
        AppManagement appMgmt = this.getAppMgmtObject(service);
        if (appMgmt.checkIfAppExists("ibmasyncrsp", prefs, session.toString())) {
            WSCommandListener listener;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Uninstalling ARS application from cluster: " + clusterName);
            }
            WSCommandListener wSCommandListener = listener = new WSCommandListener("ibmasyncrsp", "UninstallApplication");
            synchronized (wSCommandListener) {
                block21: {
                    if (isLocalMode) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Uninstalling ARS application in local mode");
                        }
                        appMgmt.uninstallApplicationLocal("ibmasyncrsp", prefs, listener, session.toString());
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Uninstalling ARS application in non-local mode");
                        }
                        appMgmt.uninstallApplication("ibmasyncrsp", prefs, session.toString());
                    }
                    if (!listener.isComplete()) {
                        try {
                            listener.wait();
                        }
                        catch (InterruptedException ie) {
                            Tr.debug(_tc, "Interrupted.  Continue...");
                        }
                    }
                    if (!listener.isSuccess()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "App uninstall completed but was not successful");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "App uninstall completed and was successful");
                    }
                    try {
                        AdminServiceFactory.getAdminService().removeNotificationListener(listener.getAppMgmt(), listener);
                    }
                    catch (Throwable t) {
                        if (!_tc.isDebugEnabled()) break block21;
                        Tr.debug(_tc, "Could not remove app notification listener: " + t.toString());
                    }
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The ARS application could not be uninstalled because it does not exist on the cluster: " + clusterName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "uninstallApplication");
        }
    }

    public ObjectName[] getClusterMemberObjs(String clusterName, ConfigService configService, Session session) throws Exception {
        ObjectName clusterObj = configService.resolve(session, "ServerCluster=" + clusterName)[0];
        ObjectName[] currentMemberObjs = null;
        ObjectName pattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
        currentMemberObjs = configService.queryConfigObjects(session, clusterObj, pattern, null);
        return currentMemberObjs;
    }

    private static class WSCommandListener
    implements AppNotification.Listener,
    NotificationListener {
        private boolean complete = false;
        private boolean success = false;
        private String appName;
        private ObjectName appmgmtMBean = null;
        private String appNotifierKey = null;

        public WSCommandListener(String appName, String appNotifierKey) throws Exception {
            this.appName = appName;
            this.appNotifierKey = appNotifierKey;
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding notification listener to application management bean");
                }
                String process = adminService.getProcessName();
                String node = adminService.getNodeName();
                String query = "WebSphere:type=AppManagement,node=" + node + ",process=" + process + ",*";
                Set match = adminService.queryNames(new ObjectName(query), null);
                if (match.size() >= 1) {
                    this.appmgmtMBean = (ObjectName)match.iterator().next();
                    NotificationFilterSupport filter = new NotificationFilterSupport();
                    filter.enableType("websphere.admin.appmgmt");
                    adminService.addNotificationListener(this.appmgmtMBean, this, (NotificationFilter)filter, null);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Succesfully added notification listener to application management bean");
                    }
                }
            }
        }

        public void handleNotification(Notification notf, Object handback) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "handleNotification");
            }
            if (notf == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Notification is null handback: " + handback);
                }
                return;
            }
            Object userData = notf.getUserData();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Notification not null userData: " + userData);
            }
            if (userData instanceof AppNotification) {
                this.appEventReceived((AppNotification)userData);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "handleNotification");
            }
        }

        public synchronized void appEventReceived(AppNotification ev) {
            String thisAppName;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "appEventReceived");
            }
            if (this.appName.equals(thisAppName = ev.props.getProperty("appname"))) {
                if (ev.taskStatus.equals("Completed") && ev.taskName.equals(this.appNotifierKey)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Received notification ARS application action " + this.appNotifierKey + " completed and was successful");
                    }
                    this.complete = true;
                    this.success = true;
                    this.notifyAll();
                } else if (ev.taskStatus.equals("Failed") && ev.taskName.equals(this.appNotifierKey)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Received notification ARS application action " + this.appNotifierKey + " completed but was not successful");
                    }
                    this.complete = true;
                    this.success = false;
                    this.notifyAll();
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "appEventReceived");
            }
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public ObjectName getAppMgmt() {
            return this.appmgmtMBean;
        }
    }
}

