/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.collaborators;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaboratorConfig;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppInitializationCollaborator;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import com.ibm.ws.webservices.pmi.modules.ServicePmiModule;
import com.ibm.ws.websvcs.metadata.MetaDataHolder;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import com.ibm.wsspi.wswebcontainer.metadata.WebModuleMetaData;
import java.util.Iterator;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class WebCollaborator
implements WebAppInitializationCollaborator {
    private static TraceComponent _tc = Tr.register(WebCollaborator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void starting(WebAppCollaboratorConfig collabData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void started(WebAppCollaboratorConfig collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "started, module=" + collabData.getWebApp().getWebAppConfig().getModuleName());
        }
        try {
            ServerModuleMetaData smmd = this.getServerModuleMetaData(collabData);
            if (smmd != null) {
                ModulePmiModule pmiModule = null;
                if (StatsFactory.isPMIEnabled()) {
                    pmiModule = new ModulePmiModule(smmd.getApplicationName(), smmd.getModuleName());
                }
                if (pmiModule != null) {
                    if (smmd.getConfigurationContext() == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "ConfigurationContext is null! This needs to exist to start PMI services.");
                        }
                        return;
                    }
                    AxisConfiguration axisCfg = smmd.getConfigurationContext().getAxisConfiguration();
                    Iterator svcGrpIter = axisCfg.getServiceGroups();
                    while (svcGrpIter.hasNext()) {
                        AxisServiceGroup svcGrp = (AxisServiceGroup)svcGrpIter.next();
                        Iterator svcIter = svcGrp.getServices();
                        while (svcIter.hasNext()) {
                            AxisService svc = (AxisService)svcIter.next();
                            String serviceName = Axis2Utils.getServiceQName(svc).toString();
                            String portName = Axis2Utils.getPortName(svc);
                            ServicePmiModule pmiService = null;
                            if (serviceName != null) {
                                pmiService = pmiModule.registerService(serviceName);
                            }
                            if (portName == null || pmiService == null) continue;
                            pmiService.registerEndpoint(portName);
                        }
                    }
                    smmd.setPmiModule(pmiModule);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The services above were loaded onto PMI module.");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "PMI is disabled, not adding services to PMI module.");
                }
                EndpointManagerMBean mbean = Axis2Utils.getEndpointManagerMBean(smmd.getConfigurationContext());
                if (mbean != null) {
                    mbean.startAll();
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "MBean was not available in metadata.");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Server Module Metadata is null. This is not a JAX-WS App.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.collaborators.WebCollaborator.started", "135", this);
            Tr.error(_tc, "loadPMIFail00", e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "started");
            }
        }
    }

    public void stopping(WebAppCollaboratorConfig collabData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped(WebAppCollaboratorConfig collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopped, module=" + collabData.getWebApp().getWebAppConfig().getModuleName());
        }
        try {
            ServerModuleMetaData smmd = this.getServerModuleMetaData(collabData);
            if (smmd != null) {
                ModulePmiModule pmiModule = smmd.getPmiModule();
                if (pmiModule != null) {
                    pmiModule.destroy();
                }
                smmd.setPmiModule(null);
                EndpointManagerMBean mbean = Axis2Utils.getEndpointManagerMBean(smmd.getConfigurationContext());
                if (mbean != null) {
                    mbean.stopAll();
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "MBean was not available in metadata.");
                }
            }
        }
        catch (NullPointerException npe) {
            FFDCFilter.processException((Throwable)npe, "com.ibm.ws.websvcs.collaborators.WebCollaborator.stopped", "222", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Exiting. PMI object has already been removed.");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.collaborators.WebCollaborator.stopped", "228", this);
            Tr.error(_tc, "unloadPMIFail00", e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "stopped");
            }
        }
    }

    private ServerModuleMetaData getServerModuleMetaData(WebAppCollaboratorConfig collabConfig) throws Exception {
        WebApp _webapp = collabConfig.getWebApp();
        WASAxis2Service service = WsServiceRegistry.getService(this, WASAxis2Service.class);
        WebModuleMetaData mmd = (WebModuleMetaData)_webapp.getConfiguration().getMetaData();
        MetaDataSlot slot = (MetaDataSlot)service.getModuleMetaDataSlot();
        ServerModuleMetaData smmd = null;
        MetaDataHolder mdh = (MetaDataHolder)mmd.getMetaData(slot);
        if (mdh != null) {
            smmd = mdh.getServerModuleMetaData();
        }
        return smmd;
    }
}

