/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.collaborators;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentInitializationCollaborator;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class EjbCollaborator
implements EJBComponentInitializationCollaborator {
    private static TraceComponent _tc = Tr.register(EjbCollaborator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private WASAxis2MetaDataImpl metadata = null;

    public EjbCollaborator(WASAxis2MetaDataImpl metadata) {
        this.metadata = metadata;
    }

    public void starting(EJBComponentMetaData collabData) {
    }

    public void started(EJBComponentMetaData collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EjbCollaborator.started()...");
        }
        try {
            ConfigurationContext cc = null;
            EndpointManagerMBean mbean = null;
            ServerModuleMetaData smmd = this.getServerModuleMetaData(collabData);
            if (smmd != null && (cc = smmd.getConfigurationContext()) != null) {
                mbean = Axis2Utils.getEndpointManagerMBean(cc);
                if (mbean != null) {
                    mbean.startAll();
                }
                this.checkJMSMappings(cc);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SMMD: " + smmd + ", CC: " + cc + ", EndptMgr: " + mbean);
            }
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{e};
            Tr.error(_tc, "caughtException", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EjbCollaborator.started()");
        }
    }

    public void stopping(EJBComponentMetaData collabData) {
    }

    public void stopped(EJBComponentMetaData collabData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EjbCollaborator.stopped()...");
        }
        try {
            ConfigurationContext cc = null;
            EndpointManagerMBean mbean = null;
            ServerModuleMetaData smmd = this.getServerModuleMetaData(collabData);
            if (smmd != null && (cc = smmd.getConfigurationContext()) != null && (mbean = Axis2Utils.getEndpointManagerMBean(cc)) != null) {
                mbean.stopAll();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SMMD: " + smmd + ", CC: " + cc + ", EndptMgr: " + mbean);
            }
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{e};
            Tr.error(_tc, "caughtException", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EjbCollaborator.stopped()");
        }
    }

    private ServerModuleMetaData getServerModuleMetaData(EJBComponentMetaData collabConfig) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EjbCollaborator.getServerModuleMetaData()...");
        }
        ModuleMetaData mmd = collabConfig.getModuleMetaData();
        ServerModuleMetaData smmd = (ServerModuleMetaData)this.metadata.getServerModuleMetaData(mmd);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EjbCollaborator.getServerModuleMetaData()", smmd);
        }
        return smmd;
    }

    private void checkJMSMappings(ConfigurationContext configContext) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkJMSMappings");
        }
        HashMap<String, AxisService> jmsServiceMap = new HashMap<String, AxisService>();
        AxisConfiguration ac = configContext.getAxisConfiguration();
        Iterator svcGroupIter = ac.getServiceGroups();
        while (svcGroupIter.hasNext()) {
            AxisServiceGroup svcGroup = (AxisServiceGroup)svcGroupIter.next();
            Iterator svcIter = svcGroup.getServices();
            while (svcIter.hasNext()) {
                String portName;
                AxisService axisService = (AxisService)svcIter.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found AxisService: " + axisService.getName());
                }
                if ((portName = Axis2Utils.getPortComponentName(axisService)) == null) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set JMS port component name [" + portName + "] on AxisService [" + axisService.getName() + "].");
                }
                jmsServiceMap.put(portName, axisService);
            }
        }
        configContext.setProperty("com.ibm.ws.websvcs.JMS_SERVICES_MAPPINGS", jmsServiceMap);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMS PortComponentName to Services Map: " + jmsServiceMap);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkJMSMappings");
        }
    }
}

