/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfigurationContextStore
implements Constants {
    private static final TraceComponent _tc = Tr.register(ClientConfigurationContextStore.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    HashMap<String, List<ConfigurationContext>> configContextMap = new HashMap();

    public void addConfigurationContext(ConfigurationContext cc) {
        List<ConfigurationContext> configContextList;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addConfigurationContext");
        }
        AxisConfiguration axisCfg = cc.getAxisConfiguration();
        String appName = Axis2Utils.getApplicationName(axisCfg);
        String modName = Axis2Utils.getModuleName(axisCfg);
        String key = this.makeKey(appName, modName);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "For key: " + key + " storing client ConfigurationContext: " + cc.toString());
        }
        if ((configContextList = this.configContextMap.get(key)) == null) {
            configContextList = new ArrayList<ConfigurationContext>();
        }
        configContextList.add(cc);
        this.configContextMap.put(key, configContextList);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addConfigurationContext");
        }
    }

    public List<ConfigurationContext> getConfigurationContexts(String appName, String modName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConfigurationContext");
        }
        String key = this.makeKey(appName, modName);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieving client ConfigurationContext objects for key: " + key);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConfigurationContext");
        }
        return this.configContextMap.get(key);
    }

    String makeKey(String appName, String modName) {
        return (appName == null ? "<anonymous>" : appName) + ":" + (modName == null ? "<anonymous>" : modName);
    }
}

