/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.binding;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.axis2.jaxws.message.databinding.ClassFinder;
import org.apache.axis2.jaxws.utility.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClassFinder
implements ClassFinder,
Constants {
    private static final TraceComponent _tc = Tr.register(WSClassFinder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public ArrayList<Class> getClassesFromJarFile(String packageName, ClassLoader classLoader) throws ClassNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClassesFromJarFile");
        }
        ArrayList<Class> classList = new ArrayList<Class>();
        if ((classLoader = this.getValidClassLoader(classLoader)) == null) {
            Object[] inserts = new Object[]{packageName};
            String msg = NLSProvider.getNLS().getFormattedMessage("createJAXBContextFail02", inserts, "A ClassLoader could not be found to create a JAXBContext for the package name: {0}");
            Tr.error(_tc, msg);
        } else {
            List<String> paths = this.getPaths(classLoader);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Building JAXBContext for package: " + packageName);
            }
            if (paths != null && !paths.isEmpty()) {
                for (String path : paths) {
                    File file;
                    if (path == null || !path.endsWith(".jar") || !WebServiceUtils.fileExists(file = new File(path)) || WebServiceUtils.fileIsDirectory(file)) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found JAR file while building JAXBContext: " + path);
                    }
                    try {
                        final File finalFile = file;
                        JarFile jarFile = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                            @Override
                            public JarFile run() throws IOException {
                                return new JarFile(finalFile);
                            }
                        });
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String entryName = entry.getName();
                            if (entryName == null || !entryName.endsWith(".class")) continue;
                            entryName = entryName.substring(0, entryName.length() - 6);
                            if (!(entryName = entryName.replace('/', '.')).startsWith(packageName)) continue;
                            try {
                                Class clazz = com.ibm.ws.webservices.utils.ClassUtils.forName(entryName, false, classLoader);
                                if (clazz.isInterface() || ClassUtils.getDefaultPublicConstructor(clazz) == null || ClassUtils.isJAXWSClass(clazz) || !packageName.equals(clazz.getPackage().getName())) continue;
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Adding class to JAXBContext: " + entryName);
                                }
                                classList.add(clazz);
                            }
                            catch (ClassNotFoundException e) {
                                Object[] inserts = new Object[]{entryName};
                                String msg = NLSProvider.getNLS().getFormattedMessage("createJAXBContextFail01", inserts, "The class {0} could not be loaded when trying to create a JAXBContext.");
                                Tr.error(_tc, msg);
                                throw e;
                            }
                        }
                    }
                    catch (Throwable t2) {
                        Exception t2;
                        Exception cause;
                        if (t2 instanceof PrivilegedActionException && (cause = ((PrivilegedActionException)t2).getException()) != null) {
                            t2 = cause;
                        }
                        Object[] inserts = new Object[]{t2};
                        String msg = NLSProvider.getNLS().getFormattedMessage("createJAXBContextFail00", inserts, "The following error occurred when attempting to create a JAXBContext: {0}");
                        Tr.error(_tc, msg);
                    }
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClassesFromJarFile");
        }
        return classList;
    }

    ClassLoader getValidClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof CompoundClassLoader || classLoader instanceof ExtClassLoader || classLoader instanceof URLClassLoader) {
            return classLoader;
        }
        if (classLoader.getParent() != null) {
            return this.getValidClassLoader(classLoader.getParent());
        }
        return null;
    }

    List<String> getPaths(ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getPaths, classLoader= " + classLoader);
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (classLoader instanceof CompoundClassLoader) {
            CompoundClassLoader ccl = (CompoundClassLoader)classLoader;
            this.addPathsFromArray(ccl.getPaths(), paths);
            ClassLoader parent = this.getParentClassLoaderPrivileged(ccl);
            while (parent != null && parent instanceof CompoundClassLoader) {
                CompoundClassLoader parentCCL = (CompoundClassLoader)parent;
                this.addPathsFromArray(parentCCL.getPaths(), paths);
                parent = this.getParentClassLoaderPrivileged(parentCCL);
            }
        } else {
            URL[] urls = null;
            if (classLoader instanceof ExtClassLoader) {
                urls = ((ExtClassLoader)classLoader)._getURLs();
            } else if (classLoader instanceof URLClassLoader) {
                urls = ((URLClassLoader)classLoader).getURLs();
            }
            if (urls != null) {
                String[] filePaths = this.convertURLsToPaths(urls);
                this.addPathsFromArray(filePaths, paths);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getPaths, classLoader= " + classLoader + ", paths= " + paths);
        }
        return paths;
    }

    String[] convertURLsToPaths(URL[] urls) {
        String[] paths = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null || urls[i].getPath() == null) continue;
            paths[i] = urls[i].getPath();
        }
        return paths;
    }

    ClassLoader getParentClassLoaderPrivileged(final ClassLoader cl) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return cl.getParent();
            }
        });
    }

    void addPathsFromArray(String[] pathArray, List<String> paths) {
        if (pathArray != null) {
            for (String path : pathArray) {
                paths.add(path);
            }
        }
    }
}

