/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.utils;

import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.WebMethodRefObject;
import com.ibm.ws.metadata.WebServiceProviderRefObject;
import com.ibm.ws.metadata.WebServiceRefObject;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void setImplWSDefaults(WebServiceRefObject wsRef, ClassDataObject cdo) {
        if (wsRef.getName() == null || wsRef.getName().equals("")) {
            String className = Utils.deriveSimpleClassName((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
            wsRef.setName(className);
        }
        if (wsRef.getServiceName() == null || wsRef.getServiceName().equals("")) {
            wsRef.setServiceName(wsRef.getName() + "Service");
        }
        if (wsRef.getPortName() == null || wsRef.getPortName().equals("")) {
            wsRef.setPortName(wsRef.getName() + "Port");
        }
        if (wsRef.getTargetNamespace() == null || wsRef.getTargetNamespace().equals("")) {
            String namespace = Utils.deriveNamespace((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
            wsRef.setTargetNamespace(namespace);
        }
    }

    public static void setSEIWSDefaults(WebServiceRefObject wsRef, ClassDataObject cdo) {
        if (wsRef.getName() == null || wsRef.getName().equals("")) {
            String className = Utils.deriveSimpleClassName((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
            wsRef.setName(className);
        }
        if (wsRef.getTargetNamespace() == null || wsRef.getTargetNamespace().equals("")) {
            String namespace = Utils.deriveNamespace((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
            wsRef.setTargetNamespace(namespace);
        }
    }

    public static String deriveNamespace(String ns) {
        String[] nsArray = ns.split("/");
        ns = "";
        for (int i = nsArray.length - 2; i > -1; --i) {
            ns = ns.equals("") ? nsArray[i] : ns + "." + nsArray[i];
        }
        ns = "http://" + ns + "/";
        return ns;
    }

    public static String deriveSimpleClassName(String ns) {
        String[] nsArray = ns.split("/");
        return nsArray[nsArray.length - 1];
    }

    public static void setImplWMDefaults(WebMethodRefObject wmRef, MetaDataSubObject mdso) {
        if (wmRef.getOperationName() == null || wmRef.getOperationName().equals("")) {
            wmRef.setOperationName(mdso.getName());
        }
        if (wmRef.getAction() == null) {
            wmRef.setAction("");
        }
        if (wmRef.getExclude() == null) {
            wmRef.setExclude("false");
        }
    }

    public static void setSEIWMDefaults(WebMethodRefObject wmRef, MetaDataSubObject mdso) {
        if (wmRef.getOperationName() == null || wmRef.getOperationName().equals("")) {
            wmRef.setOperationName(mdso.getName());
        }
        if (wmRef.getAction() == null) {
            wmRef.setAction("");
        }
    }

    public static String javifyQualifiedClassName(String qualifiedName) {
        if (qualifiedName.contains("/")) {
            qualifiedName = qualifiedName.replace("/", ".");
        }
        return qualifiedName;
    }

    public static ClassDataObject getEndpointInterface(String name, ArrayList<ClassDataObject> cdoList) {
        for (ClassDataObject cdo : cdoList) {
            String className = Utils.javifyQualifiedClassName((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
            if (!className.equals(name)) continue;
            return cdo;
        }
        return null;
    }

    public static boolean isSEI(String className, ArrayList<ClassDataObject> cdoList) {
        for (ClassDataObject listCDO : cdoList) {
            WebServiceRefObject wsRef = (WebServiceRefObject)listCDO.getEntry(ClassDataObjectFields.WEBSERVICE);
            if (wsRef == null) {
                return false;
            }
            String seiName = wsRef.getEndpointInterface();
            if (seiName == null || seiName.equals("") || !(seiName = Utils.javifyQualifiedClassName(seiName)).equals(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(MethodRefObject mRefObj) {
        return mRefObj.getAccess() == 1 || mRefObj.getAccess() == 1025;
    }

    public static boolean isAnnotated(MethodRefObject mRefObj, ArrayList<String> annotatedMethods) {
        return !annotatedMethods.isEmpty() && annotatedMethods.contains(mRefObj.getName());
    }

    public static boolean isControlOperation(MethodRefObject mRefObj) {
        return mRefObj.getName().contains("<");
    }

    public static boolean implementsMethod(String name, ArrayList<MethodRefObject> mRefList) {
        for (MethodRefObject mRef : mRefList) {
            if (!name.equals(mRef.getName())) continue;
            return true;
        }
        return false;
    }

    public static MethodRefObject getMRef(String name, ArrayList<MethodRefObject> mdsoList) {
        for (MethodRefObject mRef : mdsoList) {
            if (!name.equals(mRef.getName())) continue;
            return mRef;
        }
        return null;
    }

    public static boolean isPublicClass(ClassDataObject cdo) {
        Integer accessObj = (Integer)cdo.getEntry(ClassDataObjectFields.CLASS_ACCESS);
        int access = accessObj;
        return access == 1 || access == 33;
    }

    public static AxisOperation getAxisOperation(String opName, AxisService service) {
        Iterator opIter = service.getOperations();
        while (opIter.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)opIter.next();
            String operationName = axisOperation.getName().getLocalPart();
            String firstLetter = operationName.substring(0, 1);
            String remainingName = operationName.substring(1, operationName.length());
            String upperOpName = firstLetter.toUpperCase() + remainingName;
            String lowerOpName = firstLetter.toLowerCase() + remainingName;
            if (upperOpName.equals(opName)) {
                return axisOperation;
            }
            if (!lowerOpName.equals(opName)) continue;
            return axisOperation;
        }
        return null;
    }

    public static void setProviderWSDefaults(WebServiceProviderRefObject wspRef, ClassDataObject cdo) {
        String simpleClassName = Utils.deriveSimpleClassName((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
        if (wspRef.getServiceName() == null || wspRef.getServiceName().equals("")) {
            wspRef.setServiceName(simpleClassName + "Service");
        }
        if (wspRef.getPortName() == null || wspRef.getPortName().equals("")) {
            wspRef.setPortName(simpleClassName + "Port");
        }
        if (wspRef.getTargetNamespace() == null || wspRef.getTargetNamespace().equals("")) {
            String namespace = Utils.deriveNamespace((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
            wspRef.setTargetNamespace(namespace);
        }
    }

    public static ArrayList<String> getAnnotatedMethods(ArrayList<MetaDataSubObject> mdsoList) {
        ArrayList<String> annotatedMethods = new ArrayList<String>();
        if (mdsoList != null && !mdsoList.isEmpty()) {
            for (MetaDataSubObject mdso : mdsoList) {
                annotatedMethods.add(mdso.getName());
            }
        }
        return annotatedMethods;
    }

    public static boolean isPublicType(int access) {
        return access == 33 || access == 1537;
    }

    public static boolean isPublicMethod(int access) {
        return access == 1 || access == 9 || access == 17 || access == 25 || access == 1025;
    }
}

