/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.injection.InjectionHelper;
import com.ibm.ws.websvcs.annotations.injection.ServiceRefPostProcessor;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.jws.HandlerChain;
import javax.naming.Reference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefBinding
extends InjectionBinding<WebServiceRef> {
    private static final TraceComponent tc = Tr.register(WebServiceRefBinding.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected WebServiceRefMetadata wsrMetadata;
    private boolean resourceType = false;

    public WebServiceRefBinding(WebServiceRef annotation, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super((Annotation)annotation, nameSpaceConfig);
        this.setJndiName(annotation.name());
    }

    public WebServiceRefBinding(WebServiceRefMetadata wsrMetadata, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super((Annotation)wsrMetadata.getAnnotationValue(), nameSpaceConfig);
        this.setJndiName(wsrMetadata.getJndiName());
        this.wsrMetadata = wsrMetadata;
    }

    public void merge(WebServiceRef webServiceRef, Member member) throws InjectionException {
        Method method;
        Field field;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge, webServiceRef= " + webServiceRef + " member= " + member);
        }
        if (webServiceRef.type().getName() != Object.class.getName()) {
            this.validateExistingClasses(webServiceRef.type(), "type", member);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "setting the type: " + webServiceRef.type().getName());
            }
            this.wsrMetadata.setType(webServiceRef.type());
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "the type referred to the Object class, no validation is needed");
        }
        if (webServiceRef.value().getName() != Object.class.getName()) {
            this.validateExistingClasses(webServiceRef.value(), "value", member);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "setting the value: " + webServiceRef.value().getName());
            }
            this.wsrMetadata.setValue(webServiceRef.value());
            if (Service.class.isAssignableFrom(this.wsrMetadata.getValue()) && (this.wsrMetadata.getType() == null || this.wsrMetadata.getType().getName().equals(Object.class.getName()))) {
                Class<?> typeClass = InjectionHelper.getTypeFromMember(member);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "the value indicated a Service type, setting type to member type: " + typeClass);
                }
                this.wsrMetadata.setType(typeClass);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "the value referred to the Object class, no validation is needed");
        }
        if (webServiceRef.wsdlLocation() != null && !"".equals(webServiceRef.wsdlLocation())) {
            this.processExistingWSDL(webServiceRef.wsdlLocation(), member);
        }
        HandlerChain handlerChainInstance = null;
        if (member instanceof Field) {
            field = (Field)member;
            handlerChainInstance = field.getAnnotation(HandlerChain.class);
        } else if (member instanceof Method) {
            method = (Method)member;
            handlerChainInstance = method.getAnnotation(HandlerChain.class);
            this.validateHandlerChain(handlerChainInstance, member);
        }
        if (handlerChainInstance != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "@HandlerChain annotation found with @WebServiceRef annotation, jndiName: " + webServiceRef.name());
            }
            this.wsrMetadata.setCurrentHandlerChain(handlerChainInstance);
        }
        if (this.wsrMetadata.getType() == null && webServiceRef.type().getName().equals(Object.class.getName()) && member != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking for injection type based on member: " + member + " in class: " + member.getDeclaringClass().getName());
            }
            if (member instanceof Field) {
                Class<?> type;
                field = (Field)member;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting service-ref-type to: " + field.getType() + " based on " + "annotated field: " + field.getName() + " in class: " + field.getDeclaringClass().getName());
                }
                if (Service.class.isAssignableFrom(type = field.getType())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting 'type' and 'value' to java.xml.ws.Service class: " + type);
                    }
                    this.wsrMetadata.setValue(type);
                    this.wsrMetadata.setType(type);
                    this.wsrMetadata.setServiceClassName(type.getName());
                } else {
                    this.wsrMetadata.setType(type);
                }
            } else if (member instanceof Method) {
                method = (Method)member;
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes != null && paramTypes.length == 1) {
                    Class<?> paramType = paramTypes[0];
                    if (paramType != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting service-ref-type to: " + paramType + " based on " + "annotated method: " + method.getName() + " in class: " + method.getDeclaringClass().getName());
                        }
                        if (Service.class.isAssignableFrom(paramType)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting 'type' and 'value' to java.xml.ws.Service class: " + paramType);
                            }
                            this.wsrMetadata.setValue(paramType);
                            this.wsrMetadata.setType(paramType);
                            this.wsrMetadata.setServiceClassName(paramType.getName());
                        } else {
                            this.wsrMetadata.setType(paramType);
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An injection type could not be determined for the @Resource/@WebServiceRef annotation on the " + method.getName() + " method in the " + method.getDeclaringClass().getName() + " class.");
                }
            }
        } else if (this.wsrMetadata.getType() != null && Service.class.isAssignableFrom(this.wsrMetadata.getType())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting service class name to class set in 'type' attribute: " + this.wsrMetadata.getType().getName());
            }
            this.wsrMetadata.setServiceClassName(this.wsrMetadata.getType().getName());
        }
        if (member != null) {
            this.addInjectionTarget(member);
        }
        ServiceRefPostProcessor.markCompleteness(this.wsrMetadata);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }

    private void validateExistingClasses(Class<?> newClassType, String attributeName, Member newMember) throws InjectionException {
        Class<?> existingTypeClass;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateExistingClasses, newClass= " + newClassType + ", attribute= " + attributeName + " newMember= " + newMember);
        }
        Class<?> clazz = existingTypeClass = attributeName.equals("type") ? this.wsrMetadata.getType() : this.wsrMetadata.getValue();
        if (existingTypeClass != null && !existingTypeClass.getName().equals(Object.class.getName()) && !existingTypeClass.isAssignableFrom(newClassType)) {
            if (attributeName.equals("type")) {
                String msg = null;
                msg = newMember != null ? NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail00", new Object[]{this.wsrMetadata.getJndiName(), newMember.getName(), newMember.getDeclaringClass().getName(), newClassType.getName(), existingTypeClass.getName()}, "The {0} service reference on the {1} member in the {2} class specifies the {3} service-ref-type class but other metadata was found for this service reference which specifies the {4} service-ref-type class.") : NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail04", new Object[]{this.wsrMetadata.getJndiName(), newClassType.getName(), existingTypeClass.getName()}, "A {0} class-level service reference was found which specifies the {1} service-ref-type class but another service reference was found which specifies the {2} service-ref-type class.");
                Tr.error(tc, msg);
                throw new InjectionException(msg);
            }
            String msg = null;
            msg = newMember != null ? NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail01", new Object[]{this.wsrMetadata.getJndiName(), newMember.getName(), newMember.getDeclaringClass().getName(), newClassType.getName(), existingTypeClass.getName()}, "The {0} service reference on the {1} member in the {2} class specifies the {3} service-interface class but other metadata was found for this service reference which specifies the {4} service-interface class.") : NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail05", new Object[]{this.wsrMetadata.getJndiName(), newClassType.getName(), existingTypeClass.getName()}, "A {0} class-level service reference was found which specifies the {1} service-interface class but another service reference was found which specifies the {2} service-interface class.");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
    }

    private void processExistingWSDL(String wsdlLocation, Member newMember) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateExistingWSDLLocations, wsdlLocation= " + wsdlLocation + " member= " + newMember);
        }
        if (this.wsrMetadata.getWsdlLocation() != null && !"".equals(this.wsrMetadata.getWsdlLocation())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "the " + this.wsrMetadata.getWsdlLocation() + " WSDL file is specified in the " + "deployment descriptor. Annotation metadata referencing a WSDL file for " + "this service reference will be ignored.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For the " + this.wsrMetadata.getJndiName() + " service reference, " + "setting the wsdlLocation: " + wsdlLocation);
            }
            this.wsrMetadata.setWsdlLocation(wsdlLocation);
        }
    }

    private void validateHandlerChain(HandlerChain newHandlerChain, Member newMember) throws InjectionException {
        HandlerChain existingHC;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateHandlerChain, handlerChain= " + newHandlerChain + ", member= " + newMember + ", existingHandlerChain= " + this.wsrMetadata.getCurrentHandlerChain());
        }
        if ((existingHC = this.wsrMetadata.getCurrentHandlerChain()) == null) {
            return;
        }
        if (existingHC.name() == null && newHandlerChain.name() != null || newHandlerChain.name() == null && existingHC.name() != null || !existingHC.name().equals(newHandlerChain.name())) {
            String msg = null;
            msg = newMember != null ? NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail02", new Object[]{this.wsrMetadata.getJndiName(), newMember.getName(), newMember.getDeclaringClass().getName(), newHandlerChain.name(), existingHC.name()}, "The @HandlerChain annotation specified for the {0} service reference on the {1} member in the {2} class specifies the {3} 'name' value. This conflicts with the {4} 'name' value that was specified for handler chain information previously associated with this service reference.") : NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail06", new Object[]{this.wsrMetadata.getJndiName(), newHandlerChain.name(), existingHC.name()}, "The @HandlerChain annotation specified for the {0} class-level service reference specifies the {1} 'name' value. This conflicts with the {2} 'name' value that was specified for handler chain information previously associated with this service reference.");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
        if (!existingHC.file().equals(newHandlerChain.file())) {
            String msg = null;
            msg = newMember != null ? NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail03", new Object[]{this.wsrMetadata.getJndiName(), newMember.getName(), newMember.getDeclaringClass().getName(), newHandlerChain.file(), existingHC.file()}, "The @HandlerChain annotation specified for the {0} service reference on the {1} member in the {2} class specifies the {3} 'file' value. This conflicts with the {4} 'file' value that was specified for handler chain information previously associated with this service reference.") : NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail07", new Object[]{this.wsrMetadata.getJndiName(), newHandlerChain.file(), existingHC.file()}, "The @HandlerChain annotation specified for the {0} class-level service reference specifies the {1} 'file' value. This conflicts with the {2} 'file' value that was specified for handler chain information previously associated with this service reference.");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
    }

    public WebServiceRefMetadata getMetadata() {
        return this.wsrMetadata;
    }

    public void setMetadata(WebServiceRefMetadata wsrMetadata) {
        this.wsrMetadata = wsrMetadata;
    }

    public void addInjectionTarget(Member member) throws InjectionException {
        super.addInjectionTarget(member);
    }

    public void addInjectionTarget(Class<?> clazz, String targetName, String targetClassName) throws InjectionException {
        super.addInjectionTarget(clazz, targetName, targetClassName);
    }

    public void setObjects(Object object, Reference reference) throws InjectionException {
        super.setObjects(object, reference);
    }

    public boolean isResourceType() {
        return this.resourceType;
    }

    public void setResourceType(boolean resourceType) {
        this.resourceType = resourceType;
    }
}

