/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.ws.websvcs.annotations.injection.InjectionHelper;
import com.ibm.ws.websvcs.annotations.injection.ResourceServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.ws.WebServiceRef;
import org.apache.axis2.jaxws.description.xml.handler.FullyQualifiedClassType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.description.xml.handler.ObjectFactory;
import org.apache.axis2.jaxws.description.xml.handler.String;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.InjectionTarget;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsclient.HandlerChain;
import org.eclipse.jst.j2ee.webservice.wsclient.HandlerChains;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRBindingBuilder {
    private static final TraceComponent tc = Tr.register(WSRBindingBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public List<InjectionBinding<WebServiceRef>> buildJAXWSBindings(List<ServiceRef> jaxwsServiceRefs, ComponentNameSpaceConfiguration cnsConfig) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildJAXWSBindings, serviceRef size= " + java.lang.String.valueOf(jaxwsServiceRefs == null ? 0 : jaxwsServiceRefs.size()));
        }
        ClassLoader classLoader = cnsConfig.getClassLoader();
        LoadStrategy loadStrategy = cnsConfig.getModuleLoadStrategy();
        LinkedList<InjectionBinding<WebServiceRef>> bindingList = new LinkedList<InjectionBinding<WebServiceRef>>();
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JAX-WS service reference list size: " + java.lang.String.valueOf(jaxwsServiceRefs == null ? 0 : jaxwsServiceRefs.size()));
            }
            for (ServiceRef serviceRef : jaxwsServiceRefs) {
                java.lang.String msg;
                EList pcRefs;
                WebServiceRefMetadata wsrMetadata = new WebServiceRefMetadata(classLoader);
                wsrMetadata.setLoadStrategy(loadStrategy);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting web service ref metadata jndi name: " + serviceRef.getServiceRefName());
                }
                wsrMetadata.setJndiName(serviceRef.getServiceRefName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting web service ref metadata wsdlLocation: " + serviceRef.getWsdlFile());
                }
                wsrMetadata.setWsdlLocation(serviceRef.getWsdlFile());
                if (serviceRef.getServiceQname() != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting web service ref metadata service QName: " + serviceRef.getServiceQname());
                    }
                    QName serviceQName = new QName(serviceRef.getServiceQname().getNamespaceURI(), serviceRef.getServiceQname().getLocalPart());
                    wsrMetadata.setServiceQName(serviceQName);
                }
                if ((pcRefs = serviceRef.getPortComponentRefs()) != null && !pcRefs.isEmpty()) {
                    for (PortComponentRef pcRef : pcRefs) {
                        java.lang.String seiName = pcRef.getServiceEndpointInterface() != null ? pcRef.getServiceEndpointInterface().getQualifiedName() : null;
                        if (seiName == null || "".equals(seiName) || !pcRef.isSetEnableMtom()) continue;
                        boolean enableMTOM = pcRef.isEnableMtom();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting enable-mtom to " + enableMTOM + " for SEI: " + seiName);
                        }
                        wsrMetadata.setEnableMTOM(seiName, enableMTOM);
                    }
                }
                Class siClass = null;
                Class stClass = null;
                if (serviceRef.getServiceInterface() != null) {
                    siClass = ClassUtils.forName(serviceRef.getServiceInterface().getQualifiedName(), false, classLoader);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loaded service-interface class: " + siClass.getName());
                    }
                }
                if (serviceRef.getServiceRefType() != null) {
                    stClass = ClassUtils.forName(serviceRef.getServiceRefType().getQualifiedName(), false, classLoader);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loaded service-ref-type class: " + stClass.getName());
                    }
                }
                if (siClass != null) {
                    if (!javax.xml.ws.Service.class.isAssignableFrom(siClass)) {
                        msg = NLSProvider.getNLS().getFormattedMessage("buildXMLBindingsFail00", new Object[]{serviceRef.getServiceRefName(), cnsConfig.getModuleName(), siClass.getName()}, "The {0} service ref in the {1} module was identfied as a JAX-WS style service-ref, but the service-interface element specifies the {2} class which is not a subclass of javax.xml.ws.Service. For JAX-WS service refs, the service-interface value must specify a subclass of javax.xml.ws.Service");
                        throw new InjectionException(msg);
                    }
                    wsrMetadata.setServiceClassName(siClass.getName());
                    wsrMetadata.setValue(siClass);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not set web service ref metadata value class from XML");
                }
                if (stClass != null) {
                    if (!javax.xml.ws.Service.class.isAssignableFrom(stClass)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting web service ref metadata type class: " + stClass);
                        }
                        wsrMetadata.setServiceSEIClassName(stClass.getName());
                        wsrMetadata.setType(stClass);
                    } else {
                        if (siClass != null && !siClass.isAssignableFrom(stClass)) {
                            msg = NLSProvider.getNLS().getFormattedMessage("buildXMLBindingsFail01", new Object[]{serviceRef.getServiceRefName(), cnsConfig.getModuleName()}, "The {0} service ref in the {1} module specifies a javax.xml.ws.Service class type in the service-interface and service-ref-type elements, but the class names differ. If both element types specify a javax.xml.ws.Service class type, they must specify the same class.");
                            throw new InjectionException(msg);
                        }
                        wsrMetadata.setServiceSEIClassName(stClass.getName());
                        wsrMetadata.setType(stClass);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not set web service ref metadata type class from XML");
                }
                this.setPortComponentLinkValue(serviceRef, wsrMetadata);
                if (serviceRef.getHandlerChains() != null) {
                    HandlerChainsType hcsType = this.createHandlerChainsType(serviceRef.getHandlerChains());
                    wsrMetadata.setHandlerChains(hcsType);
                }
                wsrMetadata.setXMLSource(true);
                WebServiceRefBinding binding = new WebServiceRefBinding(wsrMetadata, cnsConfig);
                this.addInjectionTargets(serviceRef.getInjectionTargets(), binding, stClass != null ? stClass : siClass);
                bindingList.add(binding);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Created binding from JAX-WS XML service ref: " + (Object)((Object)binding));
            }
        }
        catch (InjectionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InjectionException(t);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildJAXWSBindings, jaxwsBindings size= " + java.lang.String.valueOf(bindingList.size()));
        }
        return bindingList;
    }

    public List<InjectionBinding<WebServiceRef>> buildJAXRPCBindings(List<ServiceRef> jaxrpcServiceRefs, ComponentNameSpaceConfiguration cnsConfig) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildJAXRPCBindings, serviceRef size= " + java.lang.String.valueOf(jaxrpcServiceRefs == null ? 0 : jaxrpcServiceRefs.size()));
        }
        LinkedList<InjectionBinding<WebServiceRef>> bindingList = new LinkedList<InjectionBinding<WebServiceRef>>();
        Iterator<ServiceRef> srIter = jaxrpcServiceRefs.iterator();
        ClassLoader classLoader = cnsConfig.getClassLoader();
        try {
            while (srIter.hasNext()) {
                ServiceRef serviceRef = srIter.next();
                java.lang.String jndiName = serviceRef.getServiceRefName();
                Class serviceClass = null;
                if (serviceRef.getServiceInterface() != null && serviceRef.getServiceInterface().getQualifiedName() != null) {
                    serviceClass = ClassUtils.forName(serviceRef.getServiceInterface().getQualifiedName(), true, classLoader);
                }
                if (serviceClass == null) continue;
                if (!Service.class.isAssignableFrom(serviceClass)) {
                    java.lang.String msg = NLSProvider.getNLS().getFormattedMessage("buildXMLBindingsFail02", new Object[]{serviceRef.getServiceRefName(), cnsConfig.getModuleName(), serviceClass.getName()}, "The {0} service ref in the {1} module was identfied as a JAX-RPC style service-ref, but the service-interface element specifies the {2} class which is not a subclass of javax.xml.rpc.Service. For JAX-RPC service refs, the service-interface value must specify a subclass of javax.xml.rpc.Service");
                    throw new InjectionException(msg);
                }
                InjectionBinding<WebServiceRef> binding = InjectionHelper.createResourceServiceRefBinding(cnsConfig, serviceClass, jndiName, null);
                this.addInjectionTargets(serviceRef.getInjectionTargets(), binding, serviceClass);
                ((ResourceServiceRefBinding)binding).getMetadata().setXMLSource(true);
                this.setPortComponentLinkValue(serviceRef, ((ResourceServiceRefBinding)binding).getMetadata());
                bindingList.add(binding);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Created binding from JAX-RPC XML service ref: " + binding);
            }
        }
        catch (Exception e) {
            throw new InjectionException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildJAXRPCBindings, jaxrpcBindings size= " + java.lang.String.valueOf(bindingList.size()));
        }
        return bindingList;
    }

    private void setPortComponentLinkValue(ServiceRef serviceRef, WebServiceRefMetadata wsrMetadata) {
        EList portComponentRefs = serviceRef.getPortComponentRefs();
        if (portComponentRefs != null) {
            for (PortComponentRef pcr : portComponentRefs) {
                if (pcr.getPortComponentLink() == null || "".equals(pcr.getPortComponentLink())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting web service ref metadata port component link: " + pcr.getPortComponentLink());
                }
                wsrMetadata.setPortComponentLinkValue(pcr.getPortComponentLink());
                break;
            }
        }
    }

    HandlerChainsType createHandlerChainsType(HandlerChains handlerChains) {
        ObjectFactory factory = new ObjectFactory();
        HandlerChainsType hcsType = factory.createHandlerChainsType();
        List<HandlerChainType> hcTypeList = hcsType.getHandlerChain();
        EList hcList = handlerChains.getHandlerChains();
        if (hcList != null && !hcList.isEmpty()) {
            for (HandlerChain hChain : hcList) {
                HandlerChainType hcType = this.populateHandlerChainType(factory, hChain);
                EList hList = hChain.getHandlers();
                if (hList != null && hList.size() > 0) {
                    Iterator hListIter = hList.iterator();
                    List<HandlerType> handlerTypeList = hcType.getHandler();
                    while (hListIter.hasNext()) {
                        Handler handler = (Handler)hListIter.next();
                        HandlerType handlerType = this.populateHandlerType(factory, handler);
                        handlerTypeList.add(handlerType);
                    }
                }
                hcTypeList.add(hcType);
            }
        }
        return hcsType;
    }

    HandlerChainType populateHandlerChainType(ObjectFactory factory, HandlerChain hChain) {
        HandlerChainType hcType = factory.createHandlerChainType();
        if (hChain.getPortNamePattern() != null) {
            QName portNamePattern = new QName(hChain.getPortNamePattern().getNamespaceURI(), hChain.getPortNamePattern().getLocalPart());
            hcType.setPortNamePattern(portNamePattern);
        }
        if (hChain.getServiceNamePattern() != null) {
            QName serviceNamePattern = new QName(hChain.getServiceNamePattern().getNamespaceURI(), hChain.getServiceNamePattern().getLocalPart());
            hcType.setServiceNamePattern(serviceNamePattern);
        }
        if (hChain.getProtocolBindings() != null && hChain.getProtocolBindings().size() > 0) {
            List<java.lang.String> protocolBindingList = hcType.getProtocolBindings();
            EList pbList = hChain.getProtocolBindings();
            for (java.lang.String pb : pbList) {
                protocolBindingList.add(pb);
            }
        }
        return hcType;
    }

    HandlerType populateHandlerType(ObjectFactory factory, Handler handler) {
        HandlerType handlerType = factory.createHandlerType();
        FullyQualifiedClassType handlerClass = factory.createFullyQualifiedClassType();
        handlerClass.setValue(handler.getHandlerClass().getQualifiedName());
        String hName = factory.createString();
        hName.setValue(handler.getHandlerName());
        handlerType.setHandlerClass(handlerClass);
        handlerType.setHandlerName(hName);
        EList soapRoleList = handler.getSoapRoles();
        if (soapRoleList != null && !soapRoleList.isEmpty()) {
            List<String> soapRoles = handlerType.getSoapRole();
            for (java.lang.String role : soapRoleList) {
                String jaxbRole = new String();
                jaxbRole.setValue(role);
                soapRoles.add(jaxbRole);
            }
        }
        return handlerType;
    }

    void addInjectionTargets(List injectionTargets, InjectionBinding<WebServiceRef> binding, Class<?> injectionType) throws InjectionException {
        if (injectionTargets != null && !injectionTargets.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding injection targets specified in service-ref element");
            }
            for (InjectionTarget target : injectionTargets) {
                if (target.getInjectionTargetClass() == null || target.getInjectionTargetName() == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding injection target from XML, type= " + injectionType.getName() + ", target class= " + target.getInjectionTargetClass().getQualifiedName() + ", target member= " + target.getInjectionTargetName());
                }
                binding.addInjectionTarget(injectionType, target.getInjectionTargetName(), target.getInjectionTargetClass().getQualifiedName());
            }
        }
    }
}

