/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.websvcs.annotations.injection.ServiceRefPostProcessor;
import com.ibm.ws.websvcs.deployment.WSRefInfoBuilder;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.metadata.MetaDataHolder;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaData;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.util.Map;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;

public class WSInjectionMetaDataListener
implements InjectionMetaDataListener {
    private static final TraceComponent tc = Tr.register(WSInjectionMetaDataListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void injectionMetaDataCreated(InjectionMetaData injectionMetaData) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "injectionMetaDataCreated");
        }
        try {
            ServerModuleMetaData smmd;
            WebServicesService webServicesService = WsServiceRegistry.getService(this, WebServicesService.class);
            WASAxis2Service service = WsServiceRegistry.getService(this, WASAxis2Service.class);
            MetaDataSlot slot = (MetaDataSlot)service.getModuleMetaDataSlot();
            if (injectionMetaData.getModuleMetaData() == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("moduleMetaDataNull00", null, "Internal error. The module metadata was not available after injection metadata was created.");
                throw new InjectionException(msg);
            }
            MetaDataHolder holder = (MetaDataHolder)injectionMetaData.getModuleMetaData().getMetaData(slot);
            if (holder == null) {
                holder = new MetaDataHolder();
            }
            if ((smmd = holder.getServerModuleMetaData()) == null) {
                smmd = new ServerModuleMetaData(injectionMetaData.getJ2EEName().getApplication(), injectionMetaData.getJ2EEName().getModule());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Storing injection targets: " + injectionMetaData.getInjectionTargets() + " for module: " + smmd.getModuleName());
            }
            smmd.setInjectionTargets(injectionMetaData.getInjectionTargets());
            ModuleMetaData mmd = injectionMetaData.getModuleMetaData();
            ClientMetaData cmd = (ClientMetaData)service.getClientModuleMetaData(mmd);
            if (cmd != null && cmd.getClientServiceRefs() != null && cmd.getClientServiceRefs().hasIncompleteRefs()) {
                Map<String, DescriptionBuilderComposite> dbcMap;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Completing client metadata for module: " + mmd.getName());
                }
                if ((dbcMap = smmd.getDBCs()) != null && !dbcMap.isEmpty()) {
                    WSRefInfoBuilder builder = new WSRefInfoBuilder(dbcMap);
                    Map<String, ServiceRefPartialInfo> partialInfoMap = builder.buildInfo();
                    if (partialInfoMap != null && !partialInfoMap.isEmpty()) {
                        webServicesService.setServiceRefInfo(partialInfoMap, mmd);
                        ServiceRefPostProcessor postProcessor = new ServiceRefPostProcessor(cmd.getClientServiceRefs(), partialInfoMap, mmd);
                        postProcessor.completeClientMetadata();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Completed client metadata for module: " + mmd.getName());
                        }
                    }
                    dbcMap = null;
                }
            }
        }
        catch (InjectionException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new InjectionException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "injectionMetaDataCreated");
        }
    }
}

