/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.metadata.ClientServiceRefs;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRefPostProcessor {
    private static final TraceComponent tc = Tr.register(ServiceRefPostProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Map<String, ServiceRefPartialInfo> partialInfoMap;
    private ClientServiceRefs clientServiceRefs;
    private WebServicesService jaxrpcService;
    private boolean retrievedJaxRPCService;
    private ModuleMetaData mmd;

    public ServiceRefPostProcessor(ClientServiceRefs clientServiceRefs, Map<String, ServiceRefPartialInfo> partialInfoMap, ModuleMetaData mmd) {
        this.clientServiceRefs = clientServiceRefs;
        this.partialInfoMap = partialInfoMap;
        this.retrievedJaxRPCService = false;
        this.mmd = mmd;
    }

    public ClientServiceRefs completeClientMetadata() throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeClientMetadata");
        }
        if (this.clientServiceRefs.hasIncompleteRefs()) {
            Map<String, WebServiceRefMetadata> incompleteRefs = this.clientServiceRefs.getIncompleteRefs();
            Iterator<String> keySetIter = incompleteRefs.keySet().iterator();
            HashMap<String, WebServiceRefMetadata> newIncompleteRefs = new HashMap<String, WebServiceRefMetadata>();
            while (keySetIter.hasNext()) {
                String key = keySetIter.next();
                WebServiceRefMetadata wsrMetadata = incompleteRefs.get(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to complete client metadata for service reference with JNDI name: " + wsrMetadata.getJndiName());
                }
                this.resolveWSDLLocation(wsrMetadata);
                this.resolveServiceQName(wsrMetadata);
                this.resolvePortQName(wsrMetadata);
                ServiceRefPostProcessor.markCompleteness(wsrMetadata);
                if (!wsrMetadata.isMetadataComplete()) {
                    if (tc.isWarningEnabled()) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("incompleteServiceRef", new Object[]{wsrMetadata.getJndiName(), this.mmd.getName()}, "The {0} service reference in the {1} module is missing either the service QName or WSDL file location attribute. This may cause unpredictable results when this service reference is requested.");
                        Tr.warning(tc, msg);
                    }
                    newIncompleteRefs.put(wsrMetadata.getJndiName(), wsrMetadata);
                    continue;
                }
                this.clientServiceRefs.addServiceRefMetadata(wsrMetadata);
            }
            if (!newIncompleteRefs.isEmpty()) {
                this.clientServiceRefs.setIncompleteRefs(newIncompleteRefs);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No incomplete client metadata found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeClientMetadata");
        }
        return this.clientServiceRefs;
    }

    void resolveWSDLLocation(WebServiceRefMetadata wsrMetadata) throws DeploymentException {
        ServiceRefPartialInfo info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveWSDLLocation, serviceRefName= " + wsrMetadata.getJndiName() + ", currentWSDLLocation= " + wsrMetadata.getWsdlLocation());
        }
        if (wsrMetadata.getWsdlLocation() == null || "".equals(wsrMetadata.getWsdlLocation())) {
            String serviceClassName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to complete client WSDL location for service reference with JNDI name: " + wsrMetadata.getJndiName() + " by service class name: " + wsrMetadata.getServiceClassName());
            }
            if ((info = this.partialInfoMap.get(serviceClassName = wsrMetadata.getServiceClassName())) != null && info.getWsdlLocation() != null && !"".equals(info.getWsdlLocation())) {
                wsrMetadata.setWsdlLocation(info.getWsdlLocation());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For the " + wsrMetadata.getJndiName() + " service reference " + "setting WSDL location to: " + wsrMetadata.getWsdlLocation() + " based on the @WebServiceClient annotation in the " + serviceClassName + " class.");
                }
            }
        }
        if (wsrMetadata.getPortComponentLinkValue() != null) {
            String pcLinkValue = wsrMetadata.getPortComponentLinkValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for partial service ref info for port component: " + wsrMetadata.getPortComponentLinkValue());
            }
            if ((info = this.getServiceRefInfoFromPCName(pcLinkValue)) != null && info.getWsdlLocation() != null && !"".equals(info.getWsdlLocation())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For service reference: " + wsrMetadata.getJndiName() + " setting wsdl location to: " + info.getWsdlLocation() + " based on port component metadata for: " + pcLinkValue);
                }
                wsrMetadata.setWsdlLocation(info.getWsdlLocation());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveWSDLLocation, serviceRefName= " + wsrMetadata.getJndiName() + ", finalWSDLLocation= " + wsrMetadata.getWsdlLocation());
        }
    }

    void resolveServiceQName(WebServiceRefMetadata wsrMetadata) throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveServiceQName, serviceRefName= " + wsrMetadata.getJndiName() + ", currentServiceQName= " + wsrMetadata.getServiceQName());
        }
        if (wsrMetadata.getServiceQName() == null || "".equals(wsrMetadata.getServiceQName().toString())) {
            ServiceRefPartialInfo info;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For service reference: " + wsrMetadata.getJndiName() + " attempting to resolve service QName.");
            }
            String serviceClassName = wsrMetadata.getServiceClassName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for partial service ref info for service class: " + serviceClassName);
            }
            if ((info = this.partialInfoMap.get(serviceClassName)) != null && info.getServiceQName() != null && !"".equals(info.getServiceQName().toString())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For service reference: " + wsrMetadata.getJndiName() + " setting service QName to: " + info.getServiceQName().toString());
                }
                wsrMetadata.setServiceQName(info.getServiceQName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveServiceQName, serviceRefName= " + wsrMetadata.getJndiName() + ", finalServiceQName= " + wsrMetadata.getServiceQName());
        }
    }

    void resolvePortQName(WebServiceRefMetadata wsrMetadata) throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolvePortQName, serviceRefName= " + wsrMetadata.getJndiName() + ", currentPortQName= " + wsrMetadata.getPortQName());
        }
        if (wsrMetadata.getPortQName() == null || "".equals(wsrMetadata.getPortQName().toString())) {
            ServiceRefPartialInfo info;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For service reference: " + wsrMetadata.getJndiName() + " attempting to resolve port QName.");
            }
            String portComponentLink = wsrMetadata.getPortComponentLinkValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for partial service ref info for port component: " + portComponentLink);
            }
            if ((info = this.getServiceRefInfoFromPCName(portComponentLink)) != null && info.getPortQName() != null && !"".equals(info.getPortQName().toString())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For service reference: " + wsrMetadata.getJndiName() + " setting port QName to: " + info.getPortQName().toString());
                }
                wsrMetadata.setPortQName(info.getPortQName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolvePortQName, serviceRefName= " + wsrMetadata.getJndiName() + ", finalPortQName= " + wsrMetadata.getPortQName());
        }
    }

    public static void markCompleteness(WebServiceRefMetadata wsrMetadata) {
        if (wsrMetadata.getWsdlLocation() != null && !"".equals(wsrMetadata.getWsdlLocation()) && wsrMetadata.getServiceQName() != null && !"".equals(wsrMetadata.getServiceQName())) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "Setting service reference: " + wsrMetadata.getJndiName() + " to metadata complete");
            }
            wsrMetadata.setMetadataComplete(true);
        }
    }

    ServiceRefPartialInfo getServiceRefInfoFromPCName(String portComponentName) throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceRefInfoFromPCName, portComponentName= " + portComponentName);
        }
        ServiceRefPartialInfo info = null;
        info = this.partialInfoMap.get(portComponentName);
        if (info == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find port component: " + portComponentName + " in JAX-WS service ref info map, looking for JAX-RPC info");
            }
            if (this.jaxrpcService == null && !this.retrievedJaxRPCService) {
                this.jaxrpcService = this.getJAXRPCService();
            }
            if (this.jaxrpcService != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found WebServicesService");
                }
                try {
                    info = this.jaxrpcService.getServiceRefInfo(portComponentName, this.mmd);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
                if (info != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found ServiceRefPartialInfo from WebServicesService");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceRefInfoFromPCName, portComponentName= " + portComponentName + ", info= " + info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebServicesService getJAXRPCService() {
        try {
            WebServicesService service;
            WebServicesService webServicesService = service = WsServiceRegistry.getService(this, WebServicesService.class);
            return webServicesService;
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String msg = "The following error occurred when retrieving the WebServicesService: " + t.toString() + "\n" + sw.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, msg);
            }
            WebServicesService webServicesService = null;
            return webServicesService;
        }
        finally {
            this.retrievedJaxRPCService = true;
        }
    }
}

