/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.ws.websvcs.annotations.injection.ResourceServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefImpl;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceRef;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionHelper {
    private static final TraceComponent tc = Tr.register(InjectionHelper.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    static final String referenceClassName = "com.ibm.ws.webservices.metadata.ClientServiceMetaData";
    static final String objectFactoryClassName = "com.ibm.ws.webservices.multiprotocol.naming.ObjectFactoryImpl";
    static final String refAddrName = "refServiceName:";

    static InjectionBinding<WebServiceRef> createResourceServiceRefBinding(Resource resource, ComponentNameSpaceConfiguration cnsConfig, Class<?> serviceClass, String jndiName) throws InjectionException {
        return InjectionHelper.createResourceServiceRefBinding(cnsConfig, serviceClass, jndiName, resource.mappedName());
    }

    static InjectionBinding<WebServiceRef> createResourceServiceRefBinding(ComponentNameSpaceConfiguration cnsConfig, Class<?> serviceClass, String jndiName, String mappedName) throws InjectionException {
        ResourceServiceRefBinding binding = null;
        WebServiceRef wsRef = InjectionHelper.createWebServiceRef(mappedName, serviceClass, jndiName, Object.class, null);
        WebServiceRefMetadata wsrMetadata = new WebServiceRefMetadata(wsRef, cnsConfig.getClassLoader());
        wsrMetadata.setJndiName(jndiName);
        binding = new ResourceServiceRefBinding(wsRef, cnsConfig, wsrMetadata);
        Reference ref = new Reference(referenceClassName, objectFactoryClassName, null);
        StringRefAddr refAddr = new StringRefAddr(refAddrName, jndiName);
        ref.add(refAddr);
        binding.setObjects(null, ref);
        return binding;
    }

    static WebServiceRef createWebServiceRefFromResource(Resource resource, Class<?> typeClass, String jndiName) throws InjectionException {
        return InjectionHelper.createWebServiceRef(resource.mappedName(), typeClass, jndiName, Object.class, null);
    }

    static WebServiceRef createWebServiceRef(String mappedName, Class<?> typeClass, String jndiName, Class<?> valueClass, String wsdlLocation) {
        return new WebServiceRefImpl(mappedName, jndiName, typeClass, valueClass, null);
    }

    static InjectionBinding<WebServiceRef> createWebServiceRefBindingFromResource(Resource resource, ComponentNameSpaceConfiguration cnsConfig, Class<?> serviceClass, String jndiName) throws InjectionException {
        WebServiceRefBinding binding = null;
        WebServiceRef wsRef = InjectionHelper.createWebServiceRefFromResource(resource, serviceClass, jndiName);
        WebServiceRefMetadata wsrMetadata = new WebServiceRefMetadata(wsRef, cnsConfig.getClassLoader());
        wsrMetadata.setType(serviceClass);
        wsrMetadata.setServiceClassName(serviceClass.getName());
        binding = new WebServiceRefBinding(wsRef, cnsConfig);
        binding.setMetadata(wsrMetadata);
        binding.setResourceType(true);
        return binding;
    }

    static Class<?> getTypeFromMember(Member member) throws InjectionException {
        Class<?> memberType = null;
        if (member instanceof Field) {
            memberType = ((Field)member).getType();
        } else if (member instanceof Method) {
            Method method = (Method)member;
            if (method.getParameterTypes() == null || method.getParameterTypes().length != 1) {
                String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail02", new Object[]{method.getName(), method.getDeclaringClass().getName()}, "An @WebServiceRef annotation was found on the {0} method in the {1} class, but the method does not follow the standard JavaBeans convention.");
                Tr.error(tc, msg);
                throw new InjectionException(msg);
            }
            memberType = method.getParameterTypes()[0];
        }
        return memberType;
    }

    public static ServiceRef getBindingEntry(String refName, String componentName, ClientBinding binding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingEntry, serviceRefName= " + refName);
        }
        ServiceRef bindingRef = null;
        List bindingRefs = null;
        bindingRefs = componentName != null ? InjectionHelper.getRefsByComponentName(binding, componentName) : binding.getServiceRefs();
        if (bindingRefs != null && !bindingRefs.isEmpty()) {
            for (ServiceRef currentRef : bindingRefs) {
                if (!currentRef.getServiceRefLink().equals(refName)) continue;
                bindingRef = currentRef;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingEntry, serviceRefName= " + refName + ", bindingRef= " + bindingRef);
        }
        return bindingRef;
    }

    public static ComponentScopedRefs getComponentScopedRefs(ClientBinding binding, String componentName) {
        EList csRefsList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getComponentScopedRefs, componentName= " + componentName);
        }
        ComponentScopedRefs csRefs = null;
        if (binding != null && componentName != null && (csRefsList = binding.getComponentScopedRefs()) != null && !csRefsList.isEmpty()) {
            for (ComponentScopedRefs refs : csRefsList) {
                if (!componentName.equals(refs.getComponentNameLink())) continue;
                csRefs = refs;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getComponentScopedRefs, componentName= " + componentName + ", csRefs= " + csRefs);
        }
        return csRefs;
    }

    public static List getRefsByComponentName(ClientBinding binding, String componentName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRefsByComponentName, componentName= " + componentName);
        }
        EList serviceRefs = null;
        ComponentScopedRefs csRefs = InjectionHelper.getComponentScopedRefs(binding, componentName);
        if (csRefs != null) {
            serviceRefs = csRefs.getServiceRefs();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRefsByComponentName, componentName= " + componentName + ", foundRefs= " + String.valueOf(serviceRefs != null && !serviceRefs.isEmpty()));
        }
        return serviceRefs;
    }

    public static PortQnameBinding getPortBinding(QName portQName, ServiceRef bindingRef) {
        EList portBindings;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortBinding, portQName= " + portQName);
        }
        PortQnameBinding portBinding = null;
        if (portQName != null && (portBindings = bindingRef.getPortQnameBindings()) != null && !portBindings.isEmpty()) {
            for (PortQnameBinding currentBinding : portBindings) {
                QName currentQName = new QName(currentBinding.getPortQnameNamespaceLink(), currentBinding.getPortQnameLocalNameLink());
                if (!currentQName.equals(portQName)) continue;
                portBinding = currentBinding;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPortBinding, portQName= " + portQName + ", portBinding= " + portBinding);
        }
        return portBinding;
    }
}

