/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.generator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ClassRefObject;
import com.ibm.ws.metadata.MetaDataScope;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.XmlListRefObject;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.adapters.WebParamRefObject;
import com.ibm.ws.websvcs.annotations.custom.StatelessInstance;
import com.ibm.ws.websvcs.annotations.custom.processors.StatelessInstanceProcessor;
import com.ibm.ws.websvcs.annotations.utils.Utils;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.WASWSDLGenerator;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.WebParam;
import org.apache.axis2.jaxws.description.builder.ActionAnnot;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.ParameterDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.RequestWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.ResponseWrapperAnnot;
import org.apache.axis2.jaxws.description.builder.ServiceModeAnnot;
import org.apache.axis2.jaxws.description.builder.SoapBindingAnnot;
import org.apache.axis2.jaxws.description.builder.WebEndpointAnnot;
import org.apache.axis2.jaxws.description.builder.WebFaultAnnot;
import org.apache.axis2.jaxws.description.builder.WebMethodAnnot;
import org.apache.axis2.jaxws.description.builder.WebParamAnnot;
import org.apache.axis2.jaxws.description.builder.WebResultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAnnotationInputBuilder
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAnnotationInputBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private List<ClassDataObject> cdoList;
    private ClassRefObject classRef;
    private ArrayList<MetaDataSubObject> hcMethodList;
    private ArrayList<MetaDataSubObject> sbMethodList;
    private ArrayList<MetaDataSubObject> webMethodList;
    private ArrayList<MetaDataSubObject> webParamList;
    private ArrayList<MetaDataSubObject> xmlFieldList;
    private ArrayList<MetaDataSubObject> xmlMethodList;
    private ArrayList<MetaDataSubObject> xmlParameterList;
    private ArrayList<MetaDataSubObject> responseWrapperList;
    private ArrayList<MetaDataSubObject> requestWrapperList;
    private ArrayList<MetaDataSubObject> wsRefMethodList;
    private ArrayList<MetaDataSubObject> wsRefFieldList;
    private ArrayList<MetaDataSubObject> webEndpointList;
    private ArrayList<MetaDataSubObject> oneWayList;
    private ArrayList<MetaDataSubObject> webResultList;
    private ArrayList<MetaDataSubObject> wsRefList;
    private ArrayList<MetaDataSubObject> actionList;
    private ClassLoader classLoader;
    private LoadStrategy loadStrategy;
    private String applicationName;
    private String moduleName;
    private Archive moduleFile;

    public WASAnnotationInputBuilder(List<ClassDataObject> cdoList, ClassLoader classLoader, Archive moduleFile) {
        this.cdoList = cdoList;
        this.classLoader = classLoader;
        this.loadStrategy = moduleFile.getLoadStrategy();
        this.applicationName = WebServiceUtils.getApplicationName(moduleFile);
        this.moduleName = moduleFile.getName();
        this.moduleFile = moduleFile;
    }

    public HashMap<String, DescriptionBuilderComposite> buildInputs() throws Exception {
        HashMap<String, DescriptionBuilderComposite> composites = new HashMap<String, DescriptionBuilderComposite>();
        if (this.cdoList != null) {
            for (ClassDataObject cdo : this.cdoList) {
                this.setAllAnnotationLists(cdo);
                try {
                    DescriptionBuilderComposite composite = this.convertCDOToDBC(cdo);
                    composite.addCustomAnnotationProcessor(new StatelessInstanceProcessor());
                    composite.getProperties().put("reduceWSDLMemoryCache", true);
                    composites.put(composite.getClassName(), composite);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder.buildInputs", "180", this);
                    Object[] inserts = new Object[]{(String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME), e};
                    String msg = NLSProvider.getNLS().getFormattedMessage("loadDBCFail00", inserts, "Configuration data could not be created for the Web service related class {0} : {1}");
                    throw new Exception(msg);
                }
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Null ClassDataObject list given to buildInputs... returning");
        }
        return composites;
    }

    private void setAllAnnotationLists(ClassDataObject cdo) {
        this.hcMethodList = (ArrayList)cdo.getEntry(ClassDataObjectFields.HANDLERCHAINMETHOD);
        this.sbMethodList = (ArrayList)cdo.getEntry(ClassDataObjectFields.SOAPBINDINGMETHOD);
        this.wsRefList = (ArrayList)cdo.getEntry(ClassDataObjectFields.WEBSERVICEREFNONTYPE);
        this.wsRefMethodList = this.separateWSRefAnnotations(this.wsRefList, MetaDataScope.METHOD);
        this.wsRefFieldList = this.separateWSRefAnnotations(this.wsRefList, MetaDataScope.FIELD);
        this.requestWrapperList = (ArrayList)cdo.getEntry(ClassDataObjectFields.REQUESTWRAPPER);
        this.responseWrapperList = (ArrayList)cdo.getEntry(ClassDataObjectFields.RESPONSEWRAPPER);
        this.webEndpointList = (ArrayList)cdo.getEntry(ClassDataObjectFields.WEBENDPOINT);
        this.oneWayList = (ArrayList)cdo.getEntry(ClassDataObjectFields.ONEWAY);
        this.webMethodList = (ArrayList)cdo.getEntry(ClassDataObjectFields.WEBMETHOD);
        this.webResultList = (ArrayList)cdo.getEntry(ClassDataObjectFields.WEBRESULT);
        this.webParamList = (ArrayList)cdo.getEntry(ClassDataObjectFields.WEBPARAM);
        this.xmlMethodList = (ArrayList)cdo.getEntry(ClassDataObjectFields.XMLLISTMETHOD);
        this.xmlFieldList = (ArrayList)cdo.getEntry(ClassDataObjectFields.XMLLISTFIELD);
        this.xmlParameterList = (ArrayList)cdo.getEntry(ClassDataObjectFields.XMLLISTPARAMETER);
        this.actionList = (ArrayList)cdo.getEntry(ClassDataObjectFields.ACTIONNONTYPE);
    }

    private ArrayList<MetaDataSubObject> separateWSRefAnnotations(ArrayList<MetaDataSubObject> wsRefList, MetaDataScope scope) {
        if (wsRefList != null && !wsRefList.isEmpty()) {
            ArrayList<MetaDataSubObject> mdsoList = new ArrayList<MetaDataSubObject>();
            for (MetaDataSubObject mdso : wsRefList) {
                if (!mdso.getScope().equals((Object)scope)) continue;
                mdsoList.add(mdso);
            }
            return mdsoList;
        }
        return null;
    }

    private DescriptionBuilderComposite convertCDOToDBC(ClassDataObject cdo) throws DeploymentException, ClassNotFoundException {
        DescriptionBuilderComposite dbComposite = new DescriptionBuilderComposite();
        this.attachClassLevelInfo(cdo, dbComposite);
        this.attachMethodLevelInfo(cdo, dbComposite);
        this.attachFieldLevelInfo(cdo, dbComposite);
        return dbComposite;
    }

    private void attachClassLevelInfo(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) throws DeploymentException {
        this.attachClassInfo(cdo, dbComposite);
        this.attachWebServiceAnnotation(cdo, dbComposite);
        this.attachWebServiceProviderAnnotation(cdo, dbComposite);
        this.attachHandlerChainAnnotation(cdo, dbComposite);
        this.attachServiceModeAnnotation(cdo, dbComposite);
        this.attachBindingTypeAnnotation(cdo, dbComposite);
        this.attachSoapBindingAnnotationClass(cdo, dbComposite);
        this.attachWebFaultAnnotation(cdo, dbComposite);
        this.attachWebServiceClientAnnotation(cdo, dbComposite);
        this.attachWebServiceRefAnnotation(cdo, dbComposite);
        this.attachStatelessAnnotation(cdo, dbComposite);
        this.attachWebServiceFeatures(cdo, dbComposite);
    }

    private void attachClassInfo(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) throws DeploymentException {
        this.classRef = (ClassRefObject)cdo.getEntry(ClassDataObjectFields.CLASS_INFO);
        if (this.classRef == null) {
            throw new DeploymentException("Missing class-level info");
        }
        ArrayList<String> interfaceList = new ArrayList<String>();
        String[] interfaces = this.classRef.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceList.add(this.javifyName(interfaces[i]));
        }
        if (Utils.isPublicClass(cdo)) {
            dbComposite.setIsInterface(false);
        } else {
            dbComposite.setIsInterface(true);
        }
        dbComposite.setInterfacesList(interfaceList);
        dbComposite.setSuperClassName(this.classRef.getSuperName() != null ? this.javifyName(this.classRef.getSuperName()) : null);
        String qualifiedClassName = (String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME);
        dbComposite.setClassName(this.javifyName(qualifiedClassName));
        dbComposite.setClassLoader(this.classLoader);
    }

    private void attachWebServiceAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) throws DeploymentException {
        WebServiceAnnot wsAnnot = (WebServiceAnnot)cdo.getEntry(ClassDataObjectFields.WEBSERVICE);
        if (wsAnnot != null) {
            dbComposite.setWebServiceAnnot(wsAnnot);
            if (this.getOutputDirectory() != null) {
                dbComposite.setCustomWsdlGenerator(new WASWSDLGenerator(this.getOutputDirectory(), this.applicationName, this.moduleFile));
            }
        }
    }

    private void attachWebServiceProviderAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) throws DeploymentException {
        WebServiceProviderAnnot wspAnnot = (WebServiceProviderAnnot)cdo.getEntry(ClassDataObjectFields.WEBSERVICEPROVIDER);
        if (wspAnnot != null) {
            dbComposite.setWebServiceProviderAnnot(wspAnnot);
        }
    }

    private void attachWebServiceFeatures(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) throws DeploymentException {
        List featureList = (List)cdo.getEntry(ClassDataObjectFields.WEBSERVICEFEATURES);
        if (featureList != null && !featureList.isEmpty()) {
            for (Annotation annot : featureList) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding WebServiceFeature annotation: " + annot);
                }
                dbComposite.addWebServiceFeature(annot);
            }
        }
    }

    private void attachStatelessAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        Object obj = cdo.getEntry(ClassDataObjectFields.EJB_TYPE);
        if (obj != null) {
            StatelessInstance instance = new StatelessInstance(ElementType.TYPE, Stateless.class.getName());
            instance.addParameterData("name", (String)cdo.getEntry(ClassDataObjectFields.EJB_NAME));
            instance.addParameterData("mappedName", (String)cdo.getEntry(ClassDataObjectFields.MAPPED_NAME));
            dbComposite.addCustomAnnotationInstance(instance);
        }
    }

    private void attachHandlerChainAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        HandlerChainAnnot hcAnnot = (HandlerChainAnnot)cdo.getEntry(ClassDataObjectFields.HANDLERCHAIN);
        if (hcAnnot != null) {
            dbComposite.setHandlerChainAnnot(hcAnnot);
        }
    }

    private void attachHandlerChainAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.hcMethodList != null && !this.hcMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.hcMethodList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                HandlerChainAnnot hcAnnot = (HandlerChainAnnot)mdso.getValue();
                methodDC.setHandlerChainAnnot(hcAnnot);
            }
        }
    }

    private ArrayList<FieldDescriptionComposite> attachHandlerChainAnnotation(ClassDataObject cdo, ArrayList<FieldDescriptionComposite> fdcList) {
        ArrayList mdsoList = (ArrayList)cdo.getEntry(ClassDataObjectFields.HANDLERCHAINFIELD);
        if (mdsoList != null && !mdsoList.isEmpty()) {
            Iterator mdsoIter = mdsoList.iterator();
            while (mdsoIter.hasNext()) {
                FieldDescriptionComposite fdComposite = new FieldDescriptionComposite();
                MetaDataSubObject mdso = (MetaDataSubObject)mdsoIter.next();
                fdComposite.setFieldName(mdso.getName());
                HandlerChainAnnot hcAnnot = (HandlerChainAnnot)mdso.getValue();
                fdComposite.setHandlerChainAnnot(hcAnnot);
                fdcList.add(fdComposite);
            }
            return fdcList;
        }
        return null;
    }

    private ArrayList<FieldDescriptionComposite> attachXmlListAnnotation(ClassDataObject cdo, ArrayList<FieldDescriptionComposite> fdcList) {
        if (this.xmlFieldList != null && !this.xmlFieldList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.xmlFieldList.iterator();
            while (mdsoIter.hasNext()) {
                FieldDescriptionComposite fdComposite = new FieldDescriptionComposite();
                MetaDataSubObject mdso = mdsoIter.next();
                fdComposite.setFieldName(mdso.getName());
                fdComposite.setIsListType(true);
                fdcList.add(fdComposite);
            }
            return fdcList;
        }
        return null;
    }

    private void attachServiceModeAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        ServiceModeAnnot smAnnot = (ServiceModeAnnot)cdo.getEntry(ClassDataObjectFields.SERVICEMODE);
        if (smAnnot != null) {
            dbComposite.setServiceModeAnnot(smAnnot);
        }
    }

    private void attachBindingTypeAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        BindingTypeAnnot btAnnot = (BindingTypeAnnot)cdo.getEntry(ClassDataObjectFields.BINDINGTYPE);
        if (btAnnot != null) {
            dbComposite.setBindingTypeAnnot(btAnnot);
        }
    }

    private void attachSoapBindingAnnotationClass(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        SoapBindingAnnot sbAnnot = (SoapBindingAnnot)cdo.getEntry(ClassDataObjectFields.SOAPBINDING);
        if (sbAnnot != null) {
            dbComposite.setSoapBindingAnnot(sbAnnot);
        }
    }

    private void attachSoapBindingAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.sbMethodList != null && !this.sbMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.sbMethodList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                SoapBindingAnnot sbAnnot = (SoapBindingAnnot)mdso.getValue();
                methodDC.setSoapBindingAnnot(sbAnnot);
            }
        }
    }

    private void attachWebFaultAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        WebFaultAnnot wfAnnot = (WebFaultAnnot)cdo.getEntry(ClassDataObjectFields.WEBFAULT);
        if (wfAnnot != null) {
            dbComposite.setWebFaultAnnot(wfAnnot);
        }
    }

    private void attachWebServiceClientAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        WebServiceClientAnnot wscAnnot = (WebServiceClientAnnot)cdo.getEntry(ClassDataObjectFields.WEBSERVICECLIENT);
        if (wscAnnot != null) {
            dbComposite.setWebServiceClientAnnot(wscAnnot);
        }
    }

    private void attachWebServiceRefAnnotation(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        ArrayList wsRefList = (ArrayList)cdo.getEntry(ClassDataObjectFields.WEBSERVICEREF);
        if (wsRefList != null && !wsRefList.isEmpty()) {
            for (WebServiceRefAnnot wsrAnnot : wsRefList) {
                dbComposite.addWebServiceRefAnnot(wsrAnnot);
            }
        }
    }

    private void attachWebServiceRefAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.wsRefMethodList != null && !this.wsRefMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.wsRefMethodList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                WebServiceRefAnnot wsrAnnot = (WebServiceRefAnnot)mdso.getValue();
                methodDC.setWebServiceRefAnnot(wsrAnnot);
            }
        }
    }

    private ArrayList<FieldDescriptionComposite> attachWebServiceRefAnnotation(ClassDataObject cdo, ArrayList<FieldDescriptionComposite> fdcList) {
        if (this.wsRefFieldList != null && !this.wsRefFieldList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.wsRefFieldList.iterator();
            while (mdsoIter.hasNext()) {
                FieldDescriptionComposite fdComposite = new FieldDescriptionComposite();
                MetaDataSubObject mdso = mdsoIter.next();
                fdComposite.setFieldName(mdso.getName());
                WebServiceRefAnnot wsrAnnot = (WebServiceRefAnnot)mdso.getValue();
                fdComposite.setWebServiceRefAnnot(wsrAnnot);
                fdComposite.setFieldClassName(mdso.getSignature());
                fdcList.add(fdComposite);
            }
            return fdcList;
        }
        return null;
    }

    private void attachMethodLevelInfo(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) throws ClassNotFoundException {
        ArrayList mRefList = this.classRef.getMethodRefs();
        if (mRefList != null && !mRefList.isEmpty()) {
            for (MethodRefObject mRef : mRefList) {
                if (!Utils.isPublicMethod(mRef.getAccess())) continue;
                MethodDescriptionComposite methodDC = new MethodDescriptionComposite();
                methodDC.setDescriptionBuilderCompositeRef(dbComposite);
                methodDC.setMethodName(mRef.getName());
                methodDC.setExceptions(this.javifyExceptions(mRef.getExceptions()));
                methodDC.setReturnType(this.javifyName(mRef.getReturnType()));
                this.attachRequestWrapperAnnotation(cdo, mRef, methodDC);
                this.attachResponseWrapperAnnotation(cdo, mRef, methodDC);
                this.attachSoapBindingAnnotation(cdo, mRef, methodDC);
                this.attachWebEndpointAnnotation(cdo, mRef, methodDC);
                this.attachWebServiceRefAnnotation(cdo, mRef, methodDC);
                this.attachHandlerChainAnnotation(cdo, mRef, methodDC);
                this.attachOneWayAnnotation(cdo, mRef, methodDC);
                this.attachWebMethodAnnotation(cdo, mRef, methodDC);
                this.attachWebResultAnnotation(cdo, mRef, methodDC);
                this.attachXmlListAnnotation(cdo, mRef, methodDC);
                this.attachActionAnnotation(cdo, mRef, methodDC);
                String[] signature = mRef.getSignature();
                for (int i = 0; i < signature.length; ++i) {
                    String paramType = signature[i];
                    ParameterDescriptionComposite paramDC = new ParameterDescriptionComposite();
                    paramDC.setMethodDescriptionCompositeRef(methodDC);
                    paramDC.setParameterType(paramType);
                    paramDC.setListOrder(i);
                    this.attachWebParamAnnotation(cdo, mRef, paramType, i, paramDC);
                    this.attachXmlListAnnotation(cdo, mRef, paramType, i, paramDC);
                    methodDC.addParameterDescriptionComposite(paramDC);
                }
                dbComposite.addMethodDescriptionComposite(methodDC);
            }
        }
    }

    private void attachRequestWrapperAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.requestWrapperList != null && !this.requestWrapperList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.requestWrapperList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                RequestWrapperAnnot rwAnnot = (RequestWrapperAnnot)mdso.getValue();
                methodDC.setRequestWrapperAnnot(rwAnnot);
            }
        }
    }

    private void attachResponseWrapperAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.responseWrapperList != null && !this.responseWrapperList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.responseWrapperList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                ResponseWrapperAnnot rwAnnot = (ResponseWrapperAnnot)mdso.getValue();
                methodDC.setResponseWrapperAnnot(rwAnnot);
            }
        }
    }

    private void attachWebEndpointAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.webEndpointList != null && !this.webEndpointList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.webEndpointList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                WebEndpointAnnot weAnnot = (WebEndpointAnnot)mdso.getValue();
                methodDC.setWebEndpointAnnot(weAnnot);
            }
        }
    }

    private void attachOneWayAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.oneWayList != null && !this.oneWayList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.oneWayList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                methodDC.setOneWayAnnot(true);
            }
        }
    }

    private void attachXmlListAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.xmlMethodList != null && !this.xmlMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.xmlMethodList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                methodDC.setIsListType(true);
            }
        }
    }

    private void attachWebMethodAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.webMethodList != null && !this.webMethodList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.webMethodList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                WebMethodAnnot wmAnnot = (WebMethodAnnot)mdso.getValue();
                methodDC.setWebMethodAnnot(wmAnnot);
            }
        }
    }

    private void attachWebResultAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.webResultList != null && !this.webResultList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.webResultList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                WebResultAnnot wrAnnot = (WebResultAnnot)mdso.getValue();
                methodDC.setWebResultAnnot(wrAnnot);
            }
        }
    }

    private void attachActionAnnotation(ClassDataObject cdo, MethodRefObject mRef, MethodDescriptionComposite methodDC) {
        boolean found = false;
        if (this.actionList != null && !this.actionList.isEmpty()) {
            Iterator<MetaDataSubObject> mdsoIter = this.actionList.iterator();
            while (mdsoIter.hasNext() && !found) {
                MetaDataSubObject mdso = mdsoIter.next();
                if (!this.matchesMethod(mRef, mdso)) continue;
                found = true;
                ActionAnnot actionAnnot = (ActionAnnot)mdso.getValue();
                methodDC.setActionAnnot(actionAnnot);
            }
        }
    }

    private void attachWebParamAnnotation(ClassDataObject cdo, MethodRefObject mRef, String paramType, int order, ParameterDescriptionComposite paramDC) {
        if (this.webParamList != null && !this.webParamList.isEmpty()) {
            for (MetaDataSubObject mdso : this.webParamList) {
                WebParamRefObject wpRef = (WebParamRefObject)mdso.getValue();
                if (!this.matchesMethod(mRef, mdso) || wpRef.getArgOrder() != order) continue;
                WebParamAnnot annotation = wpRef.getWebParamAnnot();
                paramDC.setWebParamAnnot(annotation);
            }
        }
    }

    private void attachXmlListAnnotation(ClassDataObject cdo, MethodRefObject mRef, String paramType, int order, ParameterDescriptionComposite paramDC) {
        if (this.xmlParameterList != null && !this.xmlParameterList.isEmpty()) {
            for (MetaDataSubObject mdso : this.xmlParameterList) {
                XmlListRefObject xmlRef = (XmlListRefObject)mdso.getValue();
                if (!this.matchesMethod(mRef, mdso) || xmlRef.getArgOrder() != order) continue;
                paramDC.setIsListType(true);
            }
        }
    }

    private WebParam.Mode getWebParamMode(String modeString) {
        if (modeString == null || "".equals(modeString) || modeString.equals("IN")) {
            return WebParam.Mode.IN;
        }
        if (modeString.equals("OUT")) {
            return WebParam.Mode.OUT;
        }
        return WebParam.Mode.INOUT;
    }

    private void attachFieldLevelInfo(ClassDataObject cdo, DescriptionBuilderComposite dbComposite) {
        ArrayList<FieldDescriptionComposite> fdcList = new ArrayList<FieldDescriptionComposite>();
        this.attachHandlerChainAnnotation(cdo, fdcList);
        this.attachWebServiceRefAnnotation(cdo, fdcList);
        this.attachXmlListAnnotation(cdo, fdcList);
        if (fdcList != null && !fdcList.isEmpty()) {
            for (FieldDescriptionComposite fdComposite : fdcList) {
                dbComposite.addFieldDescriptionComposite(fdComposite);
            }
        }
    }

    private boolean matchesMethod(MethodRefObject mRef, MetaDataSubObject mdso) {
        String[] mdsoSignature;
        if (!mRef.getName().equals(mdso.getName())) {
            return false;
        }
        String[] mRefSignature = mRef.getSignature();
        if (mRefSignature.length != (mdsoSignature = mdso.getSignature().split(" ")).length) {
            return mRefSignature.length == 0 && mdsoSignature.length == 1 && mdsoSignature[0].equals("");
        }
        for (int i = 0; i < mRefSignature.length; ++i) {
            if (mRefSignature[i].equals(mdsoSignature[i])) continue;
            return false;
        }
        return true;
    }

    private boolean convertStringToBoolean(String value, boolean defaultVal) {
        if (value == null || "".equals(value)) {
            return defaultVal;
        }
        return !value.equals("false");
    }

    private String getOutputDirectory() {
        String outputDirectory = Axis2Utils.getCacheDirectory();
        if (outputDirectory != null) {
            outputDirectory = outputDirectory + this.applicationName + File.separator + this.moduleName + File.separator;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Output directory for WsGen artifacts: " + outputDirectory);
        }
        return outputDirectory;
    }

    private String[] javifyExceptions(String[] exceptions) {
        if (exceptions != null) {
            String[] javifiedNames = new String[exceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                String exception;
                javifiedNames[i] = exception = this.javifyName(exceptions[i]);
            }
            return javifiedNames;
        }
        return null;
    }

    private String javifyName(String name) {
        return name.replaceAll("/", ".");
    }
}

