/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.amm.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.amm.client.WSAmmUtils;
import com.ibm.wsspi.amm.merge.AbstractMergeAction;
import com.ibm.wsspi.amm.merge.MergeException;
import com.ibm.wsspi.amm.scan.AnnotationScanner;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.AnnotationValue;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.validate.ValidationException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.MTOM;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.HandlerChain;
import org.eclipse.jst.j2ee.webservice.wsdd.HandlerChains;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLService;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddFactory;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceMergeAction
extends AbstractMergeAction {
    private static TraceComponent tc = Tr.register(WebServiceMergeAction.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    WsddFactory wsddFactory = null;

    public Class<? extends Annotation> getAnnotationClass() {
        return WebService.class;
    }

    public Class<? extends EObject>[] getApplicableTypes() {
        return new Class[]{WebServices.class};
    }

    public boolean isClassTargetsSupported() {
        return true;
    }

    public boolean requiresValidation() {
        return false;
    }

    public void mergeClassTarget(MergeData mergeData, AnnotationScanner annotationScanner, ClassAnnotationTarget cat) throws MergeException, ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeClassTarget");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mergeClassTarget for deployment descriptor: " + mergeData.getDeploymentDescriptor() + " in application module: " + mergeData.getModuleFile().getName());
        }
        Class annotationClass = cat.getAnnotationClass();
        AnnotationInfo annotationInfo = cat.getApplicableClass().getAnnotation(annotationClass);
        ClassInfo classInfo = cat.getApplicableClass();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mergeClassTarget: have " + annotationClass.getName() + " annotation " + "in class " + classInfo.getName());
        }
        try {
            WebServices webServices = this.getOrCreateWebServices(mergeData);
            this.doWebServiceMerge(mergeData, annotationScanner, cat, webServices);
        }
        catch (MergeException e) {
            throw e;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MergeException(e.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeClassTarget");
            }
        }
    }

    void doWebServiceMerge(MergeData mergeData, AnnotationScanner annotationScanner, ClassAnnotationTarget cat, WebServices webServices) throws ValidationException, Exception {
        HandlerChains ddHandC;
        String ddBind;
        boolean ddEnableMtom;
        WSDLPort ddWsdlPort;
        PortComponent ddPortComponent;
        String aName;
        WebServiceDescription ddWebserviceDescription;
        String ddWsdl;
        Class annotationClass = cat.getAnnotationClass();
        AnnotationInfo annotationInfo = cat.getApplicableClass().getAnnotation(annotationClass);
        ClassInfo classInfo = cat.getApplicableClass();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "doWebServiceMerge: have " + annotationClass + " annotation in class: " + classInfo.getName());
        }
        if ((ddWsdl = (ddWebserviceDescription = this.getOrCreateWebServiceDescription(webServices, aName = this.getOrCreateName(classInfo, cat))).getWsdlFile()) == null || "".equals(ddWsdl)) {
            String aWsdl = null;
            AnnotationValue aValue = annotationInfo.getValue("wsdlLocation");
            if (!WSAmmUtils.isEmpty(aValue)) {
                aWsdl = aValue.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doWebServiceMerge: got wsdlLocation " + aWsdl + " from the annotation.");
                }
            }
            if (aWsdl != null) {
                ddWebserviceDescription.setWsdlFile(aWsdl);
            }
        }
        if ((ddPortComponent = this.findNamedPortComponent(ddWebserviceDescription, aName)) == null) {
            ddPortComponent = this.getWsddFactory().createPortComponent();
            ddWebserviceDescription.getPortComponents().add(ddPortComponent);
            ddPortComponent.setPortComponentName(aName);
        }
        String aTNS = null;
        String aSN = null;
        WSDLService ddWsdlService = ddPortComponent.getWsdlService();
        if (ddWsdlService == null || ddWsdlService.getLocalPart() == null || ddWsdlService.getNamespaceURI() == null) {
            AnnotationValue aValue = annotationInfo.getValue("targetNamespace");
            if (!WSAmmUtils.isEmpty(aValue)) {
                aTNS = aValue.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doWebServiceMerge: got targetNamespace " + aTNS + " from the annotation.");
                }
            }
            if (!WSAmmUtils.isEmpty(aValue = annotationInfo.getValue("serviceName"))) {
                aSN = aValue.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doWebServiceMerge: got serviceName " + aSN + " from the annotation.");
                }
            }
            if (aTNS != null && aSN != null) {
                ddWsdlService = this.getWsddFactory().createWSDLService();
                ddWsdlService.setLocalPart(aSN);
                ddWsdlService.setNamespaceURI(aTNS);
                ddPortComponent.setWsdlService(ddWsdlService);
            }
        }
        if ((ddWsdlPort = ddPortComponent.getWsdlPort()) == null || ddWsdlPort.getLocalPart() == null || ddWsdlPort.getNamespaceURI() == null) {
            String aPN = null;
            AnnotationValue aValue = annotationInfo.getValue("portName");
            if (!WSAmmUtils.isEmpty(aValue)) {
                aPN = aValue.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doWebServiceMerge: got portName " + aPN + " from the annotation.");
                }
            }
            if (aPN != null && aTNS != null) {
                ddWsdlPort = this.getWsddFactory().createWSDLPort();
                ddWsdlPort.setLocalPart(aPN);
                ddWsdlPort.setNamespaceURI(aTNS);
                ddPortComponent.setWsdlPort(ddWsdlPort);
            }
        }
        String ddSEI = ddPortComponent.getServiceEndpointInterface();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "doWebServiceMerge: got ServiceEndpointInterface " + (ddSEI == null ? "null" : ddSEI) + " from the DD's PortComponent.");
        }
        String aEI = null;
        AnnotationValue aValue = annotationInfo.getValue("endpointInterface");
        if (!WSAmmUtils.isEmpty(aValue)) {
            aEI = aValue.getStringValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "doWebServiceMerge: got endpointInterface " + aEI + " from the annotation.");
            }
        }
        if (aEI != null && ddSEI != null && !aEI.equals(ddSEI)) {
            Tr.warning(tc, "doWebServiceMerge: the endpointInterface from the @WebService annotation (" + aEI + ") does not match the DD PortComponent" + " ServiceEndpointInterface (" + ddSEI + ").  This violates the JSR-109 rules. " + aEI + " will be used.");
        }
        if (aEI != null) {
            ddPortComponent.setServiceEndpointInterface(aEI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "doWebServiceMerge: set annotation endpointInterface (" + aEI + ") as the DD PortComponent ServiceEndpointInterface.");
            }
        }
        if (!(ddEnableMtom = ddPortComponent.isSetEnableMtom())) {
            this.doMtomMerge(ddPortComponent, annotationScanner);
        }
        if ((ddBind = ddPortComponent.getProtocolBinding()) == null || "".equals(ddBind)) {
            this.doBindingTypeMerge(ddPortComponent, annotationScanner);
        }
        if ((ddHandC = ddPortComponent.getHandlerChains()) == null) {
            this.doHandlerChainMerge(ddPortComponent, annotationScanner, mergeData);
        }
        ServiceImplBean ddSIB = null;
        ddSIB = ddPortComponent.getServiceImplBean();
        if (ddSIB == null) {
            this.doStatelessMergeOrServletLink(ddPortComponent, annotationScanner, classInfo);
        }
    }

    private WebServices getOrCreateWebServices(MergeData mergeData) {
        WebServices webServices = null;
        webServices = (WebServices)mergeData.getDeploymentDescriptor();
        if (webServices == null) {
            webServices = this.getWsddFactory().createWebServices();
        }
        return webServices;
    }

    private WsddFactory getWsddFactory() {
        if (this.wsddFactory == null) {
            String uri = "wsdd.xmi";
            WsddPackage pkg = (WsddPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
            this.wsddFactory = pkg.getWsddFactory();
        }
        return this.wsddFactory;
    }

    private String getOrCreateName(ClassInfo classInfo, ClassAnnotationTarget cat) {
        String aName = null;
        AnnotationInfo annotationInfo = classInfo.getAnnotation(cat.getAnnotationClass());
        AnnotationValue aValue = annotationInfo.getValue("name");
        if (!WSAmmUtils.isEmpty(aValue)) {
            aName = aValue.getStringValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOrCreateName: got name " + aName + " from the annotation.");
            }
        } else {
            int inx;
            String fqName = classInfo.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOrCreateName: full qualified name " + fqName + " from the ClassInfo.");
            }
            aName = (inx = fqName.lastIndexOf(46)) >= 0 ? fqName.substring(inx + 1) : fqName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getOrCreateName: got name " + aName + " from the ClassInfo.");
            }
        }
        return aName;
    }

    private WebServiceDescription getOrCreateWebServiceDescription(WebServices webServices, String portCompName) {
        EList wsdList = webServices.getWebServiceDescriptions();
        if (wsdList != null) {
            for (WebServiceDescription ddWebserviceDescription : wsdList) {
                PortComponent pc = this.findNamedPortComponent(ddWebserviceDescription, portCompName);
                if (pc == null) continue;
                return ddWebserviceDescription;
            }
        }
        WebServiceDescription ddWebserviceDescription = this.getWsddFactory().createWebServiceDescription();
        webServices.getWebServiceDescriptions().add(ddWebserviceDescription);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getOrCreateWebServiceDescription: returning newly created empty one.");
        }
        return ddWebserviceDescription;
    }

    private PortComponent findNamedPortComponent(WebServiceDescription ddWebserviceDescription, String portCompName) {
        EList pcList = ddWebserviceDescription.getPortComponents();
        for (PortComponent pc : pcList) {
            String pcName = pc.getPortComponentName();
            if (pcName == null || !pcName.equals(portCompName)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "findNamedPortComponent: found " + pcName);
            }
            return pc;
        }
        return null;
    }

    private void doMtomMerge(PortComponent ddPortComponent, AnnotationScanner annotationScanner) {
        Map cats = annotationScanner.getClassAnnotationTargets(MTOM.class);
        if (cats != null && !cats.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have " + cats.size() + " @MTOM annotations to process.");
            }
            for (String className : cats.keySet()) {
                AnnotationValue aValue;
                ClassAnnotationTarget cat = (ClassAnnotationTarget)cats.get(className);
                ClassInfo classInfo = cat.getApplicableClass();
                AnnotationInfo annotationInfo = classInfo.getAnnotation(cat.getAnnotationClass());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doMtomMerge: Found " + cat.getAnnotationClass() + " annotation in class: " + className);
                }
                if (WSAmmUtils.isEmpty(aValue = annotationInfo.getValue("enabled"))) continue;
                boolean aEnabled = aValue.getBooleanValue();
                ddPortComponent.setEnableMtom(aEnabled);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doMtomMerge: got enabled " + aEnabled + " from the annotation.  Set it into the DD <port-component>.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No @MTOM annotations to process.");
        }
    }

    private void doBindingTypeMerge(PortComponent ddPortComponent, AnnotationScanner annotationScanner) {
        Map cats = annotationScanner.getClassAnnotationTargets(BindingType.class);
        if (cats != null && !cats.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have " + cats.size() + " @BindingType annotations to process.");
            }
            for (String className : cats.keySet()) {
                AnnotationValue aValue;
                ClassAnnotationTarget cat = (ClassAnnotationTarget)cats.get(className);
                ClassInfo classInfo = cat.getApplicableClass();
                AnnotationInfo annotationInfo = classInfo.getAnnotation(cat.getAnnotationClass());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doBindingTypeMerge: Found " + cat.getAnnotationClass() + " annotation in class: " + className);
                }
                if (WSAmmUtils.isEmpty(aValue = annotationInfo.getValue("value"))) continue;
                String aBT = aValue.getStringValue();
                ddPortComponent.setProtocolBinding(aBT);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doBindingTypeMerge: got value " + aBT + " from the annotation.  Set it into the DD <port-component>.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No @BindingType annotations to process.");
        }
    }

    private void doHandlerChainMerge(PortComponent ddPortComponent, AnnotationScanner annotationScanner, MergeData mergeData) {
        Map cats = annotationScanner.getClassAnnotationTargets(javax.jws.HandlerChain.class);
        if (cats != null && !cats.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have " + cats.size() + " @HandlerChain annotations to process.");
            }
            for (String className : cats.keySet()) {
                AnnotationValue aValue;
                ClassAnnotationTarget cat = (ClassAnnotationTarget)cats.get(className);
                ClassInfo classInfo = cat.getApplicableClass();
                AnnotationInfo annotationInfo = classInfo.getAnnotation(cat.getAnnotationClass());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doHandlerChainMerge: Found " + cat.getAnnotationClass() + " annotation in class: " + className);
                }
                if (WSAmmUtils.isEmpty(aValue = annotationInfo.getValue("file"))) continue;
                String aHCFile = aValue.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doHandlerChainMerge: got file " + aHCFile + " from the annotation.");
                }
                ClassLoader classLoader = mergeData.getModuleFile().getArchiveClassLoader();
                InputStream is = DescriptionUtils.openHandlerConfigStream(aHCFile, classInfo.getName(), classLoader);
                if (is != null) {
                    HandlerChainsType fHCSType = DescriptionUtils.loadHandlerChains(is, classLoader);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "doHandlerChainMerge: Loaded " + aHCFile + " handler configuration file.");
                    }
                    this.createHandlerChainsInDD(ddPortComponent, fHCSType);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doHandlerChainMerge: Could not load " + aHCFile + " handler configuration file");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No @HandlerChain annotations to process.");
        }
    }

    private void createHandlerChainsInDD(PortComponent ddPortComponent, HandlerChainsType fHCSType) {
        List<HandlerChainType> hcTypeList = fHCSType.getHandlerChain();
        if (hcTypeList != null) {
            HandlerChains ddHCs = this.getWsddFactory().createHandlerChains();
            ddPortComponent.setHandlerChains(ddHCs);
            for (HandlerChainType hcType : hcTypeList) {
                List<HandlerType> hTypes;
                javax.xml.namespace.QName serviceQNamePattern;
                HandlerChain ddHC = this.getWsddFactory().createHandlerChain();
                ddHCs.getHandlerChains().add(ddHC);
                String uri = "common.xmi";
                CommonPackage pkg = (CommonPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
                CommonFactory factory = pkg.getCommonFactory();
                QName wccmQName = factory.createQName();
                javax.xml.namespace.QName portQNamePattern = hcType.getPortNamePattern();
                if (portQNamePattern != null) {
                    wccmQName.setLocalPart(portQNamePattern.getLocalPart());
                    wccmQName.setNamespaceURI(portQNamePattern.getNamespaceURI());
                    ddHC.setPortNamePattern(wccmQName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createHandlerChainsInDD: set handler-chain port QName pattern = " + portQNamePattern);
                    }
                }
                if ((serviceQNamePattern = hcType.getServiceNamePattern()) != null) {
                    wccmQName.setLocalPart(serviceQNamePattern.getLocalPart());
                    wccmQName.setNamespaceURI(serviceQNamePattern.getNamespaceURI());
                    ddHC.setServiceNamePattern(wccmQName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "createHandlerChainsInDD: set handler-chain service QName pattern = " + serviceQNamePattern);
                    }
                }
                if ((hTypes = hcType.getHandler()) == null) continue;
                for (HandlerType hType : hTypes) {
                    String name;
                    String className;
                    Handler ddH = this.getWsddFactory().createHandler();
                    ddHC.getHandlers().add(ddH);
                    String string = className = hType.getHandlerClass() != null ? hType.getHandlerClass().getValue() : null;
                    if (className != null) {
                        ddH.setHandlerClass(className);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "createHandlerChainsInDD: set HandlerClass " + className + " into the DD <handler-chain><handler-chains>.");
                        }
                    }
                    if ((name = hType.getHandlerName() != null ? hType.getHandlerName().getValue() : null) == null) continue;
                    ddH.setHandlerName(name);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "createHandlerChainsInDD: set HandlerName " + name + " into the DD <handler-chain><handler-chains>.");
                }
            }
        }
    }

    private void doStatelessMergeOrServletLink(PortComponent ddPortComponent, AnnotationScanner annotationScanner, ClassInfo classInfoParm) {
        ServiceImplBean ddSIB = this.getWsddFactory().createServiceImplBean();
        ddPortComponent.setServiceImplBean(ddSIB);
        boolean addedEJB = false;
        Map cats = annotationScanner.getClassAnnotationTargets(Stateless.class);
        if (cats != null && !cats.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Have " + cats.size() + " @Stateless annotations to process.");
            }
            for (String className : cats.keySet()) {
                AnnotationValue aValue;
                ClassAnnotationTarget cat = (ClassAnnotationTarget)cats.get(className);
                ClassInfo classInfo = cat.getApplicableClass();
                AnnotationInfo annotationInfo = classInfo.getAnnotation(cat.getAnnotationClass());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doStatelessMergeOrServletLink: Found " + cat.getAnnotationClass() + " annotation in class: " + className);
                }
                if (WSAmmUtils.isEmpty(aValue = annotationInfo.getValue("name"))) continue;
                String aName = aValue.getStringValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doStatelessMergeOrServletLink: got name " + aName + " from the annotation.");
                }
                EJBLink ddE = this.getWsddFactory().createEJBLink();
                ddSIB.setEEJBLink(ddE);
                ddE.setEjbLink(aName);
                addedEJB = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "doStatelessMergeOrServletLink: set EJBLink " + aName + " into the DD <service-impl-bean><ejb-link>.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No @Stateless annotations to process.");
        }
        if (!addedEJB) {
            String fqName = classInfoParm.getName();
            ServletLink ddSL = this.getWsddFactory().createServletLink();
            ddSIB.setEServletLink(ddSL);
            ddSL.setServletLink(fqName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "doStatelessMergeOrServletLink: set ServletLink " + fqName + " into the DD <service-impl-bean><servlet-link>.");
            }
        }
    }
}

