/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.amm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.amm.client.ResourceValidator;
import com.ibm.ws.websvcs.annotations.amm.client.WSAmmUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.FieldAnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.AnnotationValue;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.FieldInfo;
import com.ibm.wsspi.amm.scan.util.info.MethodInfo;
import com.ibm.wsspi.amm.validate.AnnotationValidator;
import com.ibm.wsspi.amm.validate.ValidationException;
import java.lang.annotation.Annotation;
import javax.xml.ws.WebServiceRef;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefValidator
extends ResourceValidator
implements AnnotationValidator {
    private static TraceComponent tc = Tr.register(WebServiceRefValidator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return WebServiceRef.class;
    }

    @Override
    public void validate(MergeData mergeData, AnnotationTarget annotationTarget) throws ValidationException {
        this.validate(mergeData, annotationTarget, null);
    }

    @Override
    public void validate(MergeData mergeData, AnnotationTarget annotationTarget, AnnotationInfo annotationInfo) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        EObject eObject = mergeData.getDeploymentDescriptor();
        if (annotationTarget instanceof ClassAnnotationTarget) {
            if (annotationInfo == null) {
                annotationInfo = ((ClassAnnotationTarget)annotationTarget).getApplicableClass().getAnnotation(annotationTarget.getAnnotationClass());
            }
            this.validateClassLevelAnnotation((ClassAnnotationTarget)annotationTarget, eObject, annotationInfo);
        } else if (annotationTarget instanceof MethodAnnotationTarget) {
            this.validateMethodLevelAnnotation((MethodAnnotationTarget)annotationTarget);
        } else if (annotationTarget instanceof FieldAnnotationTarget) {
            this.validateFieldLevelAnnotation((FieldAnnotationTarget)annotationTarget);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    @Override
    protected void validateClassLevelAnnotation(ClassAnnotationTarget cat, EObject eObject, AnnotationInfo annotationInfo) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClassLevelAnnotation, class= " + cat.getApplicableClass().getName());
        }
        super.validateClassLevelAnnotation(cat, eObject, annotationInfo);
        try {
            AnnotationValue type = annotationInfo.getValue("type");
            ClassInfo typeInfo = type.getClassValue();
            if (!WSAmmUtils.isAssignableFrom(typeInfo, WSAmmUtils.JAX_WS_SVC_CLASS_NAME)) {
                ClassInfo valueInfo;
                AnnotationValue value = annotationInfo.getValue("value");
                ClassInfo classInfo = valueInfo = value != null ? value.getClassValue() : null;
                if (valueInfo == null || !WSAmmUtils.isAssignableFrom(valueInfo, WSAmmUtils.JAX_WS_SVC_CLASS_NAME)) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("meregeValidateFail05", new Object[]{cat.getApplicableClass().getName()}, "An @WebServiceRef annotation was found on the {0} class but neitherthe ''type'' nor the ''value'' attribute referred to a javax.xml.ws.Serviceclass type. Either the ''type'' or ''value'' attribute must refer to a java.xml.ws.Service class type.");
                    Tr.error(tc, msg);
                    throw new ValidationException(msg);
                }
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail01", new Object[]{cat.getApplicableClass().getName(), e}, "Validation of the @Resource or @WebServiceRef annotation in the {0} class failed due to the following error: {1}");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateClassLevelAnnotation, class= " + cat.getApplicableClass().getName());
        }
    }

    @Override
    protected void validateMethodLevelAnnotation(MethodAnnotationTarget mat) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMethodLevelAnnotation, method= " + mat.getApplicableMethod().getName() + ", class= " + mat.getApplicableClass().getName());
        }
        super.validateMethodLevelAnnotation(mat);
        MethodInfo methodInfo = mat.getApplicableMethod();
        AnnotationInfo annotationInfo = methodInfo.getAnnotation(mat.getAnnotationClass());
        AnnotationValue typeValue = annotationInfo.getValue("type");
        AnnotationValue valueValue = annotationInfo.getValue("value");
        if (!(typeValue == null || WSAmmUtils.isAssignableFrom(typeValue.getClassValue(), WSAmmUtils.JAX_WS_SVC_CLASS_NAME) || valueValue != null && WSAmmUtils.isAssignableFrom(valueValue.getClassValue(), WSAmmUtils.JAX_WS_SVC_CLASS_NAME))) {
            String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail07", new Object[]{methodInfo.getName(), methodInfo.getDeclaringClass().getName()}, "The @WebServiceRef annotation was found on the {0} member in the {1} class, but the ''value'' attribute did not specify a class that is a subclass of the javax.xml.ws.Service class. If the @WebServiceRef annotation is being used to indicate port injection, the ''value'' attribute must specify a class that is a subclass of the javax.xml.ws.Service class.");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMethodLevelAnnotation, method= " + mat.getApplicableMethod().getName() + ", class= " + mat.getApplicableClass().getName());
        }
    }

    @Override
    protected void validateFieldLevelAnnotation(FieldAnnotationTarget fat) throws ValidationException {
        super.validateFieldLevelAnnotation(fat);
        this.validateFieldLevelAnnotation(fat.getApplicableField(), fat.getApplicableField().getAnnotation(WebServiceRef.class));
    }

    protected void validateFieldLevelAnnotation(FieldInfo fieldInfo, AnnotationInfo annotationInfo) throws ValidationException {
        AnnotationValue type = annotationInfo.getValue("type");
        AnnotationValue value = annotationInfo.getValue("value");
        if (fieldInfo.getType().getName().equals(Object.class.getName())) {
            ClassInfo typeInfo;
            if (type == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail03", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName()}, "The @WebServiceRef or @Resource annotation was found on the {0} member in the {1} class but the type of injection could not be inferred from either the ''type'' attribute or the member type.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
            if (type != null && value != null) {
                if (type.getClassValue().getName().equals(Object.class.getName()) && value.getClassValue().getName().equals(Object.class.getName())) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail03", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName()}, "The @WebServiceRef or @Resource annotation was found on the {0} member in the {1} class but the type of injection could not be inferred from either the ''type'' attribute or the member type.");
                    Tr.error(tc, msg);
                    throw new ValidationException(msg);
                }
            } else if (value == null && !WSAmmUtils.isAssignableFrom(typeInfo = type.getClassValue(), WSAmmUtils.JAX_WS_SVC_CLASS_NAME)) {
                String msg = NLSProvider.getNLS().getFormattedMessage("meregeValidateFail06", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName()}, "An @WebServiceRef annotation was found on the {0} member in the {1} class but neither the ''type'' nor the ''value'' attribute referred to a javax.xml.ws.Serviceclass type. Either the ''type'' or ''value'' attribute must refer to a java.xml.ws.Service class type.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
        } else {
            ClassInfo valueInfo;
            if (type == null && value == null && !WSAmmUtils.isAssignableFrom(fieldInfo.getType(), WSAmmUtils.JAX_WS_SVC_CLASS_NAME)) {
                String msg = NLSProvider.getNLS().getFormattedMessage("meregeValidateFail06", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName()}, "An @WebServiceRef annotation was found on the {0} member in the {1} class but neither the ''type'' nor the ''value'' attribute referred to a javax.xml.ws.Serviceclass type. Either the ''type'' or ''value'' attribute must refer to a java.xml.ws.Service class type.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
            ClassInfo typeInfo = type != null ? type.getClassValue() : null;
            ClassInfo classInfo = valueInfo = value != null ? value.getClassValue() : null;
            if (!(typeInfo != null && !typeInfo.getName().equals(Object.class.getName()) || WSAmmUtils.isAssignableFrom(fieldInfo.getType(), WSAmmUtils.JAX_WS_SVC_CLASS_NAME) || valueInfo != null && WSAmmUtils.isAssignableFrom(valueInfo, WSAmmUtils.JAX_WS_SVC_CLASS_NAME))) {
                String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail07", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName()}, "The @WebServiceRef annotation was found on the {0} member in the {1} class, but the 'value' attribute did not specify a class that is a subclass of the javax.xml.ws.Service class. If the @WebServiceRef annotation is being used to indicate port injection, the 'value' attribute must specify a class that is a subclass of the javax.xml.ws.Service class.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFieldLevelAnnotation, field= " + fieldInfo.getName() + ", class= " + fieldInfo.getDeclaringClass().getName());
        }
    }
}

