/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.amm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscbnd.WscbndFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.injection.InjectionHelper;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.AnnotationValue;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.FieldInfo;
import com.ibm.wsspi.amm.scan.util.info.Info;
import com.ibm.wsspi.amm.scan.util.info.MethodInfo;
import com.ibm.wsspi.amm.validate.ValidationException;
import com.ibm.wsspi.webservices.WSDescriptionUtils;
import com.ibm.wsspi.webservices.WebServiceClientType;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.ws.Service;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class WSAmmUtils {
    private static TraceComponent tc = Tr.register(WSAmmUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    static final String JAX_WS_SVC_CLASS_NAME = Service.class.getName();
    static final String JAX_RPC_SVC_CLASS_NAME = javax.xml.rpc.Service.class.getName();
    static final String TMP_DIR_PATH = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("java.io.tmpdir");
        }
    });
    private static Map<ClassLoader, JaxWSCatalogAccessor> catalogAccessorMap = new Hashtable<ClassLoader, JaxWSCatalogAccessor>();

    public static String getJavaBeanPropertyName(String methodName) {
        String propertyName = null;
        if (methodName.startsWith("set") && methodName.length() > 3) {
            propertyName = methodName.substring(3, methodName.length());
            String firstChar = propertyName.substring(0, 1);
            firstChar = firstChar.toLowerCase();
            propertyName = firstChar + propertyName.substring(1);
        }
        return propertyName;
    }

    public static FieldInfo getApplicableField(MethodAnnotationTarget mat) throws ValidationException {
        MethodInfo methodInfo = mat.getApplicableMethod();
        String methodName = methodInfo.getName();
        String annotationTypeName = mat.getAnnotationClass().getName();
        String propertyName = WSAmmUtils.getJavaBeanPropertyName(methodName);
        if (propertyName == null) {
            throw new ValidationException("The " + annotationTypeName + " annotation was found " + "on the " + methodName + " method, but a Java Bean property name could not " + "be determined from the method name.");
        }
        ClassInfo classInfo = methodInfo.getDeclaringClass();
        FieldInfo fieldInfo = null;
        try {
            fieldInfo = classInfo.getField(propertyName);
        }
        catch (NoSuchFieldException e) {
            throw new ValidationException("The " + annotationTypeName + " annotation was found " + "on the " + methodName + " method, but a field by the name of " + propertyName + " could not be found.");
        }
        return fieldInfo;
    }

    public static boolean isEmpty(AnnotationValue value) {
        return value == null || value.getStringValue() == null || "".equals(value.getStringValue());
    }

    public static boolean isServiceResource(AnnotationTarget target, AnnotationInfo annotationInfo, Info info) {
        return WSAmmUtils.isJAXRPCServiceResource(target, annotationInfo, info) || WSAmmUtils.isJAXWSServiceResource(target, annotationInfo, info);
    }

    public static boolean isJAXRPCServiceResource(AnnotationTarget target, AnnotationInfo annotationInfo, Info info) {
        ClassInfo typeClassInfo = WSAmmUtils.getClassAttributeValue(annotationInfo, info, "type");
        return WSAmmUtils.isAssignableFrom(typeClassInfo, JAX_RPC_SVC_CLASS_NAME);
    }

    public static boolean isJAXWSServiceResource(AnnotationTarget target, AnnotationInfo annotationInfo, Info info) {
        ClassInfo typeClassInfo = WSAmmUtils.getClassAttributeValue(annotationInfo, info, "type");
        ClassInfo valueClassInfo = WSAmmUtils.getClassAttributeValue(annotationInfo, info, "value");
        if (valueClassInfo != null) {
            return WSAmmUtils.isAssignableFrom(typeClassInfo, JAX_WS_SVC_CLASS_NAME) || WSAmmUtils.isAssignableFrom(valueClassInfo, JAX_WS_SVC_CLASS_NAME);
        }
        return WSAmmUtils.isAssignableFrom(typeClassInfo, JAX_WS_SVC_CLASS_NAME);
    }

    static boolean isAssignableFrom(ClassInfo classInfo, String className) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAssignableFrom, className= " + className + " assigningClass= " + (classInfo != null ? classInfo.getName() : "<null>"));
        }
        boolean assignable = false;
        if (classInfo != null) {
            assignable = classInfo.getName().equals(className);
            if (!assignable) {
                assignable = WSAmmUtils.isSuperClass(classInfo, className);
            }
            if (!assignable) {
                assignable = WSAmmUtils.isSuperInterface(classInfo, className);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAssignableFrom, returning: " + String.valueOf(assignable));
        }
        return assignable;
    }

    static boolean isSuperClass(ClassInfo classInfo, String className) {
        boolean isSuperClass = false;
        for (ClassInfo superClassInfo = classInfo.getSuperclass(); superClassInfo != null; superClassInfo = superClassInfo.getSuperclass()) {
            if (!superClassInfo.getName().equals(className)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The " + className + " class is a super class of the " + classInfo.getName() + " class.");
            }
            isSuperClass = true;
            break;
        }
        return isSuperClass;
    }

    static boolean isSuperInterface(ClassInfo classInfo, String className) {
        Collection interfacesInfo = classInfo.getAllInterfaces();
        if (interfacesInfo != null && !interfacesInfo.isEmpty()) {
            for (ClassInfo interfaceInfo : interfacesInfo) {
                if (interfaceInfo.getName().equals(className)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + className + " class is a super interface of the " + classInfo.getName() + " class.");
                    }
                    return true;
                }
                WSAmmUtils.isSuperInterface(interfaceInfo, className);
            }
        }
        return false;
    }

    public static ClassInfo getClassAttributeValue(AnnotationInfo annotationInfo, Info info, String attributeName) {
        AnnotationValue annotValue;
        ClassInfo typeClassInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassAttributeValue, attribute-name= " + attributeName + "annotationInfo= " + annotationInfo.getClass().getName());
        }
        ClassInfo classInfo = typeClassInfo = (annotValue = annotationInfo.getValue(attributeName)) != null ? annotValue.getClassValue() : null;
        if (typeClassInfo == null || typeClassInfo.getName().equals(Object.class.getName())) {
            typeClassInfo = WSAmmUtils.inferClassType(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassAttributeValue= " + (typeClassInfo != null ? typeClassInfo.getName() : null));
        }
        return typeClassInfo;
    }

    public static String getClassNameForAttribute(AnnotationInfo annotationInfo, Info info, String attributeName) throws Exception {
        String typeClassName;
        AnnotationValue annotValue;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassNameAttributeValue, attribute-name= " + attributeName);
        }
        ClassInfo typeClassInfo = (annotValue = annotationInfo.getValue(attributeName)) != null ? annotValue.getClassValue() : null;
        String string = typeClassName = typeClassInfo != null ? typeClassInfo.getName() : null;
        if (typeClassName == null || typeClassName.equals(Object.class.getName())) {
            typeClassName = WSAmmUtils.inferClassName(info);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassNameAttributeValue= " + typeClassName);
        }
        return typeClassName;
    }

    public static ClassInfo inferClassType(Info info) {
        ClassInfo inferClassInfo = null;
        if (info instanceof MethodInfo) {
            ClassInfo paramInfo;
            MethodInfo methodInfo = (MethodInfo)info;
            inferClassInfo = paramInfo = (ClassInfo)methodInfo.getParameterTypes().get(0);
        } else if (info instanceof FieldInfo) {
            FieldInfo fieldInfo = (FieldInfo)info;
            inferClassInfo = fieldInfo.getType();
        }
        return inferClassInfo;
    }

    public static String inferClassName(Info info) {
        String inferClassName = null;
        if (info instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)info;
            ClassInfo paramInfo = (ClassInfo)methodInfo.getParameterTypes().get(0);
            inferClassName = paramInfo.getName();
        } else if (info instanceof FieldInfo) {
            FieldInfo fieldInfo = (FieldInfo)info;
            inferClassName = fieldInfo.getType().getName();
        }
        return inferClassName;
    }

    public static List getServiceRefs(EObject eObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceRefs, EObject= " + eObject);
        }
        ArrayList serviceRefList = new ArrayList();
        if (eObject instanceof WebApp) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting service refs from web.xml deployment descriptor");
            }
            WebApp webApp = (WebApp)eObject;
            serviceRefList.addAll(webApp.getServiceRefs());
        } else if (eObject instanceof EJBJar) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting service refs from ejb-jar.xml deployment descriptor");
            }
            EJBJar ejbJar = (EJBJar)eObject;
            for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting service refs from enterprise bean: " + bean.getName());
                }
                serviceRefList.addAll(bean.getServiceRefs());
            }
        } else if (eObject instanceof ApplicationClient) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting service refs from application-client.xml deployment descriptor");
            }
            ApplicationClient appClient = (ApplicationClient)eObject;
            serviceRefList.addAll(appClient.getServiceRefs());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceRefs, EObject= " + eObject);
        }
        return serviceRefList;
    }

    public static QName createQName(String tns, String localPart) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createQName, tns= " + tns + ", localPart= " + localPart);
        }
        String uri = "common.xmi";
        CommonPackage pkg = (CommonPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
        CommonFactory factory = pkg.getCommonFactory();
        QName qName = factory.createQName();
        qName.setLocalPart(localPart);
        qName.setNamespaceURI(tns);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createQName, qName= " + qName);
        }
        return qName;
    }

    public static WSDLLocator getWsdlLocator(String wsdlLocation, ModuleFile moduleFile, boolean resolveWSDL) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWsdlLocator");
        }
        ClassLoader classLoader = moduleFile.getArchiveClassLoader();
        JaxWSCatalogAccessor catalogAccessor = null;
        if (wsdlLocation != null) {
            ModuleWSDLLocator wsdlLoc;
            if (resolveWSDL) {
                catalogAccessor = catalogAccessorMap.get(classLoader);
                if (catalogAccessor == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "JaxWSCatalogAccessor not found in map, creating one for classloader: " + classLoader);
                    }
                    catalogAccessor = new JaxWSCatalogAccessor(classLoader);
                    catalogAccessorMap.put(classLoader, catalogAccessor);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JaxWSCatalogAccessor found in map for classloader: " + classLoader);
                }
                wsdlLocation = catalogAccessor.resolveLocation(wsdlLocation);
            }
            InputStream is = null;
            LoadStrategy ls = moduleFile.getLoadStrategy();
            if (Axis2Utils.isAbsolutePath(wsdlLocation)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for absolute WSDL location " + wsdlLocation);
                }
                try {
                    is = ls.getResourceInputStream(wsdlLocation);
                    if (is == null) {
                        throw new Exception();
                    }
                }
                catch (Throwable t) {
                    try {
                        URL url = new URL(wsdlLocation);
                        is = url.openStream();
                        if (is == null) {
                            throw new Exception();
                        }
                    }
                    catch (Throwable t2) {
                        try {
                            URL url;
                            java.io.File file = new java.io.File(wsdlLocation);
                            if (file != null && (url = file.toURL()) != null) {
                                is = url.openStream();
                            }
                        }
                        catch (Throwable t3) {}
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for relative WSDL location " + wsdlLocation + " in module: " + moduleFile.getName());
                }
                try {
                    is = classLoader.getResourceAsStream(wsdlLocation);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (is != null) {
                wsdlLoc = new ModuleWSDLLocator(wsdlLocation, is, ls, catalogAccessor);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWsdlLocator");
                }
                return wsdlLoc;
            }
            if (is == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using load strategy to find WSDL relative to module");
                }
                try {
                    is = ls.getInputStream(wsdlLocation);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (is != null) {
                    wsdlLoc = new ModuleWSDLLocator(wsdlLocation, is, ls, catalogAccessor);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getWsdlLocator");
                    }
                    return wsdlLoc;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWsdlLocator");
        }
        return null;
    }

    public static WSDLReader getWSDLReader() throws Exception {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleBindingServiceRefs(ModuleFile moduleFile, List ddServiceRefs, String xmiFileName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleBindingServiceRefs, module= " + moduleFile.getName());
        }
        boolean bindingsFileUpdated = false;
        ClientBinding binding = null;
        try {
            binding = WSAmmUtils.getClientBinding(moduleFile, xmiFileName);
            if (binding != null && ddServiceRefs != null && !ddServiceRefs.isEmpty()) {
                for (org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef : ddServiceRefs) {
                    EList serviceRefs = binding.getServiceRefs();
                    ServiceRef bindingRef = InjectionHelper.getBindingEntry(serviceRef.getServiceRefName(), null, binding);
                    if (bindingRef == null) {
                        bindingsFileUpdated = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client binding entry not found for service ref: " + serviceRef.getServiceRefName() + "... generating entry");
                        }
                        bindingRef = WscbndFactory.eINSTANCE.createServiceRef();
                        bindingRef.setServiceRefLink(serviceRef.getServiceRefName());
                        WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                        serviceRefs.add(bindingRef);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Client binding entry found for service ref: " + serviceRef.getServiceRefName() + "... no generation required");
                    }
                    if (!bindingsFileUpdated) {
                        bindingsFileUpdated = WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                        continue;
                    }
                    WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleBindingServiceRefs, module= " + moduleFile.getName() + ", updatesNeeded= " + String.valueOf(bindingsFileUpdated));
            }
        }
        return bindingsFileUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleBindingComponentServiceRefs(ModuleFile moduleFile, Iterator ejbIter) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleBindingComponentServiceRefs, module= " + moduleFile.getName());
        }
        boolean bindingsFileUpdated = false;
        try {
            ClientBinding binding = null;
            boolean bindingLoaded = false;
            while (ejbIter.hasNext()) {
                EnterpriseBean eb = (EnterpriseBean)ejbIter.next();
                List<org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef> ddServiceRefs = WebServiceUtils.getJAXWSServiceRefs(eb.getServiceRefs(), moduleFile.getArchiveClassLoader());
                if (ddServiceRefs == null || ddServiceRefs.isEmpty()) continue;
                String componentName = eb.getName();
                if (!bindingLoaded) {
                    bindingLoaded = true;
                    binding = WSAmmUtils.getClientBinding(moduleFile, "META-INF/ibm-webservicesclient-bnd.xmi");
                }
                if (binding == null || ddServiceRefs == null || ddServiceRefs.isEmpty()) continue;
                for (org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef : ddServiceRefs) {
                    ServiceRef bindingRef = InjectionHelper.getBindingEntry(serviceRef.getServiceRefName(), componentName, binding);
                    if (bindingRef == null) {
                        bindingsFileUpdated = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Client binding entry not found for service ref: " + serviceRef.getServiceRefName() + "... generating entry");
                        }
                        bindingRef = WscbndFactory.eINSTANCE.createServiceRef();
                        bindingRef.setServiceRefLink(serviceRef.getServiceRefName());
                        ComponentScopedRefs csRefs = InjectionHelper.getComponentScopedRefs(binding, componentName);
                        if (csRefs == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "A componentScopedRefs with the " + componentName + " component name was not found in the client binding..." + " creating one now");
                            }
                            csRefs = WscbndFactory.eINSTANCE.createComponentScopedRefs();
                            csRefs.setComponentNameLink(componentName);
                            csRefs.getServiceRefs().add(bindingRef);
                            binding.getComponentScopedRefs().add(csRefs);
                            WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                            continue;
                        }
                        csRefs.getServiceRefs().add(bindingRef);
                        if (!bindingsFileUpdated) {
                            bindingsFileUpdated = WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                            continue;
                        }
                        WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A serviceRefs with the name " + bindingRef.getServiceRefLink() + " was found in the " + componentName + " componentScopedRefs element");
                    }
                    if (!bindingsFileUpdated) {
                        bindingsFileUpdated = WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                        continue;
                    }
                    WSAmmUtils.buildPortQNameBindings(serviceRef, bindingRef, moduleFile);
                }
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleBindingComponentServiceRefs, module= " + moduleFile.getName() + ", updatesNeeded= " + String.valueOf(bindingsFileUpdated));
            }
        }
        return bindingsFileUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientBinding getClientBinding(ModuleFile moduleFile, String xmiFileName) throws Exception {
        String prefix;
        String filePath;
        String pathToBundle;
        java.io.File bundle;
        ClientBinding binding = null;
        if (moduleFile.getLoadStrategy().contains(xmiFileName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The module " + moduleFile.getName() + " contains the file " + xmiFileName);
            }
            binding = WSModels.getWSClientBinding(moduleFile.getLoadStrategy(), xmiFileName);
            return binding;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client binding file not found, it will be added from the com.ibm.wsfp.main.jar");
        }
        if (!WebServiceUtils.fileExists(bundle = new java.io.File(pathToBundle = Constants.WAS_HOME_LOC + java.io.File.separator + "plugins" + java.io.File.separator + "com.ibm.wsfp.main" + ".jar"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Client binding file will not be added because the com.ibm.wsfp.main.jar could not be located.");
            }
            return null;
        }
        if (moduleFile.isWARFile()) {
            filePath = "WEB-INF/ibm-webservicesclient-bnd.xmi";
            prefix = "WEB-INF";
        } else {
            filePath = "META-INF/ibm-webservicesclient-bnd.xmi";
            prefix = "META-INF";
        }
        try {
            File fileToAdd = WSAmmUtils.getFileToAdd(bundle, filePath, prefix);
            if (fileToAdd != null) {
                if (moduleFile.isEJBJarFile()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Dynamically adding client binding to EJB module: " + moduleFile.getName());
                    }
                    moduleFile.addCopy(fileToAdd);
                    WSAmmUtils.markResource(moduleFile, filePath);
                } else if (moduleFile.isWARFile()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Dynamically adding client binding to WAR module: " + moduleFile.getName());
                    }
                    moduleFile.addCopy(fileToAdd);
                    WSAmmUtils.markResource(moduleFile, filePath);
                } else if (moduleFile.isArchive()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Dynamically adding client binding to archive module: " + moduleFile.getName());
                    }
                    moduleFile.addCopy(fileToAdd);
                    WSAmmUtils.markResource(moduleFile, filePath);
                }
                ClientBinding clientBinding = binding = WSModels.getWSClientBinding(moduleFile.getLoadStrategy(), xmiFileName);
                return clientBinding;
            }
        }
        finally {
            WSAmmUtils.deleteTempFiles(prefix, filePath);
        }
        return binding;
    }

    static void deleteTempFiles(String parentDir, String filePath) {
        java.io.File deleteDir;
        java.io.File deleteFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteTempFiles");
        }
        if (WebServiceUtils.fileIsFile(deleteFile = new java.io.File(TMP_DIR_PATH + java.io.File.separator + parentDir + java.io.File.separator + "ibm-webservicesclient-bnd.xmi"))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting web services client binding temporary file: " + deleteFile.getAbsolutePath());
            }
            WebServiceUtils.deleteFile(deleteFile);
        }
        if (WebServiceUtils.fileIsDirectory(deleteDir = new java.io.File(TMP_DIR_PATH + java.io.File.separator + parentDir))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting web services client binding temporary directory: " + deleteDir.getAbsolutePath());
            }
            WebServiceUtils.deleteFile(deleteDir);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteTempFiles");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getFileToAdd(java.io.File file, String filePath, String prefix) throws IOException {
        File fileToAdd;
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getFileToAdd");
            }
            fileToAdd = null;
            JarFile mainBundle = null;
            java.io.File tmpDir = null;
            java.io.File tmpFile = null;
            try {
                java.io.File systemTmpDir;
                ReadOnlyDirectory wtpContainerFile;
                mainBundle = new JarFile(file);
                ZipEntry entry = mainBundle.getEntry(filePath);
                tmpFile = null;
                if (entry == null) break block28;
                InputStream is = mainBundle.getInputStream(entry);
                BufferedReader reader = null;
                BufferedWriter writer = null;
                try {
                    if (is != null) {
                        tmpDir = new java.io.File(TMP_DIR_PATH + java.io.File.separator + prefix);
                        if (!WebServiceUtils.fileIsDirectory(tmpDir)) {
                            WebServiceUtils.fileMkDirs(tmpDir);
                        }
                        if (!WebServiceUtils.fileIsFile(tmpFile = new java.io.File(tmpDir.getAbsolutePath() + java.io.File.separator + "ibm-webservicesclient-bnd.xmi"))) {
                            WebServiceUtils.createFile(tmpFile);
                        }
                        if (WebServiceUtils.fileIsFile(tmpFile)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Temporary web services client binding file created: " + tmpFile.getAbsolutePath());
                            }
                            reader = new BufferedReader(new InputStreamReader(is));
                            String contents = "";
                            String line = reader.readLine();
                            while (line != null) {
                                contents = contents + line;
                                line = reader.readLine();
                            }
                            writer = new BufferedWriter(new FileWriter(tmpFile));
                            writer.write(contents);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not add web services client binding file because temporary file was not created");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "InputStream not found for web services client binding file");
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                if (tmpFile != null && tmpFile.exists() && (wtpContainerFile = CommonarchiveFactory.eINSTANCE.openReadOnlyDirectory((systemTmpDir = new java.io.File(TMP_DIR_PATH)).getAbsolutePath())) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking in tmp dir: " + systemTmpDir.getAbsolutePath() + " for web services client binding file: " + filePath);
                    }
                    fileToAdd = wtpContainerFile.getFileInSelfOrSubdirectory(filePath);
                }
            }
            catch (Throwable t) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Web services client binding file cannot be copied to application due to the following error: " + t.toString());
                }
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.annotations.amm.client.WSAmmUtils", "1080", WSAmmUtils.class);
            }
            finally {
                if (mainBundle != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Closing JAR file: " + mainBundle.getName());
                    }
                    mainBundle.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFileToAdd, file= " + fileToAdd);
        }
        return fileToAdd;
    }

    static void markResource(ModuleFile moduleFile, String uri) throws FileNotFoundException {
        Resource res = moduleFile.getMofResource(uri);
        if (res != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Marking client binding resource as modified for URI: " + uri);
            }
            res.setModified(true);
        }
    }

    public static boolean buildPortQNameBindings(org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef serviceRef, ServiceRef bindingRef, ModuleFile moduleFile) throws Exception {
        boolean bindingsFileUpdated;
        block15: {
            bindingsFileUpdated = false;
            if (serviceRef.getServiceQname() == null || serviceRef.getWsdlFile() == null || "".equals(serviceRef.getWsdlFile())) break block15;
            javax.xml.namespace.QName serviceQName = new javax.xml.namespace.QName(serviceRef.getServiceQname().getNamespaceURI(), serviceRef.getServiceQname().getLocalPart());
            String wsdlLocation = serviceRef.getWsdlFile();
            WebServiceClientType wscType = WSDescriptionUtils.getWebServiceClientType(serviceRef, moduleFile.getArchiveClassLoader());
            boolean resolveWSDL = false;
            if (wscType == null || wscType.equals((Object)WebServiceClientType.JAXWS)) {
                resolveWSDL = true;
            }
            WSDLLocator locator = WSAmmUtils.getWsdlLocator(wsdlLocation, moduleFile, resolveWSDL);
            boolean errorOnRead = false;
            Iterator portIter = null;
            if (locator != null) {
                try {
                    portIter = WSAmmUtils.getPortsFromWSDL(locator, serviceQName);
                }
                catch (Throwable t) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSDL could not be processed for client with service QName: " + serviceQName + "... attempting to build port list without WSDL");
                    }
                    errorOnRead = true;
                }
            }
            if (locator == null || errorOnRead) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Port binding information will be built without WSDL");
                }
                portIter = WSAmmUtils.getPortsFromWSDesc(moduleFile, serviceQName);
            }
            if (portIter != null) {
                while (portIter.hasNext()) {
                    javax.xml.namespace.QName portQName = (javax.xml.namespace.QName)portIter.next();
                    PortQnameBinding portRefBinding = InjectionHelper.getPortBinding(portQName, bindingRef);
                    if (portRefBinding == null) {
                        bindingsFileUpdated = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Port binding entry not found for port: " + portQName);
                        }
                        portRefBinding = WscbndFactory.eINSTANCE.createPortQnameBinding();
                        portRefBinding.setPortQnameLocalNameLink(portQName.getLocalPart());
                        portRefBinding.setPortQnameNamespaceLink(portQName.getNamespaceURI());
                        bindingRef.getPortQnameBindings().add(portRefBinding);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Port binding entry already found for port: " + portQName);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ports under service: " + serviceQName);
            }
        }
        return bindingsFileUpdated;
    }

    static Iterator getPortsFromWSDL(WSDLLocator wsdlLocator, javax.xml.namespace.QName serviceQName) throws Exception {
        LinkedList<javax.xml.namespace.QName> portQNameList = new LinkedList<javax.xml.namespace.QName>();
        WSDLReader reader = WSAmmUtils.getWSDLReader();
        Definition definition = reader.readWSDL(wsdlLocator);
        if (definition != null && definition.getService(serviceQName) != null) {
            javax.wsdl.Service service;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing ports in WSDL file for service: " + serviceQName);
            }
            if ((service = definition.getService(serviceQName)).getPorts() != null && !service.getPorts().isEmpty()) {
                for (Port wsdlPort : service.getPorts().values()) {
                    javax.xml.namespace.QName pQName = new javax.xml.namespace.QName(serviceQName.getNamespaceURI(), wsdlPort.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding port QName from WSDL: " + pQName);
                    }
                    portQNameList.add(pQName);
                }
            }
        }
        return portQNameList.iterator();
    }

    static Iterator getPortsFromWSDesc(ModuleFile moduleFile, javax.xml.namespace.QName serviceQName) {
        LinkedList<javax.xml.namespace.QName> portQNameList = new LinkedList<javax.xml.namespace.QName>();
        WSModuleDescriptor wsModDesc = WSDescriptionBuilderFactory.getBuilder().getModuleDescriptor(moduleFile);
        Iterator refsIter = wsModDesc.getServiceRefs();
        if (refsIter != null) {
            while (refsIter.hasNext()) {
                Iterator endpointIter;
                WSClientServiceDescriptor wsClientSvc = (WSClientServiceDescriptor)refsIter.next();
                if (!WSClientType.JAX_WS.equals((Object)wsClientSvc.getClientType()) || !serviceQName.equals(wsClientSvc.getQName())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found JAX-WS client with service QName: " + serviceQName);
                }
                if ((endpointIter = wsClientSvc.getEndpoints()) == null) continue;
                while (endpointIter.hasNext()) {
                    WSClientEndpointDescriptor wsClientEndpoint = (WSClientEndpointDescriptor)endpointIter.next();
                    javax.xml.namespace.QName pQName = new javax.xml.namespace.QName(serviceQName.getNamespaceURI(), wsClientEndpoint.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding port QName from DescriptionBuilder hierarchy: " + pQName);
                    }
                    portQNameList.add(pQName);
                }
            }
        }
        return portQNameList.iterator();
    }
}

