/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.amm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.ws.websvcs.annotations.amm.client.WSAmmUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.amm.merge.AbstractMergeAction;
import com.ibm.wsspi.amm.merge.MergeException;
import com.ibm.wsspi.amm.scan.AnnotationScanner;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.FieldAnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.AnnotationValue;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.FieldInfo;
import com.ibm.wsspi.amm.scan.util.info.Info;
import com.ibm.wsspi.amm.scan.util.info.MethodInfo;
import com.ibm.wsspi.amm.validate.AnnotationValidator;
import com.ibm.wsspi.amm.validate.AnnotationValidatorManager;
import com.ibm.wsspi.amm.validate.ValidationException;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jws.HandlerChain;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsclient.HandlerChains;
import org.eclipse.jst.j2ee.webservice.wsclient.PortComponentRef;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientPackage;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMergeAction
extends AbstractMergeAction {
    private static TraceComponent tc = Tr.register(ResourceMergeAction.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static Map<String, ClientBinding> createdBindings = new HashMap<String, ClientBinding>();

    public Class<? extends EObject>[] getApplicableTypes() {
        return new Class[]{WebApp.class, EJBJar.class, ApplicationClient.class};
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return Resource.class;
    }

    public boolean isClassTargetsSupported() {
        return true;
    }

    public boolean isFieldTargetsSupported() {
        return true;
    }

    public boolean isMethodTargetsSupported() {
        return true;
    }

    public boolean requiresValidation() {
        return false;
    }

    public void merge(MergeData mergeData, AnnotationScanner context) throws MergeException, ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge, module= " + mergeData.getModuleFile().getName() + ", dd= " + mergeData.getDeploymentDescriptor().getClass().getName());
        }
        AnnotationValidator resourceValidator = AnnotationValidatorManager.getInstance().getAnnotationValidator(Resource.class);
        AnnotationValidator wsrValidator = AnnotationValidatorManager.getInstance().getAnnotationValidator(WebServiceRef.class);
        this.doClassLevelMerge(mergeData, context, Resource.class, resourceValidator);
        this.doClassLevelMerge(mergeData, context, WebServiceRef.class, wsrValidator);
        this.doMethodLevelMerge(mergeData, context, Resource.class, resourceValidator);
        this.doMethodLevelMerge(mergeData, context, WebServiceRef.class, wsrValidator);
        this.doFieldLevelMerge(mergeData, context, Resource.class, resourceValidator);
        this.doFieldLevelMerge(mergeData, context, WebServiceRef.class, wsrValidator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge, module= " + mergeData.getModuleFile().getName() + ", dd= " + mergeData.getDeploymentDescriptor().getClass().getName());
        }
    }

    public void doClassLevelMerge(MergeData mergeData, AnnotationScanner context, Class<? extends Annotation> annotationClass, AnnotationValidator validator) throws MergeException, ValidationException {
        Map catMap = context.getClassAnnotationTargets(annotationClass);
        if (catMap != null && !catMap.isEmpty()) {
            for (ClassAnnotationTarget cat : catMap.values()) {
                if (!WSAmmUtils.isServiceResource((AnnotationTarget)cat, cat.getApplicableClass().getAnnotation(annotationClass), (Info)cat.getApplicableClass())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found @Resource annotation on the " + cat.getApplicableClass().getName() + " class indicating a service-ref type.");
                }
                if (validator != null) {
                    validator.validate(mergeData, (AnnotationTarget)cat);
                }
                this.mergeClassTarget(mergeData, context, cat);
            }
        }
    }

    public void doMethodLevelMerge(MergeData mergeData, AnnotationScanner context, Class<? extends Annotation> annotationClass, AnnotationValidator validator) throws MergeException, ValidationException {
        Map matMap = context.getMethodAnnotationTargets(annotationClass);
        if (matMap != null && !matMap.isEmpty()) {
            for (List matList : matMap.values()) {
                for (MethodAnnotationTarget mat : matList) {
                    if (!WSAmmUtils.isServiceResource((AnnotationTarget)mat, mat.getApplicableMethod().getAnnotation(annotationClass), (Info)mat.getApplicableMethod())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found @Resource annotation on the " + mat.getApplicableMethod().getName() + " method on the " + mat.getApplicableClass().getName() + " class indicating a service-ref type.");
                    }
                    if (validator != null) {
                        validator.validate(mergeData, (AnnotationTarget)mat);
                    }
                    this.mergeMethodTarget(mergeData, context, mat);
                }
            }
        }
    }

    public void doFieldLevelMerge(MergeData mergeData, AnnotationScanner context, Class<? extends Annotation> annotationClass, AnnotationValidator validator) throws MergeException, ValidationException {
        Map fatMap = context.getFieldAnnotationTargets(annotationClass);
        if (fatMap != null && !fatMap.isEmpty()) {
            for (List fatList : fatMap.values()) {
                for (FieldAnnotationTarget fat : fatList) {
                    if (!WSAmmUtils.isServiceResource((AnnotationTarget)fat, fat.getApplicableField().getAnnotation(annotationClass), (Info)fat.getApplicableField())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found @Resource annotation on the " + fat.getApplicableField().getName() + " field on the " + fat.getApplicableClass().getName() + " class indicating a service-ref type.");
                    }
                    if (validator != null) {
                        validator.validate(mergeData, (AnnotationTarget)fat);
                    }
                    this.mergeFieldTarget(mergeData, context, fat);
                }
            }
        }
    }

    public void mergeClassTarget(MergeData mergeData, AnnotationScanner context, ClassAnnotationTarget cat) throws MergeException, ValidationException {
        this.mergeClassTarget(mergeData, context, cat, null, cat.getAnnotationClass());
    }

    void mergeClassTarget(MergeData mergeData, AnnotationScanner context, ClassAnnotationTarget cat, AnnotationInfo annotationInfo, Class<? extends Annotation> annotationClass) throws MergeException, ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeClassTarget, class= " + cat.getApplicableClass().getName() + ", annotationType= " + annotationClass.getName());
        }
        try {
            EObject eObject = mergeData.getDeploymentDescriptor();
            ClassInfo classInfo = cat.getApplicableClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found " + annotationClass.getName() + " annotation " + "in class: " + classInfo.getName());
            }
            if (annotationInfo == null) {
                annotationInfo = cat.getApplicableClass().getAnnotation(annotationClass);
            }
            if (WSAmmUtils.isJAXWSServiceResource((AnnotationTarget)cat, annotationInfo, (Info)classInfo)) {
                this.mergeServiceRef(eObject, annotationInfo, (Info)cat.getApplicableClass(), mergeData, context);
                this.doDebug(eObject, (Info)cat.getApplicableClass());
            }
        }
        catch (MergeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeFail00", new Object[]{cat.getApplicableClass().getName(), e}, "Annotation metadata for the @Resource or @WebServiceRef annotation in the {0} class could not be merged due to the following error: {1}");
            throw new MergeException(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeClassTarget, class= " + cat.getApplicableClass().getName() + ", annotationType= " + cat.getAnnotationClass().getName());
            }
        }
    }

    public void mergeFieldTarget(MergeData mergeData, AnnotationScanner context, FieldAnnotationTarget fat) throws MergeException, ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeFieldTarget, class= " + fat.getApplicableClass().getName() + ", field= " + fat.getApplicableField().getName() + " annotationType= " + fat.getAnnotationClass().getName());
        }
        try {
            EObject eObject = mergeData.getDeploymentDescriptor();
            AnnotationInfo annotationInfo = fat.getApplicableField().getAnnotation(fat.getAnnotationClass());
            if (WSAmmUtils.isJAXWSServiceResource((AnnotationTarget)fat, annotationInfo, (Info)fat.getApplicableField())) {
                this.mergeServiceRef(eObject, annotationInfo, (Info)fat.getApplicableField(), mergeData, context);
                this.doDebug(eObject, (Info)fat.getApplicableField());
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The " + fat.getAnnotationClass().getName() + " annotation class on the " + fat.getApplicableField().getName() + " field in the " + fat.getApplicableClass().getName() + " class indicates a JAX-RPC service ref");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doFieldLevelMerge");
            }
        }
        catch (MergeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeFail01", new Object[]{fat.getApplicableField().getName(), fat.getApplicableClass().getName(), e}, "Annotation metadata for the @Resource or @WebServiceRef annotation on the {0} member in the {1} class could not be merged due to the following error: {2}");
            throw new MergeException(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeFieldTarget, class= " + fat.getApplicableClass().getName() + ", field= " + fat.getApplicableField().getName() + " annotationType= " + fat.getAnnotationClass().getName());
            }
        }
    }

    public void mergeMethodTarget(MergeData mergeData, AnnotationScanner context, MethodAnnotationTarget mat) throws MergeException, ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeMethodTarget, class= " + mat.getApplicableClass().getName() + ", method= " + mat.getApplicableMethod().getName() + " annotationType= " + mat.getAnnotationClass().getName());
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doMethodLevelMerge");
            }
            EObject eObject = mergeData.getDeploymentDescriptor();
            AnnotationInfo annotationInfo = mat.getApplicableMethod().getAnnotation(mat.getAnnotationClass());
            if (WSAmmUtils.isJAXWSServiceResource((AnnotationTarget)mat, annotationInfo, (Info)mat.getApplicableMethod())) {
                this.mergeServiceRef(eObject, annotationInfo, (Info)mat.getApplicableMethod(), mergeData, context);
                this.doDebug(eObject, (Info)mat.getApplicableMethod());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "doMethodLevelMerge");
            }
        }
        catch (MergeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeFail01", new Object[]{mat.getApplicableMethod().getName(), mat.getApplicableClass().getName(), e}, "Annotation metadata for the @Resource or @WebServiceRef annotation on the {0} member in the {1} class could not be merged due to the following error: {2}");
            throw new MergeException(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "mergeMethodTarget, class= " + mat.getApplicableClass().getName() + ", method= " + mat.getApplicableMethod().getName() + " annotationType= " + mat.getAnnotationClass().getName());
            }
        }
    }

    void mergeServiceRef(EObject eObject, AnnotationInfo annotationInfo, Info info, MergeData mergeData, AnnotationScanner context) throws MergeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeServiceRef");
        }
        ServiceRef serviceRef = null;
        EList serviceRefs = null;
        if (eObject instanceof WebApp) {
            String name;
            WebApp webApp = (WebApp)eObject;
            serviceRefs = webApp.getServiceRefs();
            serviceRef = this.getServiceRefByName(serviceRefs, name = this.getName(annotationInfo, info));
            if (serviceRef == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A service-ref with the name: " + name + " was not found " + "in a deployment descriptor. Annotation metadata will be used " + "to create a service-ref.");
                }
                serviceRef = Webservice_clientFactory.eINSTANCE.createServiceRef();
                serviceRef.setServiceRefName(name);
            }
            this.doMerge(annotationInfo, info, serviceRefs, serviceRef, mergeData, context);
        } else if (eObject instanceof EJBJar) {
            EJBJar ejbJar = (EJBJar)eObject;
            EnterpriseBean bean2 = null;
            String name = this.getName(annotationInfo, info);
            String componentName = this.findComponentName(info, ejbJar);
            bean2 = ejbJar.getEnterpriseBeanNamed(componentName);
            if (bean2 != null) {
                serviceRef = this.getServiceRefFromBean(bean2, name);
            }
            if (serviceRef == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A service-ref with the name: " + name + " was not found " + "in a deployment descriptor. Annotation metadata will be used " + "to create a service-ref.");
                }
                serviceRef = Webservice_clientFactory.eINSTANCE.createServiceRef();
                serviceRef.setServiceRefName(name);
            }
            if (bean2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting current list of service-refs from found EnterpriseBean");
                }
                if ((serviceRefs = bean2.getServiceRefs()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Merging service-ref information for EJB: " + bean2.getName());
                    }
                    this.doMerge(annotationInfo, info, serviceRefs, serviceRef, mergeData, context);
                }
            } else if (ejbJar.getEnterpriseBeans() != null && !ejbJar.getEnterpriseBeans().isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Existing EnterpriseBean with service-ref not found. This service-ref will be merged with the first EnterpiseBean in the EJB JAR.");
                }
                for (EnterpriseBean bean2 : ejbJar.getEnterpriseBeans()) {
                    serviceRefs = bean2.getServiceRefs();
                    if (serviceRefs == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Merging service-ref information for EJB: " + bean2.getName());
                    }
                    this.doMerge(annotationInfo, info, serviceRefs, serviceRef, mergeData, context);
                }
            }
        } else if (eObject instanceof ApplicationClient) {
            String name;
            ApplicationClient appClient = (ApplicationClient)eObject;
            serviceRefs = appClient.getServiceRefs();
            serviceRef = this.getServiceRefByName(serviceRefs, name = this.getName(annotationInfo, info));
            if (serviceRef == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "A service-ref with the name: " + name + " was not found " + "in a deployment descriptor. Annotation metadata will be used " + "to create a service-ref.");
                }
                serviceRef = Webservice_clientFactory.eINSTANCE.createServiceRef();
                serviceRef.setServiceRefName(name);
            }
            this.doMerge(annotationInfo, info, serviceRefs, serviceRef, mergeData, context);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeServiceRef");
        }
    }

    String findComponentName(Info info, EJBJar ejbJar) {
        String componentName = null;
        String className = null;
        if (info instanceof ClassInfo) {
            className = ((ClassInfo)info).getName();
        } else if (info instanceof MethodInfo) {
            className = ((MethodInfo)info).getDeclaringClass().getName();
        } else if (info instanceof FieldInfo) {
            className = ((FieldInfo)info).getDeclaringClass().getName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to determine correct component for class: " + className);
        }
        for (EnterpriseBean eb : ejbJar.getEnterpriseBeans()) {
            if (!eb.getEjbClassName().equals(className)) continue;
            componentName = eb.getName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The class: " + className + " is associated with the component: " + componentName);
        }
        return componentName;
    }

    void addServiceRef(ServiceRef serviceRef, EList serviceRefs) throws MergeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServiceRef");
        }
        if (serviceRefs.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding new service-ref with name: " + serviceRef.getServiceRefName());
            }
            serviceRefs.add(serviceRef);
        } else {
            for (int i = 0; i < serviceRefs.size(); ++i) {
                ServiceRef sr = (ServiceRef)serviceRefs.get(i);
                if (sr.getServiceRefName().equals(serviceRef.getServiceRefName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Merging service-ref with name: " + serviceRef.getServiceRefName());
                    }
                    serviceRefs.remove(i);
                    serviceRefs.add(i, serviceRef);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding new service-ref with name: " + serviceRef.getServiceRefName());
                }
                serviceRefs.add(serviceRef);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServiceRef");
        }
    }

    JavaClass createJavaClass(Class clazz) throws Exception {
        return this.createJavaClass(clazz, JavaRefFactory.eINSTANCE.createJavaClass());
    }

    JavaClass createJavaClass(String className) {
        return this.createJavaClass(className, JavaRefFactory.eINSTANCE.createJavaClass());
    }

    JavaClass createJavaClass(Class clazz, JavaClass javaClass) throws Exception {
        int mods = clazz.getModifiers();
        javaClass.setAbstract(Modifier.isAbstract(mods));
        javaClass.setFinal(Modifier.isFinal(mods));
        javaClass.setInstanceClass(clazz);
        javaClass.setInstanceClassName(clazz.getName());
        javaClass.setInterface(Modifier.isInterface(mods));
        javaClass.setName(clazz.getName());
        javaClass.setPublic(Modifier.isPublic(mods));
        if (clazz.getDeclaringClass() != null) {
            JavaClass declaringClass = JavaRefFactory.eINSTANCE.createJavaClass();
            this.createJavaClass(clazz.getDeclaringClass(), declaringClass);
            javaClass.setDeclaringClass(declaringClass);
        }
        if (clazz.getSuperclass() != null) {
            JavaClass superClass = JavaRefFactory.eINSTANCE.createJavaClass();
            this.createJavaClass(clazz.getSuperclass(), superClass);
            javaClass.setSupertype(superClass);
        }
        return javaClass;
    }

    JavaClass createJavaClass(String className, JavaClass javaClass) {
        javaClass.setName(className);
        return javaClass;
    }

    ServiceRef getServiceRefByName(List serviceRefs, String serviceRefName) {
        for (ServiceRef serviceRef : serviceRefs) {
            if (serviceRef.getServiceRefName() == null || !serviceRef.getServiceRefName().equals(serviceRefName)) continue;
            return serviceRef;
        }
        return null;
    }

    String getName(AnnotationInfo annotationInfo, Info info) throws MergeException {
        String name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getName");
        }
        if ((name = this.getStringAttributeValue(annotationInfo, "name")) == null || "".equals(name)) {
            if (info instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)info;
                name = WSAmmUtils.getJavaBeanPropertyName(methodInfo.getName());
                ClassInfo classInfo = methodInfo.getDeclaringClass();
                name = classInfo.getName() + "/" + name;
            } else {
                FieldInfo fieldInfo = (FieldInfo)info;
                ClassInfo classInfo = fieldInfo.getDeclaringClass();
                name = classInfo.getName() + "/" + fieldInfo.getName();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getName= " + name);
        }
        return name;
    }

    String getStringAttributeValue(AnnotationInfo annotationInfo, String attributeName) {
        return annotationInfo.getValue(attributeName) != null ? annotationInfo.getValue(attributeName).getStringValue() : null;
    }

    ServiceRef getServiceRefFromBean(EnterpriseBean bean, String name) {
        for (ServiceRef sr : bean.getServiceRefs()) {
            if (!sr.getServiceRefName().equals(name)) continue;
            return sr;
        }
        return null;
    }

    protected void doMerge(AnnotationInfo annotationInfo, Info info, EList serviceRefs, ServiceRef serviceRef, MergeData mergeData, AnnotationScanner context) throws MergeException {
        try {
            ClassInfo type = WSAmmUtils.getClassAttributeValue(annotationInfo, info, "type");
            if (!WSAmmUtils.isAssignableFrom(type, WSAmmUtils.JAX_WS_SVC_CLASS_NAME)) {
                ClassInfo value = WSAmmUtils.getClassAttributeValue(annotationInfo, info, "value");
                if (value != null) {
                    JavaClass javaClass;
                    if (serviceRef.getServiceInterface() == null) {
                        javaClass = this.createJavaClass(value.getName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting service-interface based on 'value' attribute: " + value.getName());
                        }
                        serviceRef.setServiceInterface(javaClass);
                    }
                    if (serviceRef.getServiceRefType() == null) {
                        javaClass = this.createJavaClass(type.getName());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting service-ref-type based on 'type' attribute: " + type.getName());
                        }
                        serviceRef.setServiceRefType(javaClass);
                    }
                }
            } else {
                JavaClass javaClass = null;
                if (serviceRef.getServiceRefType() == null) {
                    javaClass = this.createJavaClass(type.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting service-ref-type based on 'type' attribute: " + type.getName());
                    }
                    serviceRef.setServiceRefType(javaClass);
                }
                if (serviceRef.getServiceInterface() == null) {
                    Tr.debug(tc, "Setting service-interface based on 'type' attribute: " + type.getName());
                    if (javaClass == null) {
                        javaClass = this.createJavaClass(type.getName());
                    }
                    serviceRef.setServiceInterface(javaClass);
                }
            }
            ClassInfo classInfo = this.getServiceClassInfo(annotationInfo, context, type);
            if (classInfo == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ClassInfo not found for generated service class");
                }
            } else {
                this.doWSDLMerge(serviceRef, annotationInfo, mergeData, classInfo);
                this.doServiceQNameMerge(serviceRef, classInfo);
            }
            this.doHandlerChainMerge(serviceRef, info, mergeData.getModuleFile().getArchiveClassLoader());
            this.addServiceRef(serviceRef, serviceRefs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MergeException(e.getMessage());
        }
    }

    void doDebug(EObject eObject, Info info) {
        String level = info.getClass().getSimpleName();
        EList serviceRefs = null;
        if (eObject instanceof WebApp) {
            serviceRefs = ((WebApp)eObject).getServiceRefs();
        } else if (eObject instanceof ApplicationClient) {
            serviceRefs = ((ApplicationClient)eObject).getServiceRefs();
        } else if (eObject instanceof EJBJar) {
            EJBJar ejbJar = (EJBJar)eObject;
            for (EnterpriseBean bean : ejbJar.getEnterpriseBeans()) {
                if (serviceRefs == null) {
                    serviceRefs = bean.getServiceRefs();
                    continue;
                }
                serviceRefs.addAll(bean.getServiceRefs());
            }
        }
        Tr.debug(tc, "After service-ref merge for level: " + level + " number of " + "service-refs: " + (serviceRefs != null ? serviceRefs.size() : 0));
        if (serviceRefs != null && !serviceRefs.isEmpty()) {
            Iterator srIter = serviceRefs.iterator();
            while (srIter.hasNext()) {
                Tr.debug(tc, "Service-Ref: " + ((ServiceRef)srIter.next()).getServiceRefName());
            }
        }
    }

    ClassInfo getServiceClassInfo(AnnotationInfo annotationInfo, AnnotationScanner context, ClassInfo typeClassInfo) {
        ClassInfo classInfo = typeClassInfo;
        AnnotationValue value = annotationInfo.getValue("value");
        if (value != null && value.getClassValue() != null) {
            classInfo = value.getClassValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting ClassInfo for JAX-WS service class: " + classInfo.getName());
            }
        }
        return classInfo;
    }

    protected void doWSDLMerge(ServiceRef serviceRef, AnnotationInfo annotationInfo, MergeData mergeData, ClassInfo classInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doWSDLMerge, serviceRef= " + serviceRef.getServiceRefName() + ", wsdlFile= " + serviceRef.getWsdlFile());
        }
        if (serviceRef.getWsdlFile() == null || "".equals(serviceRef.getWsdlFile())) {
            String wsdlLocation = null;
            if (serviceRef.getPortComponentRefs() != null && !serviceRef.getPortComponentRefs().isEmpty()) {
                String pcLinkValue = null;
                String serviceSei = serviceRef.getServiceRefType().getQualifiedName();
                for (PortComponentRef pcRef : serviceRef.getPortComponentRefs()) {
                    if (pcRef.getServiceEndpointInterface() == null || !pcRef.getServiceEndpointInterface().getQualifiedName().equals(serviceSei)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found port-component-ref for sei: " + serviceSei);
                    }
                    pcLinkValue = pcRef.getPortComponentLink();
                    break;
                }
                if (pcLinkValue != null) {
                    ModuleFile moduleFile = mergeData.getModuleFile();
                    String xmlFileName = null;
                    if (moduleFile.isWARFile()) {
                        xmlFileName = "WEB-INF/webservices.xml";
                    } else if (moduleFile.isEJBJarFile()) {
                        xmlFileName = "META-INF/webservices.xml";
                    }
                    if (xmlFileName != null && moduleFile.getLoadStrategy().contains(xmlFileName)) {
                        WebServices webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), xmlFileName);
                        for (WebServiceDescription wsd : webServices.getWebServiceDescriptions()) {
                            for (PortComponent pc : wsd.getPortComponents()) {
                                if (!pc.getPortComponentName().equals(pcLinkValue)) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "For module: " + moduleFile.getName() + " a port component with the name: " + pcLinkValue + " was found in the webservices.xml.");
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting service-ref WSDL location to value in webservices.xml: " + wsd.getWsdlFile());
                                }
                                wsdlLocation = wsd.getWsdlFile();
                                break;
                            }
                            if (wsdlLocation == null) continue;
                            break;
                        }
                    }
                }
            }
            if (wsdlLocation == null || "".equals(wsdlLocation)) {
                AnnotationValue wsdlFile = annotationInfo.getValue("wsdlLocation");
                if (!WSAmmUtils.isEmpty(wsdlFile)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting service-ref WSDL location to value in @WebServiceRef.wsdlLocation: " + wsdlFile.getStringValue());
                    }
                    wsdlLocation = wsdlFile.getStringValue();
                } else if (classInfo != null) {
                    AnnotationInfo wscInfo;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking on generated service class: " + classInfo.getName() + " for service-ref wsdl location");
                    }
                    if ((wscInfo = classInfo.getAnnotation(WebServiceClient.class)) != null && wscInfo.getValue("wsdlLocation") != null) {
                        wsdlLocation = wscInfo.getValue("wsdlLocation").getStringValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting service-ref WSDL location to value in @WebServiceRef.wsdlLocation: " + wsdlLocation);
                        }
                    }
                }
            }
            serviceRef.setWsdlFile(wsdlLocation);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doWSDLMerge, serviceRef= " + serviceRef.getServiceRefName() + ", wsdlLocation= " + serviceRef.getWsdlFile());
        }
    }

    void doServiceQNameMerge(ServiceRef serviceRef, ClassInfo classInfo) {
        AnnotationInfo info;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doServiceQNameMerge, serviceQName= " + serviceRef.getServiceQname());
        }
        if (serviceRef.getServiceQname() == null && (info = classInfo.getAnnotation(WebServiceClient.class)) != null && info.getValue("name") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For service-ref with name: " + serviceRef.getServiceRefName() + " merging service QName from @WebServiceClient in the " + classInfo.getName() + " class");
            }
            AnnotationValue nameValue = info.getValue("name");
            AnnotationValue tnsValue = info.getValue("targetNamespace");
            QName qName = WSAmmUtils.createQName(tnsValue != null ? tnsValue.getStringValue() : null, nameValue.getStringValue());
            serviceRef.setServiceQname(qName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doServiceQNameMerge, serviceQName= " + serviceRef.getServiceQname());
        }
    }

    void doHandlerChainMerge(ServiceRef serviceRef, Info info, ClassLoader classLoader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doHandlerChainMerge, serviceRef= " + serviceRef.getServiceRefName() + ", handlerChain= " + serviceRef.getHandlerChains());
        }
        if (serviceRef.getHandlerChains() == null) {
            AnnotationInfo hcInfo = info.getAnnotation(HandlerChain.class);
            String className = null;
            if (info instanceof ClassInfo) {
                className = ((ClassInfo)info).getName();
            } else if (info instanceof MethodInfo) {
                className = ((MethodInfo)info).getDeclaringClass().getName();
            } else if (info instanceof FieldInfo) {
                className = ((FieldInfo)info).getDeclaringClass().getName();
            }
            if (hcInfo != null && hcInfo.getValue("file") != null) {
                String file;
                InputStream is;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found @HandlerChain annotation along with @Resource/WebServiceRef annotation for service-ref: " + serviceRef.getServiceRefName() + " in " + "the " + className + " class");
                }
                if ((is = DescriptionUtils.openHandlerConfigStream(file = hcInfo.getValue("file").getStringValue(), className, classLoader)) != null) {
                    HandlerChainsType hcsType = DescriptionUtils.loadHandlerChains(is, classLoader);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loaded " + file + " handler configuration file declared " + "by an @HandlerChain annotation in the " + className + " class.");
                    }
                    this.createHandlerChains(serviceRef, hcsType);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load " + file + " handler configuration file declared " + "by an @HandlerChain annotation in the " + className + " class.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doHandlerChainMerge, serviceRef= " + serviceRef.getServiceRefName() + ", handlerChain= " + serviceRef.getHandlerChains());
        }
    }

    void createHandlerChains(ServiceRef serviceRef, HandlerChainsType hcsType) {
        String uri = "webservice_client.xmi";
        Webservice_clientPackage wscPackage = (Webservice_clientPackage)EPackage.Registry.INSTANCE.getEPackage(uri);
        Webservice_clientFactory factory = wscPackage.getWebservice_clientFactory();
        HandlerChains hChains = factory.createHandlerChains();
        serviceRef.setHandlerChains(hChains);
        EList hChainList = hChains.getHandlerChains();
        List<HandlerChainType> hcTypeList = hcsType.getHandlerChain();
        if (hcTypeList != null) {
            for (HandlerChainType hcType : hcTypeList) {
                javax.xml.namespace.QName serviceQNamePattern;
                org.eclipse.jst.j2ee.webservice.wsclient.HandlerChain hChain = factory.createHandlerChain();
                hChainList.add(hChain);
                javax.xml.namespace.QName portQNamePattern = hcType.getPortNamePattern();
                if (portQNamePattern != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting service-ref handler-chain port QName pattern: " + portQNamePattern);
                    }
                    hChain.setPortNamePattern(WSAmmUtils.createQName(portQNamePattern.getNamespaceURI(), portQNamePattern.getLocalPart()));
                }
                if ((serviceQNamePattern = hcType.getServiceNamePattern()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting service-ref handler-chain service QName pattern: " + serviceQNamePattern);
                    }
                    hChain.setServiceNamePattern(WSAmmUtils.createQName(serviceQNamePattern.getNamespaceURI(), serviceQNamePattern.getLocalPart()));
                }
                List<HandlerType> hTypes = hcType.getHandler();
                EList handlers = hChain.getHandlers();
                if (hTypes == null) continue;
                for (HandlerType hType : hTypes) {
                    Handler handler = factory.createHandler();
                    String className = hType.getHandlerClass() != null ? hType.getHandlerClass().getValue() : null;
                    String name = hType.getHandlerName() != null ? hType.getHandlerName().getValue() : null;
                    handler.setHandlerName(name);
                    handler.setHandlerClass(this.createJavaClass(className));
                    handlers.add(handler);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added handler element to service-ref for the " + className + " class");
                }
            }
        }
    }
}

