/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import com.ibm.ws.webservices.utils.PortInfo;
import com.ibm.ws.webservices.utils.SaveInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;

public class WSDLParser {
    private String contextURI;
    private String wsdlURI;
    private Definition def;
    private Vector portInfos;
    private Vector imports;

    public WSDLParser(String contextURI, String wsdlURI) throws IOException {
        this.contextURI = contextURI;
        this.wsdlURI = wsdlURI;
        try {
            this.parse();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.utils.WSDLParser.WSDLParser", "69", this);
            throw new IOException(ex.toString() + JavaUtils.LS + JavaUtils.stackToString(ex));
        }
    }

    private void parse() throws WSDLException {
        WSDLFactoryImpl factory = new WSDLFactoryImpl();
        WSDLReader reader = factory.newWSDLReader();
        this.def = reader.readWSDL(null, this.contextURI + this.wsdlURI);
        this.portInfos = new Vector();
        this.imports = new Vector();
        this.gatherPortInfos(this.def, this.portInfos, this.imports);
    }

    public boolean portExists(String namespace, String portName) {
        PortInfo portInfo = this.findPort(namespace, portName);
        return portInfo != null;
    }

    public PortInfo[] findUndeployedPorts() {
        Vector<PortInfo> vect = new Vector<PortInfo>();
        Enumeration vEnum = this.portInfos.elements();
        while (vEnum.hasMoreElements()) {
            PortInfo info = (PortInfo)vEnum.nextElement();
            if (info.soapAddressChanged) continue;
            vect.add(info);
        }
        PortInfo[] ret = new PortInfo[vect.size()];
        int i = 0;
        Enumeration undeployedEnum = vect.elements();
        while (undeployedEnum.hasMoreElements()) {
            ret[i] = (PortInfo)undeployedEnum.nextElement();
            ++i;
        }
        return ret;
    }

    public boolean setSOAPAddress(String namespace, String portName, String addressURI) {
        PortInfo portInfo = this.findPort(namespace, portName);
        if (portInfo == null) {
            return false;
        }
        return this.setSOAPAddress(portInfo, addressURI);
    }

    private boolean setSOAPAddress(PortInfo portInfo, String addressURI) {
        Object[] extElements = portInfo.port.getExtensibilityElements().toArray();
        for (int i = 0; i < extElements.length; ++i) {
            if (!(extElements[i] instanceof SOAPAddress)) continue;
            SOAPAddress addr = (SOAPAddress)extElements[i];
            addr.setLocationURI(addressURI);
            portInfo.soapAddressChanged = true;
            return true;
        }
        return false;
    }

    public SaveInfo[] save(String directory, String fileName) throws WSDLException, IOException {
        Vector<SaveInfo> savedFiles = new Vector<SaveInfo>();
        WSDLFactoryImpl factory = new WSDLFactoryImpl();
        WSDLWriter writer = factory.newWSDLWriter();
        File dir = new File(directory);
        File outFile = new File(dir, fileName);
        String parent = outFile.getParent();
        File parentFile = null;
        if (parent != null) {
            parentFile = new File(parent);
            parentFile.mkdirs();
        }
        FileOutputStream sink = new FileOutputStream(outFile);
        savedFiles.add(new SaveInfo(fileName, outFile.getCanonicalPath()));
        writer.writeWSDL(this.def, sink);
        ((OutputStream)sink).close();
        Enumeration vEnum = this.imports.elements();
        while (vEnum.hasMoreElements()) {
            Import elem = (Import)vEnum.nextElement();
            Definition importDef = elem.getDefinition();
            String locationURI = elem.getLocationURI();
            if (locationURI.startsWith("http://") || locationURI.startsWith("https://") || locationURI.startsWith("file:")) continue;
            File outputOfImport = new File(parentFile, locationURI);
            String importParent = outputOfImport.getParent();
            if (importParent != null) {
                new File(importParent).mkdirs();
            }
            FileOutputStream importSink = new FileOutputStream(outputOfImport);
            savedFiles.add(new SaveInfo(locationURI, outputOfImport.getCanonicalPath()));
            if (importDef != null) {
                writer.writeWSDL(importDef, importSink);
            } else {
                int num;
                URL contextURL = this.contextURI != null ? new URL(this.contextURI) : new URL(this.wsdlURI);
                URL inputURL = new URL(contextURL, locationURI);
                InputStream inStrm = inputURL.openStream();
                byte[] buf = new byte[1024];
                while ((num = inStrm.read(buf)) != -1) {
                    ((OutputStream)importSink).write(buf, 0, num);
                }
            }
            ((OutputStream)importSink).close();
        }
        SaveInfo[] ret = new SaveInfo[savedFiles.size()];
        int i = 0;
        Enumeration vEnum2 = savedFiles.elements();
        while (vEnum2.hasMoreElements()) {
            ret[i] = (SaveInfo)vEnum2.nextElement();
            ++i;
        }
        return ret;
    }

    private PortInfo findPort(String namespace, String portName) {
        Enumeration vEnum = this.portInfos.elements();
        while (vEnum.hasMoreElements()) {
            PortInfo portInfo = (PortInfo)vEnum.nextElement();
            if (!portInfo.def.getTargetNamespace().equals(namespace) || !portInfo.port.getName().equals(portName)) continue;
            return portInfo;
        }
        return null;
    }

    private Import findImport(String importURI, Vector importVector) {
        Enumeration vEnum = importVector.elements();
        while (vEnum.hasMoreElements()) {
            Import element = (Import)vEnum.nextElement();
            if (!importURI.equals(element.getLocationURI())) continue;
            return element;
        }
        return null;
    }

    private void gatherPortInfos(Import element, Vector portVector, Vector importVector) {
        if (this.findImport(element.getLocationURI(), importVector) != null) {
            return;
        }
        importVector.add(element);
        Definition def = element.getDefinition();
        if (def != null) {
            this.gatherPortInfos(def, portVector, importVector);
        }
    }

    private void gatherPortInfos(Definition def, Vector portVector, Vector importVector) {
        Iterator defIterator = def.getServices().values().iterator();
        while (defIterator.hasNext()) {
            Service service = (Service)defIterator.next();
            Iterator portIterator = service.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port port = (Port)portIterator.next();
                portVector.add(new PortInfo(def, port));
            }
        }
        Map map = def.getImports();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator listIterator = list.iterator();
            while (listIterator.hasNext()) {
                Import element = (Import)listIterator.next();
                this.gatherPortInfos(element, portVector, importVector);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 3) {
                WSDLParser.usage();
            }
            String contextURI = args[0];
            String wsdlURI = args[1];
            String outDir = args[2];
            WSDLParser parser = new WSDLParser(contextURI, wsdlURI);
            Enumeration vEnum = parser.portInfos.elements();
            while (vEnum.hasMoreElements()) {
                PortInfo info = (PortInfo)vEnum.nextElement();
                parser.setSOAPAddress(info, "http://com.ibm.webservices.ri.deploy.WSDLParser/test");
            }
            SaveInfo[] saved = parser.save(outDir, wsdlURI);
            System.out.println(saved.length + " files saved");
            for (int i = 0; i < saved.length; ++i) {
                System.out.println(saved[i].fileURI + " saved at " + saved[i].fileName);
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.webservices.utils.WSDLParser.main", "331");
            ex.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("usage: java com.ibm.webservices.ri.deploy.WSDLParser contextURI wsdlURI outDirectory");
        System.exit(1);
    }

    public Vector getPortInfos() {
        return this.portInfos;
    }
}

