/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

public final class JavaUtils {
    private static HashMap loadableMap = new HashMap();

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static final boolean isTrueExplicitly(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes"));
    }

    public static final boolean isTrueExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object value) {
        return JavaUtils.isTrueExplicitly(value, false);
    }

    public static String getLoadableClassName(String text) {
        String loadClass;
        int bracket = text.indexOf("[");
        if (text == null || bracket < 0 || bracket == 0) {
            return text;
        }
        String className = text;
        if (bracket > 0) {
            className = className.substring(0, bracket);
        }
        if ((loadClass = (String)loadableMap.get(className)) == null) {
            loadClass = "L" + className + ";";
        }
        if (bracket > 0) {
            int i = text.indexOf("]");
            while (i > 0) {
                loadClass = "[" + loadClass;
                i = text.indexOf("]", i + 1);
            }
        }
        return loadClass;
    }

    public static final boolean isTrue(String value) {
        return !JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isTrue(Object value, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value, !defaultVal);
    }

    public static final boolean isTrue(Object value) {
        return JavaUtils.isTrue(value, false);
    }

    public static final boolean isFalseExplicitly(String value) {
        return value == null || value.equalsIgnoreCase("false") || value.equals("0") || value.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object value) {
        return JavaUtils.isFalseExplicitly(value, true);
    }

    public static final boolean isFalse(Object value, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value, defaultVal);
    }

    public static final boolean isFalse(Object value) {
        return JavaUtils.isFalse(value, true);
    }

    static {
        loadableMap.put("byte", "B");
        loadableMap.put("char", "C");
        loadableMap.put("double", "D");
        loadableMap.put("float", "F");
        loadableMap.put("int", "I");
        loadableMap.put("long", "J");
        loadableMap.put("short", "S");
        loadableMap.put("boolean", "Z");
    }
}

