/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.JavaUtils;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;

public final class ClassUtils {
    private static Hashtable classloaders = new Hashtable();
    private static HashMap loadClassMap = new HashMap();

    public static void setClassLoader(String className, ClassLoader loader) {
        if (className != null && loader != null) {
            classloaders.put(className, loader);
        }
    }

    public static ClassLoader getClassLoader(String className) {
        if (className == null) {
            return null;
        }
        return (ClassLoader)classloaders.get(className);
    }

    public static void removeClassLoader(String className) {
        classloaders.remove(className);
    }

    public static Class forName(String className) throws ClassNotFoundException {
        return ClassUtils.loadClass(className);
    }

    public static Class forName(final String className, final boolean init, final ClassLoader loader) throws ClassNotFoundException {
        try {
            Object ret = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String lclassName = JavaUtils.getLoadableClassName(className);
                        return Class.forName(lclassName, init, loader);
                    }
                    catch (Throwable e) {
                        FFDCFilter.processException(e, "com.ibm.ws.webservices.utils.ClassUtils.run", "161", this);
                        return e;
                    }
                }
            });
            if (ret instanceof Class) {
                return (Class)ret;
            }
            if (ret instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)ret;
            }
            throw new ClassNotFoundException(className);
        }
        catch (ClassNotFoundException cnfe) {
            FFDCFilter.processException(cnfe, "com.ibm.ws.webservices.utils.ClassUtils.forName", "175");
            return ClassUtils.loadClass(className);
        }
    }

    private static Class loadClass(final String className) throws ClassNotFoundException {
        Object ret = null;
        try {
            ret = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String lclassName = JavaUtils.getLoadableClassName(className);
                    ClassLoader classLoader = ClassUtils.getClassLoader(lclassName);
                    if (classLoader != null) {
                        try {
                            return Class.forName(lclassName, true, classLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            FFDCFilter.processException((Throwable)cnfe, "com.ibm.ws.webservices.utils.ClassUtils.run", "225", this);
                        }
                    }
                    try {
                        return Class.forName(lclassName, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException cnfe2) {
                        FFDCFilter.processException((Throwable)cnfe2, "com.ibm.ws.webservices.utils.ClassUtils.run", "236", this);
                        try {
                            return Class.forName(lclassName, true, ClassUtils.class.getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe3) {
                            FFDCFilter.processException((Throwable)cnfe3, "com.ibm.ws.webservices.utils.ClassUtils.run", "261", this);
                            return cnfe3;
                        }
                    }
                }
            });
        }
        catch (SecurityException se) {
            FFDCFilter.processException(se, "com.ibm.ws.webservices.utils.ClassUtils.loadClass", "271");
            throw new ClassNotFoundException(className);
        }
        if (ret instanceof Class) {
            return (Class)ret;
        }
        if (ret instanceof ClassNotFoundException) {
            Class cls = (Class)loadClassMap.get(className);
            if (cls != null) {
                return cls;
            }
            throw (ClassNotFoundException)ret;
        }
        throw new ClassNotFoundException(className);
    }

    public static InputStream getResourceAsStream(Class clazz, String resource) {
        InputStream myInputStream = null;
        myInputStream = clazz.getClassLoader() != null ? clazz.getClassLoader().getResourceAsStream(resource) : ClassLoader.getSystemClassLoader().getResourceAsStream(resource);
        if (myInputStream == null) {
            myInputStream = clazz.getResourceAsStream(resource);
        }
        return myInputStream;
    }

    public static URL getResource(Class clazz, String resource) {
        URL myResource = null;
        myResource = clazz.getClassLoader() != null ? clazz.getClassLoader().getResource(resource) : ClassLoader.getSystemClassLoader().getResource(resource);
        if (myResource == null) {
            myResource = clazz.getResource(resource);
        }
        return myResource;
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
    }
}

