/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.pmi.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.pmi.modules.PmiModuleUtils;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class EndpointPmiModule
extends StatisticActions {
    private static TraceComponent _tc = Tr.register(EndpointPmiModule.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    public static final String endpointTemplate = "/com/ibm/ws/webservices/pmi/modules/webServicesEndpointStats.xml";
    public static final String ENDPOINT_PMI_MODULE = "pmiWebServiceEndpoint";
    private StatsInstance endpointStatsInstance = null;
    private String moduleName = null;
    private String serviceName = null;
    private String endpointName = null;
    private SPICountStatistic numberReceived = null;
    private SPICountStatistic numberSuccessful = null;
    private SPICountStatistic numberFailed = null;
    private SPITimeStatistic responseTime = null;
    private SPITimeStatistic responseTimeMax = null;
    private SPITimeStatistic responseTimeLast = null;
    private SPIAverageStatistic requestSize = null;
    private SPIAverageStatistic requestSizeMax = null;
    private SPICountStatistic requestSizeLast = null;
    private SPIAverageStatistic responseSize = null;
    private SPIAverageStatistic responseSizeMax = null;
    private SPICountStatistic responseSizeLast = null;
    public static final int PMI_ID_NUMBER_RECEIVED = 30;
    public static final int PMI_ID_NUMBER_SUCCESSFUL = 31;
    public static final int PMI_ID_NUMBER_FAILED = 32;
    public static final int PMI_ID_AVERAGE_RESPONSE_TIME = 33;
    public static final int PMI_ID_RESPONSE_TIME_MAX = 34;
    public static final int PMI_ID_RESPONSE_TIME_LAST = 35;
    public static final int PMI_ID_REQUEST_SIZE = 36;
    public static final int PMI_ID_REQUEST_SIZE_MAX = 37;
    public static final int PMI_ID_REQUEST_SIZE_LAST = 38;
    public static final int PMI_ID_RESPONSE_SIZE = 39;
    public static final int PMI_ID_RESPONSE_SIZE_MAX = 40;
    public static final int PMI_ID_RESPONSE_SIZE_LAST = 41;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointPmiModule(String moduleName, String serviceName, String endpointName, StatsGroup endpointStatsGroup) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointPmiModule.EndpointPmiModule()...");
        }
        this.moduleName = moduleName;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        try {
            String string = endpointTemplate;
            synchronized (endpointTemplate) {
                this.endpointStatsInstance = StatsFactory.getStatsInstance(new String[]{"pmiWebServiceModule", moduleName, "pmiWebServiceService", serviceName, ENDPOINT_PMI_MODULE, endpointName});
                if (this.endpointStatsInstance == null) {
                    this.endpointStatsInstance = StatsFactory.createStatsInstance(endpointName, endpointStatsGroup, null, (StatisticActions)this);
                } else {
                    this.copyStatisticCreated();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (StatsFactoryException sfe) {
            Object[] inserts = new Object[]{moduleName, serviceName, endpointName, sfe};
            Tr.error(_tc, "createEndpointPmiModuleFail", inserts);
        }
        {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...EndpointPmiModule.EndpointPmiModule()");
            }
            return;
        }
    }

    public void statisticCreated(SPIStatistic data) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointPmiModule.statisticCreated()...");
        }
        switch (data.getId()) {
            case 30: {
                this.numberReceived = (SPICountStatistic)data;
                break;
            }
            case 31: {
                this.numberSuccessful = (SPICountStatistic)data;
                break;
            }
            case 32: {
                this.numberFailed = (SPICountStatistic)data;
                break;
            }
            case 33: {
                this.responseTime = (SPITimeStatistic)data;
                break;
            }
            case 34: {
                this.responseTimeMax = (SPITimeStatistic)data;
                break;
            }
            case 35: {
                this.responseTimeLast = (SPITimeStatistic)data;
                break;
            }
            case 36: {
                this.requestSize = (SPIAverageStatistic)data;
                break;
            }
            case 37: {
                this.requestSizeMax = (SPIAverageStatistic)data;
                break;
            }
            case 38: {
                this.requestSizeLast = (SPICountStatistic)data;
                break;
            }
            case 39: {
                this.responseSize = (SPIAverageStatistic)data;
                break;
            }
            case 40: {
                this.responseSizeMax = (SPIAverageStatistic)data;
                break;
            }
            case 41: {
                this.responseSizeLast = (SPICountStatistic)data;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EndpointPmiModule.statisticCreated()");
        }
    }

    private void copyStatisticCreated() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointPmiModule.copyStatisticCreated()...");
        }
        if (this.endpointStatsInstance != null) {
            this.numberReceived = (SPICountStatistic)this.endpointStatsInstance.getStatistic(30);
            this.numberSuccessful = (SPICountStatistic)this.endpointStatsInstance.getStatistic(31);
            this.numberFailed = (SPICountStatistic)this.endpointStatsInstance.getStatistic(32);
            this.responseTime = (SPITimeStatistic)this.endpointStatsInstance.getStatistic(33);
            this.responseTimeMax = (SPITimeStatistic)this.endpointStatsInstance.getStatistic(34);
            this.responseTimeLast = (SPITimeStatistic)this.endpointStatsInstance.getStatistic(35);
            this.requestSize = (SPIAverageStatistic)this.endpointStatsInstance.getStatistic(36);
            this.requestSizeMax = (SPIAverageStatistic)this.endpointStatsInstance.getStatistic(37);
            this.requestSizeLast = (SPICountStatistic)this.endpointStatsInstance.getStatistic(38);
            this.responseSize = (SPIAverageStatistic)this.endpointStatsInstance.getStatistic(39);
            this.responseSizeMax = (SPIAverageStatistic)this.endpointStatsInstance.getStatistic(40);
            this.responseSizeLast = (SPICountStatistic)this.endpointStatsInstance.getStatistic(41);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EndpointPmiModule.copyStatisticCreated()");
        }
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointPmiModule.destroy()...");
        }
        try {
            StatsFactory.removeStatsInstance(this.endpointStatsInstance);
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{this.moduleName, this.serviceName, this.endpointName, e};
            Tr.error(_tc, "removeEndpointPmiModuleFail", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EndpointPmiModule.destroy()");
        }
    }

    public void incReceived(long currTime) {
        PmiModuleUtils.increment(EndpointPmiModule.class.getName(), "incReceived-A", currTime, this.numberReceived);
    }

    public void incReceived(long currTime, boolean successful) {
        if (successful) {
            PmiModuleUtils.increment(EndpointPmiModule.class.getName(), "incReceived-B", currTime, this.numberSuccessful);
        } else {
            PmiModuleUtils.increment(EndpointPmiModule.class.getName(), "incReceived-B", currTime, this.numberFailed);
        }
    }

    public void addResponseTime(long currTime, long rspTime) {
        PmiModuleUtils.addTime(EndpointPmiModule.class.getName(), "addResponseTime", currTime, rspTime, this.responseTime);
        if (this.responseTimeMax != null && this.responseTimeMax.getMax() < rspTime) {
            this.responseTimeMax.reset();
            PmiModuleUtils.addTime(EndpointPmiModule.class.getName(), "responseTimeMax", currTime, rspTime, this.responseTimeMax);
        }
        if (this.responseTimeLast != null) {
            this.responseTimeLast.reset();
            this.responseTimeLast.add(currTime, rspTime);
        }
    }

    public void addRequestSize(long currTime, long size) {
        PmiModuleUtils.addAverage(EndpointPmiModule.class.getName(), "addRequestSize", currTime, size, this.requestSize);
        if (this.requestSizeMax != null && this.requestSizeMax.getMax() < size) {
            this.requestSizeMax.reset();
            PmiModuleUtils.addAverage(EndpointPmiModule.class.getName(), "requestSizeMax", currTime, size, this.requestSizeMax);
        }
        if (this.requestSizeLast != null) {
            this.requestSizeLast.setLastSampleTime(currTime);
            this.requestSizeLast.setCount(size);
        }
    }

    public void addResponseSize(long currTime, long size) {
        PmiModuleUtils.addAverage(EndpointPmiModule.class.getName(), "addResponseSize", currTime, size, this.responseSize);
        if (this.responseSizeMax != null && this.responseSizeMax.getMax() < size) {
            this.responseSizeMax.reset();
            PmiModuleUtils.addAverage(EndpointPmiModule.class.getName(), "responseSizeMax", currTime, size, this.responseSizeMax);
        }
        if (this.responseSizeLast != null) {
            this.responseSizeLast.setLastSampleTime(currTime);
            this.responseSizeLast.setCount(size);
        }
    }
}

