/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.authorizer.AdminAuthorizer;
import com.ibm.websphere.management.authorizer.AdminAuthorizerFactory;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.resources.NLSProvider;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;

public class EndpointManagerMBeanImpl
extends J2EEManagedObjectCollaborator
implements EndpointManagerMBean {
    private static final TraceComponent _tc = Tr.register(EndpointManagerMBeanImpl.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private static final String START_OP = "START_OPERATION";
    private static final String STOP_OP = "STOP_OPERATION";
    private static final String OTHER_OP = "OTHER_OPERATION";
    private Map urlPatternMap = new HashMap();
    private Map servicePortNameMap = new HashMap();
    private Map portComponentNameMap = new HashMap();
    private static long seqNum = 0L;
    private String contextRoot = null;

    public void initializeEndpoint(Endpoint endpoint) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initializeEndpoint", endpoint);
        }
        if (endpoint != null) {
            endpoint.setState(0);
            String urlPattern = endpoint.getUrlPattern();
            String serviceName = endpoint.getServiceName();
            String portName = endpoint.getPortName();
            String portComponentName = endpoint.getPortComponentName();
            String servicePort = serviceName + "#" + portName;
            Endpoint existingEndpt = null;
            existingEndpt = (Endpoint)this.portComponentNameMap.get(portComponentName);
            if (existingEndpt == null && (existingEndpt = (Endpoint)this.urlPatternMap.get(urlPattern)) != null && existingEndpt.getPortComponentName() != null && !existingEndpt.getPortComponentName().equals(portComponentName)) {
                existingEndpt = null;
            }
            if (existingEndpt == null) {
                existingEndpt = (Endpoint)this.servicePortNameMap.get(servicePort);
            }
            if (existingEndpt != null) {
                String existingSvcPort;
                Endpoint tmpEndpoint;
                Endpoint tmpEndpoint2;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Existing Endpt obj found, only updating.");
                }
                if (existingEndpt.getPortComponentName() != null) {
                    if (_tc.isEntryEnabled()) {
                        Tr.debug(_tc, "Removing existing port component name mapping: " + existingEndpt.getPortComponentName());
                    }
                    this.portComponentNameMap.remove(existingEndpt.getPortComponentName());
                }
                if (existingEndpt.getUrlPattern() != null && (tmpEndpoint2 = (Endpoint)this.urlPatternMap.get(existingEndpt.getUrlPattern())) != null && tmpEndpoint2.getPortComponentName() != null && tmpEndpoint2.getPortComponentName().equals(existingEndpt.getPortComponentName())) {
                    if (_tc.isEntryEnabled()) {
                        Tr.debug(_tc, "Removing existing url pattern mapping: " + existingEndpt.getUrlPattern());
                    }
                    this.urlPatternMap.remove(existingEndpt.getUrlPattern());
                }
                if (existingEndpt.getServiceName() != null && existingEndpt.getPortName() != null && (tmpEndpoint = (Endpoint)this.servicePortNameMap.get(existingSvcPort = existingEndpt.getServiceName() + "#" + existingEndpt.getPortName())) != null && tmpEndpoint.getPortComponentName() != null && tmpEndpoint.getPortComponentName().equals(existingEndpt.getPortComponentName())) {
                    if (_tc.isEntryEnabled()) {
                        Tr.debug(_tc, "Removing existing service/port name mapping: " + existingSvcPort);
                    }
                    this.servicePortNameMap.remove(existingSvcPort);
                }
                existingEndpt.updateValues(endpoint);
                endpoint = existingEndpt;
            }
            if (urlPattern != null) {
                this.urlPatternMap.put(urlPattern, endpoint);
            }
            if (serviceName != null && portName != null) {
                this.servicePortNameMap.put(servicePort, endpoint);
            }
            if (portComponentName != null) {
                this.portComponentNameMap.put(portComponentName, endpoint);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Endpoint was null.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initializeEndpoint");
        }
    }

    public void initializeEndpoints(List endpoints) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initializeEndpoints");
        }
        if (endpoints != null && endpoints.size() > 0) {
            Iterator it = endpoints.iterator();
            while (it.hasNext()) {
                this.initializeEndpoint((Endpoint)it.next());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No endpoints to add. Endpoints list: " + endpoints);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initializeEndpoints");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEndpointListener(String serviceName, String portName) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "startEndpointListener");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        String servicePort = serviceName + "#" + portName;
        if (serviceName != null && portName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(servicePort);
                if (endpoint != null) {
                    this.validateAuthorizationForApp(endpoint.getApplicationName(), START_OP);
                    if (endpoint.getState() == 2) {
                        Object[] inserts = new Object[]{servicePort};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointAlreadyStarted", inserts, "The endpoint corresponding to key {0} is already started.");
                        Tr.error(_tc, "endpointAlreadyStarted", inserts);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{servicePort};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                endpoint.setState(2);
                endpoint.setStartTime(System.currentTimeMillis());
                endpoints.add(endpoint);
                if (endpoints.size() > 0) {
                    this.sendJMXEvent(endpoints);
                }
            }
        } else {
            Object[] inserts = new Object[]{servicePort};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startEndpointListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServiceListener(String serviceName) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "startServiceListener");
        }
        long startTime = System.currentTimeMillis();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        boolean endpointFound = false;
        if (serviceName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                String msg;
                Object[] inserts;
                for (Object key : this.servicePortNameMap.keySet()) {
                    Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                    this.validateAuthorizationForApp(endpoint.getApplicationName(), START_OP);
                    if (!serviceName.equals(endpoint.getServiceName())) continue;
                    endpointFound = true;
                    if (endpoint.getState() == 2) continue;
                    endpoint.setState(2);
                    endpoint.setStartTime(startTime);
                    endpoints.add(endpoint);
                }
                if (!endpointFound) {
                    inserts = new Object[]{serviceName};
                    msg = NLSProvider.getNLS().getFormattedMessage("badServiceKey", inserts, "Could not locate any endpoints pertaining to the {0} service.");
                    Tr.error(_tc, "badServiceKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                if (endpoints.size() <= 0) {
                    inserts = new Object[]{serviceName};
                    msg = NLSProvider.getNLS().getFormattedMessage("serviceAlreadyStarted", inserts, "The service corresponding to key {0} is already started.");
                    Tr.error(_tc, "serviceAlreadyStarted", inserts);
                    throw new IllegalStateException(msg);
                }
                this.sendJMXEvent(endpoints);
            }
        } else {
            Object[] inserts = new Object[]{serviceName};
            String msg = NLSProvider.getNLS().getFormattedMessage("badServiceKey", inserts, "Could not locate any endpoints pertaining to the {0} service.");
            Tr.error(_tc, "badServiceKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startServiceListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpointListener(String serviceName, String portName) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopEndpointListener");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        String servicePort = serviceName + "#" + portName;
        if (serviceName != null && portName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(servicePort);
                if (endpoint != null) {
                    this.validateAuthorizationForApp(endpoint.getApplicationName(), STOP_OP);
                    if (endpoint.getState() == 3) {
                        Object[] inserts = new Object[]{servicePort};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointAlreadyStopped", inserts, "The endpoint corresponding to key {0} is already stopped.");
                        Tr.error(_tc, "endpointAlreadyStopped", inserts);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{servicePort};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                endpoint.setState(3);
                endpoint.setStartTime(0L);
                endpoints.add(endpoint);
                if (endpoints.size() > 0) {
                    this.sendJMXEvent(endpoints);
                }
            }
        } else {
            Object[] inserts = new Object[]{servicePort};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stopEndpointListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServiceListener(String serviceName) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopServiceListener");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        boolean endpointFound = false;
        if (serviceName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                String msg;
                Object[] inserts;
                for (Object key : this.servicePortNameMap.keySet()) {
                    Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                    this.validateAuthorizationForApp(endpoint.getApplicationName(), STOP_OP);
                    if (!serviceName.equals(endpoint.getServiceName())) continue;
                    endpointFound = true;
                    if (endpoint.getState() == 3) continue;
                    endpoint.setState(3);
                    endpoint.setStartTime(0L);
                    endpoints.add(endpoint);
                }
                if (!endpointFound) {
                    inserts = new Object[]{serviceName};
                    msg = NLSProvider.getNLS().getFormattedMessage("badServiceKey", inserts, "Could not locate any endpoints pertaining to the {0} service.");
                    Tr.error(_tc, "badServiceKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                if (endpoints.size() <= 0) {
                    inserts = new Object[]{serviceName};
                    msg = NLSProvider.getNLS().getFormattedMessage("serviceAlreadyStopped", inserts, "The service corresponding to key {0} is already stopped.");
                    Tr.error(_tc, "serviceAlreadyStopped", inserts);
                    throw new IllegalStateException(msg);
                }
                this.sendJMXEvent(endpoints);
            }
        } else {
            Object[] inserts = new Object[]{serviceName};
            String msg = NLSProvider.getNLS().getFormattedMessage("badServiceKey", inserts, "Could not locate any endpoints pertaining to the {0} service.");
            Tr.error(_tc, "badServiceKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stopServiceListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getEndpointState(String serviceName, String portName) throws IllegalArgumentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndpointState");
        }
        int state = -1;
        String servicePort = serviceName + "#" + portName;
        if (serviceName != null && portName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(servicePort);
                if (endpoint == null) {
                    Object[] inserts = new Object[]{servicePort};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badServiceKey", inserts, "Could not locate any endpoints pertaining to the {0} service.");
                    Tr.error(_tc, "badServiceKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
                state = endpoint.getState();
            }
        } else {
            Object[] inserts = new Object[]{servicePort};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointState", state);
        }
        return new Integer(state);
    }

    public Integer getServiceState(String serviceName) throws IllegalArgumentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceState");
        }
        int state = 0;
        if (serviceName != null) {
            for (Object key : this.servicePortNameMap.keySet()) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
                if (!serviceName.equals(endpoint.getServiceName())) continue;
                int currState = endpoint.getState();
                if (currState == 2) {
                    if (state == -1) {
                        return new Integer(1);
                    }
                    state = 1;
                    continue;
                }
                if (currState != 3) continue;
                if (state == 1) {
                    return new Integer(1);
                }
                state = -1;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServiceState", state);
        }
        if (state == 1) {
            return new Integer(2);
        }
        if (state == -1) {
            return new Integer(3);
        }
        Object[] inserts = new Object[]{serviceName};
        String msg = NLSProvider.getNLS().getFormattedMessage("badServiceKey", inserts, "Could not locate any endpoints pertaining to the {0} service.");
        Tr.error(_tc, "badServiceKey", inserts);
        throw new IllegalArgumentException(msg);
    }

    public List getServiceNames() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceNames");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Object key : this.servicePortNameMap.keySet()) {
            Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
            this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
            String serviceName = endpoint.getServiceName();
            if (names.contains(serviceName)) continue;
            names.add(serviceName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServiceNames", names);
        }
        return names;
    }

    public List getEndpointNames(String serviceName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndpointNames");
        }
        ArrayList<String> names = new ArrayList<String>();
        if (serviceName != null) {
            for (Object key : this.servicePortNameMap.keySet()) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
                if (!endpoint.getServiceName().equals(serviceName)) continue;
                names.add(endpoint.getPortName());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Service name was null.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointNames", names);
        }
        return names;
    }

    public String getEndpointType(String serviceName, String portName) throws IllegalArgumentException {
        Endpoint endpoint;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndpointType");
        }
        String type = null;
        String servicePort = serviceName + "#" + portName;
        if (serviceName != null && portName != null) {
            endpoint = (Endpoint)this.servicePortNameMap.get(servicePort);
            if (endpoint == null) {
                Object[] inserts = new Object[]{servicePort};
                String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                Tr.error(_tc, "badEndpointKey", inserts);
                throw new IllegalArgumentException(msg);
            }
        } else {
            Object[] inserts = new Object[]{servicePort};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
        type = endpoint.getType();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointType", type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAll() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "startAll");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        long startTime = System.currentTimeMillis();
        EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
        synchronized (endpointManagerMBeanImpl) {
            for (Object key : this.servicePortNameMap.keySet()) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                if (endpoint.getState() == 2) continue;
                endpoint.setState(2);
                endpoint.setStartTime(startTime);
                endpoints.add(endpoint);
            }
            if (endpoints.size() > 0) {
                this.sendJMXEvent(endpoints);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEndpointListenerWithUrlPattern(String urlPattern) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "startEndpointListenerWithUrlPattern");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (urlPattern != null) {
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = this.getEndpointFromURLPattern(urlPattern);
                if (endpoint != null) {
                    if (endpoint.getState() == 2) {
                        Object[] inserts = new Object[]{urlPattern};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointAlreadyStarted", inserts, "The endpoint corresponding to key {0} is already started.");
                        Tr.error(_tc, "endpointAlreadyStarted", inserts);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{urlPattern};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                endpoint.setState(2);
                endpoint.setStartTime(System.currentTimeMillis());
                endpoints.add(endpoint);
                if (endpoints.size() > 0) {
                    this.sendJMXEvent(endpoints);
                }
            }
        } else {
            Object[] inserts = new Object[]{urlPattern};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startEndpointListenerWithUrlPattern");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEndpointListenerWithPortComponentName(String portComponentName) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "startEndpointListenerWithPortComponentName");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (portComponentName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = (Endpoint)this.portComponentNameMap.get(portComponentName);
                if (endpoint != null) {
                    if (endpoint.getState() == 2) {
                        Object[] inserts = new Object[]{portComponentName};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointAlreadyStarted", inserts, "The endpoint corresponding to key {0} is already started.");
                        Tr.error(_tc, "endpointAlreadyStarted", inserts);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{portComponentName};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                endpoint.setState(2);
                endpoint.setStartTime(System.currentTimeMillis());
                endpoints.add(endpoint);
                if (endpoints.size() > 0) {
                    this.sendJMXEvent(endpoints);
                }
            }
        } else {
            Object[] inserts = new Object[]{portComponentName};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "startEndpointListenerWithPortComponentName");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopAll");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
        synchronized (endpointManagerMBeanImpl) {
            for (Object key : this.servicePortNameMap.keySet()) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                if (endpoint.getState() == 3) continue;
                endpoint.setState(3);
                endpoint.setStartTime(0L);
                endpoints.add(endpoint);
            }
            if (endpoints.size() > 0) {
                this.sendJMXEvent(endpoints);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stopAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpointListenerWithUrlPattern(String urlPattern) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopEndpointListenerWithUrlPattern");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (urlPattern != null) {
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = this.getEndpointFromURLPattern(urlPattern);
                if (endpoint != null) {
                    if (endpoint.getState() == 3) {
                        Object[] inserts = new Object[]{urlPattern};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointAlreadyStopped", inserts, "The endpoint corresponding to key {0} is already stopped.");
                        Tr.error(_tc, "endpointAlreadyStopped", inserts);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{urlPattern};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                endpoint.setState(3);
                endpoint.setStartTime(0L);
                endpoints.add(endpoint);
                if (endpoints.size() > 0) {
                    this.sendJMXEvent(endpoints);
                }
            }
        } else {
            Object[] inserts = new Object[]{urlPattern};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stopEndpointListenerWithUrlPattern");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopEndpointListenerWithPortComponentName(String portComponentName) throws IllegalArgumentException, IllegalStateException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stopEndpointListenerWithPortComponentName");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (portComponentName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = (Endpoint)this.portComponentNameMap.get(portComponentName);
                if (endpoint != null) {
                    if (endpoint.getState() == 3) {
                        Object[] inserts = new Object[]{portComponentName};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointAlreadyStopped", inserts, "The endpoint corresponding to key {0} is already stopped.");
                        Tr.error(_tc, "endpointAlreadyStopped", inserts);
                        throw new IllegalStateException(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{portComponentName};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                endpoint.setState(3);
                endpoint.setStartTime(0L);
                endpoints.add(endpoint);
                if (endpoints.size() > 0) {
                    this.sendJMXEvent(endpoints);
                }
            }
        } else {
            Object[] inserts = new Object[]{portComponentName};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stopEndpointListenerWithPortComponentName");
        }
    }

    public Endpoint getEndpointListenerWithUrlPattern(String urlPattern) {
        Endpoint endpoint = this.getEndpointFromURLPattern(urlPattern);
        return endpoint;
    }

    public Endpoint getEndpointListenerWithPortComponentName(String portComponentName) {
        Endpoint endpoint = (Endpoint)this.portComponentNameMap.get(portComponentName);
        return endpoint;
    }

    public List getEndpointsByType(String serviceType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndpointsByType");
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (serviceType != null) {
            for (Object key : this.servicePortNameMap.keySet()) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(key);
                this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
                if (!serviceType.equals(endpoint.getType())) continue;
                endpoints.add(endpoint);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointsByType", endpoints);
        }
        return endpoints;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"EndpointManager"}, EndpointManagerMBean.class.getName(), "Notifications of endpoint state change.")};
    }

    public void sendJMXEvent(Object e) {
        this.sendJMXEvent("websphere.webservices.change", e);
    }

    public void sendJMXEvent(String type, Object e) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendJMXEvent");
        }
        try {
            Notification notf = new Notification(type, this.getObjectName(), ++seqNum);
            notf.setUserData(e);
            this.sendNotification(notf);
        }
        catch (Throwable t) {
            Object[] inserts = new Object[]{t};
            Tr.error(_tc, "sendNotificationFail", inserts);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendJMXEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoints(List endpoints) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeEndpoints");
        }
        Iterator it = endpoints.iterator();
        EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
        synchronized (endpointManagerMBeanImpl) {
            while (it.hasNext()) {
                Endpoint endpoint = (Endpoint)it.next();
                String servicePort = endpoint.getServiceName() + "#" + endpoint.getPortName();
                this.servicePortNameMap.remove(servicePort);
                this.urlPatternMap.remove(endpoint.getUrlPattern());
                this.portComponentNameMap.remove(endpoint.getPortComponentName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeEndpoints");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
        synchronized (endpointManagerMBeanImpl) {
            return this.servicePortNameMap.isEmpty() && this.urlPatternMap.isEmpty() && this.portComponentNameMap.isEmpty();
        }
    }

    public String getEndpointPartialURL(String serviceName, String portName) throws IllegalArgumentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndpointURLPattern");
        }
        String servicePortName = serviceName + "#" + portName;
        Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(servicePortName);
        String urlPattern = null;
        if (endpoint != null) {
            this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
            urlPattern = endpoint.getUrlPattern();
        }
        if (this.contextRoot == null || urlPattern == null) {
            Object[] inserts = new Object[]{servicePortName};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointURLPattern", this.contextRoot + urlPattern);
        }
        return this.contextRoot + urlPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getEndpointStartTime(String serviceName, String portName) throws IllegalArgumentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEndpointStartTime", serviceName + "#" + portName);
        }
        long startTime = 0L;
        String servicePort = serviceName + "#" + portName;
        if (serviceName != null && portName != null) {
            EndpointManagerMBeanImpl endpointManagerMBeanImpl = this;
            synchronized (endpointManagerMBeanImpl) {
                Endpoint endpoint = (Endpoint)this.servicePortNameMap.get(servicePort);
                if (endpoint == null) {
                    Object[] inserts = new Object[]{servicePort};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
                    Tr.error(_tc, "badEndpointKey", inserts);
                    throw new IllegalArgumentException(msg);
                }
                this.validateAuthorizationForApp(endpoint.getApplicationName(), OTHER_OP);
                startTime = endpoint.getStartTime();
            }
        } else {
            Object[] inserts = new Object[]{servicePort};
            String msg = NLSProvider.getNLS().getFormattedMessage("badEndpointKey", inserts, "Could not locate endpoint with the {0} key.");
            Tr.error(_tc, "badEndpointKey", inserts);
            throw new IllegalArgumentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEndpointStartTime", startTime);
        }
        return new Long(startTime);
    }

    Endpoint getEndpointFromURLPattern(String urlPattern) {
        Endpoint endpoint = null;
        endpoint = (Endpoint)this.urlPatternMap.get(urlPattern);
        if (endpoint == null && !this.urlPatternMap.isEmpty() && this.urlPatternMap.values().size() == 1 && this.urlPatternMap.containsKey("/*")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Returning entry for /* url pattern from map");
            }
            endpoint = (Endpoint)this.urlPatternMap.values().iterator().next();
        }
        return endpoint;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    private void validateAuthorizationForApp(String appName, String operation) throws AccessControlException {
        AdminAuthorizer myAdminAuthorizer;
        String resource = "applications/" + appName;
        boolean monitorIsSufficient = true;
        if (operation.equals(START_OP) || operation.equals(STOP_OP)) {
            monitorIsSufficient = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EndpointManagerMBeanImpl.validateAuthorizationForApp()...", "app=" + appName + ", operation=" + operation + ", monitorIsSufficient=" + monitorIsSufficient);
        }
        if ((myAdminAuthorizer = AdminAuthorizerFactory.getAdminAuthorizer()) != null) {
            if (monitorIsSufficient && !myAdminAuthorizer.checkAccess(resource, "monitor")) {
                Object[] inserts = new Object[]{resource};
                String msg = NLSProvider.getNLS().getFormattedMessage("endptMgrAccessDenied00", inserts, "Access is denied for resource {0}, monitor authority is required.");
                Tr.error(_tc, "endptMgrAccessDenied00", inserts);
                throw new AccessControlException(msg);
            }
            if (!(monitorIsSufficient || myAdminAuthorizer.checkAccess(resource, "operator") || myAdminAuthorizer.checkAccess(resource, "deployer"))) {
                Object[] inserts = new Object[]{resource};
                String msg = NLSProvider.getNLS().getFormattedMessage("endptMgrAccessDenied01", inserts, "Access is denied for resource {0}, operator or deployer authority is required.");
                Tr.error(_tc, "endptMgrAccessDenied01", inserts);
                throw new AccessControlException(msg);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...EndpointManagerMBeanImpl.validateAuthorizationForApp()", "app=" + appName + ", user has authorization to perform the operation " + operation);
        }
    }
}

