/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.saaj13only;

import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPConnectionJAXWS {
    private static final String DUMMY_NS = "urn://soapconnection";
    private static final String DUMMY_SERVICE = "connectionService";
    private static final String DUMMY_PORT_11 = "connectionPort11";
    private static final String DUMMY_PORT_12 = "connectionPort12";

    public SOAPMessage call(SOAPMessage request, String endpoint, String soapProtocol) throws SOAPException {
        try {
            Dispatch<SOAPMessage> dispatch = this.getDispatch(endpoint, soapProtocol);
            Map requestContext = dispatch.getRequestContext();
            requestContext.put("com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPConnectionJAXWS.soapConnection", true);
            SOAPMessage response = (SOAPMessage)dispatch.invoke((Object)request);
            return response;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.saaj13only.SOAPConnectionJAXWS.call", "63", this);
            throw new SOAPException((Throwable)e);
        }
    }

    private Dispatch<SOAPMessage> getDispatch(String endpoint, String soapProtocol) throws WebServiceException {
        QName serviceQName = new QName(DUMMY_NS, DUMMY_SERVICE);
        QName portName = null;
        String soapBinding = null;
        if ("SOAP 1.1 Protocol".equals(soapProtocol)) {
            portName = new QName(DUMMY_NS, DUMMY_PORT_11);
            soapBinding = "http://schemas.xmlsoap.org/wsdl/soap/http";
        } else {
            portName = new QName(DUMMY_NS, DUMMY_PORT_12);
            soapBinding = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        }
        Service.Mode mode = Service.Mode.MESSAGE;
        Service service = Service.create((QName)serviceQName);
        service.addPort(portName, soapBinding, endpoint);
        Dispatch dispatch = service.createDispatch(portName, SOAPMessage.class, mode);
        return dispatch;
    }
}

