/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;

public final class InputStreamAlternateContent
extends AlternateContentBase {
    private static Log log = LogFactory.getLog(InputStreamAlternateContent.class.getName());

    public static InputStreamAlternateContent create(InputStream content) {
        return new InputStreamAlternateContent(content, AlternateContentBase.CONTENT_ONLY);
    }

    InputStreamAlternateContent(InputStream content, short contentFlag) {
        super(content, contentFlag);
    }

    protected void serialize(SerializationContext context, boolean includeNSDecls) throws Exception {
        MappingScope ms = this._getMappingScope(this.owner);
        if (includeNSDecls) {
            ms = this._getMappingScope(this.owner);
            MappingScope msAncestors = this._getMappingScopeForAncestorsNotWritten(context);
            ms.setParent(msAncestors);
            ms = ms.flatten();
        }
        context.getSerializationWriter().startElement(this.owner.getQName(), this.owner.getPrefix(), this.owner.getSAXAttributes(), ms);
        InputStream inputStream = (InputStream)this.content;
        try {
            byte[] buf = new byte[inputStream.available()];
            inputStream.read(buf);
            String enc = context.getMessageContext() == null ? "utf-8" : context.getMessageContext().getCharacterEncoding();
            context.getSerializationWriter().write(buf, enc);
            this.content = new ByteArrayInputStream(buf);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.xmlsoap.ext.InputStreamAlternateContent.serialize", "60", this);
            throw ex;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.ext.InputStreamAlternateContent.serialize", "64", this);
            log.error(Messages.getMessage("exception00"), e);
        }
        if (this.owner instanceof SOAPBody) {
            context.outputMultiRefs();
        }
        context.getSerializationWriter().endElement();
    }
}

