/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.utils.BAIS;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.InputStream;
import javax.xml.soap.SOAPException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPBuilder
extends DEventProcessor {
    protected SOAPElement myElement = null;
    protected SOAPElement myChildElement = null;
    protected int lazyParseLevel = 0;

    public void elementEvent(SOAPElement element) {
        this.myElement = element;
    }

    public void childElementEvent(SOAPElement element) {
        this.myChildElement = element;
    }

    public void setMyElement(SOAPElement element) {
        this.myElement = element;
    }

    public void setLazyParseLevel(int level) {
        this.lazyParseLevel = level;
    }

    public void startElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (this.myElement == null) {
            throw new SAXException(Messages.getMessage("noElementInBuilder00", this.getClass().getName()));
        }
        if (this.myElement.rebuildTagQName()) {
            this.myElement.setQName(namespace, prefixedName);
        }
        if (this.myElement.rebuildAttributesAndMapping()) {
            this.myElement.setAttributes(attributes);
            this.myElement.setMappingScope(mappingScope);
        }
        if (this.lazyParseLevel == 1 && !context.isSimpleEventEnabled()) {
            try {
                InputStream is = context.getLazyParse();
                if (is != null) {
                    WebServicesInputSource wsis = null;
                    wsis = is instanceof BAIS ? WebServicesInputSource.create(((BAIS)is).getBuff()) : WebServicesInputSource.create(is);
                    MessageContext msgContext = context.getMessageContext();
                    if (msgContext != null && msgContext.getCurrentMessage() != null) {
                        String encoding = msgContext.getCurrentMessage().getCharacterEncoding();
                        wsis.setEncoding(encoding);
                    }
                    this.myElement.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(wsis));
                }
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.startElement", "152", this);
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
    }

    public void characters(String value) throws SAXException {
        if (this.myElement != null) {
            try {
                this.myElement.addTextNode(value);
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.characters", "197", this);
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public void comment(char[] chars, int offset, int length) throws SAXException {
        String value = new String(chars, offset, length);
        if (this.myElement != null) {
            try {
                this.myElement.addComment(value);
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.comment", "216", this);
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public DEventProcessor onStartChild(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        try {
            SOAPBuilder builder = new SOAPBuilder();
            this.myChildElement = this.myElement.getSOAPFactory().createSOAPElement(namespace, localName, prefixedName, attributes, mappingScope, context, this.myElement);
            builder.setMyElement(this.myChildElement);
            if (this.lazyParseLevel > 1) {
                builder.setLazyParseLevel(this.lazyParseLevel - 1);
            }
            return builder;
        }
        catch (SOAPException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder.onStartChild", "206", this);
            throw new SAXException((Exception)((Object)se));
        }
    }
}

