/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPFault;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFaultElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.WebServicesFaultProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class SOAPFault
extends SOAPBodyElement
implements IBMSOAPFault {
    private Locale locale;
    protected static Log log = LogFactory.getLog(SOAPFault.class.getName());

    SOAPFault(SOAPFactory soapFactory) {
        super(soapFactory.getSOAPConstants().getFaultQName().getNamespaceURI(), soapFactory.getSOAPConstants().getFaultQName().getLocalPart(), soapFactory);
    }

    private void _setFaultCode(String faultCode) throws SOAPException {
        if (this.isSOAP12()) {
            if (this._getFault() != null) {
                String prefix = SOAPFault.extractPrefixFromQName(faultCode);
                String localName = SOAPFault.extractLocalNameFromQName(faultCode);
                String namespace = null;
                prefix = prefix == null ? "" : prefix;
                Mapping mapping = this._getMappingScope().getMappingForPrefix(prefix, false);
                if (mapping != null) {
                    namespace = mapping.getNamespaceURI();
                }
                if (namespace != null && namespace.length() > 0) {
                    faultCode = "{" + namespace + "}" + localName;
                }
                this._getFault().setFaultCodeAsString(faultCode);
            } else {
                QName faultCodeValueQName;
                SOAPElement valueElement;
                QName faultCodeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
                SOAPElement codeElement = this.getChildElement(faultCodeQName.getNamespaceURI(), faultCodeQName.getLocalPart());
                if (codeElement == null) {
                    codeElement = this.createChildElement(faultCodeQName);
                    this.addChild(codeElement);
                }
                if ((valueElement = codeElement.getChildElement((faultCodeValueQName = this.soapFactory.getSOAPConstants().getFaultCodeValueQName()).getNamespaceURI(), faultCodeValueQName.getLocalPart())) != null) {
                    valueElement.detachNode();
                }
                valueElement = this.createChildElement(faultCodeValueQName);
                valueElement.addTextNode(faultCode);
                codeElement.insertBefore((Node)((Object)valueElement), codeElement.getFirstChild());
            }
        } else if (this._getFault() != null) {
            String prefix = SOAPFault.extractPrefixFromQName(faultCode);
            String localName = SOAPFault.extractLocalNameFromQName(faultCode);
            String namespace = null;
            prefix = prefix == null ? "" : prefix;
            Mapping mapping = this._getMappingScope().getMappingForPrefix(prefix, false);
            if (mapping != null) {
                namespace = mapping.getNamespaceURI();
            }
            if (namespace != null && namespace.length() > 0) {
                faultCode = "{" + namespace + "}" + localName;
            }
            this._getFault().setFaultCodeAsString(faultCode);
        } else {
            QName faultCodeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            SOAPElement se = this.getChildElement(faultCodeQName.getNamespaceURI(), faultCodeQName.getLocalPart());
            if (se != null) {
                se.detachNode();
            }
            se = this.createChildElement(faultCodeQName);
            se = this.addChild(se);
            se.addTextNode(faultCode);
        }
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        this._validateFaultCode(faultCode);
        this._setFaultCode(faultCode);
    }

    public void setFaultCode(javax.xml.soap.Name faultCodeQName) throws SOAPException {
        String namespace = faultCodeQName.getURI();
        String localName = faultCodeQName.getLocalName();
        String prefix = faultCodeQName.getPrefix();
        this._validateFaultCode(namespace, localName, prefix);
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            fault.setFaultCode(QNameTable.createQName(namespace, localName));
        } else {
            String text = localName;
            if (prefix != null && prefix.length() > 0) {
                text = prefix + ":" + text;
                if (this._getMappingScope().getMappingForPrefix(prefix, false) == null) {
                    this.addNamespaceDeclaration(prefix, namespace);
                }
            } else if (namespace != null && namespace.length() > 0) {
                Mapping mapping = this._getMappingScope().getMappingForNamespaceURI(namespace, false, true);
                if (mapping != null) {
                    prefix = mapping.getPrefix();
                    text = prefix + ":" + text;
                } else {
                    text = "{" + namespace + "}" + text;
                }
            }
            this._setFaultCode(text);
        }
    }

    private void _validateFaultCode(String faultCode) throws SOAPException {
        String prefix = null;
        String value = null;
        int separatorIndex = faultCode.indexOf(58);
        if (separatorIndex != -1) {
            prefix = faultCode.substring(0, separatorIndex);
            value = faultCode.substring(separatorIndex + 1);
        } else {
            value = faultCode;
        }
        this._validateFaultCode(null, value, prefix);
    }

    private void _validateFaultCode(String uri, String value, String prefix) throws SOAPException {
        QName faultcode;
        uri = this._validateQName(uri, value, prefix, "FaultCode");
        if (!(!this.isSOAP12() || (faultcode = QNameTable.createQName(uri, value)).equals(SOAPConstants.SOAP_DATAENCODINGUNKNOWN_FAULT) || faultcode.equals(SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT) || faultcode.equals(SOAPConstants.SOAP_RECEIVER_FAULT) || faultcode.equals(SOAPConstants.SOAP_SENDER_FAULT) || faultcode.equals(SOAPConstants.SOAP_VERSIONMISMATCH_FAULT))) {
            throw new SOAPException(Messages.getMessage("invalidFaultCode", value, uri));
        }
    }

    protected String _validateQName(String uri, String value, String prefix, String type) throws SOAPException {
        if (disableSOAPNamespaceValidation) {
            return uri;
        }
        if (uri == null || uri.equals("")) {
            if (prefix == null || prefix.equals("")) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", type, value, prefix, uri));
            }
            Mapping map = this._getMappingScope().getMappingForPrefix(prefix, false);
            if (map == null) {
                throw new SOAPException(Messages.getMessage("unqualifiedName", type, value, prefix, uri));
            }
            uri = map.getNamespaceURI();
        }
        return uri;
    }

    public String getFaultCode() {
        if (this.isSOAP12()) {
            if (this._getFault() != null) {
                return this._getFault().getFaultCode().toString();
            }
            QName faultCodeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            SOAPElement se = this._getChildElement(faultCodeQName);
            if (se != null) {
                QName faultCodeValueQName = this.soapFactory.getSOAPConstants().getFaultCodeValueQName();
                try {
                    SOAPElement seValue = se.getChildElement(faultCodeValueQName.getNamespaceURI(), faultCodeValueQName.getLocalPart());
                    if (seValue != null) {
                        return seValue.getValue();
                    }
                }
                catch (SOAPException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.getFaultCode", "292", this);
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        if (this._getFault() != null) {
            return this._getFault().getFaultCode().toString();
        }
        QName faultCodeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
        SOAPElement se = this._getChildElement(faultCodeQName);
        if (se != null) {
            return se.getValue();
        }
        se = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTCODE.getLocalPart()));
        if (se != null) {
            if (se.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return se.getValue();
            }
            if (se.getPrefix() != null && se.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public QName getFaultCodeAsQName() {
        int endCurly;
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            return fault.getFaultCode();
        }
        String text = this.getFaultCode();
        if (text == null) {
            return null;
        }
        if (text.startsWith("{") && (endCurly = text.indexOf("}")) > 0) {
            String namespace = text.substring(1, endCurly);
            text = text.substring(endCurly + 1);
            return QNameTable.createQName(namespace, text);
        }
        String prefix = SOAPFault.extractPrefixFromQName(text);
        String localName = SOAPFault.extractLocalNameFromQName(text);
        String namespace = null;
        prefix = prefix == null ? "" : prefix;
        QName faultCodeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
        SOAPElement se = this._getChildElement(faultCodeQName);
        if (se == null) {
            se = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTCODE.getLocalPart()));
            if (se != null) {
                if (se.getPrefix() == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                    }
                } else if (se.getPrefix() != null && se.getPrefix().length() > 0 && log.isDebugEnabled()) {
                    log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Error: Namespace for this SOAP Fault child is not valid.");
            }
        }
        Mapping mapping = null;
        if (se != null) {
            mapping = se._getMappingScope().getMappingForPrefix(prefix, false);
        }
        if (mapping != null) {
            namespace = mapping.getNamespaceURI();
        }
        return new QName(namespace, localName, prefix);
    }

    public javax.xml.soap.Name getFaultCodeAsName() {
        QName qName = this.getFaultCodeAsQName();
        if (qName == null) {
            return null;
        }
        return new Name(qName);
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if (this.isSOAP12()) {
            this.setFaultRole(faultActor);
            return;
        }
        if (this._getFault() != null) {
            this._getFault().setFaultActor(faultActor);
        } else {
            QName faultActorQName = this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName();
            SOAPElement se = this.getChildElement(faultActorQName.getNamespaceURI(), faultActorQName.getLocalPart());
            if (se != null) {
                se.detachNode();
            }
            se = this.createChildElement(faultActorQName);
            se = this.addChild(se);
            se.addTextNode(faultActor);
        }
    }

    public String getFaultActor() {
        if (this.isSOAP12()) {
            return this.getFaultRole();
        }
        if (this._getFault() != null) {
            return this._getFault().getFaultActor();
        }
        QName faultActorQName = this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName();
        SOAPElement se = this._getChildElement(faultActorQName);
        if (se != null) {
            return se.getValue();
        }
        se = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTACTOR.getLocalPart()));
        if (se != null) {
            if (se.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return se.getValue();
            }
            if (se.getPrefix() != null && se.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public void setFaultString(String faultString) throws SOAPException {
        if (this.isSOAP12()) {
            this.addFaultReasonText(faultString, Locale.getDefault());
        } else if (this._getFault() != null) {
            this._getFault().setFaultString(faultString);
        } else {
            QName faultStringQName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
            SOAPElement se = this.getChildElement(faultStringQName.getNamespaceURI(), faultStringQName.getLocalPart());
            if (se != null) {
                se.detachNode();
            }
            se = this.createChildElement(faultStringQName);
            se = this.addChild(se);
            se.addTextNode(faultString);
        }
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        if (this.isSOAP12()) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            this.addFaultReasonText(faultString, locale);
        } else {
            this.setFaultString(faultString);
            this.locale = locale;
        }
    }

    public Locale getFaultStringLocale() {
        if (this.isSOAP12()) {
            try {
                return (Locale)this.getFaultReasonLocales().next();
            }
            catch (SOAPException sOAPException) {
                return null;
            }
        }
        return this.locale;
    }

    public String getFaultString() {
        if (this.isSOAP12()) {
            String reason = null;
            try {
                reason = (String)this.getFaultReasonTexts().next();
            }
            catch (SOAPException se) {
                // empty catch block
            }
            return reason;
        }
        if (this._getFault() != null) {
            return this._getFault().getFaultString();
        }
        QName faultStringQName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        SOAPElement se = this._getChildElement(faultStringQName);
        if (se != null) {
            return se.getValue();
        }
        se = this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTSTRING.getLocalPart()));
        if (se != null) {
            if (se.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return se.getValue();
            }
            if (se.getPrefix() != null && se.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public boolean isUserFault() {
        return this.getDetail() != null;
    }

    public javax.xml.soap.Detail getDetail() {
        QName faultDetailQName = this.soapFactory.getSOAPConstants().getFaultDetailQName();
        javax.xml.soap.Detail se = (javax.xml.soap.Detail)this._getChildElement(faultDetailQName);
        if (se != null) {
            return se;
        }
        se = (javax.xml.soap.Detail)this._getChildElement(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", Constants.QNAME_FAULTDETAILS.getLocalPart()));
        if (se != null) {
            if (se.getPrefix() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Per section 3.3.3 of the sWS-I Basic Profile, SOAP Fault children should not have a namespace. However, this namespace will be tolerated.");
                }
                return se;
            }
            if (se.getPrefix() != null && se.getPrefix().length() > 0 && log.isDebugEnabled()) {
                log.debug("Error: Per section 3.3.3 of the WS-I Basic Profile, SOAP Fault children must not be namespace qualified.");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Error: Namespace for this SOAP Fault child is not valid.");
        }
        return null;
    }

    public javax.xml.soap.Detail addDetail() throws SOAPException {
        if (this.getDetail() != null) {
            throw new SOAPException(Messages.getMessage("valuePresent"));
        }
        QName faultDetailQName = this.soapFactory.getSOAPConstants().getFaultDetailQName();
        Detail se = (Detail)this.createChildElement(faultDetailQName);
        se = (Detail)this.addChild(se);
        return se;
    }

    protected WebServicesFault _getFault() {
        Object altContent = this.getAlternateContent();
        if (altContent instanceof WebServicesFault) {
            return (WebServicesFault)altContent;
        }
        return null;
    }

    public WebServicesFault getFault() {
        WebServicesFault fault = this._getFault();
        if (fault == null) {
            this.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
            try {
                fault = WebServicesFaultProcessor.createFault(this, this.getSOAPFactory().getDeserializationContext());
                this.setFault(fault);
            }
            catch (SAXException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.getFault", "485", this);
                throw new RuntimeException(e);
            }
        }
        return fault;
    }

    public void setFault(WebServicesFault fault) {
        try {
            this.removeContents();
            this.setAlternateContent(WebServicesFaultAlternateContent.create(fault));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.setFault", "472", this);
            throw new RuntimeException(e);
        }
    }

    public void setFault(SOAPFaultException soapFault) {
        this.setFault(new WebServicesFault(soapFault));
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPFaultBuilder();
    }

    protected SOAPElement createChildElement(String namespaceURI, String localPart, SOAPFactory factory) throws SOAPException {
        QName detailQName = factory.getSOAPConstants().getFaultDetailQName();
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (detailQName.getLocalPart().equals(localPart) && detailQName.getNamespaceURI().equals(namespaceURI)) {
            return new Detail(factory);
        }
        return super.createChildElement(namespaceURI, localPart, factory);
    }

    private SOAPElement createChildElement(QName qName) throws SOAPException {
        return this.createChildElement(qName.getNamespaceURI(), qName.getLocalPart(), this.getSOAPFactory());
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> cls = node.getClass();
        if (node instanceof SOAPElement && !(node instanceof Detail)) {
            QName faultDetailQName = this.soapFactory.getSOAPConstants().getFaultDetailQName();
            SOAPElement se = (SOAPElement)((Object)node);
            if (se.getQName().equals(faultDetailQName)) {
                return false;
            }
        }
        return (cls.equals(SOAPElement.class) || cls.equals(SOAPFaultElement.class) || cls.equals(Detail.class) || cls.equals(Text.class) || cls.equals(Comment.class) || cls.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public javax.xml.soap.SOAPElement addTextNode(String text) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(text)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.SOAPFault"));
        }
        return super.addTextNode(text);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.SOAPFault"));
        }
        super.setEncodingStyle(encodingStyle);
    }

    private SOAPElement _getChildElement(QName qName) {
        try {
            return this.getChildElement(qName.getNamespaceURI(), qName.getLocalPart());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFault.setFault", "519", this);
            throw new RuntimeException(e);
        }
    }

    public void setFaultCode(QName faultCodeQName) throws SOAPException {
        String namespace = faultCodeQName.getNamespaceURI();
        String localName = faultCodeQName.getLocalPart();
        String prefix = faultCodeQName.getPrefix();
        this._validateFaultCode(namespace, localName, prefix);
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            fault.setFaultCode(QNameTable.createQName(namespace, localName));
        } else {
            String text = localName;
            if (prefix != null && prefix.length() > 0) {
                text = prefix + ":" + text;
                if (this._getMappingScope().getMappingForPrefix(prefix, false) == null) {
                    this.addNamespaceDeclaration(prefix, namespace);
                }
            } else if (namespace != null && namespace.length() > 0) {
                Mapping mapping = this._getMappingScope().getMappingForNamespaceURI(namespace, false, true);
                if (mapping != null) {
                    prefix = mapping.getPrefix();
                    text = prefix + ":" + text;
                } else {
                    text = "{" + namespace + "}" + text;
                }
            }
            this._setFaultCode(text);
        }
    }

    public Iterator getFaultSubcodes() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultSubcodes()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultSubcodes()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            List subcodes = fault.getSOAP12_Subcodes();
            if (subcodes == null) {
                return new ArrayList().iterator();
            }
            return subcodes.iterator();
        }
        QName codeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
        QName subcodeQName = this.soapFactory.getSOAPConstants().getFaultSubcodeQName();
        SOAPElement codeElement = this._getChildElement(codeQName);
        if (codeElement == null) {
            return new ArrayList().iterator();
        }
        String methodName = "javax.xml.soap.Fault.getFaultSubcodes()";
        NestedNodeIterator it = new NestedNodeIterator((Node)((Object)codeElement), subcodeQName, methodName);
        NodeIteratorFilter it2 = new NodeIteratorFilter(it, methodName){
            final QName valueQName;
            {
                this.valueQName = SOAPFault.this.soapFactory.getSOAPConstants().getFaultCodeValueQName();
            }

            public Object getObject(Node node) {
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    if (!this.valueQName.getNamespaceURI().equals(childNode.getNamespaceURI()) || !this.valueQName.getLocalPart().equals(childNode.getLocalName())) continue;
                    String qualifiedName = childNode.getTextContent();
                    return Utils.toQName((SOAPElement)((Object)childNode), qualifiedName);
                }
                throw new IllegalArgumentException();
            }
        };
        return it2;
    }

    public void removeAllFaultSubcodes() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "removeAllFaultSubcodes()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "removeAllFaultSubcodes()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            fault.setSOAP12_Subcodes(null);
        } else {
            QName codeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            QName subcodeQName = this.soapFactory.getSOAPConstants().getFaultSubcodeQName();
            SOAPElement codeElement = this._getChildElement(codeQName);
            if (codeElement == null) {
                return;
            }
            String methodName = "javax.xml.soap.Fault.removeAllFaultSubcodes()";
            NestedNodeIterator it = new NestedNodeIterator((Node)((Object)codeElement), subcodeQName, methodName);
            if (it.hasNext()) {
                Node subcodeNode = (Node)it.next();
                subcodeNode.getParentNode().removeChild(subcodeNode);
            }
        }
    }

    public void appendFaultSubcode(QName subcode) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "appendFaultSubcode(QName)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "appendFaultSubcode(QName)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        this._validateQName(subcode.getNamespaceURI(), subcode.getLocalPart(), subcode.getPrefix(), "FaultSubcode");
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            ArrayList<QName> subcodes = fault.getSOAP12_Subcodes();
            if (subcodes == null) {
                subcodes = new ArrayList<QName>();
            }
            subcodes.add(subcode);
            fault.setSOAP12_Subcodes(subcodes);
        } else {
            QName codeQName = this.soapFactory.getSOAPConstants().getFaultCodeQName();
            QName subcodeQName = this.soapFactory.getSOAPConstants().getFaultSubcodeQName();
            QName valueQName = this.soapFactory.getSOAPConstants().getFaultCodeValueQName();
            SOAPElement codeElement = this._getChildElement(codeQName);
            String methodName = "javax.xml.soap.Fault.appendFaultSubcode(QName)";
            if (codeElement == null) {
                throw new SOAPException(Messages.getMessage("noFaultCode", methodName));
            }
            String prefix = this.soapFactory.getSOAPConstants().getEnvelopePrefix();
            SOAPElement subcodeElement = (SOAPElement)this.soapFactory.createElement(subcodeQName.getLocalPart(), prefix, subcodeQName.getNamespaceURI());
            SOAPElement valueElement = (SOAPElement)subcodeElement.addChildElement(valueQName.getLocalPart(), prefix, valueQName.getNamespaceURI());
            String strSubcodePrefix = subcode.getPrefix();
            if (strSubcodePrefix != null && strSubcodePrefix.length() > 0 && this._getMappingScope().getMappingForPrefix(strSubcodePrefix, false) == null) {
                valueElement.addNamespaceDeclaration(strSubcodePrefix, subcode.getNamespaceURI());
            }
            String qualifiedName = Utils.toQualifiedName(valueElement, subcode);
            valueElement.setTextContent(qualifiedName);
            Object parent = codeElement;
            NestedNodeIterator it = new NestedNodeIterator((Node)parent, subcodeQName, methodName);
            while (it.hasNext()) {
                parent = (Node)it.next();
            }
            parent.appendChild((Node)((Object)subcodeElement));
        }
    }

    public Iterator getFaultReasonLocales() throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultReasonLocales()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonLocales()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            ArrayList<Locale> locales = new ArrayList<Locale>();
            String localeString = fault.getSOAP12_ReasonLanguage();
            locales.add(this.getLocale(localeString));
            List reasons = fault.getSOAP12_AdditionalReasons();
            if (reasons != null) {
                for (int i = 0; i < reasons.size(); i += 2) {
                    localeString = (String)reasons.get(i);
                    locales.add(this.getLocale(localeString));
                }
            }
            return locales.iterator();
        }
        QName reasonQName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        QName textQName = this.soapFactory.getSOAPConstants().getFaultReasonTextQName();
        SOAPElement reasonElement = this._getChildElement(reasonQName);
        String methodName = "javax.xml.soap.Fault.getFaultReasonLocales()";
        if (reasonElement == null) {
            throw new SOAPException(Messages.getMessage("noFaultReason", methodName));
        }
        CE_Iterator it = new CE_Iterator((Node)((Object)reasonElement), textQName.getNamespaceURI(), textQName.getLocalPart(), methodName);
        NodeIteratorFilter it2 = new NodeIteratorFilter(it, methodName){
            QName xmlLang;
            {
                this.xmlLang = SOAPFault.this.soapFactory.getSOAPConstants().getXMLLangAttributeQName();
            }

            public Object getObject(Node node) {
                Element element = (Element)node;
                String xmlLangValue = element.getAttributeNS(this.xmlLang.getNamespaceURI(), this.xmlLang.getLocalPart());
                Locale locale = SOAPFault.this.getLocale(xmlLangValue);
                return locale;
            }
        };
        return it2;
    }

    public Iterator getFaultReasonTexts() throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultReasonTexts()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonTexts()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            ArrayList<String> reasons = new ArrayList<String>();
            reasons.add(fault.getFaultString());
            List list = fault.getSOAP12_AdditionalReasons();
            if (list != null) {
                for (int i = 1; i < list.size(); i += 2) {
                    reasons.add((String)list.get(i));
                }
            }
            return reasons.iterator();
        }
        QName reasonQName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        QName textQName = this.soapFactory.getSOAPConstants().getFaultReasonTextQName();
        SOAPElement reasonElement = this._getChildElement(reasonQName);
        String methodName = "javax.xml.soap.Fault.getFaultReasonTexts()";
        if (reasonElement == null) {
            throw new SOAPException(Messages.getMessage("noFaultReason", methodName));
        }
        CE_Iterator it = new CE_Iterator((Node)((Object)reasonElement), textQName.getNamespaceURI(), textQName.getLocalPart(), methodName);
        NodeIteratorFilter it2 = new NodeIteratorFilter(it, methodName){

            public Object getObject(Node node) {
                return node.getTextContent();
            }
        };
        return it2;
    }

    public String getFaultReasonText(Locale locale) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultReasonText(Locale)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonText(Locale)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        Iterator itLocales = this.getFaultReasonLocales();
        Iterator itTexts = this.getFaultReasonTexts();
        while (itLocales.hasNext() && itTexts.hasNext()) {
            Locale tryLocale = (Locale)itLocales.next();
            String tryText = (String)itTexts.next();
            if (!tryLocale.equals(locale)) continue;
            return tryText;
        }
        throw new SOAPException(Messages.getMessage("noFaultReasonTextLocale", locale.toString()));
    }

    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addFaultReasonText(String, Locale)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "addFaultReasonText(String, Locale)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        QName reasonQName = this.soapFactory.getSOAPConstants().getFaultStringOrReasonQName();
        QName textQName = this.soapFactory.getSOAPConstants().getFaultReasonTextQName();
        QName xmlLang = this.soapFactory.getSOAPConstants().getXMLLangAttributeQName();
        SOAPElement reasonElement = this._getChildElement(reasonQName);
        if (reasonElement == null) {
            reasonElement = this.createChildElement(reasonQName);
            reasonElement = this.addChild(reasonElement);
        }
        String methodName = "javax.xml.soap.Fault.addFaultReasonText(String,Locale)";
        CE_Iterator it = new CE_Iterator((Node)((Object)reasonElement), textQName.getNamespaceURI(), textQName.getLocalPart(), methodName);
        while (it.hasNext() && text != null) {
            Element element = (Element)it.next();
            String xmlLangValue = element.getAttributeNS(xmlLang.getNamespaceURI(), xmlLang.getLocalPart());
            if (!this.isMatchingLocale(xmlLangValue, locale)) continue;
            element.setTextContent(text);
            return;
        }
        String prefix = this.getPrefix();
        SOAPElement textElement = (SOAPElement)reasonElement.addChildElement(textQName.getLocalPart(), prefix, textQName.getNamespaceURI());
        textElement.setAttributeNS(xmlLang.getNamespaceURI(), "xml:" + xmlLang.getLocalPart(), this.localeToXmlLang(locale));
        textElement.setTextContent(text);
    }

    public String getFaultNode() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultNode()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultReasonNode()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            return fault.getSOAP12_Node();
        }
        SOAPElement se = this._getChildElement(this.soapFactory.getSOAPConstants().getFaultNodeQName());
        return se == null ? null : se.getValue();
    }

    public void setFaultNode(String uri) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setFaultNode(String)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setFaultNode(String)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            fault.setSOAP12_Node(uri);
        } else {
            QName faultNodeQName = this.soapFactory.getSOAPConstants().getFaultNodeQName();
            SOAPElement se = this._getChildElement(faultNodeQName);
            if (se != null) {
                se.detachNode();
            }
            se = this.createChildElement(faultNodeQName);
            se = this.addChild(se);
            se.addTextNode(uri);
        }
    }

    public String getFaultRole() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getFaultRole()", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getFaultRole()", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            return fault.getFaultActor();
        }
        SOAPElement se = this._getChildElement(this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName());
        return se == null ? null : se.getValue();
    }

    public void setFaultRole(String uri) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setFaultRole(String)", "javax.xml.soap.Fault"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setFaultRole(String)", "javax.xml.soap.Fault", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        if (this._getFault() != null) {
            WebServicesFault fault = this._getFault();
            fault.setFaultActor(uri);
        } else {
            QName faultRoleQName = this.soapFactory.getSOAPConstants().getFaultActorOrRoleQName();
            SOAPElement se = this._getChildElement(faultRoleQName);
            if (se != null) {
                se.detachNode();
            }
            se = this.createChildElement(faultRoleQName);
            se = this.addChild(se);
            se.addTextNode(uri);
        }
    }

    public boolean hasDetail() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "hasDetail()", "javax.xml.soap.Fault"));
        }
        return this.getDetail() != null;
    }

    private Locale getLocale(String value) {
        Locale locale = null;
        locale = value == null || value.length() == 0 ? Locale.getDefault() : this.xmlLangToLocale(value);
        return locale;
    }

    private Locale xmlLangToLocale(String xmlLang) {
        if (xmlLang == null || xmlLang.equals("")) {
            return null;
        }
        Locale locale = null;
        int hyphenIndx = xmlLang.indexOf(45);
        if (hyphenIndx < 0) {
            locale = new Locale(xmlLang);
        } else {
            String lang = xmlLang.substring(0, hyphenIndx);
            String countryCode = xmlLang.substring(hyphenIndx + 1);
            locale = new Locale(lang, countryCode);
        }
        return locale;
    }

    private String localeToXmlLang(Locale locale) {
        String lang = locale.getLanguage();
        String countryCode = locale.getCountry();
        if (countryCode == null || countryCode.length() == 0) {
            return lang;
        }
        return new String(lang + "-" + countryCode);
    }

    private boolean isMatchingLocale(String langValue, Locale locale) {
        Locale locale2 = this.getLocale(langValue);
        return locale2.getLanguage().equals(locale.getLanguage()) && locale2.getCountry().equals(locale.getCountry());
    }

    private SOAPElement addChild(SOAPElement element) {
        SOAPConstants sc = this.soapFactory.getSOAPConstants();
        if (!this.isSOAP12()) {
            if (element.getLocalName().equals(sc.getFaultCodeQName().getLocalPart())) {
                return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), this.getFirstChild()));
            }
            if (element.getLocalName().equals(sc.getFaultStringOrReasonQName().getLocalPart())) {
                SOAPElement ref = this._getChildElement(sc.getFaultActorOrRoleQName());
                if (ref == null) {
                    ref = this._getChildElement(sc.getFaultDetailQName());
                }
                return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), (Node)((Object)ref)));
            }
            if (element.getLocalName().equals(sc.getFaultActorOrRoleQName().getLocalPart())) {
                SOAPElement ref = this._getChildElement(sc.getFaultDetailQName());
                return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), (Node)((Object)ref)));
            }
            return (SOAPElement)((Object)this.appendChild((Node)((Object)element)));
        }
        if (element.getLocalName().equals(sc.getFaultCodeQName().getLocalPart())) {
            return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), this.getFirstChild()));
        }
        if (element.getLocalName().equals(sc.getFaultStringOrReasonQName().getLocalPart())) {
            SOAPElement ref = this._getChildElement(sc.getFaultNodeQName());
            if (ref == null) {
                ref = this._getChildElement(sc.getFaultActorOrRoleQName());
            }
            if (ref == null) {
                ref = this._getChildElement(sc.getFaultDetailQName());
            }
            return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), (Node)((Object)ref)));
        }
        if (element.getLocalName().equals(sc.getFaultNodeQName().getLocalPart())) {
            SOAPElement ref = this._getChildElement(sc.getFaultActorOrRoleQName());
            if (ref == null) {
                ref = this._getChildElement(sc.getFaultDetailQName());
            }
            return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), (Node)((Object)ref)));
        }
        if (element.getLocalName().equals(sc.getFaultActorOrRoleQName().getLocalPart())) {
            SOAPElement ref = this._getChildElement(sc.getFaultDetailQName());
            return (SOAPElement)((Object)this.insertBefore((Node)((Object)element), (Node)((Object)ref)));
        }
        return (SOAPElement)((Object)this.appendChild((Node)((Object)element)));
    }

    public javax.xml.soap.SOAPElement setElementQName(QName newQName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.SOAPFault"));
        }
        if (!newQName.getNamespaceURI().equals(this.getNamespaceURI()) || !newQName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.SOAPFault"));
        }
        return super.setElementQName(newQName);
    }

    class CE_Iterator
    implements Iterator {
        Node parent;
        Node prev;
        boolean first = true;
        boolean safeRemove = false;
        String ns = null;
        String localPart = null;
        String methodName = null;
        boolean elementsOnly = false;

        CE_Iterator(Node parent, boolean elementsOnly, String methodName) {
            this.parent = parent;
            this.methodName = methodName;
            parent.normalize();
            this.elementsOnly = elementsOnly;
            this.prev = parent;
        }

        CE_Iterator(Node parent, String ns, String localPart, String methodName) {
            this.parent = parent;
            this.methodName = methodName;
            parent.normalize();
            this.prev = parent;
            this.ns = ns;
            this.localPart = localPart;
            this.elementsOnly = true;
        }

        public boolean hasNext() {
            Node node = this.getNext();
            return node != null;
        }

        public Object next() {
            Node node = this.getNext();
            if (node == null) {
                throw new NoSuchElementException(Messages.getMessage("exception00"));
            }
            this.safeRemove = true;
            this.first = false;
            this.prev = node;
            return node;
        }

        public void remove() {
            if (!this.safeRemove || this.prev == null) {
                throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
            }
            this.safeRemove = false;
            Node se = this.getPrev();
            this.parent.removeChild(this.prev);
            if (se == null) {
                this.first = true;
                this.prev = this.parent;
            } else {
                this.prev = se;
            }
        }

        private Node getNext() {
            Node node = null;
            if (this.prev == null) {
                return node;
            }
            for (node = this.first ? this.prev.getFirstChild() : this.prev.getNextSibling(); node != null && !this.match(node); node = node.getNextSibling()) {
            }
            return node;
        }

        private Node getPrev() {
            Node node = null;
            if (this.prev == null) {
                return node;
            }
            for (node = this.prev.getPreviousSibling(); node != null && !this.match(node); node = node.getPreviousSibling()) {
            }
            return node;
        }

        protected boolean match(Node node) {
            if (this.localPart == null) {
                return !this.elementsOnly || node instanceof Element;
            }
            String localName = node.getLocalName();
            if (localName == null) {
                localName = SOAPElement.extractLocalNameFromQName(node.getNodeName());
            }
            if (!this.localPart.equals(localName)) {
                return false;
            }
            String namespace = node.getNamespaceURI();
            return this.ns.equals(namespace) || this.ns.length() == 0 && namespace == null;
        }
    }

    private abstract class NodeIteratorFilter
    implements Iterator {
        public Iterator nodeIterator;
        private String methodName;

        public NodeIteratorFilter(Iterator nodeIterator, String methodName) {
            this.nodeIterator = nodeIterator;
            this.methodName = methodName;
        }

        public boolean hasNext() {
            return this.nodeIterator.hasNext();
        }

        public Object next() {
            return this.getObject((Node)this.nodeIterator.next());
        }

        public void remove() {
            throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
        }

        protected abstract Object getObject(Node var1);
    }

    private class NestedNodeIterator
    implements Iterator {
        Node curr = null;
        QName nestedQName;
        String methodName;

        public NestedNodeIterator(Node root, QName nestedQName, String methodName) {
            this.curr = root;
            this.nestedQName = nestedQName;
            this.methodName = methodName;
        }

        public boolean hasNext() {
            return this.getNext(this.curr) != null;
        }

        public Object next() {
            this.curr = this.getNext(this.curr);
            return this.curr;
        }

        public void remove() {
            throw new IllegalStateException(Messages.getMessage("unsupportedIteratorRemove", this.methodName));
        }

        private Node getNext(Node node) {
            if (node == null) {
                return null;
            }
            Node next = null;
            for (next = node.getFirstChild(); next != null; next = next.getNextSibling()) {
                if (!(next instanceof Element) || !next.getNamespaceURI().equals(this.nestedQName.getNamespaceURI()) || !next.getLocalName().equals(this.nestedQName.getLocalPart())) continue;
                return next;
            }
            return next;
        }
    }
}

