/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMDetail;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.DetailEntry;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFaultElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultDetailsBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Node;

public final class Detail
extends SOAPFaultElement
implements IBMDetail {
    Detail(SOAPFactory soapFactory) {
        super(soapFactory.getSOAPConstants().getFaultDetailQName().getNamespaceURI(), soapFactory.getSOAPConstants().getFaultDetailQName().getLocalPart(), soapFactory);
    }

    public javax.xml.soap.DetailEntry addDetailEntry(Name name) throws SOAPException {
        DetailEntry entry = this.getSOAPFactory().createDetailEntry(name.getURI(), name.getLocalName());
        entry.setPrefix(name.getPrefix());
        this.addChildElement(entry);
        return entry;
    }

    public Iterator getDetailEntries() {
        Iterator it = this.getChildElements();
        ArrayList childDEs = new ArrayList();
        while (it != null && it.hasNext()) {
            Object childDE = it.next();
            if (!(childDE instanceof DetailEntry)) continue;
            childDEs.add(childDE);
        }
        return childDEs.iterator();
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPFaultDetailsBuilder();
    }

    protected SOAPElement createChildElement(String namespaceURI, String localPart, SOAPFactory factory) throws SOAPException {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return new DetailEntry(null, localPart, factory);
        }
        return new DetailEntry(namespaceURI, localPart, factory);
    }

    protected boolean isValidSAAJChild(Node node) {
        Class<?> cls = node.getClass();
        return (cls.equals(DetailEntry.class) || cls.equals(Text.class) || cls.equals(Comment.class) || cls.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public javax.xml.soap.DetailEntry addDetailEntry(QName qName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "addDetailEntry(QName)", "javax.xml.soap.Detail"));
        }
        DetailEntry entry = this.getSOAPFactory().createDetailEntry(qName.getNamespaceURI(), qName.getLocalPart());
        entry.setPrefix(qName.getPrefix());
        this.addChildElement(entry);
        return entry;
    }

    public javax.xml.soap.SOAPElement addTextNode(String text) throws SOAPException {
        if (this.isSOAP12() && !XMLUtils.isXMLWhitespace(text)) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "addTextNode(String)", "javax.xml.soap.Detail"));
        }
        return super.addTextNode(text);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (this.isSOAP12()) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setEncodingStyle(String)", "javax.xml.soap.Detail"));
        }
        super.setEncodingStyle(encodingStyle);
    }

    public javax.xml.soap.SOAPElement setElementQName(QName newQName) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setElementQName(QName)", "javax.xml.soap.Detail"));
        }
        if (!newQName.getNamespaceURI().equals(this.getNamespaceURI()) || !newQName.getLocalPart().equals(this.getLocalName())) {
            throw new SOAPException(Messages.getMessage("unsupportedSAAJMethod", "setElementQName(QName)", "javax.xml.soap.Detail"));
        }
        return super.setElementQName(newQName);
    }
}

