/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Base64;
import com.ibm.ws.webservices.engine.utils.DOM2Writer;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.WebServicesParserFactory;
import com.ibm.ws.webservices.engine.utils.XMLChar;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    protected static Log log = LogFactory.getLog(XMLUtils.class.getName());
    public static final String charEncoding = "ISO-8859-1";
    private static DocumentBuilderFactory dbf = XMLUtils.getDOMFactory();
    private static byte[] encodeTable = new byte[128];
    private static final char[] ReplacementText1;
    private static final char[] ReplacementText2;
    private static final char[] ReplacementText3;
    private static final char[] ReplacementText4;
    private static final char[] ReplacementText5;
    private static final char[] ReplacementText6;
    private static final char[] ReplacementText7;
    private static final char[] ReplacementText8;
    private static final char[][] replacementTextTable;
    private static final char[] nums;
    static WebServicesParserFactory parserFactory;
    private static long timeout;
    private static int retry;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler;

    private static char[] expandCharArray(char[] chars, int required) {
        char[] charNew = new char[Math.max(chars.length * 2, required)];
        System.arraycopy(chars, 0, charNew, 0, chars.length);
        return charNew;
    }

    public static String xmlEncodeString(String orig) {
        if (orig == null) {
            return "";
        }
        return XMLUtils.xmlEncodeString(orig, new char[orig.length() * 2]);
    }

    public static String xmlEncodeString(String orig, char[] workBuf) {
        char ch;
        int idx;
        if (orig == null) {
            return "";
        }
        int ch_length = orig.length();
        byte[] specialTab = encodeTable;
        for (idx = 0; idx < ch_length && (ch = orig.charAt(idx)) <= '\u007f' && specialTab[ch] <= 0; ++idx) {
        }
        if (idx == ch_length) {
            return orig;
        }
        return XMLUtils._xmlEncodeString(orig.toCharArray(), idx, workBuf);
    }

    private static String _xmlEncodeString(char[] orig, int i, char[] workBuf) {
        int orig_length = orig.length;
        int ch_pos = i;
        byte x = 0;
        int work_pos = 0;
        int len = 0;
        int LEN = 11;
        char[] ch_num = new char[11];
        if (i > 0) {
            System.arraycopy(orig, 0, workBuf, 0, i);
            work_pos += i;
        }
        String cte = (String)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.contentTransferEncoding");
        boolean CTE_binary = cte.equalsIgnoreCase("binary");
        boolean CTE_8bit = cte.equalsIgnoreCase("8bit");
        if (log.isDebugEnabled()) {
            log.debug("CTE_binary: " + CTE_binary + "  CTE_8bit: " + CTE_8bit);
        }
        while (i < orig_length) {
            char c = orig[i];
            x = c > '\u007f' ? (CTE_binary ? (byte)0 : (CTE_8bit ? (c > '\u00ff' ? (byte)1 : 0) : (byte)1)) : encodeTable[c];
            if (x > 0) {
                if (ch_pos < i) {
                    len = i - ch_pos;
                    if (workBuf.length < work_pos + len) {
                        workBuf = XMLUtils.expandCharArray(workBuf, work_pos + len);
                    }
                    System.arraycopy(orig, ch_pos, workBuf, work_pos, len);
                    work_pos += len;
                }
                ch_pos = i + 1;
                if (x == 1) {
                    ch_num[10] = 59;
                    int ch_num_i = 10;
                    int rem = 0;
                    int quot = orig[i];
                    if (XMLChar.isHighSurrogate(orig[i])) {
                        if (i + 1 < orig_length && XMLChar.isLowSurrogate(orig[i + 1])) {
                            quot = XMLChar.supplemental(orig[i], orig[i + 1]);
                            ++i;
                            ++ch_pos;
                        } else if (log.isDebugEnabled()) {
                            log.debug("XML high surrogate [" + orig[i] + "] not followed by low surrogate [" + orig[i + 1] + "]");
                        }
                    }
                    while (quot > 0) {
                        rem = quot % 10;
                        ch_num[--ch_num_i] = nums[rem];
                        quot /= 10;
                    }
                    if (orig[i] < '\n') {
                        ch_num[--ch_num_i] = 48;
                    }
                    ch_num[--ch_num_i] = 35;
                    ch_num[--ch_num_i] = 38;
                    len = 11 - ch_num_i;
                    if (workBuf.length < work_pos + len) {
                        workBuf = XMLUtils.expandCharArray(workBuf, work_pos + len);
                    }
                    System.arraycopy(ch_num, ch_num_i, workBuf, work_pos, len);
                    work_pos += len;
                } else {
                    len = replacementTextTable[x].length;
                    if (workBuf.length < work_pos + len) {
                        workBuf = XMLUtils.expandCharArray(workBuf, work_pos + len);
                    }
                    System.arraycopy(replacementTextTable[x], 0, workBuf, work_pos, len);
                    work_pos += len;
                }
            }
            ++i;
        }
        if (ch_pos < i) {
            len = i - ch_pos;
            if (workBuf.length < work_pos + len) {
                workBuf = XMLUtils.expandCharArray(workBuf, work_pos + len);
            }
            System.arraycopy(orig, ch_pos, workBuf, work_pos, len);
            work_pos += len;
        }
        return new String(workBuf, 0, work_pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParserFactory initSAXFactory(boolean namespaceAware, boolean validating) {
        if (parserFactory != null) {
            return parserFactory;
        }
        WebServicesParserFactory webServicesParserFactory = parserFactory = (WebServicesParserFactory)WebServicesParserFactory.newInstance();
        synchronized (webServicesParserFactory) {
            parserFactory.setNamespaceAware(namespaceAware);
            parserFactory.setValidating(validating);
        }
        return parserFactory;
    }

    private static DocumentBuilderFactory getDOMFactory() {
        DocumentBuilderFactory dbf;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.getDOMFactory", "254");
            log.error(Messages.getMessage("exception00"), e);
            dbf = null;
        }
        return dbf;
    }

    public static synchronized SAXParser getSAXParser() {
        try {
            SAXParserFactory saxFactory = XMLUtils.initSAXFactory(true, false);
            SAXParser parser = saxFactory.newSAXParser();
            return parser;
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.getSAXParser", "282");
            log.error(Messages.getMessage("parserConfigurationException00", e.toString()));
            return null;
        }
        catch (SAXException se) {
            FFDCFilter.processException(se, "com.ibm.ws.webservices.engine.utils.XMLUtils.getSAXParser", "286");
            log.error(Messages.getMessage("SAXException00", se.toString()));
            return null;
        }
    }

    public static void releaseSAXParser(SAXParser parser) {
        if (parser instanceof WebServicesParser) {
            ((WebServicesParser)parser).recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            return dbf.newDocumentBuilder().newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(InputSource inp) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db;
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            db = dbf.newDocumentBuilder();
        }
        db.setErrorHandler(new ParserErrorHandler());
        return db.parse(inp);
    }

    public static Document newDocument(InputStream inp) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(new InputSource(inp));
    }

    public static Document newDocument(String uri) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(uri, null, null);
    }

    public static Document newDocument(String uri, String username, String password) throws ParserConfigurationException, SAXException, IOException {
        InputSource ins = XMLUtils.getInputSourceFromURI(uri, username, password);
        Document doc = XMLUtils.newDocument(ins);
        if (ins.getByteStream() != null) {
            ins.getByteStream().close();
        } else if (ins.getCharacterStream() != null) {
            ins.getCharacterStream().close();
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(InputSource inp, final ImportResolver resolver2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db;
        if (resolver2 == null) {
            return XMLUtils.newDocument(inp);
        }
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            db = dbf.newDocumentBuilder();
        }
        db.setErrorHandler(new ParserErrorHandler());
        db.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputStream stream = resolver2.resolve(systemId);
                if (stream != null) {
                    InputSource source = new InputSource(stream);
                    source.setSystemId(systemId);
                    return source;
                }
                return null;
            }
        });
        return db.parse(inp);
    }

    private static String privateElementToString(Element element, boolean omitXMLDecl) {
        return DOM2Writer.nodeToString(element, omitXMLDecl);
    }

    public static String ElementToString(Element element) {
        return XMLUtils.privateElementToString(element, true);
    }

    public static String DocumentToString(Document doc) {
        return XMLUtils.privateElementToString(doc.getDocumentElement(), false);
    }

    public static void privateElementToWriter(Element element, Writer writer, boolean omitXMLDecl, boolean pretty) {
        DOM2Writer.serializeAsXML(element, writer, omitXMLDecl, pretty);
    }

    public static void ElementToStream(Element element, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToStream(Element element, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void ElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void DocumentToStream(Document doc, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToStream(Document doc, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, true);
    }

    public static void DocumentToWriter(Document doc, Writer writer) {
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToWriter(Document doc, Writer writer) {
        XMLUtils.privateElementToWriter(doc.getDocumentElement(), writer, false, true);
    }

    public static Element StringToElement(String namespace, String name, String string) {
        try {
            Document doc = XMLUtils.newDocument();
            Element element = doc.createElementNS(namespace, name);
            Text text = doc.createTextNode(string);
            element.appendChild(text);
            return element;
        }
        catch (ParserConfigurationException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.StringToElement", "475");
            throw new InternalException(e);
        }
    }

    public static String getInnerXMLString(Element element) {
        String elementString = XMLUtils.ElementToString(element);
        int start = elementString.indexOf(">") + 1;
        int end = elementString.lastIndexOf("</");
        if (end > 0) {
            return elementString.substring(start, end);
        }
        return null;
    }

    public static String getPrefix(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring(6);
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = ((Element)e).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns = XMLUtils.getNamespace(prefix, e);
            if (ns == null) {
                return null;
            }
            return QNameTable.createQName(ns, str.substring(idx + 1));
        }
        return QNameTable.createQName("", str);
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        for (Node tempNode = parentEl.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
        }
        return strBuf.toString();
    }

    public static InputSource getInputSourceFromURI(String uri) {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (Exception e) {
            try {
                File file = new File(uri);
                return new InputSource(new FileInputStream(file));
            }
            catch (Exception e2) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.getInputSourceFromURI", "763");
                log.error(Messages.getMessage("exception00"), e);
                return new InputSource(uri);
            }
        }
        return new InputSource(uri);
    }

    public static InputSource sourceToInputSource(Source source) {
        if (source instanceof SAXSource) {
            return ((SAXSource)source).getInputSource();
        }
        if (source instanceof DOMSource) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            Element domElement = (Element)node;
            XMLUtils.ElementToStream(domElement, baos);
            InputSource isource = new InputSource(source.getSystemId());
            isource.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
            return isource;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            InputSource isource = new InputSource(ss.getSystemId());
            isource.setByteStream(ss.getInputStream());
            isource.setCharacterStream(ss.getReader());
            isource.setPublicId(ss.getPublicId());
            return isource;
        }
        return XMLUtils.getInputSourceFromURI(source.getSystemId());
    }

    public static InputSource getInputSourceFromURI(String uri, String username, String password) throws IOException, ProtocolException, UnsupportedEncodingException {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (Exception e) {
            try {
                File file = new File(uri);
                return new InputSource(new FileInputStream(file));
            }
            catch (Exception e2) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.getInputSourceFromURI", "835");
                log.error(Messages.getMessage("exception00"), e);
                return new InputSource(uri);
            }
        }
        if (username == null && url.getUserInfo() == null) {
            return new InputSource(uri);
        }
        if (!url.getProtocol().startsWith("http")) {
            return new InputSource(uri);
        }
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return new InputSource(uri);
        }
        HttpURLConnection uconn = (HttpURLConnection)connection;
        String userinfo = url.getUserInfo();
        uconn.setRequestMethod("GET");
        uconn.setAllowUserInteraction(false);
        uconn.setDefaultUseCaches(false);
        uconn.setDoInput(true);
        uconn.setDoOutput(false);
        uconn.setInstanceFollowRedirects(true);
        uconn.setUseCaches(false);
        String auth = null;
        if (userinfo != null) {
            auth = userinfo;
        } else if (username != null) {
            String string = auth = password == null ? username : username + ":" + password;
        }
        if (auth != null) {
            uconn.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(auth.getBytes(charEncoding)));
        }
        String proxyUserName = null;
        String proxyPassword = null;
        boolean proxyEnabled = false;
        if (uri.startsWith("https")) {
            proxyUserName = System.getProperty("https.proxyUserName");
            proxyPassword = System.getProperty("https.proxyPassword");
            proxyEnabled = true;
        } else if (uri.startsWith("http")) {
            proxyUserName = System.getProperty("http.proxyUserName");
            proxyPassword = System.getProperty("http.proxyPassword");
            proxyEnabled = true;
        }
        if (proxyEnabled) {
            String encoded = new String(Base64.encode(new String(proxyUserName + ":" + proxyPassword).getBytes()));
            uconn.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        }
        uconn.connect();
        return new InputSource(uconn.getInputStream());
    }

    public static final String base64encode(byte[] bytes) {
        return new String(Base64.encode(bytes));
    }

    public static boolean isXMLWhitespace(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (XMLChar.isSpace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Document newDocument(InputSource inp, ImportResolver w2jResolver, int nRetry, long nTimeout) throws ParserConfigurationException, SAXException, IOException {
        retry = nRetry > -1 ? nRetry : retry;
        timeout = nTimeout > -2L ? nTimeout : timeout;
        return XMLUtils.retrieveNewDocument(inp, w2jResolver, retry);
    }

    public static Document newDocument(String uri, String username, String password, int nRetry, long nTimeout) throws ParserConfigurationException, SAXException, IOException {
        Document doc;
        retry = nRetry > -1 ? nRetry : retry;
        long l = timeout = nTimeout > -2L ? nTimeout : timeout;
        if (uri.startsWith("file:") || uri.indexOf(58) == -1) {
            doc = XMLUtils.newDocument(uri, username, password);
        } else {
            InputSource ins = XMLUtils.getInputSourceFromURI(uri, username, password);
            ins.setSystemId(uri);
            doc = XMLUtils.newDocument(ins, null, retry, timeout);
            if (ins.getByteStream() != null) {
                ins.getByteStream().close();
            } else if (ins.getCharacterStream() != null) {
                ins.getCharacterStream().close();
            }
        }
        return doc;
    }

    private static Document retrieveNewDocument(InputSource inp, ImportResolver w2jResolver, int atry) throws ParserConfigurationException, SAXException, IOException {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("w2j.LoadingURL", inp.getSystemId(), String.valueOf(retry - atry + 1)));
        }
        try {
            return XMLUtils.retrieveNewDocument(inp, w2jResolver);
        }
        catch (IOException e) {
            if (atry > 0 && e.getMessage().indexOf("timed out") > -1) {
                return XMLUtils.retrieveNewDocument(inp, w2jResolver, --atry);
            }
            throw e;
        }
    }

    private static Document retrieveNewDocument(InputSource inp, ImportResolver w2jResolver) throws ParserConfigurationException, SAXException, IOException {
        ResolverRunnable runnable = new ResolverRunnable(inp, w2jResolver);
        Thread resolverThread = new Thread(runnable);
        resolverThread.start();
        long time = System.currentTimeMillis();
        try {
            if (timeout > 0L) {
                resolverThread.join(timeout);
            } else {
                resolverThread.join();
            }
        }
        catch (InterruptedException e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.retrieveNewDocument", "1013");
        }
        if (resolverThread.isAlive()) {
            resolverThread.interrupt();
            throw new IOException(Messages.getMessage("timedOut", inp.getSystemId()));
        }
        Exception e = runnable.getFailure();
        if (e != null) {
            if (e instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)e;
            }
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("timeToLoadFile00", inp.getSystemId(), String.valueOf(System.currentTimeMillis() - time)));
        }
        return runnable.getDoc();
    }

    static {
        XMLUtils.encodeTable[0] = 2;
        XMLUtils.encodeTable[12] = 1;
        XMLUtils.encodeTable[11] = 1;
        XMLUtils.encodeTable[8] = 1;
        XMLUtils.encodeTable[7] = 1;
        XMLUtils.encodeTable[6] = 1;
        XMLUtils.encodeTable[5] = 1;
        XMLUtils.encodeTable[4] = 1;
        XMLUtils.encodeTable[3] = 1;
        XMLUtils.encodeTable[2] = 1;
        XMLUtils.encodeTable[1] = 1;
        XMLUtils.encodeTable[13] = 3;
        XMLUtils.encodeTable[31] = 1;
        XMLUtils.encodeTable[30] = 1;
        XMLUtils.encodeTable[29] = 1;
        XMLUtils.encodeTable[28] = 1;
        XMLUtils.encodeTable[27] = 1;
        XMLUtils.encodeTable[26] = 1;
        XMLUtils.encodeTable[25] = 1;
        XMLUtils.encodeTable[24] = 1;
        XMLUtils.encodeTable[23] = 1;
        XMLUtils.encodeTable[22] = 1;
        XMLUtils.encodeTable[21] = 1;
        XMLUtils.encodeTable[20] = 1;
        XMLUtils.encodeTable[19] = 1;
        XMLUtils.encodeTable[18] = 1;
        XMLUtils.encodeTable[17] = 1;
        XMLUtils.encodeTable[16] = 1;
        XMLUtils.encodeTable[15] = 1;
        XMLUtils.encodeTable[14] = 1;
        XMLUtils.encodeTable[34] = 4;
        XMLUtils.encodeTable[38] = 5;
        XMLUtils.encodeTable[39] = 6;
        XMLUtils.encodeTable[60] = 7;
        XMLUtils.encodeTable[62] = 8;
        ReplacementText1 = new char[]{'&', '#'};
        ReplacementText2 = new char[]{'&', '#', '0', ';'};
        ReplacementText3 = new char[]{'&', '#', 'x', 'd', ';'};
        ReplacementText4 = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        ReplacementText5 = new char[]{'&', 'a', 'm', 'p', ';'};
        ReplacementText6 = new char[]{'&', 'a', 'p', 'o', 's', ';'};
        ReplacementText7 = new char[]{'&', 'l', 't', ';'};
        ReplacementText8 = new char[]{'&', 'g', 't', ';'};
        replacementTextTable = new char[][]{null, ReplacementText1, ReplacementText2, ReplacementText3, ReplacementText4, ReplacementText5, ReplacementText6, ReplacementText7, ReplacementText8};
        nums = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        parserFactory = null;
        timeout = 45000L;
        retry = 0;
    }

    private static class ResolverRunnable
    implements Runnable {
        private InputSource inp;
        private ImportResolver w2jResolver;
        private Document doc = null;
        private Exception failure = null;

        public ResolverRunnable(InputSource nInp, ImportResolver nW2JResolver) {
            this.inp = nInp;
            this.w2jResolver = nW2JResolver;
        }

        public void run() {
            try {
                this.doc = XMLUtils.newDocument(this.inp, this.w2jResolver);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.XMLUtils.ResolverHelper.run", "1059");
                this.failure = e;
            }
        }

        public Exception getFailure() {
            return this.failure;
        }

        public Document getDoc() {
            return this.doc;
        }
    }

    public static class ParserErrorHandler
    implements ErrorHandler {
        protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler == null ? (class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler = XMLUtils.class$("com.ibm.ws.webservices.engine.utils.XMLUtils$ParserErrorHandler")) : class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler).getName());

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("warning00", this.getParseExceptionInfo(spe)));
            }
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

