/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.commons.logging.Log;

public class SessionUtils {
    protected static Log log = LogFactory.getLog(SessionUtils.class.getName());
    protected static Random random = null;
    protected static String randomClass = "java.security.SecureRandom";
    private static String thisHost = null;
    private static int count = (int)(Math.random() * 100.0);

    public static synchronized String generateSessionId() {
        return SessionUtils.getEntropy();
    }

    public static synchronized Long generateSession() {
        return new Long(SessionUtils.getRandom().nextLong());
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(randomClass);
                random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = SessionUtils.getEntropy().toCharArray();
                for (int i = 0; i < entropy.length; ++i) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                }
                random.setSeed(seed);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.SessionUtils.getRandom", "202");
                random = new Random();
            }
        }
        return random;
    }

    private static String getEntropy() {
        if (null == thisHost) {
            try {
                thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.SessionUtils.getEntropy", "219");
                log.error(Messages.getMessage("javaNetUnknownHostException00"), e);
                thisHost = "localhost";
            }
        }
        StringBuffer s = new StringBuffer();
        s.append(++count).append(s.hashCode()).append('.').append(System.currentTimeMillis()).append(".IBM.WEBSERVICES@").append(thisHost);
        return s.toString();
    }
}

