/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.types.NonPositiveInteger;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;

public class NegativeInteger
extends NonPositiveInteger
implements Serializable {
    private BigInteger zero = new BigInteger("0");

    public NegativeInteger(byte[] val) {
        super(val);
        this.checkValidity();
    }

    public NegativeInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
        this.checkValidity();
    }

    public NegativeInteger(int bitLength, int certainty, Random rnd) {
        super(bitLength, certainty, rnd);
        this.checkValidity();
    }

    public NegativeInteger(int numBits, Random rnd) {
        super(numBits, rnd);
        this.checkValidity();
    }

    public NegativeInteger(String val) {
        super(val);
        this.checkValidity();
    }

    public NegativeInteger(String val, int radix) {
        super(val, radix);
        this.checkValidity();
    }

    private void checkValidity() {
        if (this.compareTo(this.zero) >= 0) {
            throw new NumberFormatException(Messages.getMessage("badnegInt00", this.toString()));
        }
    }
}

