/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.encoding.Base64;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.http.NonBlockingBufferedInputStream;
import com.ibm.ws.webservices.engine.transport.http.SimpleServerEngine;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.xml.soap.SOAPElement;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class SimpleWebServicesWorker
implements Runnable {
    protected static Log log = LogFactory.getLog(SimpleWebServicesWorker.class.getName());
    private SimpleServerEngine server;
    private Socket socket;
    private static String transportName = "SimpleHTTP";
    private static byte[] OK = ("200 " + Messages.getMessage("ok00")).getBytes();
    private static byte[] UNAUTH = ("401 " + Messages.getMessage("unauth00")).getBytes();
    private static byte[] ISE = ("500 " + Messages.getMessage("internalError01")).getBytes();
    private static byte[] HTTP = "HTTP/1.0 ".getBytes();
    private static byte[] XML_MIME_STUFF = "\r\nContent-Type: text/xml; charset=utf-8\r\nContent-Length: ".getBytes();
    private static byte[] HTML_MIME_STUFF = "\r\nContent-Type: text/html; charset=utf-8\r\nContent-Length: ".getBytes();
    private static byte[] SEPARATOR = "\r\n\r\n".getBytes();
    private static final String responseStr = "<html><head><title>SimpleServerEngine</title></head><body><h1>SimpleServerEngine</h1>" + Messages.getMessage("reachedServer00") + "</html>";
    private static byte[] cannedHTMLResponse = responseStr.getBytes();
    private static final byte[] toLower = new byte[256];
    private static final int BUFSIZ = 4096;
    private static final byte[] lenHeader;
    private static final int lenLen;
    private static final byte[] typeHeader;
    private static final int typeLen;
    private static final byte[] locationHeader;
    private static final int locationLen;
    private static final byte[] actionHeader;
    private static final int actionLen;
    private static final byte[] trimmedActionHeader;
    private static final byte[] cookieHeader;
    private static final int cookieLen;
    private static final byte[] cookie2Header;
    private static final int cookie2Len;
    private static final byte[] authHeader;
    private static final int authLen;
    private static final byte[] getHeader;
    private static final byte[] postHeader;
    private static final byte[] headerEnder;
    private static final byte[] basicAuth;

    public SimpleWebServicesWorker(SimpleServerEngine server, Socket socket) {
        this.server = server;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block57: {
            block56: {
                block55: {
                    block54: {
                        buf = new byte[4096];
                        v0 = this;
                        engine = v0.server.getServerEngine();
                        msgContext = new MessageContext(engine);
                        is = new NonBlockingBufferedInputStream();
                        soapAction = new StringBuffer();
                        httpRequest = new StringBuffer();
                        fileName = new StringBuffer();
                        cookie = new StringBuffer();
                        cookie2 = new StringBuffer();
                        authInfo = new StringBuffer();
                        contentType = new StringBuffer();
                        contentLocation = new StringBuffer();
                        responseMsg = null;
                        try {
                            msgContext.setTargetPort(null);
                        }
                        catch (WebServicesFault fault) {
                            // empty catch block
                        }
                        msgContext.setResponseMessage(null);
                        msgContext.setTransportName(SimpleWebServicesWorker.transportName);
                        try {
                            try {
                                block53: {
                                    status = SimpleWebServicesWorker.OK;
                                    doWsdl = false;
                                    cooky = null;
                                    try {
                                        if (this.server.isSessionUsed()) {
                                            cookie.delete(0, cookie.length());
                                            cookie2.delete(0, cookie2.length());
                                        }
                                        authInfo.delete(0, authInfo.length());
                                        is.setInputStream(this.socket.getInputStream());
                                        contentLength = this.parseHeaders(is, buf, contentType, contentLocation, soapAction, httpRequest, fileName, cookie, cookie2, authInfo);
                                        is.setContentLength(contentLength);
                                        paramIdx = fileName.toString().indexOf(63);
                                        if (paramIdx != -1) {
                                            params = fileName.substring(paramIdx + 1);
                                            fileName.setLength(paramIdx);
                                            if (SimpleWebServicesWorker.log.isDebugEnabled()) {
                                                SimpleWebServicesWorker.log.debug(Messages.getMessage("filename00", fileName.toString()));
                                                SimpleWebServicesWorker.log.debug(Messages.getMessage("params00", params));
                                            }
                                            if ("wsdl".equalsIgnoreCase(params)) {
                                                doWsdl = true;
                                            }
                                        }
                                        msgContext.setProperty("realpath", fileName.toString());
                                        msgContext.setProperty("path", fileName.toString());
                                        msgContext.setProperty("jws.classDir", "jwsClasses");
                                        url = "http://" + SimpleWebServicesWorker.getLocalHost() + ":" + this.server.getServerSocket().getLocalPort() + "/" + fileName.toString();
                                        msgContext.setProperty(MessageContext.TRANS_URL, url);
                                        filePart = fileName.toString();
                                        prefix = "web/services/";
                                        if (filePart.startsWith(prefix)) {
                                            msgContext.setTargetPort(filePart.substring(prefix.length()));
                                        }
                                        if (authInfo.length() > 0) {
                                            decoded = Base64.decode(authInfo.toString());
                                            userBuf = new StringBuffer();
                                            pwBuf = new StringBuffer();
                                            authBuf = userBuf;
                                            for (i = 0; i < decoded.length; ++i) {
                                                if ((char)(decoded[i] & 127) == ':') {
                                                    authBuf = pwBuf;
                                                    continue;
                                                }
                                                authBuf.append((char)(decoded[i] & 127));
                                            }
                                            msgContext.setUsername(userBuf.toString());
                                            msgContext.setPassword(pwBuf.toString());
                                        }
                                        if (!httpRequest.toString().equals("GET")) ** GOTO lbl-1000
                                        out = this.socket.getOutputStream();
                                        out.write(SimpleWebServicesWorker.HTTP);
                                        out.write(status);
                                        if (doWsdl) {
                                            engine.generateWSDL(msgContext);
                                            doc = (Document)msgContext.getProperty("WSDL");
                                            if (doc != null) {
                                                response = XMLUtils.DocumentToString(doc);
                                                respBytes = response.getBytes();
                                                out.write(SimpleWebServicesWorker.XML_MIME_STUFF);
                                                this.putInt(buf, out, respBytes.length);
                                                out.write(SimpleWebServicesWorker.SEPARATOR);
                                                out.write(respBytes);
                                                out.flush();
                                            }
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Exception e) {
                                        if (e instanceof WebServicesFault) {
                                            af = (WebServicesFault)e;
                                            if (SimpleWebServicesWorker.log.isDebugEnabled()) {
                                                SimpleWebServicesWorker.log.debug(Messages.getMessage("serverFault00"), af);
                                            }
                                            status = "Server.Unauthorized".equals(af.getFaultCode()) ? SimpleWebServicesWorker.UNAUTH : SimpleWebServicesWorker.ISE;
                                        } else {
                                            status = SimpleWebServicesWorker.ISE;
                                            af = WebServicesFault.makeFault(e);
                                        }
                                        responseMsg = msgContext.getResponseMessage();
                                        if (responseMsg == null) {
                                            responseMsg = new Message(af);
                                            break block53;
                                        } else {
                                            try {
                                                env = responseMsg.getSOAPEnvelope();
                                                env.getSOAPFactory().setProtectState(false);
                                                env.getBody().detachNode();
                                                soapFault = env.getSOAPFactory().createSOAPFault();
                                                soapFault.setFault((WebServicesFault)e);
                                                env.addBody();
                                                env.getBody().addChildElement((SOAPElement)soapFault);
                                            }
                                            catch (WebServicesFault fault) {
                                                FFDCFilter.processException((Throwable)fault, "com.ibm.ws.webservices.engine.transport.http.SimpleWebServicesWorker.run", "464", this);
                                            }
                                        }
                                        break block53;
                                    }
                                    var31_37 = null;
                                    break block54;
lbl-1000:
                                    // 1 sources

                                    {
                                        sb = new StringBuffer();
                                        sb.append("<h2>And now... Some Services</h2>\n");
                                        i = engine.getDeployedPorts();
                                        out.write("<ul>\n".getBytes());
                                        while (i.hasNext()) {
                                            portDesc = (PortDesc)i.next();
                                            sb.append("<li>\n");
                                            sb.append(portDesc.getName());
                                            sb.append(" <a href=\"../services/");
                                            sb.append(portDesc.getName());
                                            sb.append("?wsdl\"><i>(wsdl)</i></a></li>\n");
                                            operations = portDesc.getOperations();
                                            if (operations.isEmpty()) continue;
                                            sb.append("<ul>\n");
                                            it = operations.iterator();
                                            while (it.hasNext()) {
                                                desc = (OperationDesc)it.next();
                                                sb.append("<li>" + desc.getName());
                                            }
                                            sb.append("</ul>\n");
                                        }
                                        sb.append("</ul>\n");
                                        bytes = sb.toString().getBytes();
                                        out.write(SimpleWebServicesWorker.HTML_MIME_STUFF);
                                        this.putInt(buf, out, bytes.length);
                                        out.write(SimpleWebServicesWorker.SEPARATOR);
                                        out.write(bytes);
                                        out.flush();
                                    }
                                    break block55;
lbl-1000:
                                    // 1 sources

                                    {
                                        soapActionString = soapAction.toString();
                                        if (soapActionString != null && soapActionString.length() > 0) {
                                            msgContext.setUseSOAPAction(true);
                                            msgContext.setSOAPActionURI(soapActionString);
                                        } else {
                                            msgContext.setUseSOAPAction(false);
                                            msgContext.setSOAPActionURI(null);
                                        }
                                        requestMsg = new Message((Object)is, contentType.toString(), contentLocation.toString());
                                        msgContext.setRequestMessage(requestMsg);
                                        if (this.server.isSessionUsed()) {
                                            if (cookie.length() > 0) {
                                                cooky = cookie.toString().trim();
                                            } else if (cookie2.length() > 0) {
                                                cooky = cookie2.toString().trim();
                                            }
                                            if (cooky == null) {
                                                i = SimpleServerEngine.sessionIndex++;
                                                cooky = "" + i;
                                            }
                                            msgContext.setSession(this.server.createSession(cooky));
                                        }
                                        engine.invoke(msgContext);
                                        responseMsg = msgContext.getResponseMessage();
                                        if (responseMsg == null) break block53;
                                        responseMsg.ifFaultThrowSelf();
                                    }
                                }
                                out = this.socket.getOutputStream();
                                out.write(SimpleWebServicesWorker.HTTP);
                                out.write(status);
                                if (responseMsg == null) {
                                    content = msgContext.getSOAPConstants().getContentType();
                                    content = content + "charset=" + msgContext.getCharacterEncoding("utf-8");
                                } else {
                                    content = responseMsg.getContentType(msgContext.getSOAPConstants());
                                    content = content + "charset=" + responseMsg.getCharacterEncoding();
                                }
                                out.write(("\r\nContent-Type: " + content).getBytes());
                                if (this.server.isSessionUsed() && null != cooky && 0 != cooky.trim().length()) {
                                    cookieOut = new StringBuffer();
                                    cookieOut.append("\r\nSet-Cookie: ").append(cooky).append("\r\nSet-Cookie2: ").append(cooky);
                                    out.write(cookieOut.toString().getBytes());
                                }
                                out.write(SimpleWebServicesWorker.SEPARATOR);
                                if (responseMsg != null) {
                                    responseMsg.writeTo(out);
                                }
                                out.flush();
                                break block56;
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.SimpleWebServicesWorker.run", "507", this);
                                if (SimpleWebServicesWorker.log.isDebugEnabled()) {
                                    SimpleWebServicesWorker.log.debug(Messages.getMessage("exception00"), e);
                                }
                                var31_40 = null;
                                try {
                                    if (this.socket != null) {
                                        this.socket.close();
                                    }
                                    break block57;
                                }
                                catch (Exception e) {}
                                break block57;
                            }
                        }
                        catch (Throwable var30_50) {
                            var31_41 = null;
                            ** try [egrp 7[TRYBLOCK] [13 : 1628->1645)] { 
lbl220:
                            // 1 sources

                            if (this.socket == null) throw var30_50;
                            this.socket.close();
                            throw var30_50;
lbl223:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            throw var30_50;
                        }
                    }
                    try {}
                    catch (Exception e) {
                        // empty catch block
                        return;
                    }
                    if (this.socket == null) return;
                    this.socket.close();
                    return;
                }
                var31_38 = null;
                try {}
                catch (Exception e) {
                    // empty catch block
                    return;
                }
                if (this.socket == null) return;
                this.socket.close();
                return;
            }
            var31_39 = null;
            try {}
            catch (Exception e) {}
            if (this.socket != null) {
                this.socket.close();
            }
        }
        if (msgContext.getProperty(MessageContext.QUIT_REQUESTED) == null) return;
        try {
            this.server.stop();
            return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private int parseHeaders(NonBlockingBufferedInputStream is, byte[] buf, StringBuffer contentType, StringBuffer contentLocation, StringBuffer soapAction, StringBuffer httpRequest, StringBuffer fileName, StringBuffer cookie, StringBuffer cookie2, StringBuffer authInfo) throws IOException {
        int len = 0;
        int n = this.readLine(is, buf, 0, buf.length);
        if (n < 0) {
            throw new IOException(Messages.getMessage("unexpectedEOS00"));
        }
        httpRequest.delete(0, httpRequest.length());
        fileName.delete(0, fileName.length());
        contentType.delete(0, contentType.length());
        contentLocation.delete(0, contentLocation.length());
        if (buf[0] == getHeader[0]) {
            char c;
            httpRequest.append("GET");
            for (int i = 0; i < n - 5 && (c = (char)(buf[i + 5] & 0x7F)) != ' '; ++i) {
                fileName.append(c);
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("filename01", "SimpleServerEngine", fileName.toString()));
            }
            return 0;
        }
        if (buf[0] == postHeader[0]) {
            char c;
            httpRequest.append("POST");
            for (int i = 0; i < n - 6 && (c = (char)(buf[i + 6] & 0x7F)) != ' '; ++i) {
                fileName.append(c);
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("filename01", "SimpleServerEngine", fileName.toString()));
            }
        } else {
            throw new IOException(Messages.getMessage("badRequest00"));
        }
        while ((n = this.readLine(is, buf, 0, buf.length)) > 0 && (n > 2 || buf[0] != 10 && buf[0] != 13 || len <= 0)) {
            int endHeaderIndex;
            for (endHeaderIndex = 0; endHeaderIndex < n && toLower[buf[endHeaderIndex]] != headerEnder[0]; ++endHeaderIndex) {
            }
            int i = (endHeaderIndex += 2) - 1;
            if (endHeaderIndex == lenLen && this.matches(buf, lenHeader)) {
                while (++i < n && buf[i] >= 48 && buf[i] <= 57) {
                    len = len * 10 + (buf[i] - 48);
                }
                continue;
            }
            if (endHeaderIndex == actionLen && this.matches(buf, trimmedActionHeader)) {
                soapAction.delete(0, soapAction.length());
                if (buf[i + 1] == 34) {
                    ++i;
                }
                while (++i < n && buf[i] != 34 && buf[i] != 13 && buf[i] != 10) {
                    soapAction.append((char)(buf[i] & 0x7F));
                }
                continue;
            }
            if (this.server.isSessionUsed() && endHeaderIndex == cookieLen && this.matches(buf, cookieHeader)) {
                while (++i < n && buf[i] != 59 && buf[i] != 13 && buf[i] != 10) {
                    cookie.append((char)(buf[i] & 0x7F));
                }
                continue;
            }
            if (this.server.isSessionUsed() && endHeaderIndex == cookie2Len && this.matches(buf, cookie2Header)) {
                while (++i < n && buf[i] != 59 && buf[i] != 13 && buf[i] != 10) {
                    cookie2.append((char)(buf[i] & 0x7F));
                }
                continue;
            }
            if (endHeaderIndex == authLen && this.matches(buf, authHeader)) {
                if (this.matches(buf, endHeaderIndex, basicAuth)) {
                    i += basicAuth.length;
                    while (++i < n && buf[i] != 13 && buf[i] != 10) {
                        if (buf[i] == 32) continue;
                        authInfo.append((char)(buf[i] & 0x7F));
                    }
                    continue;
                }
                throw new IOException(Messages.getMessage("badAuth00"));
            }
            if (endHeaderIndex == locationLen && this.matches(buf, locationHeader)) {
                while (++i < n && buf[i] != 13 && buf[i] != 10) {
                    if (buf[i] == 32) continue;
                    contentLocation.append((char)(buf[i] & 0x7F));
                }
                continue;
            }
            if (endHeaderIndex != typeLen || !this.matches(buf, typeHeader)) continue;
            while (++i < n && buf[i] != 13 && buf[i] != 10) {
                if (buf[i] == 32) continue;
                contentType.append((char)(buf[i] & 0x7F));
            }
        }
        return len;
    }

    public boolean matches(byte[] buf, byte[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (toLower[buf[i]] == target[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matches(byte[] buf, int bufIdx, byte[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (toLower[buf[bufIdx + i]] == target[i]) continue;
            return false;
        }
        return true;
    }

    private void putInt(byte[] buf, OutputStream out, int value) throws IOException {
        int len = 0;
        int offset = buf.length;
        if (value < 0) {
            buf[--offset] = 45;
            value = -value;
            ++len;
        }
        if (value == 0) {
            buf[--offset] = 48;
            ++len;
        }
        while (value > 0) {
            buf[--offset] = (byte)(value % 10 + 48);
            value /= 10;
            ++len;
        }
        out.write(buf, offset, len);
    }

    private int readLine(NonBlockingBufferedInputStream is, byte[] b, int off, int len) throws IOException {
        int c;
        int count = 0;
        while ((c = is.read()) != -1) {
            int peek;
            if (c != 10 && c != 13) {
                b[off++] = (byte)c;
                ++count;
            }
            if (count != len && (10 != c || (peek = is.peek()) == 32 || peek == 9)) continue;
            break;
        }
        return count > 0 ? count : -1;
    }

    public static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return "localhost";
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            SimpleWebServicesWorker.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            SimpleWebServicesWorker.toLower[lc + 65 - 97] = (byte)lc;
        }
        lenHeader = "content-length: ".getBytes();
        lenLen = lenHeader.length;
        typeHeader = ("Content-Type".toLowerCase() + ": ").getBytes();
        typeLen = typeHeader.length;
        locationHeader = ("Content-Location".toLowerCase() + ": ").getBytes();
        locationLen = locationHeader.length;
        actionHeader = "soapaction: ".getBytes();
        actionLen = actionHeader.length;
        trimmedActionHeader = "soapaction:".getBytes();
        cookieHeader = "cookie: ".getBytes();
        cookieLen = cookieHeader.length;
        cookie2Header = "cookie2: ".getBytes();
        cookie2Len = cookie2Header.length;
        authHeader = "authorization: ".getBytes();
        authLen = authHeader.length;
        getHeader = "GET".getBytes();
        postHeader = "POST".getBytes();
        headerEnder = ": ".getBytes();
        basicAuth = "basic ".getBytes();
    }
}

