/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.webservices.custom.CustomPropertyProviderFactory;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.encoding.Base64;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.OutboundOutputStream;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelManager;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundCFCallbackImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager;
import com.ibm.ws.webservices.engine.transport.http.HTTPSender;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;

public class HttpOutboundChannelConnection
implements WSOutboundConnection {
    private static final TraceNLS nls;
    private static final TraceComponent _tc;
    protected String chainname = null;
    protected OutboundVirtualConnection oConn = null;
    protected HttpOutboundServiceContext httpOutSC = null;
    protected WSAddress addrToConnect = null;
    protected long lastAccessTime = 0L;
    protected boolean usedAlready = false;
    protected boolean toBeClosed = false;
    private static int SYNC_TIMEOUT;
    private static int WRITE_TIMEOUT;
    private long createTime = System.currentTimeMillis();
    private static boolean suppressHTTPRequestPortSuffix;

    public long lifetime() {
        return System.currentTimeMillis() - this.createTime;
    }

    public String groupID() {
        if (this.addrToConnect != null) {
            return this.addrToConnect.keyValueforPool();
        }
        return null;
    }

    public boolean isMessageSent() {
        boolean retvalue = false;
        if (this.httpOutSC != null) {
            retvalue = this.httpOutSC.isMessageSent();
        }
        return retvalue;
    }

    public boolean hasbeenUsed() {
        return this.usedAlready;
    }

    public void updateEndpoint(WSAddress endpoint) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateEndpoint()");
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("updateEndpoint00", this.addrToConnect.toString(), endpoint.toString()));
        }
        this.addrToConnect = endpoint;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateEndpoint()");
        }
    }

    public void updateConnectionCfg(Object key, Object value) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "updateConnectionCfg()");
        }
        if (this.oConn != null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("updateOCCObject", String.valueOf(key)));
            }
            this.oConn.getStateMap().put(key, value);
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("channelframework01", "null OutboundVirtualConnection."));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "updateConnectionCfg()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendSOAPRequest(OutboundOutputStream os) throws Exception {
        try {
            try {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "Enter sendSOAPRequest(): " + this);
                }
                WsByteBuffer[] wbufArray = this.prepareHttpRequestHeaders(os);
                if (this.httpOutSC.getRequest().isExpect100Continue()) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("httpExpect100SC", String.valueOf(this.addrToConnect)));
                    }
                    this.httpOutSC.sendRequestHeaders();
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("finishHttpMessage", String.valueOf(this.addrToConnect)));
                }
                this.httpOutSC.finishRequestMessage(wbufArray);
                if (!this.usedAlready) {
                    this.usedAlready = true;
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "Exit sendSOAPRequest(): " + this);
                }
                Object var4_4 = null;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.sendSOAPRequest", "317", this);
                if (!_tc.isEventEnabled()) throw ex;
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(ex)));
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.lastAccessTime = System.currentTimeMillis();
            throw throwable;
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public WSOutboundCFCallbackImpl sendSOAPRequestAsync(OutboundOutputStream os) throws Exception {
        WSOutboundCFCallbackImpl wSOutboundCFCallbackImpl;
        try {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "Enter sendSOAPRequestAsync(): " + this);
            }
            WsByteBuffer[] wbufArray = this.prepareHttpRequestHeaders(os);
            HttpRequestMessage httpReqMsg = this.httpOutSC.getRequest();
            httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Override " + HttpConstants.HDR_CONNECTION.toString() + " to " + HttpConstants.CONN_CLOSE.getName() + " for asynchronous response delivery ");
            }
            WSOutboundCFCallbackImpl cback = new WSOutboundCFCallbackImpl(this, this.addrToConnect);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("Created " + cback + " with " + this.oConn));
            }
            this.httpOutSC.finishRequestMessage(wbufArray, cback, true);
            if (!this.usedAlready) {
                this.usedAlready = true;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "Exit sendSOAPRequestAsync(): " + this);
            }
            wSOutboundCFCallbackImpl = cback;
            Object var7_7 = null;
        }
        catch (Exception ex) {
            try {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.sendSOAPRequest", "379", this);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(ex)));
                }
                throw ex;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.lastAccessTime = System.currentTimeMillis();
                throw throwable;
            }
        }
        this.lastAccessTime = System.currentTimeMillis();
        return wSOutboundCFCallbackImpl;
    }

    public void receiveSOAPResponse() throws Exception {
        try {
            block58: {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "Enter receiveSOAPResponse(): " + this);
                    }
                    MessageContext currMC = MessageContext.getCurrentThreadsContext();
                    Message currRspMC = currMC.getResponseMessage();
                    HttpResponseMessage httpRspMsg = this.httpOutSC.getResponse();
                    if (httpRspMsg.isIncoming()) {
                        HashMap responseTransportHeaders;
                        StatusCodes stcodes;
                        String hdrValue = null;
                        byte[] hdrBytes = null;
                        String DEF_ENCODE = "iso-8859-1";
                        hdrBytes = httpRspMsg.getReasonPhraseBytes();
                        if (hdrBytes != null) {
                            hdrValue = new String(hdrBytes, DEF_ENCODE);
                            currMC.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, hdrValue);
                        }
                        if ((stcodes = httpRspMsg.getStatusCode()) != null) {
                            currMC.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(stcodes.getIntCode()));
                            if (stcodes.equals(HttpConstants.STATUS_FOUND)) {
                                if (HTTPSender.isHttpRedirectEnabled() && (hdrBytes = httpRspMsg.getHeaderAsByteArray(HttpConstants.HDR_LOCATION)) != null && JavaUtils.hasValue(hdrValue = new String(hdrBytes, DEF_ENCODE))) {
                                    String targetURL = this.addrToConnect.toString();
                                    if (!JavaUtils.hasValue(targetURL)) {
                                        targetURL = currMC.getTargetEndpointAddress();
                                    }
                                    if (!hdrValue.equals(targetURL)) {
                                        currMC.setProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED, hdrValue);
                                    }
                                }
                            } else if (stcodes.equals(HttpConstants.STATUS_UNAUTHORIZED) && (hdrBytes = httpRspMsg.getHeaderAsByteArray(HttpConstants.HDR_WWW_AUTHENTICATE)) != null) {
                                StringBuffer tmpbuf = new StringBuffer(new String(hdrBytes, DEF_ENCODE));
                                int begin = tmpbuf.indexOf("\"") + 1;
                                int end = tmpbuf.lastIndexOf("\"");
                                if (end < 0) {
                                    end = tmpbuf.length();
                                }
                                hdrValue = tmpbuf.substring(begin, end);
                                currMC.setProperty("WWW-Authenticate", hdrValue);
                            }
                        }
                        StringBuffer contentType = new StringBuffer(32);
                        String contentLocation = null;
                        String transferEncoding = null;
                        Vector hdrValvector = httpRspMsg.getHeaderByteArrayValues("Content-Type");
                        Iterator it = hdrValvector.iterator();
                        while (it.hasNext()) {
                            byte[] b = (byte[])it.next();
                            contentType.append(new String(b, DEF_ENCODE));
                        }
                        hdrBytes = httpRspMsg.getHeaderAsByteArray("Content-Location");
                        if (hdrBytes != null) {
                            contentLocation = new String(hdrBytes, DEF_ENCODE);
                        }
                        if ((hdrBytes = httpRspMsg.getHeaderAsByteArray(HTTPConstants.HEADER_TRANSFER_ENCODING)) != null) {
                            transferEncoding = new String(hdrBytes, DEF_ENCODE);
                        }
                        String contentLength = null;
                        if (httpRspMsg.getContentLength() > 0) {
                            contentLength = String.valueOf(httpRspMsg.getContentLength());
                        }
                        WsByteBuffer[] wsbytebufferarray = this.httpOutSC.getResponseBodyBuffers();
                        byte[] wsbufArrayInBytes = null;
                        if (wsbytebufferarray != null) {
                            wsbufArrayInBytes = WsByteBufferUtils.asByteArray(wsbytebufferarray);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "One-way ? " + currMC.isOneWay());
                        }
                        ByteArrayInputStream byteInpS = null;
                        if (wsbufArrayInBytes != null && wsbufArrayInBytes.length != 0) {
                            byteInpS = new ByteArrayInputStream(wsbufArrayInBytes);
                            Message outMsg = new Message((Object)byteInpS, contentType.toString(), contentLocation);
                            outMsg.setMessageType(MessageType.RESPONSE);
                            currMC.setResponseMessage(outMsg);
                            if (MessageTrace.isTraceEnabled()) {
                                MessageTrace.log(MessageTrace.INBOUND_HTTP_RESPONSE, contentType.toString(), wsbufArrayInBytes);
                            }
                        } else if (!currMC.isOneWay()) {
                            Object redirectFlag = currMC.getProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                            Object noneFlag = currMC.getProperty("com.ibm.ws.wsaddressing.NoneURI");
                            if (redirectFlag != null || noneFlag != null) {
                                Tr.debug(_tc, "This message contained WSAddressing data indicating a redirected or discarded reply.  So, no data received in HTTP response as expected.");
                            } else {
                                Tr.error(_tc, Messages.getMessage("httpChannelError00", String.valueOf(this.addrToConnect)));
                            }
                        }
                        if (wsbytebufferarray != null) {
                            for (int i = 0; i < wsbytebufferarray.length; ++i) {
                                if (wsbytebufferarray[i] == null) continue;
                                wsbytebufferarray[i].release();
                            }
                            wsbufArrayInBytes = null;
                        }
                        if (currMC.getMaintainSession()) {
                            StringBuffer sb = new StringBuffer();
                            String cookie = null;
                            hdrValvector = httpRspMsg.getHeaderByteArrayValues(HTTPConstants.HEADER_SET_COOKIE);
                            if (hdrValvector != null && !hdrValvector.isEmpty()) {
                                Iterator it2 = hdrValvector.iterator();
                                while (it2.hasNext()) {
                                    byte[] b = (byte[])it2.next();
                                    if (it2.hasNext()) {
                                        sb.append(new String(b, DEF_ENCODE)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                        continue;
                                    }
                                    sb.append(new String(b, DEF_ENCODE));
                                }
                                cookie = sb.toString();
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, Messages.getMessage("cookieReceived", HTTPConstants.HEADER_SET_COOKIE + ": " + cookie, this.addrToConnect.toString()));
                                }
                            }
                            String cookie2 = null;
                            sb = new StringBuffer();
                            hdrValvector = httpRspMsg.getHeaderByteArrayValues(HTTPConstants.HEADER_SET_COOKIE2);
                            if (hdrValvector != null && !hdrValvector.isEmpty()) {
                                Iterator it3 = hdrValvector.iterator();
                                while (it3.hasNext()) {
                                    byte[] b = (byte[])it3.next();
                                    if (it3.hasNext()) {
                                        sb.append(new String(b, DEF_ENCODE)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                        continue;
                                    }
                                    sb.append(new String(b, DEF_ENCODE));
                                }
                                cookie2 = sb.toString();
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, Messages.getMessage("cookieReceived", HTTPConstants.HEADER_SET_COOKIE2 + ": " + cookie2, this.addrToConnect.toString()));
                                }
                            }
                            if (JavaUtils.hasValue(cookie) || JavaUtils.hasValue(cookie2)) {
                                HTTPCookieManager cm = null;
                                cm = (HTTPCookieManager)currMC.getProperty("com.ibm.ws.webservices.engine.session.context");
                                if (cm == null) {
                                    cm = new HTTPCookieManager(cookie, cookie2);
                                } else {
                                    cm.setCookies(cookie, cookie2);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "receiveSOAPResponse(): msgContext = " + currMC.toString() + " SessionContext = " + cm);
                                }
                                currMC.setProperty("com.ibm.ws.webservices.engine.session.context", cm);
                            }
                        }
                        if ((responseTransportHeaders = (HashMap)currMC.getProperty("com.ibm.websphere.webservices.responseTransportProperties")) != null) {
                            Iterator<Object> headerIterator = null;
                            if (responseTransportHeaders.isEmpty()) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "receiveSOAPResponse(): Empty response header hasmap - returning ALL headers!");
                                }
                                headerIterator = httpRspMsg.getAllHeaders().iterator();
                            } else {
                                headerIterator = responseTransportHeaders.keySet().iterator();
                            }
                            String headerKey = null;
                            String responseHeader = null;
                            while (headerIterator.hasNext()) {
                                headerKey = (String)headerIterator.next();
                                if (headerKey == "Cookie" || headerKey == "Cookie2") {
                                    Vector vtor = httpRspMsg.getHeaderByteArrayValues(headerKey);
                                    StringBuffer sbuff = new StringBuffer();
                                    if (vtor != null && !vtor.isEmpty()) {
                                        Iterator it4 = vtor.iterator();
                                        while (it4.hasNext()) {
                                            byte[] b = (byte[])it4.next();
                                            if (it4.hasNext()) {
                                                sbuff.append(new String(b, DEF_ENCODE)).append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
                                                continue;
                                            }
                                            sbuff.append(new String(b, DEF_ENCODE));
                                        }
                                        responseHeader = sbuff.toString();
                                    }
                                } else {
                                    responseHeader = httpRspMsg.getHeaderAsString(headerKey);
                                }
                                if (JavaUtils.hasValue(responseHeader)) {
                                    responseTransportHeaders.put(headerKey, responseHeader);
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "HttpOutboundChannelConnection.receiveSOAPResponse(): Rsp headerKey = " + headerKey + ", responseHeader = " + responseHeader);
                                    }
                                }
                                responseHeader = null;
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            ((HttpResponseMessageImpl)httpRspMsg).debug();
                        }
                    } else if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invalidHttpResponse", String.valueOf(this.addrToConnect)));
                    }
                    if (!_tc.isEntryEnabled()) break block58;
                    Tr.exit(_tc, "Exit receiveSOAPResponse(): " + this);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.receiveSOAPResponse", "690", this);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(ex)));
                    }
                    throw ex;
                }
            }
            Object var25_30 = null;
        }
        catch (Throwable throwable) {
            Object var25_31 = null;
            this.lastAccessTime = System.currentTimeMillis();
            throw throwable;
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void connect() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter connect() of: " + this);
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("connectingAddr", String.valueOf(this.addrToConnect)));
        }
        try {
            if (!this.toBeClosed && this.httpOutSC == null) {
                this.oConn.connect(this.addrToConnect);
                this.httpOutSC = (HttpOutboundServiceContext)this.oConn.getChannelAccessor();
                if (this.httpOutSC != null) {
                    MessageContext msgCtx = MessageContext.getCurrentThreadsContext();
                    int synctimeout = msgCtx.getTimeout();
                    if (SYNC_TIMEOUT > 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Sync timeout from JVM property : " + SYNC_TIMEOUT);
                        }
                        synctimeout = SYNC_TIMEOUT;
                    }
                    if (synctimeout != 0) {
                        this.httpOutSC.setReadTimeout(synctimeout);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("syncTimeoutValue", String.valueOf(synctimeout / 1000), this.addrToConnect.getSchemaInString()));
                        }
                    }
                    int write_timeout = msgCtx.getWriteTimeout();
                    if (WRITE_TIMEOUT > 0) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Write timeout from JVM property : " + WRITE_TIMEOUT);
                        }
                        write_timeout = WRITE_TIMEOUT;
                    }
                    if (write_timeout != 0) {
                        this.httpOutSC.setWriteTimeout(write_timeout);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("writeTimeoutValue", String.valueOf(write_timeout / 1000), this.addrToConnect.getSchemaInString()));
                        }
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("newConnection", String.valueOf(this.oConn)));
                }
            } else if (!this.toBeClosed && this.httpOutSC != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("connectedAddr", String.valueOf(this.addrToConnect)));
                    Tr.event(_tc, Messages.getMessage("reuseConnection", String.valueOf(this.oConn)));
                }
            } else {
                throw new WebServicesFault(Messages.getMessage("closedOCobject00", String.valueOf(this.oConn)));
            }
            this.lastAccessTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.connect", "782", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("exception01", JavaUtils.stackToString(ex)));
            }
            throw new WebServicesFault(Messages.getMessage("failConnect00", this.addrToConnect.getHostname() + ":" + this.addrToConnect.getPort(), ex.getMessage()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit connect() of: " + this);
        }
    }

    public void disconnect(Exception ex) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter disconnect() of: " + this);
        }
        if (!this.toBeClosed) {
            this.markToBeClosed();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("disconnectAddr", String.valueOf(this.addrToConnect), this.toString()));
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("disconnectedAddr", String.valueOf(this.addrToConnect), this.toString()));
        }
        if (ex != null) {
            this.release(ex);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit disconnect() of: " + this);
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void reset() {
        boolean persistent;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter reset() of: " + this);
        }
        boolean bl = persistent = this.httpOutSC == null ? false : this.httpOutSC.isPersistent();
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("resetConnection", String.valueOf(this.addrToConnect), String.valueOf(persistent)));
        }
        if (!this.toBeClosed) {
            if (persistent) {
                this.httpOutSC.clear();
                this.lastAccessTime = System.currentTimeMillis();
            } else {
                this.disconnect(null);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("disconnectedAddr", String.valueOf(this.addrToConnect), this.toString()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit reset() of: " + this);
        }
    }

    public boolean isClosed() {
        return this.toBeClosed;
    }

    public long timeFromLastAccess() {
        return System.currentTimeMillis() - this.lastAccessTime;
    }

    public synchronized void markToBeClosed() {
        this.toBeClosed = true;
    }

    public String getChannelChainName() {
        return this.chainname;
    }

    public WSAddress getTargetAddress() {
        return this.addrToConnect;
    }

    public synchronized void release(Exception ex) {
        boolean connAlreadyEst;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter release() of: " + this);
        }
        if (ex != null && _tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("releaseOCobjectEx", String.valueOf(ex), String.valueOf(this.oConn), String.valueOf(this.httpOutSC)));
        }
        boolean bl = connAlreadyEst = this.httpOutSC != null;
        if (connAlreadyEst) {
            this.httpOutSC.clear();
            this.httpOutSC = null;
        }
        if (this.oConn != null) {
            if (connAlreadyEst) {
                this.oConn.close(ex);
            }
            this.oConn = null;
        }
        this.lastAccessTime = 0L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit release() of: " + this);
        }
    }

    protected String getHeaderFromResponse(HttpHeaderKeys hdrkeys) throws WebServicesFault {
        HttpResponseMessage httpRspMsg;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getHeaderFromResponse()");
        }
        String returnHeader = null;
        if (this.oConn != null && this.httpOutSC != null && (httpRspMsg = this.httpOutSC.getResponse()) != null) {
            returnHeader = httpRspMsg.getHeaderAsString(hdrkeys);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getHeaderFromResponse()");
        }
        this.lastAccessTime = System.currentTimeMillis();
        return returnHeader;
    }

    public HttpOutboundChannelConnection(OutboundVirtualConnection oVC, WSAddress addr, String chainName) {
        this.addrToConnect = addr;
        this.oConn = oVC;
        this.lastAccessTime = System.currentTimeMillis();
        this.chainname = chainName;
    }

    private static void addValueToOutboundHeader(String transportHeaderKey, String transportHeaderValue, HttpRequestMessage httpReqMsg) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg): transportHeaderKey = " + transportHeaderKey + ", transportHeaderValue = " + transportHeaderValue + ", httpReqMsg" + httpReqMsg);
        }
        if (!JavaUtils.hasValue(transportHeaderKey)) {
            Tr.error(_tc, "invalid.transportheader.key");
            return;
        }
        if (!JavaUtils.hasValue(transportHeaderValue)) {
            Tr.error(_tc, "invalid.transportheader.value", new Object[]{transportHeaderKey});
            return;
        }
        if (httpReqMsg == null) {
            Tr.error(_tc, "internal.error", "HTTP Request message is null");
        }
        String TOKEN_SEPERATOR = ";";
        String currentHeader = httpReqMsg.getHeaderAsString(transportHeaderKey);
        StringTokenizer currentHeaderTokens = null;
        if (currentHeader != null) {
            currentHeaderTokens = new StringTokenizer(currentHeader, ";");
        }
        if (currentHeaderTokens != null && currentHeaderTokens.countTokens() > 0) {
            int nameValueSeperatorIndex;
            String NAME_VALUE_SEPERATOR = "=";
            StringTokenizer newHeaderTokens = new StringTokenizer(transportHeaderValue, ";");
            HashMap<String, String> newNameValuePairs = new HashMap<String, String>();
            while (newHeaderTokens != null && newHeaderTokens.countTokens() > 0) {
                String processToken = newHeaderTokens.nextToken();
                nameValueSeperatorIndex = processToken.indexOf("=");
                String tokenName = processToken.substring(0, nameValueSeperatorIndex);
                String tokenValue = processToken.substring(nameValueSeperatorIndex + 1);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader() New tokenName = " + tokenName + " , tokenValue" + tokenValue);
                }
                newNameValuePairs.put(tokenName, tokenValue);
            }
            while (currentHeaderTokens.countTokens() > 0) {
                String processCurrentToken = currentHeaderTokens.nextToken();
                nameValueSeperatorIndex = processCurrentToken.indexOf("=");
                String currentTokenName = processCurrentToken.substring(0, nameValueSeperatorIndex);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader() removing " + currentTokenName + " from new header values if it exists = " + newNameValuePairs.containsKey(currentTokenName));
                }
                newNameValuePairs.remove(currentTokenName);
            }
            StringBuffer requestHeaders = new StringBuffer(httpReqMsg.getHeaderAsString(transportHeaderKey));
            Iterator newHeaders = newNameValuePairs.entrySet().iterator();
            while (newHeaders.hasNext()) {
                Map.Entry addHeader = newHeaders.next();
                requestHeaders.append(";");
                requestHeaders.append((String)addHeader.getKey());
                requestHeaders.append("=");
                requestHeaders.append((String)addHeader.getValue());
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader() adding request header ;" + (String)addHeader.getKey() + "=" + (String)addHeader.getValue());
            }
            httpReqMsg.setHeader(transportHeaderKey, new String(requestHeaders));
        } else {
            httpReqMsg.setHeader(transportHeaderKey, transportHeaderValue);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.addValueToOutboundHeader(): Header did not already exist. Adding " + transportHeaderKey + " value " + transportHeaderValue);
            }
        }
    }

    private WsByteBuffer[] prepareHttpRequestHeaders(OutboundOutputStream os) throws WebServicesFault, UnsupportedMethodException, UnsupportedProtocolVersionException, MalformedURLException, UnsupportedEncodingException {
        String negotiate;
        HashMap requestTransportHeaders;
        Integer stcodes;
        boolean enabled;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Enter prepareHttpRequestHeaders(): " + this);
        }
        String propValue = null;
        MessageContext currMC = MessageContext.getCurrentThreadsContext();
        HttpRequestMessage httpReqMsg = this.httpOutSC.getRequest();
        int synctimeout = currMC.getTimeout();
        if (SYNC_TIMEOUT > 0) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "prepareHttpRequestHeaders. Sync timeout from JVM property : " + SYNC_TIMEOUT);
            }
            synctimeout = SYNC_TIMEOUT;
        }
        if (synctimeout != 0) {
            this.httpOutSC.setReadTimeout(synctimeout);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("syncTimeoutValue", String.valueOf(synctimeout / 1000), this.addrToConnect.getSchemaInString()));
            }
        }
        int write_timeout = currMC.getWriteTimeout();
        if (WRITE_TIMEOUT > 0) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "prepareHttpRequestHeaders. Write timeout from JVM property : " + WRITE_TIMEOUT);
            }
            write_timeout = WRITE_TIMEOUT;
        }
        if (write_timeout != 0) {
            this.httpOutSC.setWriteTimeout(write_timeout);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("writeTimeoutValue", String.valueOf(write_timeout / 1000), this.addrToConnect.getSchemaInString()));
            }
        }
        boolean postmethod = true;
        if (currMC.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            propValue = currMC.getStrProp("soap12.webmethod");
        }
        if (propValue == null) {
            propValue = "POST";
        } else {
            postmethod = propValue.equals("POST");
        }
        httpReqMsg.setMethod(propValue);
        propValue = ((HttpChannelAddress)this.addrToConnect).getTargetEndPoint();
        httpReqMsg.setRequestURL(propValue);
        String urlHost = httpReqMsg.getURLHost();
        if (urlHost == null || urlHost != null && urlHost.equals("")) {
            throw new WebServicesFault(Messages.getMessage("invalidHttpHost", urlHost, propValue));
        }
        int urlPort = httpReqMsg.getURLPort();
        if (urlPort <= 0) {
            throw new WebServicesFault(Messages.getMessage("invalidHttpPort", "" + urlPort, propValue));
        }
        String hostHeaderValue = null;
        hostHeaderValue = suppressHTTPRequestPortSuffix ? urlHost : urlHost + ":" + urlPort;
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_HOST, hostHeaderValue);
        propValue = currMC.getStrProp(MessageContext.HTTP_TRANSPORT_VERSION);
        boolean use1_1 = true;
        if (propValue != null) {
            if (propValue.equalsIgnoreCase(HTTPConstants.HEADER_PROTOCOL_11) || propValue.equalsIgnoreCase(HTTPConstants.HEADER_PROTOCOL_10)) {
                httpReqMsg.setVersion(propValue);
                if (propValue.equalsIgnoreCase(HTTPConstants.HEADER_PROTOCOL_10)) {
                    use1_1 = false;
                }
            } else {
                throw new WebServicesFault(Messages.getMessage("unsupportedHttpVersion", propValue));
            }
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("httpVersion", String.valueOf(this.addrToConnect), httpReqMsg.getVersion()));
        }
        String acceptheaders = "application/soap+xml,multipart/related,text/*";
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT, acceptheaders);
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_USER_AGENT, "IBM WebServices/1.0");
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, "no-cache");
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_PRAGMA, "no-cache");
        String cte = (String)CustomPropertyProviderFactory.getProvider().getValue("com.ibm.ws.webservices.contentTransferEncoding");
        if (!cte.equalsIgnoreCase("7bit")) {
            httpReqMsg.setHeader(HTTPConstants.HEADER_TRANSFER_ENCODING, cte);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting Content_Transfer_Encoding = " + cte);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Content_Transfer_Encoding not changed = " + cte);
        }
        String soapaction = currMC.getSOAPActionURI();
        if (!currMC.useSOAPAction() || soapaction == null) {
            httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_SOAPACTION, "");
        } else {
            httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_SOAPACTION, "\"" + soapaction + "\"");
        }
        StringBuffer basicAuthData = null;
        if (!JavaUtils.hasValue(currMC.getUsername())) {
            URL tmpURL = new URL(this.addrToConnect.toString());
            if (tmpURL.getUserInfo() != null) {
                String info = tmpURL.getUserInfo();
                int sep = info.indexOf(58);
                if (sep >= 0 && sep + 1 < info.length()) {
                    basicAuthData = new StringBuffer(info.substring(0, sep));
                    basicAuthData.append(":").append(info.substring(sep + 1));
                } else {
                    basicAuthData = new StringBuffer(info);
                }
            }
        } else {
            basicAuthData = new StringBuffer(currMC.getUsername());
            basicAuthData.append(":").append(currMC.getPassword());
        }
        if (basicAuthData != null && JavaUtils.hasValue(basicAuthData.toString())) {
            int lastindex = basicAuthData.length();
            basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes("utf-8")));
            httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_AUTHORIZATION, basicAuthData.insert(0, "Basic ").toString());
        }
        if (currMC.getMaintainSession()) {
            Object sc;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): maintain session TRUE");
            }
            if ((sc = currMC.getProperty("com.ibm.ws.webservices.engine.session.context")) != null) {
                String cookie = null;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders() : msgContext = " + currMC.toString() + " SessionContext = " + sc);
                }
                URL targetURL = currMC.getTargetEndpointAddressAsURL();
                String path = targetURL.getPath();
                String domain = targetURL.getHost();
                int port = targetURL.getPort();
                boolean secure = false;
                if (this.addrToConnect.getSchema() == 2) {
                    secure = true;
                }
                if ((cookie = ((HTTPCookieManager)sc).getCookie(path, domain, port, secure)) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Setting Cookie for maintain session = " + cookie);
                    }
                    httpReqMsg.setHeader("Cookie", cookie);
                }
            }
        }
        DefaultHTTPTransportClientProperties tcp = (DefaultHTTPTransportClientProperties)((HttpChannelAddress)this.addrToConnect).getTCproperties();
        if (((HttpChannelAddress)this.addrToConnect).isProxy() && this.addrToConnect.getSchema() == 1) {
            String proxyUser = tcp.getProxyUser();
            String proxyPassword = tcp.getProxyPassword();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, Messages.getMessage("httpProxyConfiguration00", tcp.getProxyHost(), tcp.getProxyPort(), proxyUser, JavaUtils.hasValue(proxyPassword) ? "******" : ""));
            }
            if (JavaUtils.hasValue(proxyUser) && JavaUtils.hasValue(proxyPassword)) {
                basicAuthData = new StringBuffer(proxyUser);
                basicAuthData.append(":").append(proxyPassword);
                int lastindex = basicAuthData.length();
                basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes("utf-8")));
                httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_PROXY_AUTHORIZATION, basicAuthData.insert(0, "Basic ").toString());
            }
        }
        if (!(enabled = tcp.isResendEnabled())) {
            this.httpOutSC.disallowRewrites();
        } else {
            this.httpOutSC.allowRewrites();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.requestResendEnabled: " + enabled);
        }
        if (tcp.isKeepAlivePropSet()) {
            enabled = tcp.toKeepAlive();
            if (enabled) {
                httpReqMsg.setConnection(HttpConstants.CONN_KEEPALIVE);
            } else {
                httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionKeepAlive = " + enabled);
            }
        } else if (use1_1) {
            httpReqMsg.setConnection(HttpConstants.CONN_KEEPALIVE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionKeepAlive not set. Set default for HTTP 1.1 - Connection: " + HttpConstants.CONN_KEEPALIVE.getName());
            }
        } else {
            httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionKeepAlive not set. Set default for HTTP 1.0 - Connection: " + HttpConstants.CONN_CLOSE.getName());
            }
        }
        propValue = tcp.encodeRequestMessage();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.requestContentEncoding = " + propValue);
        }
        if (JavaUtils.hasValue(propValue)) {
            if (this.httpOutSC.isGZipEncodingSupported() && propValue.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_GZIP)) {
                this.httpOutSC.setGZipEncoded(true);
                if (this.httpOutSC.isGZipEncoded()) {
                    httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, HTTPConstants.HEADER_C_ENC_GZIP);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, Messages.getMessage("gzipCompressionEnabled", String.valueOf(this.httpOutSC.isGZipEncoded())));
                }
            } else if (this.httpOutSC.isXGZipEncodingSupported() && propValue.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_XGZIP)) {
                this.httpOutSC.setXGZipEncoded(true);
                if (this.httpOutSC.isXGZipEncoded()) {
                    httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, HTTPConstants.HEADER_C_ENC_XGZIP);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("gzipCompressionEnabled", String.valueOf(this.httpOutSC.isGZipEncoded())));
                }
            } else if (this.httpOutSC.isZlibEncodingSupported() && propValue.equalsIgnoreCase(HTTPConstants.HEADER_C_ENC_DEFLATE)) {
                this.httpOutSC.setZlibEncoded(true);
                if (this.httpOutSC.isZlibEncoded()) {
                    httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, HTTPConstants.HEADER_C_ENC_DEFLATE);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("deflateCompressionEnabled", String.valueOf(this.httpOutSC.isZlibEncoded())));
                }
            }
        }
        if (!this.httpOutSC.isGZipEncoded() && !this.httpOutSC.isZlibEncoded() && !this.httpOutSC.isXGZipEncoded() && _tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("noCompression"));
        }
        Hashtable userHeaderTable = (Hashtable)currMC.getProperty("HTTP-Request-Headers");
        boolean useChunkEncoding = false;
        boolean expect100Continue = false;
        if (userHeaderTable != null) {
            String key = null;
            String val = null;
            Map.Entry me = null;
            Object keyObj = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): deprecated REQUEST_HEADERS property used = " + userHeaderTable);
            }
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                me = e.next();
                keyObj = me.getKey();
                if (keyObj == null) continue;
                key = keyObj.toString().trim();
                key.intern();
                if (key == HTTPConstants.HEADER_TRANSFER_ENCODING) {
                    if (!use1_1 || null == (val = me.getValue().toString()) || !val.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    useChunkEncoding = true;
                    continue;
                }
                if (key == "Connection") {
                    if (use1_1) {
                        val = me.getValue().toString();
                        if (val == null || val.length() == 0) continue;
                        val.intern();
                        if (val == HTTPConstants.HEADER_CONNECTION_CLOSE) {
                            httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
                            continue;
                        }
                        if (val != HTTPConstants.HEADER_CONNECTION_KEEPALIVE) continue;
                        httpReqMsg.setConnection(HttpConstants.CONN_KEEPALIVE);
                        continue;
                    }
                    httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
                    continue;
                }
                if (key == "Expect") {
                    if (!use1_1 || null == (val = me.getValue().toString()) || !val.trim().equalsIgnoreCase(HTTPConstants.HEADER_EXPECT_100_Continue) || (stcodes = (Integer)currMC.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE)) != null && stcodes == 100) continue;
                    httpReqMsg.setExpect(HttpConstants.EXPECT_100CONTINUE);
                    expect100Continue = true;
                    continue;
                }
                if (key == "Host" || key == "Content-Type" || key == "SOAPAction" || key == "Content-Length" || key == "Cookie" || key == "Cookie2") continue;
                httpReqMsg.setHeader(key, me.getValue().toString());
            }
        }
        if ((requestTransportHeaders = (HashMap)currMC.getProperty("com.ibm.websphere.webservices.requestTransportProperties")) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): REQUEST_TRANSPORT_PROPERTIES used = " + requestTransportHeaders);
            }
            if (userHeaderTable != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "*** PERFORMANCE DEGREDATION WARNING ***: Both the com.ibm.websphere.webservices.Constants.REQUEST_TRANSPORT_PROPERTIES and the now deprecated HTTPConstants.REQUEST_HEADERS support are being used.  This results in each outgoing Web services HTTP message being processed two times.  For performance reasons only the REQUEST_TRANSPORT_PROPERTIES should be used.");
            }
            Iterator headerIterator = requestTransportHeaders.entrySet().iterator();
            while (headerIterator.hasNext()) {
                Map.Entry headerMapEntry = headerIterator.next();
                String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                if (!JavaUtils.hasValue(transportHeaderKey)) {
                    Tr.warning(_tc, "invalid.transportheader.key");
                    continue;
                }
                String transportHeaderValue = ((String)headerMapEntry.getValue()).trim();
                if (!JavaUtils.hasValue(transportHeaderValue)) {
                    Tr.warning(_tc, "invalid.transportheader.value", new Object[]{transportHeaderKey});
                    continue;
                }
                transportHeaderKey.intern();
                if (transportHeaderKey == HTTPConstants.HEADER_TRANSFER_ENCODING) {
                    if (!use1_1 || !transportHeaderValue.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    useChunkEncoding = true;
                    continue;
                }
                if (transportHeaderKey == "Connection") {
                    if (use1_1) {
                        if (transportHeaderValue.equals(HTTPConstants.HEADER_CONNECTION_CLOSE)) {
                            httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
                            continue;
                        }
                        if (!transportHeaderValue.equals(HTTPConstants.HEADER_CONNECTION_KEEPALIVE)) continue;
                        httpReqMsg.setConnection(HttpConstants.CONN_KEEPALIVE);
                        continue;
                    }
                    httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
                    continue;
                }
                if (transportHeaderKey == "Expect") {
                    if (!use1_1 || !transportHeaderValue.equalsIgnoreCase(HTTPConstants.HEADER_EXPECT_100_Continue) || (stcodes = (Integer)currMC.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE)) != null && stcodes == 100) continue;
                    httpReqMsg.setExpect(HttpConstants.EXPECT_100CONTINUE);
                    expect100Continue = true;
                    continue;
                }
                if (transportHeaderKey == "Host") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "Content-Type") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "SOAPAction") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "Content-Length") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "HttpOutboundChannelConnection.prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "Cookie") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                if (transportHeaderKey == "Cookie2") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                if (transportHeaderKey == "Authorization") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                if (transportHeaderKey == "Proxy-Authorization") {
                    HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                HttpOutboundChannelConnection.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
            }
        }
        String reqContentType = "";
        if (postmethod) {
            reqContentType = os.getContentType();
            httpReqMsg.setHeader("Content-Type", reqContentType);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HTTP Content-Type: " + reqContentType);
            }
            if (useChunkEncoding) {
                httpReqMsg.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "One-way ? " + currMC.isOneWay());
        }
        if (JavaUtils.hasValue(negotiate = httpReqMsg.getHeaderAsString(HttpConstants.HDR_AUTHORIZATION)) && negotiate.startsWith("Negotiate")) {
            currMC.setProperty("com.ibm.ws.webservices.spnegoUsed", Boolean.TRUE);
        } else {
            currMC.setProperty("com.ibm.ws.webservices.spnegoUsed", Boolean.FALSE);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Is SPNEGO used? " + (Boolean)currMC.getProperty("com.ibm.ws.webservices.spnegoUsed"));
        }
        WsByteBufferPoolManager wbufPoolMgr = null;
        try {
            wbufPoolMgr = WSChannelManager.getInstance().getWsByteBufferPoolManager();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection.prepareHttpRequestHeaders", "1761", this);
            throw WebServicesFault.makeFault(ex);
        }
        WsByteBuffer[] wbufArray = new WsByteBuffer[]{wbufPoolMgr.wrap(os.toByteArray())};
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Exit prepareHttpRequestHeaders(): " + this);
        }
        return wbufArray;
    }

    static {
        block5: {
            nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
            _tc = Tr.register(HttpOutboundChannelConnection.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
            SYNC_TIMEOUT = 0;
            WRITE_TIMEOUT = 0;
            suppressHTTPRequestPortSuffix = false;
            String propName = "com.ibm.ws.webservices.suppressHTTPRequestPortSuffix";
            Log log = LogFactory.getLog(HttpOutboundChannelConnection.class.getName());
            try {
                suppressHTTPRequestPortSuffix = MCUtils.isPropertyEnabled(propName);
                if (log.isDebugEnabled()) {
                    log.debug(MCUtils.getSettingMsg(propName, suppressHTTPRequestPortSuffix));
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("Exception occurred obtaining and evaluating system property {" + propName + "}: " + ex);
            }
        }
        String str = null;
        str = System.getProperty("timeout");
        if (JavaUtils.hasValue(str) && Integer.parseInt(str) > 300) {
            SYNC_TIMEOUT = Integer.parseInt(str) * 1000;
        }
        if (JavaUtils.hasValue(str = System.getProperty("write_timeout")) && Integer.parseInt(str) > 300) {
            WRITE_TIMEOUT = Integer.parseInt(str) * 1000;
        }
    }
}

