/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.transport.http.CookieValueList;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPCookieManager
implements SessionContext {
    private static final TraceComponent _tc = Tr.register(HTTPCookieManager.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private HashMap chM = null;
    private String cookie_name = null;
    private CookieValueList cvs = null;

    public HTTPCookieManager(String cookie, String cookie2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        this.setCookies(cookie, cookie2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public static boolean newCookieHandling() {
        boolean result = false;
        String sysProp = System.getProperty("UseNewCookieHandling");
        if (sysProp != null) {
            result = Boolean.valueOf(sysProp);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of UseNewCookieHandling: " + sysProp);
            }
        }
        return result;
    }

    public void setCookies(String cookie, String cookie2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCookies this : " + this);
        }
        if (JavaUtils.hasValue(cookie)) {
            this.cookie_name = HTTPConstants.HEADER_SET_COOKIE;
            this.parseCookieandStore(cookie);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, this.cookie_name + " stored : " + cookie);
            }
        }
        if (JavaUtils.hasValue(cookie2)) {
            this.cookie_name = HTTPConstants.HEADER_SET_COOKIE2;
            this.parseCookieandStore(cookie2);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, this.cookie_name + " stored : " + cookie2);
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCookies");
        }
    }

    public String getCookie(String path, String domain, int port, boolean secure) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCookie() this : " + this);
        }
        StringBuffer token = new StringBuffer();
        Set HostKeys = this.chM.keySet();
        Iterator It = HostKeys.iterator();
        token.append("$Version=\"1\";");
        while (It.hasNext()) {
            String HostNow = (String)It.next();
            CookieValueList cvs = (CookieValueList)this.chM.get(HostNow);
            token.append(cvs.getList(path, domain, port, secure));
        }
        String result = token.toString().substring(0, token.length() - 1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCookie() : " + result);
        }
        return result;
    }

    public String printCookieSet() {
        StringBuffer token = new StringBuffer();
        Set HostKeys = this.chM.keySet();
        Iterator It = HostKeys.iterator();
        while (It.hasNext()) {
            String HostNow = (String)It.next();
            CookieValueList cvs = (CookieValueList)this.chM.get(HostNow);
            token.append(cvs.printList());
        }
        if (token.toString() == null || token.toString().equals("")) {
            return "";
        }
        String result = token.toString().substring(0, token.length() - 1);
        return result;
    }

    protected List splitMultipleCookies(String header) {
        ArrayList<String> cookies = new ArrayList<String>();
        int Count = 0;
        int b = 0;
        for (int a = 0; a < header.length(); ++a) {
            char ch = header.charAt(a);
            if (ch == '\"') {
                ++Count;
            }
            if (ch != ',' || Count % 2 != 0) continue;
            cookies.add(header.substring(b, a));
            b = a + 1;
        }
        cookies.add(header.substring(b));
        return cookies;
    }

    protected void parseCookieandStore(String cookie) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseCookieandStore() this : " + this);
        }
        if (cookie != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "cookie Received : " + cookie);
            }
            List cookies = this.splitMultipleCookies(cookie);
            String name = null;
            for (int i = 0; i < cookies.size(); ++i) {
                name = (String)cookies.get(i);
                this.cvs = null;
                int tokenValueSeperatorIndex = name.indexOf(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                String name1 = name.substring(0, tokenValueSeperatorIndex).trim();
                String token = name.substring(tokenValueSeperatorIndex + 1).trim();
                if (name1 == null) continue;
                int nameValueSeperatorIndex = name1.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                String prop = name1.substring(0, nameValueSeperatorIndex).trim();
                String value = name1.substring(nameValueSeperatorIndex + 1).trim();
                if (prop == null) continue;
                if (this.chM != null) {
                    Set HostKeys = this.chM.keySet();
                    Iterator It = HostKeys.iterator();
                    while (It.hasNext()) {
                        String HostNow = (String)It.next();
                        if (prop.compareTo(HostNow) != 0) continue;
                        this.cvs = (CookieValueList)this.chM.get(HostNow);
                        break;
                    }
                }
                if (this.cvs == null) {
                    this.cvs = new CookieValueList(this.cookie_name);
                }
                this.cvs.setCookieNameValue(prop, value);
                this.cvs.setCookie(token);
                this.chM.put(prop, this.cvs);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Stored cookie");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseCookieandStore()");
        }
    }
}

