/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.StringTokenizer;

public class CookieValueItem {
    private static final TraceComponent _tc = Tr.register(CookieValueItem.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String cookie_name;
    private long cookieCreateTime = 0L;
    private String cookieValue = null;
    private String Comment = null;
    private String CommentURL = null;
    private boolean Discard = false;
    private String Domain = null;
    private long Max_Age = -1L;
    private String Path = null;
    private String PortList = null;
    private boolean Secure = false;
    private String Version = null;

    public CookieValueItem(String name) {
        this.cookie_name = name;
        this.cookieCreateTime = System.currentTimeMillis();
    }

    public void setCookieValue(String value) {
        this.cookieValue = value;
    }

    public String getCookieValue() {
        return this.cookieValue;
    }

    public void setComment(String value) {
        this.Comment = value;
    }

    public String getComment() {
        return this.Comment;
    }

    public void setCommentURL(String value) {
        this.CommentURL = value;
    }

    public String getCommentURL() {
        return this.CommentURL;
    }

    public void setDiscard(boolean value) {
        this.Discard = value;
    }

    public boolean getDiscard() {
        return this.Discard;
    }

    public void setDomain(String value) {
        this.Domain = value;
    }

    public String getDomain() {
        return this.Domain;
    }

    public void setMax_Age(long value) {
        this.Max_Age = value;
    }

    public long getMax_Age() {
        return this.Max_Age;
    }

    public void setPath(String value) {
        this.Path = value;
    }

    public String getPath() {
        return this.Path;
    }

    public void setPortList(String value) {
        this.PortList = value;
    }

    public String getPortList() {
        return this.PortList;
    }

    public void setSecure(boolean value) {
        this.Secure = value;
    }

    public boolean getSecure() {
        return this.Secure;
    }

    public void setVersion(String value) {
        this.Version = value;
    }

    public String getVersion() {
        return this.Version;
    }

    public boolean hasExpired() {
        if (this.Max_Age == 0L) {
            return true;
        }
        if (this.Max_Age == -1L) {
            return false;
        }
        long deltaSecond = System.currentTimeMillis() - this.cookieCreateTime;
        return deltaSecond > this.Max_Age;
    }

    public boolean setCookie(String cookie) {
        if (cookie != null) {
            String value = null;
            String prop = null;
            StringTokenizer st1 = new StringTokenizer(cookie, HTTPConstants.ATTR_TOKEN_SEPARATOR);
            while (st1.hasMoreTokens()) {
                String name1 = st1.nextToken();
                int nameValueSeperatorIndex = name1.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                if (name1.contains(HTTPConstants.ATTR_VALUE_SEPARATOR)) {
                    prop = name1.substring(0, nameValueSeperatorIndex).trim();
                    value = name1.substring(nameValueSeperatorIndex + 1).trim();
                } else {
                    prop = name1;
                }
                if (value == null) continue;
                if (prop.equals("Comment")) {
                    this.setComment(value);
                    continue;
                }
                if (prop.equals("CommentURL")) {
                    this.setCommentURL(value);
                    continue;
                }
                if (prop.equals("Discard")) {
                    this.setDiscard(true);
                    continue;
                }
                if (prop.equals("Domain")) {
                    this.setDomain(value);
                    continue;
                }
                if (prop.equals("Max-Age")) {
                    long age = Long.parseLong(value);
                    if (age == 0L) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Max-Age is 0. So not storing");
                        }
                        return false;
                    }
                    this.setMax_Age(age * 1000L);
                    continue;
                }
                if (prop.equals("Path")) {
                    this.setPath(value);
                    continue;
                }
                if (prop.equals("Port")) {
                    this.setPortList(value);
                    continue;
                }
                if (prop.equals("Secure")) {
                    this.setSecure(true);
                    continue;
                }
                if (!prop.equals("Version")) continue;
                this.setVersion(value);
            }
        }
        return true;
    }

    public boolean doesDomainMatch(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = domain.equalsIgnoreCase(".local");
        int dotInDomain = domain.indexOf(46);
        if (dotInDomain == 0) {
            dotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || dotInDomain != -1 && dotInDomain != domain.length() - 1)) {
            return false;
        }
        int firstDotInHost = host.indexOf(46);
        if (firstDotInHost == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (lengthDiff > 0) {
            String H = host.substring(0, lengthDiff);
            String D = host.substring(lengthDiff);
            return H.indexOf(46) == -1 && D.equalsIgnoreCase(domain);
        }
        if (lengthDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    public String printList() {
        StringBuffer token = new StringBuffer();
        token.append(this.cookieValue);
        if (this.Comment != null) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Comment" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Comment);
        }
        if (this.CommentURL != null) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "CommentURL" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.CommentURL);
        }
        if (this.Discard) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Discard");
        }
        if (this.Domain != null) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Domain" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Domain);
        }
        if (this.Max_Age != -1L) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Max-Age" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Max_Age);
        }
        if (this.Path != null) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Path" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Path);
        }
        if (this.PortList != null) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Port" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.PortList);
        }
        if (this.Secure) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Secure");
        }
        if (this.Version != null) {
            token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "Version" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.Version);
        }
        return token.toString();
    }

    private boolean checkCookieRules() {
        return true;
    }

    private boolean checkCookie2rules() {
        return false;
    }

    boolean isPortInPortList(int port) {
        String portList = this.getPortList();
        if (portList == null) {
            return false;
        }
        portList = portList.substring(1, portList.length() - 1);
        StringTokenizer st1 = new StringTokenizer(portList, HTTPConstants.HEADER_TOKEN_SEPARATOR);
        while (st1.hasMoreTokens()) {
            String name = st1.nextToken();
            int storedPort = Integer.valueOf(name);
            if (storedPort != port) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getList(String host, int port, boolean secure) {
        StringBuffer token;
        block15: {
            String storedDomain;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getList secure : " + secure);
            }
            token = new StringBuffer();
            if (this.getSecure() && !secure) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Stored cookie is secure cookie");
                }
                return null;
            }
            token.append(this.cookieValue);
            String path = this.getPath();
            if (path != null) {
                token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "$Path" + HTTPConstants.ATTR_VALUE_SEPARATOR + path);
            }
            if ((storedDomain = this.getDomain()) != null) {
                if (this.doesDomainMatch(storedDomain, host)) {
                    token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "$Domain" + HTTPConstants.ATTR_VALUE_SEPARATOR + storedDomain);
                    break block15;
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Host : " + host + " does not match domain in stored cookie : " + storedDomain);
                    }
                    return null;
                }
            }
            if (this.cookie_name == HTTPConstants.HEADER_SET_COOKIE2) {
                boolean checkPort;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Cookie is : " + HTTPConstants.HEADER_SET_COOKIE2 + " checking port information");
                }
                if (checkPort = this.isPortInPortList(port)) {
                    token.append(HTTPConstants.ATTR_TOKEN_SEPARATOR + "$Port" + HTTPConstants.ATTR_VALUE_SEPARATOR + this.getPortList());
                } else if (JavaUtils.hasValue(this.PortList)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "port : " + port + " is not in port list : " + this.PortList);
                    }
                    return null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getList");
        }
        return token.toString();
    }
}

